<?php $__env->startSection('content'); ?>
  <div class="row mt-4">
    <div class="col-12">
      <div class="card bg-gradient-secondary">
        <img src="<?php echo e(URL::asset('assets/img/shapes/waves-white.svg')); ?>" alt="pattern-lines" class="position-absolute opacity-4 start-0 top-0 w-100">
        <div class="card-body px-5 z-index-1 bg-cover">
          <div class="row">
            <div class="col-lg-3 col-12 my-auto">
              <h4 class="text-white opacity-9">Since Last Charge</h4>
              <hr class="horizontal light mt-1 mb-3">
              <div class="d-flex">
                <div>
                  <h6 class="mb-0 text-white opacity-7">Distance</h6>
                  <h3 class="text-white">145 <small class="text-sm align-top">Km</small></h3>
                </div>
                <div class="ms-lg-6 ms-4">
                  <h6 class="mb-0 text-white opacity-7">Average Energy</h6>
                  <h3 class="text-white">300 <small class="text-sm align-top">Kw</small></h3>
                </div>
              </div>
            </div>
            <div class="col-lg-6 col-12 text-center">
              <img class="w-75 w-lg-auto mt-n7 mt-lg-n8 d-none d-md-block" src="<?php echo e(URL::asset('assets/img/mercedes-eqc.png')); ?>" alt="car image">
              <div class="d-flex align-items-center">
                <h4 class="text-white opacity-7 ms-0 ms-md-auto">Available Range</h4>
                <h2 class="text-white ms-2 me-auto">70<small class="text-sm align-top"> %</small></h2>
              </div>
            </div>
            <div class="col-lg-3 col-12 my-auto">
              <h4 class="text-white opacity-9">Nearest Charger</h4>
              <hr class="horizontal light mt-1 mb-3">
              <div class="d-flex">
                <div>
                  <h6 class="mb-0 text-white">Miclan, DW</h6>
                  <h6 class="mb-0 text-white">891 Limarenda road</h6>
                </div>
                <div class="ms-lg-6 ms-4">
                  <button class="btn btn-icon-only btn-rounded btn-outline-white mb-0">
                    <i class="ni ni-map-big" aria-hidden="true"></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-4">
    <div class="col-lg-3 col-md-6 col-12">
      <div class="card bg-gradient-secondary">
        <div class="card-body p-3">
          <div class="row">
            <div class="col-8">
              <div class="numbers">
                <p class="text-white text-sm mb-0 text-capitalize font-weight-bold opacity-7">Today's Trip</p>
                <h5 class="text-white font-weight-bolder mb-0">
                  145 Km
                </h5>
              </div>
            </div>
            <div class="col-4 text-end">
              <div class="icon icon-shape bg-white shadow text-center border-radius-md">
                <i class="ni ni-money-coins text-dark text-lg opacity-10" aria-hidden="true"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 col-12 mt-4 mt-md-0">
      <div class="card bg-gradient-secondary">
        <div class="card-body p-3">
          <div class="row">
            <div class="col-8">
              <div class="numbers">
                <p class="text-white text-sm mb-0 text-capitalize font-weight-bold opacity-7">Battery Health</p>
                <h5 class="text-white font-weight-bolder mb-0">
                  99 %
                </h5>
              </div>
            </div>
            <div class="col-4 text-end">
              <div class="icon icon-shape bg-white shadow text-center border-radius-md">
                <i class="ni ni-controller text-dark text-lg opacity-10" aria-hidden="true"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 col-12 mt-4 mt-lg-0">
      <div class="card bg-gradient-secondary">
        <div class="card-body p-3">
          <div class="row">
            <div class="col-8">
              <div class="numbers">
                <p class="text-white text-sm mb-0 text-capitalize font-weight-bold opacity-7">Average Speed</p>
                <h5 class="text-white font-weight-bolder mb-0">
                  56 Km/h
                </h5>
              </div>
            </div>
            <div class="col-4 text-end">
              <div class="icon icon-shape bg-white shadow text-center border-radius-md">
                <i class="ni ni-delivery-fast text-dark text-lg opacity-10" aria-hidden="true"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 col-12 mt-4 mt-lg-0">
      <div class="card bg-gradient-secondary">
        <div class="card-body p-3">
          <div class="row">
            <div class="col-8">
              <div class="numbers">
                <p class="text-white text-sm mb-0 text-capitalize font-weight-bold opacity-7">Music Volume</p>
                <h5 class="text-white font-weight-bolder mb-0">
                  15/100
                </h5>
              </div>
            </div>
            <div class="col-4 text-end">
              <div class="icon icon-shape bg-white shadow text-center border-radius-md">
                <i class="ni ni-note-03 text-dark text-lg opacity-10" aria-hidden="true"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-4">
    <div class="col-12">
      <div class="card bg-gradient-dark">
        <div class="card-header bg-transparent">
          <div class="row">
            <div class="col-lg-4 col-md-6 col-12">
              <div class="input-group input-group-lg">
                <span class="input-group-text text-white bg-transparent border-0">
                  <i class="ni ni-zoom-split-in text-lg" aria-hidden="true"></i>
                </span>
                <input type="text" class="form-control bg-transparent border-0" placeholder="Search anything..." onfocus="focused(this)" onfocusout="defocused(this)">
              </div>
            </div>
            <div class="col-lg-6 col-md-6 col-12 my-auto ms-auto">
              <div class="d-flex align-items-center">
                <i class="ni ni-headphones text-lg text-white ms-auto" data-bs-toggle="tooltip" data-bs-placement="top" title="Headphones connected"></i>
                <i class="ni ni-button-play text-lg text-white ms-3" data-bs-toggle="tooltip" data-bs-placement="top" title="Music is playing"></i>
                <i class="ni ni-button-power text-lg text-white ms-3" data-bs-toggle="tooltip" data-bs-placement="top" title="Start radio"></i>
                <i class="ni ni-watch-time text-lg text-white ms-3" data-bs-toggle="tooltip" data-bs-placement="top" title="Time tracker"></i>
                <h4 class="text-white mb-1 ms-4">10:45</h4>
              </div>
            </div>
          </div>
          <hr class="horizontal light">
          <div class="row">
            <div class="col-lg-4 col-md-6 col-12">
              <div class="d-flex align-items-center position-relative">
                <h3 class="text-white mb-1">11:13</h3>
                <p class="text-white opacity-8 mb-1 ms-3">Estimated arrival time</p>
                <hr class="vertical light mt-0">
              </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
              <div class="d-flex align-items-center position-relative">
                <h3 class="text-white mb-1 ms-auto">2.4<small class="align-top text-sm">Km</small></h3>
                <p class="text-white opacity-8 mb-1 ms-3 me-auto">Turn right in 2.4 miles</p>
                <hr class="vertical light mt-0">
              </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12 ms-lg-auto">
              <div class="d-flex align-items-center">
                <h3 class="text-white mb-1 ms-lg-auto">6.3<small class="align-top text-sm">Km</small></h3>
                <p class="text-white opacity-8 mb-1 ms-3">Distance to Creative Tim</p>
              </div>
            </div>
          </div>
        </div>
        <div class="card-body px-0 py-0">
          <div id="mapid" class="leaflet"></div>
        </div>
        <div class="card-footer">
          <div class="row">
            <div class="col-lg-4 col-md-6 col-12">
              <div class="d-flex align-items-center">
                <div class="position-relative">
                  <div class="avatar avatar-lg">
                    <img src="<?php echo e(URL::asset('assets/img/curved-images/curved10.jpg')); ?>" alt="kal" class="border-radius-xl rounded-circle shadow">
                  </div>
                  <img class="position-absolute w-60 end-0 bottom-0 me-n3 mb-0" src="<?php echo e(URL::asset('assets/img/small-logos/logo-spotify.svg')); ?>" alt="spotify logo">
                </div>
                <div class="px-3">
                  <p class="text-white text-sm font-weight-bold mb-0">
                    You're Mines Still (feat Drake)
                  </p>
                  <p class="text-white text-xs mb-2 opacity-8">
                    Yung Bleu - Hip-Hop
                  </p>
                </div>
              </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12 my-auto text-center mt-3 mt-lg-0">
              <div class="d-flex align-items-center">
                <button class="btn btn-lg btn-icon-only btn-rounded btn-outline-white mb-0 ms-auto">
                  <i class="ni ni-button-play top-0 rotate-180" aria-hidden="true"></i>
                </button>
                <button class="btn btn-lg btn-icon-only btn-rounded btn-outline-white mb-0 ms-4">
                  <i class="ni ni-button-pause top-0" aria-hidden="true"></i>
                </button>
                <button class="btn btn-lg btn-icon-only btn-rounded btn-outline-white mb-0 ms-4 me-auto">
                  <i class="ni ni-button-play top-0" aria-hidden="true"></i>
                </button>
              </div>
            </div>
            <div class="col-lg-2 col-md-6 col-8 my-auto">
              <p class="text-white mb-2">Volume</p>
              <div id="sliderRegular"></div>
            </div>
            <div class="col-lg-1 col-md-6 col-4 my-auto ms-auto">
              <i class="ni ni-bullet-list-67 text-white mt-3 ms-auto" data-bs-toggle="tooltip" data-bs-placement="top" title="Hide menu"></i>
              <i class="ni ni-chat-round text-white ms-3 mt-3" data-bs-toggle="tooltip" data-bs-placement="top" title="Track messages"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>  
  <script src="<?php echo e(URL::asset('assets/js/plugins/leaflet.js')); ?>"></script>
  <script src="<?php echo e(URL::asset('assets/js/plugins/nouislider.min.js')); ?>"></script>
  <script>
    // Initialize the map and assign it to a variable for later use
    // there's a few ways to declare a VARIABLE in javascript.
    // you might also see people declaring variables using `const` and `let`
    var map = L.map('mapid', {
      // Set latitude and longitude of the map center (required)
      center: [38.89, -77.03],
      // Set the initial zoom level, values 0-18, where 0 is most zoomed-out (required)
      zoom: 11
    });


    // Create a Tile Layer and add it to the map
    var tiles = new L.tileLayer('https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png', {
      attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors &copy; <a href="https://carto.com/attributions">CARTO</a>',
      subdomains: 'abcd',
      maxZoom: '19'
    }).addTo(map);


    // Init slider
    var slider = document.getElementById("sliderRegular");
    noUiSlider.create(slider, {
      start: 40,
      connect: [true, false],
      range: {
        min: 0,
        max: 100
      }
    });
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'dashboards', 'childFolder' => 'none'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Learning Admin Panel\admin panel\resources\views/dashboards/automotive.blade.php ENDPATH**/ ?>