<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">All Alias</h5>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <div class="ms-auto my-auto">
              <a href="<?php echo e(url('/add-alias')); ?>" class="btn bg-gradient-dark btn-sm mb-0">+&nbsp; New Alias</a>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              <?php echo e($errors->first()); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <?php if(session('success')): ?>
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              <?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <table class="table table-flush" id="category-list">
            <thead class="thead-light">
              <tr>
                <th>SELECT</th>
                <th>ALIAS TAG</th>
                <th>DESCRIPTION</th>
                <th>CREATION DATE</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php if(count($data) > 0): ?>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="<?php echo e($item->id); ?>">
                <td class="text-sm">
                  <div class="form-check my-auto">
                        <input class="form-check-input" type="checkbox" id="customCheck1">
                      </div>
                 </td>
                <td class="text-sm"><?php echo e(str_replace('_',' ',$item->tag)); ?></td>
                <td class="text-sm"><?php echo e($item->description); ?></td>
                <td class="text-sm"><?php echo e($item->created_at); ?></td>
                <td class="text-sm">
                  <a href="<?php echo e(url('edit-alias/' . $item->id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Edit Alias">
                    <i class="fas fa-user-edit text-secondary"></i>
                  </a>
                  <a href="#" class="delete" data-id="alias"  id="<?php echo e($item->id); ?>"  data-bs-toggle="tooltip" data-bs-original-title="Delete Alias">
                    <i class="fas fa-trash text-secondary"></i>
                  </a>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>no content </tr>
              <?php endif; ?>
            </tbody>
          </table>
          <?php echo e($data->links('components.paginate')); ?>

        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>
<script>
  if (document.getElementById('category-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#category-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
            placeholder: "Search...",
            perPage: "Show {select} entries",
            noRows: "No entries found",
            info: "Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> entries"
          },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };


</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);

  });


  // $("#category-list").on("click",".delete",function(){
    // Swal.fire({
    //         title: 'Are you sure?',
    //         text: "You won't be able to revert this!",
    //         icon: 'warning',
    //         showCancelButton: true,
    //         confirmButtonColor: '#3085d6',
    //         cancelButtonColor: '#d33',
    //         confirmButtonText: 'Yes, delete it!'
    //       }).then((result) => {
    //         if (result.isConfirmed) {
    //           $(this).parent().parent().remove();

              // Swal.fire(
              //   'Deleted!',
              //   'Your file has been deleted.',
              //   'success'
              // )
    //         }
    //       })
    // });


</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'admin-setting', 'childFolder' => 'alias'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/today.technicalsumer.com/resources/views/admin-setting/alias/alias-management.blade.php ENDPATH**/ ?>