<aside class="sidenav navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 <?php echo e((\Request::is('pages-rtl') ? 'fixed-end me-3 rotate-caret' : 'fixed-start ms-3' )); ?>" id="sidenav-main">
    <div class="sidenav-header">
        <i class="fas fa-times p-3 cursor-pointer text-secondary opacity-5 position-absolute end-0 top-0 d-none d-xl-none" aria-hidden="true" id="iconSidenav"></i>
        <a class="align-items-center d-flex m-0 navbar-brand text-wrap" href="<?php echo e(url('dashboard')); ?>">
            <img src="<?php echo e(url('/images/favicon.png')); ?>" class="navbar-brand-img h-100" alt="main_logo">
            <span class="ms-3 font-weight-bold">Welcome Admin</span>
        </a>
    </div>
    <hr class="horizontal dark mt-0">
    <div class="collapse navbar-collapse w-auto h-auto" id="sidenav-collapse-main">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a  href="<?php echo e(url('dashboard')); ?>" class="nav-link <?php echo e(($parentFolder == 'dashboard' ? ' active' : '')); ?>" >
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop </title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Dashboard</span>
                </a>
            </li>

            <!--Users-->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#pagesExamples" class="nav-link <?php echo e(($parentFolder == 'users' ? ' active' : '')); ?>" aria-controls="pagesExamples" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>office</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Users</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'users' ? 'show' : '')); ?>" id="pagesExamples">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('users') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users') ? 'active' : '')); ?>" href="<?php echo e(url('users')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Users</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('users/search/null') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/search/null') ? 'active' : '')); ?>" href="<?php echo e(url('users/search/null')); ?>">
                                <span class="sidenav-mini-icon"> S </span>
                                <span class="sidenav-normal">Search User</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('users/banned') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/banned') ? 'active' : '')); ?>" href="<?php echo e(url('users/banned')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Banned Users</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('users/top-earning-user') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/top-earning-user') ? 'active' : '')); ?>" href="<?php echo e(url('users/top-earning-user')); ?>">
                                <span class="sidenav-mini-icon"> W </span>
                                <span class="sidenav-normal">Top Earning User</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>
            
             <!--Transaction-->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#transaction" class="nav-link <?php echo e(($parentFolder == 'pages' ? ' active' : '')); ?>" aria-controls="transaction" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>office</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -741.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="basket" transform="translate(153.000000, 450.000000)">
                                            <path class="color-background" d="M34.080375,13.125 L27.3748125,1.9490625 C27.1377583,1.53795093 26.6972449,1.28682264 26.222716,1.29218729 C25.748187,1.29772591 25.3135593,1.55890827 25.0860125,1.97535742 C24.8584658,2.39180657 24.8734447,2.89865282 25.1251875,3.3009375 L31.019625,13.125 L10.980375,13.125 L16.8748125,3.3009375 C17.1265553,2.89865282 17.1415342,2.39180657 16.9139875,1.97535742 C16.6864407,1.55890827 16.251813,1.29772591 15.777284,1.29218729 C15.3027551,1.28682264 14.8622417,1.53795093 14.6251875,1.9490625 L7.919625,13.125 L0,13.125 L0,18.375 L42,18.375 L42,13.125 L34.080375,13.125 Z" opacity="0.595377604"></path>
                                            <path class="color-background" d="M3.9375,21 L3.9375,38.0625 C3.9375,40.9619949 6.28800506,43.3125 9.1875,43.3125 L32.8125,43.3125 C35.7119949,43.3125 38.0625,40.9619949 38.0625,38.0625 L38.0625,21 L3.9375,21 Z M14.4375,36.75 L11.8125,36.75 L11.8125,26.25 L14.4375,26.25 L14.4375,36.75 Z M22.3125,36.75 L19.6875,36.75 L19.6875,26.25 L22.3125,26.25 L22.3125,36.75 Z M30.1875,36.75 L27.5625,36.75 L27.5625,26.25 L30.1875,26.25 L30.1875,36.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Transaction</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'pages' ? 'show' : '')); ?>" id="transaction">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('all-transaction') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('all-transaction') ? 'active' : '')); ?>" href="<?php echo e(url('all-transaction')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">All User Activity</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('coinstore-transaction') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('coinstore-transaction') ? 'active' : '')); ?>" href="<?php echo e(url('coinstore-transaction')); ?>">
                                <span class="sidenav-mini-icon"> S </span>
                                <span class="sidenav-normal">Coin Store Transaction</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>
            
            <!-- Transaction -->
      <!--      <li class="nav-item ">
                <a href="<?php echo e(url('all-transaction')); ?>" class="nav-link <?php echo e((Request::is('all-transaction') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                         <i class="ni ni-chart-bar-32 text-lg text-dark" aria-hidden="true"></i> 
                    </div>
                    <span class="nav-link-text ms-1">Transaction</span>
                </a>
            </li>-->
            
             <!-- Support -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#support" class="nav-link <?php echo e(($parentFolder == 'support' ? ' active' : '')); ?>" aria-controls="support" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg class="text-dark" width="12px" height="12px" viewBox="0 0 42 44" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>basket</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -741.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="basket" transform="translate(153.000000, 450.000000)">
                                            <path class="color-background" d="M34.080375,13.125 L27.3748125,1.9490625 C27.1377583,1.53795093 26.6972449,1.28682264 26.222716,1.29218729 C25.748187,1.29772591 25.3135593,1.55890827 25.0860125,1.97535742 C24.8584658,2.39180657 24.8734447,2.89865282 25.1251875,3.3009375 L31.019625,13.125 L10.980375,13.125 L16.8748125,3.3009375 C17.1265553,2.89865282 17.1415342,2.39180657 16.9139875,1.97535742 C16.6864407,1.55890827 16.251813,1.29772591 15.777284,1.29218729 C15.3027551,1.28682264 14.8622417,1.53795093 14.6251875,1.9490625 L7.919625,13.125 L0,13.125 L0,18.375 L42,18.375 L42,13.125 L34.080375,13.125 Z" opacity="0.595377604"></path>
                                            <path class="color-background" d="M3.9375,21 L3.9375,38.0625 C3.9375,40.9619949 6.28800506,43.3125 9.1875,43.3125 L32.8125,43.3125 C35.7119949,43.3125 38.0625,40.9619949 38.0625,38.0625 L38.0625,21 L3.9375,21 Z M14.4375,36.75 L11.8125,36.75 L11.8125,26.25 L14.4375,26.25 L14.4375,36.75 Z M22.3125,36.75 L19.6875,36.75 L19.6875,26.25 L22.3125,26.25 L22.3125,36.75 Z M30.1875,36.75 L27.5625,36.75 L27.5625,26.25 L30.1875,26.25 L30.1875,36.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Support </span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'support' ? ' show' : '')); ?>" id="support">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('support/ticket_active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('support/ticket_active') ? 'active' : '')); ?>" href="<?php echo e(url('support/ticket_active')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal"> Active Ticket</span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('support/ticket_closed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('support/ticket_closed') ? 'active' : '')); ?>" href="<?php echo e(url('support/ticket_closed')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Closed Ticket </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
             <!-- Withdraw Request -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#withdrawal" class="nav-link <?php echo e(($parentFolder == 'withdrawal' ? ' active' : '')); ?>" aria-controls="withdrawal" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg class="text-dark" width="12px" height="12px" viewBox="0 0 42 44" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>basket</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -741.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="basket" transform="translate(153.000000, 450.000000)">
                                            <path class="color-background" d="M34.080375,13.125 L27.3748125,1.9490625 C27.1377583,1.53795093 26.6972449,1.28682264 26.222716,1.29218729 C25.748187,1.29772591 25.3135593,1.55890827 25.0860125,1.97535742 C24.8584658,2.39180657 24.8734447,2.89865282 25.1251875,3.3009375 L31.019625,13.125 L10.980375,13.125 L16.8748125,3.3009375 C17.1265553,2.89865282 17.1415342,2.39180657 16.9139875,1.97535742 C16.6864407,1.55890827 16.251813,1.29772591 15.777284,1.29218729 C15.3027551,1.28682264 14.8622417,1.53795093 14.6251875,1.9490625 L7.919625,13.125 L0,13.125 L0,18.375 L42,18.375 L42,13.125 L34.080375,13.125 Z" opacity="0.595377604"></path>
                                            <path class="color-background" d="M3.9375,21 L3.9375,38.0625 C3.9375,40.9619949 6.28800506,43.3125 9.1875,43.3125 L32.8125,43.3125 C35.7119949,43.3125 38.0625,40.9619949 38.0625,38.0625 L38.0625,21 L3.9375,21 Z M14.4375,36.75 L11.8125,36.75 L11.8125,26.25 L14.4375,26.25 L14.4375,36.75 Z M22.3125,36.75 L19.6875,36.75 L19.6875,26.25 L22.3125,26.25 L22.3125,36.75 Z M30.1875,36.75 L27.5625,36.75 L27.5625,26.25 L30.1875,26.25 L30.1875,36.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Withdrawal </span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'withdrawal' ? ' show' : '')); ?>" id="withdrawal">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('withdrawal') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal"> Withdrawal Setup </span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('withdrawal/pending') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/pending') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/pending')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal"> Pending </span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('withdrawal/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/completed') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal"> Completed </span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('withdrawal/rejected') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/rejected') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/rejected')); ?>">
                                <span class="sidenav-mini-icon"> R </span>
                                <span class="sidenav-normal"> Rejected </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
            <!-- Apps -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#appofffer" class="nav-link <?php echo e(($parentFolder == 'offer' ? ' active' : '')); ?>" aria-controls="appofffer" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>offers</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">App Offers</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'offer' ? 'show' : '')); ?>" id="appofffer">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('offers/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offers/active') ? 'active' : '')); ?>" href="<?php echo e(url('offers/active')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Active</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('offers/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offers/completed') ? 'active' : '')); ?>" href="<?php echo e(url('offers/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
            <!-- dailyoffer -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#dailyoffer" class="nav-link <?php echo e(($parentFolder == 'dailyoffer' ? ' active' : '')); ?>" aria-controls="dailyoffer" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Daily offers</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Daily Offers</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'dailyoffer' ? 'show' : '')); ?>" id="dailyoffer">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('dailyoffer') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('dailyoffer') ? 'active' : '')); ?>" href="<?php echo e(url('dailyoffer')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Offers</span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('dailyoffer/pending') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('dailyoffer/pending') ? 'active' : '')); ?>" href="<?php echo e(url('dailyoffer/pending')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Pending Approval</span>
                            </a>
                        </li>
                        
                         <li class="nav-item <?php echo e((Request::is('dailyoffer/approved') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('dailyoffer/approved') ? 'active' : '')); ?>" href="<?php echo e(url('dailyoffer/approved')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Approved</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- Article -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#webArticle" class="nav-link <?php echo e(($parentFolder == 'web' ? ' active' : '')); ?>" aria-controls="webArticle" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Article</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Web Article</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'web' ? 'show' : '')); ?>" id="webArticle">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('article/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('article/active') ? 'active' : '')); ?>" href="<?php echo e(url('article/active')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Active</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('article/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('article/completed') ? 'active' : '')); ?>" href="<?php echo e(url('article/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- pending promotino -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#promotion" class="nav-link <?php echo e(($parentFolder == 'promotion' ? ' active' : '')); ?>" aria-controls="promotion" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Article</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Promotion Approval</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'promotion' ? 'show' : '')); ?>" id="promotion">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('promotion/article/approval') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('promotion/article/approval') ? 'active' : '')); ?>" href="<?php echo e(url('promotion/article/approval')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Web Article</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('promotion/videozone/approval') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('promotion/videozone/approval') ? 'active' : '')); ?>" href="<?php echo e(url('promotion/videozone/approval')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Videozone</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

             <!-- offerwall -->
             <li class="nav-item">
                <a data-bs-toggle="collapse" href="#offerwall" class="nav-link <?php echo e(($parentFolder == 'offerwall' ? ' active' : '')); ?>" aria-controls="offerwall" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>offerwall</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Offerwall</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'offerwall' ? 'show' : '')); ?>" id="offerwall">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('offerwall/sdk') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/sdk') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/sdk')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Sdk Offerwall</span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('offerwall/web') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/web') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/web')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Web Offerwall</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('offerwall/api') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/api') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/api')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Api Offerwall</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!--videozne-->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#video" class="nav-link <?php echo e(($parentFolder == 'video' ? ' active' : '')); ?>" aria-controls="video" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>office</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">VideoZone</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'video' ? 'show' : '')); ?>" id="video">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('videozone/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('videozone/active') ? 'active' : '')); ?>" href="<?php echo e(url('videozone/active')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Videos</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('videozone/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('videozone/completed') ? 'active' : '')); ?>" href="<?php echo e(url('videozone/completed')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <!-- CoinStorer -->
            <li class="nav-item ">
                <a href="<?php echo e(url('coinstore')); ?>" class="nav-link <?php echo e((Request::is('coinstore') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">CoinStore</span>
                </a>
            </li>
            
            <!-- Promotion Banner -->
            <li class="nav-item ">
                <a href="<?php echo e(url('banner')); ?>" class="nav-link <?php echo e((Request::is('banner') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Promotion Banner</span>
                </a>
            </li>
            
             <!-- playzone  -->
            <li class="nav-item ">
                <a href="<?php echo e(url('games')); ?>" class="nav-link <?php echo e((Request::is('games') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">HTML 5 Game </span>
                </a>
            </li>

            <!-- luckywheel  -->
            <li class="nav-item ">
                <a href="<?php echo e(url('luckywheel')); ?>" class="nav-link <?php echo e((Request::is('luckywheel') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Lucky Wheel</span>
                </a>
            </li>

           
            <!-- Notification -->
            <li class="nav-item ">
                <a href="<?php echo e(url('push-notification')); ?>" class="nav-link <?php echo e((Request::is('push-notification') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>N</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Notification</span>
                </a>
            </li>


            <!-- admin setting -->
            <li class="nav-item" style="margin-bottom:30px;">
                <a data-bs-toggle="collapse" href="#adminsetting" class="nav-link <?php echo e(($parentFolder == 'admin-setting' ? ' active' : '')); ?>" aria-controls="adminsetting" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 40 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>settings</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-2020.000000, -442.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(304.000000, 151.000000)">
                                            <polygon class="color-background" opacity="0.596981957" points="18.0883333 15.7316667 11.1783333 8.82166667 13.3333333 6.66666667 6.66666667 0 0 6.66666667 6.66666667 13.3333333 8.82166667 11.1783333 15.315 17.6716667"></polygon>
                                            <path class="color-background" d="M31.5666667,23.2333333 C31.0516667,23.2933333 30.53,23.3333333 30,23.3333333 C29.4916667,23.3333333 28.9866667,23.3033333 28.48,23.245 L22.4116667,30.7433333 L29.9416667,38.2733333 C32.2433333,40.575 35.9733333,40.575 38.275,38.2733333 L38.275,38.2733333 C40.5766667,35.9716667 40.5766667,32.2416667 38.275,29.94 L31.5666667,23.2333333 Z" opacity="0.596981957"></path>
                                            <path class="color-background" d="M33.785,11.285 L28.715,6.215 L34.0616667,0.868333333 C32.82,0.315 31.4483333,0 30,0 C24.4766667,0 20,4.47666667 20,10 C20,10.99 20.1483333,11.9433333 20.4166667,12.8466667 L2.435,27.3966667 C0.95,28.7083333 0.0633333333,30.595 0.00333333333,32.5733333 C-0.0583333333,34.5533333 0.71,36.4916667 2.11,37.89 C3.47,39.2516667 5.27833333,40 7.20166667,40 C9.26666667,40 11.2366667,39.1133333 12.6033333,37.565 L27.1533333,19.5833333 C28.0566667,19.8516667 29.01,20 30,20 C35.5233333,20 40,15.5233333 40,10 C40,8.55166667 39.685,7.18 39.1316667,5.93666667 L33.785,11.285 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Admin Setting</span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'admin-setting' ? ' show' : '')); ?>" id="adminsetting">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('alias-management') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('alias-management') ? 'active' : '')); ?>" href="<?php echo e(url('alias-management')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Default Alias </span>
                            </a>
                        </li>
                         <li class="nav-item <?php echo e((Request::is('faq') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('faq') ? 'active' : '')); ?>" href="<?php echo e(url('faq')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Faq</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/general') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/general') ? 'active' : '')); ?>" href="<?php echo e(url('setting/general')); ?>">
                                <span class="sidenav-mini-icon"> G </span>
                                <span class="sidenav-normal"> General Setting </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/app') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/app') ? 'active' : '')); ?>" href="<?php echo e(url('setting/app')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> App Setting </span>
                            </a>
                        </li>
                          <li class="nav-item <?php echo e((Request::is('setting/fraud-prevention') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/fraud-prevention') ? 'active' : '')); ?>" href="<?php echo e(url('setting/fraud-prevention')); ?>">
                                <span class="sidenav-mini-icon"> U </span>
                                <span class="sidenav-normal"> Fraud Prevention </span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('setting/update-maintenance') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/update-maintenance') ? 'active' : '')); ?>" href="<?php echo e(url('setting/update-maintenance')); ?>">
                                <span class="sidenav-mini-icon"> U </span>
                                <span class="sidenav-normal"> Update & Maintenance </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/ads') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/ads') ? 'active' : '')); ?>" href="<?php echo e(url('setting/ads')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Ads Setting </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/admin-profile') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/admin-profile') ? 'active' : '')); ?>" href="<?php echo e(url('setting/admin-profile')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Admin Profile </span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('setting/app-configuration') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/app-configuration') ? 'active' : '')); ?>" href="<?php echo e(url('setting/app-configuration')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> App Configuration </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

        </ul>
    </div>
</aside><?php /**PATH /home/u418110056/domains/techappinnovation.in/public_html/domain/rewardpoint/resources/views/layouts/navbars/auth/sidebar.blade.php ENDPATH**/ ?>