

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Top Earning Users</h5>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <div class="ms-auto my-auto">
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              <?php echo e($errors->first()); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <?php if(session('success')): ?>
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              <?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <table class="table table-flush" id="users-list">
            <thead class="thead-light">
              <tr>
                <th>User ID</th>
                <th>PHOTO</th>
                <th>NAME</th>
                <th>EMAIL</th>
                <th>COIN</th>
                <th>COUNTRY</th>
                <th>ACCOUNT STATUS</th>
                <th>CREATION DATE</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php if(count($users) > 1): ?>
              <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="<?php echo e($user->cust_id); ?>">
                <td class="text-sm"><?php echo e($user->cust_id); ?></td>
                <td class="text-sm">
                   <span class="my-2 text-xs">
                    <?php if($user->type=="null"): ?>
                    <a href="<?php echo e(url('/images/user/userpro.png')); ?>" target="_blank"><img src="<?php echo e(url('/images/user/userpro.png')); ?>" class="avatar avatar-xl shadow"></a>
                    <?php elseif($user->type=="google"): ?>
                    <?php if($user->profile=='null'): ?>
                    <a href="<?php echo e(url('/images/user/userpro.png')); ?>" target="_blank"><img src="<?php echo e(url('/images/user/userpro.png' )); ?>" class="avatar avatar-xl shadow"></a>
                    <?php else: ?>
                    <a href="<?php echo e($user->profile); ?>" target="_blank"><img src="<?php echo e($user->profile); ?>" class="avatar avatar-xl shadow"></a>
                    <?php endif; ?>
                    <?php else: ?>
                    <a href="<?php echo e(url('/images/user/userpro.png'.$user->profile)); ?>" target="_blank"><img src="<?php echo e(url('/images/user/userpro.png'.$user->profile)); ?>" class="avatar avatar-xl shadow"></a>
                    <?php endif; ?>
                  </span>
                </td>
                <td class="text-sm "><a href="<?php echo e(url('/user-track/' . $user->cust_id)); ?>" class="text-info text-bold"><?php echo e($user->name); ?></a></td>
                <td class="text-sm"><?php echo e($user->email); ?></td>
                <td class="text-sm"><?php echo e(number_format($user->balance)); ?></td>
                <td class="text-sm"><img src="<?php echo e('https://ipdata.co/flags/'.strtolower($user->country).'.png'); ?>"/></td>
                <td class="text-sm" data-bs-toggle="modal" data-bs-target="#userStatusModal">
                  <?php if($user->status==0): ?>
                    <span class="badge bg-gradient-success">Active</span>
                  <?php else: ?>
                    <span class="badge bg-gradient-danger">Disabled</span>
                  <?php endif; ?>
                </td>
                <td class="text-sm"><?php echo date('d-M-y H:i:s',strtotime($user->inserted_at)); ?></td>
                <td class="text-sm">
                     <a href="<?php echo e(url('/user-track/' . $user->cust_id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="User Info">
                    <i class="fas fa-user-edit text-info"></i>
                  </a>
                  <a href="#" class="delete" data-id="user"  id="<?php echo e($user->cust_id); ?>"  data-bs-toggle="tooltip" data-bs-original-title="Delete User">
                    <i class="fas fa-trash text-danger"></i>
                  </a>
                    <?php echo e($user->page); ?>


                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr> no content </tr>
              <?php endif; ?>
            </tbody>
          </table>
            <?php echo e($users->links('components.paginate')); ?>

        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/js/plugins/modal.js')); ?>"></script>
<script>
  if (document.getElementById('users-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#users-list", {
      searchable: false,
      fixedHeight: true,
      paginate: false,
      perPage: 15,
      sortable: 2,
      labels: {
            placeholder: "Search...",
            noRows: "No entries found",
            info: "Showing <?php echo e($users->firstItem()); ?> to <?php echo e($users->lastItem()); ?> of <?php echo e($users->total()); ?> entries"
          },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });


    $("body").on("click", ".updateUserStatus", function () {
        var current_object = $(this);
        var id = current_object.attr('id');
        var status = current_object.attr('data-id');
        console.log('status=>'+status+'  userid=?'+id);
        $("#AcStatusModal").modal('show');
        $("#banid").val(id);
        $("#banstatus").val(status);
        if(status==0){
            $("#exampleModalLabel").val('Ban Account');
        }else{
           $("#exampleModalLabel").val('Unban Account');
        }
       
    });

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'users', 'childFolder' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u418110056/domains/techappinnovation.in/public_html/domain/rewardpoint/resources/views/users/top-user.blade.php ENDPATH**/ ?>