<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <!-- Card header -->
        <div class="card-header pb-0">
          <div class="d-lg-flex">
            <div>
              <h5 class="mb-0">All Items</h5>
            </div>
            <div class="ms-auto my-auto mt-lg-0 mt-4">
              <div class="ms-auto my-auto">
                <a href="<?php echo e(url('laravel-new-item')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New Item</a>
              </div>
            </div>
          </div>
        </div>
        <div class="card-body px-0 pb-0">
          <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
              <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                  <span class="alert-text text-white">
                  <?php echo e($errors->first()); ?></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                  </button>
              </div>
            <?php endif; ?>
            <?php if(session('success')): ?>
              <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                  <span class="alert-text text-white">
                  <?php echo e(session('success')); ?></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                  </button>
              </div>
            <?php endif; ?>
            <table class="table table-flush" id="items-list">
              <thead class="thead-light">
                <tr>
                  <th>ID</th>
                  <th>NAME</th>
                  <th>PHOTO</th>
                  <th>CATEGORY</th>
                  <th>TAGS</th>
                  <th>CREATION DATE</th>
                  <th>ACTION</th>
                </tr>
              </thead>
              <tbody>
                  <?php if(count($items) > 0): ?>
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td class="text-sm"><?php echo e($item->id); ?></td>
                        <td class="text-sm"><?php echo e($item->name); ?></td>
                        <td class="text-sm">
                          <span class="my-2 text-xs">
                            <img src="<?php echo e(URL::asset('assets/img/items/'.$item->file)); ?>" alt="picture" class="avatar avatar-xxl me-2" style="object-fit: cover">
                          </span>
                        </td>
                        <td class="text-sm"><?php echo e($item->category->name); ?></td>
                        <td class="text-sm">
                          <span class="my-2 text-xs">
                            <?php $__currentLoopData = $item->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <span class="badge text-white" style="background-color:<?=$tag->description?>;"><?php echo e($tag->name); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </span>
                        </td>
                        <td class="text-sm"><?php echo e($item->created_at); ?></td>
                        <td class="text-sm">
                          <a href="<?php echo e(url('laravel-edit-items/' . $item->id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Edit item">
                            <i class="fas fa-user-edit text-secondary"></i>
                          </a>
                          <a href="<?php echo e(url('laravel-delete-item/' . $item->id)); ?>" data-bs-toggle="tooltip" data-bs-original-title="Delete item">
                            <i class="fas fa-trash text-secondary"></i>
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <?php else: ?>
                      <tr> no content </tr>
                  <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

  <?php $__env->startPush('js'); ?>
    <script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
    <script>
      if (document.getElementById('items-list')) {
        const dataTableSearch = new simpleDatatables.DataTable("#items-list", {
          searchable: true,
          fixedHeight: false,
          perPage: 7
        });

        document.querySelectorAll(".export").forEach(function(el) {
          el.addEventListener("click", function(e) {
            var type = el.dataset.type;

            var data = {
              type: type,
              filename: "soft-ui-" + type,
            };

            if (type === "csv") {
              data.columnDelimiter = "|";
            }

            dataTableSearch.export(data);
          });
        });
      };
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
    $(document).ready(function(){
        $("#alert-success").delay(3000).slideUp(300);

        });
    </script>
  <?php $__env->stopPush(); ?>

<?php echo $__env->make('user_type.auth', ['parentFolder' => 'laravel', 'childFolder' => 'items'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Learning Admin Panel\admin panel\resources\views/laravel-examples/items/items-management.blade.php ENDPATH**/ ?>