

<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">App Offers</h5>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <div class="ms-auto my-auto">
              <a href="<?php echo e(url('/offers/add')); ?>" class="btn bg-gradient-info btn-sm mb-0">+&nbsp; ADD NEW</a>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              <?php echo e($errors->first()); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <?php if(session('success')): ?>
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              <?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>SELECT</th>
                <th>ICON</th>
                <th>TITLE</th>
                <th>APP URL</th>
                <th>COIN</th>
                <th>VIEWS</th>
                <th>DESCRIPTION</th>
                <th>STATUS</th>
                <th>CREATED AT</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php if(count($data) > 0): ?>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="<?php echo e($item->id); ?>">
                <td class="text-sm">
                  <div class="form-check my-auto">
                    <input class="form-check-input sub_chk" type="checkbox" id="customCheck1" data-id="<?php echo e($item->id); ?>" value="<?php echo e($item->id); ?>">
                  </div>
                </td>
                <td class="text-sm">
                  <span class="my-2 text-xs">
                    <img src="<?php echo e($item->image); ?>" class="avatar avatar-xl shadow">
                  </span>
                </td>
                <td class="text-sm"><?php echo e($item->app_name); ?></td>
                <td class="text-sm"><a href="<?php echo e($item->appurl); ?>" target="_blank" class="text-info">View App</a></td>
                <td class="text-sm"><?php echo e($item->points); ?></td>
                <td class="text-sm"><?php echo e($item->views); ?>/<?php echo e($item->task_limit); ?></td>
                <td class="text-sm"><?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->details), 30, $end='...')); ?></td>
                <td class="text-sm">
                  <?php if($item->status==0): ?>
                  <span class="badge bg-success">Active</span>
                  <?php else: ?>
                  <span class="badge bg-danger">Disabled</span>
                  <?php endif; ?>
                </td>
                <td class="text-sm"><?php echo date('d-M-y H:i:s',strtotime($item->inserted_at)); ?></td>
                <td class="text-sm">
                  <input type="hidden" id="postback" value="<?php echo e(env('APP_URL').'api/v1/offer_custom/'.$item->id.'?secret='.env('CUSTOM_OFFER_SECRET').'&'.$item->p_userid.'{'.str_replace('=','',$item->p_userid).'}'); ?>">
                  <a href="#" class="mx-3" onclick="copyText()" data-bs-toggle="tooltip" data-bs-original-title="Copy PostBack">
                    <i class="fas fa-copy text-info"></i>
                  </a>
                  <a href="<?php echo e(url('offers/edit/' . $item->id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Edit">
                    <i class="fas fa-edit text-success"></i>
                  </a>
                  <a href="#" data-id="appoffer" id="<?php echo e($item->id); ?>" class="mx-3 delete" data-bs-toggle="tooltip" data-bs-original-title="Delete">
                    <i class="fas fa-trash text-danger"></i>
                  </a>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>no content </tr>
              <?php endif; ?>
            </tbody>
          </table>
          <div class="d-flex" style="margin-left: 30px;">
            <button class="btn btn-outline-dark sub_chk_all"> Select All </button>
            <div class="dropdown d-inline " style="margin-left: 10px;">
              <a href="javascript:;" class="btn btn-outline-dark dropdown-toggle " data-bs-toggle="dropdown" id="navbarDropdownMenuLink2">
                Action
              </a>
              <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3" aria-labelledby="navbarDropdownMenuLink2" data-popper-placement="left-start">
                <li><a class="dropdown-item border-radius-md" href="javascript:;" id="enable" data-id="appoffer">Eanble Task</a></li>
                <li><a class="dropdown-item border-radius-md" href="javascript:;" id="disable" data-id="appoffer">Disable Task</a></li>
                <li><a class="dropdown-item border-radius-md text-danger" href="javascript:;" id="delete" data-id="appoffer">Delete</a></li>
              </ul>
            </div>
            <!-- <button class="btn btn-icon btn-outline-dark ms-2 export" data-type="csv" type="button">
              <span class="btn-inner--icon"><i class="ni ni-archive-2"></i></span>
              <span class="btn-inner--text">Export CSV</span>
            </button> -->
          </div>
          <?php echo e($data->links('components.paginate')); ?>

        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>

<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found",
        info: "Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> entries"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });

  function copyText() {
    var copyText = $("#postback").val();
    console.log('click oncopy btn ='+copyText);

    navigator.clipboard.writeText(copyText);

    alert("Postback Copied");
  }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'offer', 'childFolder' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/today.technicalsumer.com/resources/views/offer/active.blade.php ENDPATH**/ ?>