<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <!-- Card header -->
        <div class="card-header pb-0">
          <div class="d-lg-flex">
            <div>
              <h5 class="mb-0">All Alias</h5>
            </div>
            <div class="ms-auto my-auto mt-lg-0 mt-4">
              <div class="ms-auto my-auto">
                <a href="<?php echo e(route('add.alias')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New Alias</a>
              </div>
            </div>
          </div>
        </div>
        <div class="card-body px-0 pb-0">
          <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
              <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                  <span class="alert-text text-white">
                  <?php echo e($errors->first()); ?></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                  </button>
              </div>
            <?php endif; ?>
            <?php if(session('success')): ?>
              <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                  <span class="alert-text text-white">
                  <?php echo e(session('success')); ?></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                  </button>
              </div>
            <?php endif; ?>
            <table class="table table-flush" id="category-list">
              <thead class="thead-light">
                <tr>
                  <th>ID</th>
                  <th>ALIAS TAG</th>
                  <th>DESCRIPTION</th>
                  <th>CREATION DATE</th>
                  <th>ACTION</th>
                </tr>
              </thead>
              <tbody>
              <?php if(count($data) > 1): ?>
                  <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td class="text-sm"><?php echo e($category->id); ?></td>
                        <td class="text-sm"><?php echo e($category->tag); ?></td>
                        <td class="text-sm"><?php echo e($category->msg); ?></td>
                        <td class="text-sm"><?php echo e($category->created_at); ?></td>
                        <td class="text-sm">
                          <a href="<?php echo e(url('laravel-edit-categories/' . $category->id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Edit category">
                            <i class="fas fa-user-edit text-secondary"></i>
                          </a>
                          <a href="<?php echo e(url('laravel-delete-category/' . $category->id)); ?>" data-bs-toggle="tooltip" data-bs-original-title="Delete category">
                            <i class="fas fa-trash text-secondary"></i>
                          </a>
                        </td>
                      </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
                  <tr> no content </tr>
              <?php endif; ?>
              </tbody>
            </table>
            <?php echo e($data->links('components.paginate')); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

  <?php $__env->startPush('js'); ?>
    <script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>  
    <script>
      if (document.getElementById('category-list')) {
        const dataTableSearch = new simpleDatatables.DataTable("#category-list", {
          searchable: true,
          fixedHeight: false,
          perPage: 7
        });

        document.querySelectorAll(".export").forEach(function(el) {
          el.addEventListener("click", function(e) {
            var type = el.dataset.type;

            var data = {
              type: type,
              filename: "soft-ui-" + type,
            };

            if (type === "csv") {
              data.columnDelimiter = "|";
            }

            dataTableSearch.export(data);
          });
        });
      };
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
    $(document).ready(function(){
        $("#alert-success").delay(3000).slideUp(300);

        });
    </script>
  <?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'admin-setting', 'childFolder' => 'alias'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Learning Admin Panel\admin panel\resources\views/pages/admin-setting/alias/alias-management.blade.php ENDPATH**/ ?>