<aside class="sidenav navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 <?php echo e((\Request::is('pages-rtl') ? 'fixed-end me-3 rotate-caret' : 'fixed-start ms-3' )); ?>" id="sidenav-main">
    <div class="sidenav-header">
        <i class="fas fa-times p-3 cursor-pointer text-secondary opacity-5 position-absolute end-0 top-0 d-none d-xl-none" aria-hidden="true" id="iconSidenav"></i>
        <a class="align-items-center d-flex m-0 navbar-brand text-wrap" href="<?php echo e(url('dashboard')); ?>">
            <img src="<?php echo e(URL::asset('assets/img/logo-ct.png')); ?>" class="navbar-brand-img h-100" alt="main_logo">
            <span class="ms-3 font-weight-bold">Tech App Innovation</span>
        </a>
    </div>
    <hr class="horizontal dark mt-0">
    <div class="collapse navbar-collapse w-auto h-auto" id="sidenav-collapse-main">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="<?php echo e(url('dashboard')); ?>" class="nav-link <?php echo e(($parentFolder == 'dashboard' ? ' active' : '')); ?>" aria-controls="dashboardsExamples" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop </title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Dashboard</span>
                </a>
            </li>

            <li class="nav-item mt-3">
                <h6 class="ps-4  ms-2 text-uppercase text-xs font-weight-bolder opacity-6">PAGES</h6>
            </li>
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#pagesExamples" class="nav-link <?php echo e(($parentFolder == 'users' ? ' active' : '')); ?>" aria-controls="pagesExamples" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>office</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Users</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'users' ? 'show' : '')); ?>" id="pagesExamples">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('users') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users') ? 'active' : '')); ?>" href="<?php echo e(url('users')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Users</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('users/search/null') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/search/null') ? 'active' : '')); ?>" href="<?php echo e(url('users/search/null')); ?>">
                                <span class="sidenav-mini-icon"> S </span>
                                <span class="sidenav-normal">Search User</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('users/banned') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/banned') ? 'active' : '')); ?>" href="<?php echo e(url('users/banned')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Banned Users</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('users/top-earning-user') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('users/top-earning-user') ? 'active' : '')); ?>" href="<?php echo e(url('users/top-earning-user')); ?>">
                                <span class="sidenav-mini-icon"> W </span>
                                <span class="sidenav-normal">Top Earning User</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <!-- Apps -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#appofffer" class="nav-link <?php echo e(($parentFolder == 'offer' ? ' active' : '')); ?>" aria-controls="appofffer" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>offers</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">App Offers</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'offer' ? 'show' : '')); ?>" id="appofffer">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('offers/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offers/active') ? 'active' : '')); ?>" href="<?php echo e(url('offers/active')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Active</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('offers/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offers/completed') ? 'active' : '')); ?>" href="<?php echo e(url('offers/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- Article -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#webArticle" class="nav-link <?php echo e(($parentFolder == 'web' ? ' active' : '')); ?>" aria-controls="webArticle" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Article</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Web Article</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'web' ? 'show' : '')); ?>" id="webArticle">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('article/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('article/active') ? 'active' : '')); ?>" href="<?php echo e(url('article/active')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Active</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('article/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('article/completed') ? 'active' : '')); ?>" href="<?php echo e(url('article/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- pending promotino -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#promotion" class="nav-link <?php echo e(($parentFolder == 'promotion' ? ' active' : '')); ?>" aria-controls="promotion" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Article</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Promotion Approval</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'promotion' ? 'show' : '')); ?>" id="promotion">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('promotion/article/approval') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('promotion/article/approval') ? 'active' : '')); ?>" href="<?php echo e(url('promotion/article/approval')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Web Article</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('promotion/videozone/approval') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('promotion/videozone/approval') ? 'active' : '')); ?>" href="<?php echo e(url('promotion/videozone/approval')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal">Videozone</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

             <!-- offerwall -->
             <li class="nav-item">
                <a data-bs-toggle="collapse" href="#offerwall" class="nav-link <?php echo e(($parentFolder == 'offerwall' ? ' active' : '')); ?>" aria-controls="offerwall" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>offerwall</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Offerwall</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'offerwall' ? 'show' : '')); ?>" id="offerwall">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('offerwall/sdk') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/sdk') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/sdk')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Sdk Offerwall</span>
                            </a>
                        </li>
                        
                        <li class="nav-item <?php echo e((Request::is('offerwall/web') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/web') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/web')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Web Offerwall</span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('offerwall/api') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('offerwall/api') ? 'active' : '')); ?>" href="<?php echo e(url('offerwall/api')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal">Api Offerwall</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#video" class="nav-link <?php echo e(($parentFolder == 'video' ? ' active' : '')); ?>" aria-controls="video" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 42 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>office</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -293.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="office" transform="translate(153.000000, 2.000000)">
                                            <path class="color-background" d="M12.25,17.5 L8.75,17.5 L8.75,1.75 C8.75,0.78225 9.53225,0 10.5,0 L31.5,0 C32.46775,0 33.25,0.78225 33.25,1.75 L33.25,12.25 L29.75,12.25 L29.75,3.5 L12.25,3.5 L12.25,17.5 Z" opacity="0.6"></path>
                                            <path class="color-background" d="M40.25,14 L24.5,14 C23.53225,14 22.75,14.78225 22.75,15.75 L22.75,38.5 L19.25,38.5 L19.25,22.75 C19.25,21.78225 18.46775,21 17.5,21 L1.75,21 C0.78225,21 0,21.78225 0,22.75 L0,40.25 C0,41.21775 0.78225,42 1.75,42 L40.25,42 C41.21775,42 42,41.21775 42,40.25 L42,15.75 C42,14.78225 41.21775,14 40.25,14 Z M12.25,36.75 L7,36.75 L7,33.25 L12.25,33.25 L12.25,36.75 Z M12.25,29.75 L7,29.75 L7,26.25 L12.25,26.25 L12.25,29.75 Z M35,36.75 L29.75,36.75 L29.75,33.25 L35,33.25 L35,36.75 Z M35,29.75 L29.75,29.75 L29.75,26.25 L35,26.25 L35,29.75 Z M35,22.75 L29.75,22.75 L29.75,19.25 L35,19.25 L35,22.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">VideoZone</span>
                </a>
                <div class="collapse  <?php echo e(($parentFolder == 'video' ? 'show' : '')); ?>" id="video">
                    <ul class="nav ms-4 ps-3">

                        <li class="nav-item <?php echo e((Request::is('videozone/active') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('videozone/active') ? 'active' : '')); ?>" href="<?php echo e(url('videozone/active')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Videos</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('videozone/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('videozone/completed') ? 'active' : '')); ?>" href="<?php echo e(url('videozone/completed')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal">Completed</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <!-- Transaction -->
            <li class="nav-item ">
                <a href="<?php echo e(url('all-transaction')); ?>" class="nav-link <?php echo e((Request::is('all-transaction') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Transaction</span>
                </a>
            </li>

            <!-- Promotion Banner -->
            <li class="nav-item ">
                <a href="<?php echo e(url('banner')); ?>" class="nav-link <?php echo e((Request::is('banner') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>shop</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Promotion Banner</span>
                </a>
            </li>

            <!-- Withdraw Request -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#withdrawal" class="nav-link <?php echo e(($parentFolder == 'withdrawal' ? ' active' : '')); ?>" aria-controls="withdrawal" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg class="text-dark" width="12px" height="12px" viewBox="0 0 42 44" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>basket</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1869.000000, -741.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g id="basket" transform="translate(153.000000, 450.000000)">
                                            <path class="color-background" d="M34.080375,13.125 L27.3748125,1.9490625 C27.1377583,1.53795093 26.6972449,1.28682264 26.222716,1.29218729 C25.748187,1.29772591 25.3135593,1.55890827 25.0860125,1.97535742 C24.8584658,2.39180657 24.8734447,2.89865282 25.1251875,3.3009375 L31.019625,13.125 L10.980375,13.125 L16.8748125,3.3009375 C17.1265553,2.89865282 17.1415342,2.39180657 16.9139875,1.97535742 C16.6864407,1.55890827 16.251813,1.29772591 15.777284,1.29218729 C15.3027551,1.28682264 14.8622417,1.53795093 14.6251875,1.9490625 L7.919625,13.125 L0,13.125 L0,18.375 L42,18.375 L42,13.125 L34.080375,13.125 Z" opacity="0.595377604"></path>
                                            <path class="color-background" d="M3.9375,21 L3.9375,38.0625 C3.9375,40.9619949 6.28800506,43.3125 9.1875,43.3125 L32.8125,43.3125 C35.7119949,43.3125 38.0625,40.9619949 38.0625,38.0625 L38.0625,21 L3.9375,21 Z M14.4375,36.75 L11.8125,36.75 L11.8125,26.25 L14.4375,26.25 L14.4375,36.75 Z M22.3125,36.75 L19.6875,36.75 L19.6875,26.25 L22.3125,26.25 L22.3125,36.75 Z M30.1875,36.75 L27.5625,36.75 L27.5625,26.25 L30.1875,26.25 L30.1875,36.75 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Withdrawal Request</span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'withdrawal' ? ' show' : '')); ?>" id="withdrawal">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('withdrawal/pending') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/pending') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/pending')); ?>">
                                <span class="sidenav-mini-icon"> P </span>
                                <span class="sidenav-normal"> Pending </span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('withdrawal/completed') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/completed') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/completed')); ?>">
                                <span class="sidenav-mini-icon"> C </span>
                                <span class="sidenav-normal"> Completed </span>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e((Request::is('withdrawal/rejected') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('withdrawal/rejected') ? 'active' : '')); ?>" href="<?php echo e(url('withdrawal/rejected')); ?>">
                                <span class="sidenav-mini-icon"> R </span>
                                <span class="sidenav-normal"> Rejected </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- Notification -->
            <li class="nav-item ">
                <a href="<?php echo e(url('push-notification')); ?>" class="nav-link <?php echo e((Request::is('push-notification') ? 'active' : '')); ?>">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>N</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" opacity="0.598981585"></path>
                                            <path class="color-background" d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Notification</span>
                </a>
            </li>


            <!-- admin setting -->
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#applicationsExamples" class="nav-link <?php echo e(($parentFolder == 'applications' ? ' active' : '')); ?>" aria-controls="applicationsExamples" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 40 40" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>settings</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-2020.000000, -442.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(304.000000, 151.000000)">
                                            <polygon class="color-background" opacity="0.596981957" points="18.0883333 15.7316667 11.1783333 8.82166667 13.3333333 6.66666667 6.66666667 0 0 6.66666667 6.66666667 13.3333333 8.82166667 11.1783333 15.315 17.6716667"></polygon>
                                            <path class="color-background" d="M31.5666667,23.2333333 C31.0516667,23.2933333 30.53,23.3333333 30,23.3333333 C29.4916667,23.3333333 28.9866667,23.3033333 28.48,23.245 L22.4116667,30.7433333 L29.9416667,38.2733333 C32.2433333,40.575 35.9733333,40.575 38.275,38.2733333 L38.275,38.2733333 C40.5766667,35.9716667 40.5766667,32.2416667 38.275,29.94 L31.5666667,23.2333333 Z" opacity="0.596981957"></path>
                                            <path class="color-background" d="M33.785,11.285 L28.715,6.215 L34.0616667,0.868333333 C32.82,0.315 31.4483333,0 30,0 C24.4766667,0 20,4.47666667 20,10 C20,10.99 20.1483333,11.9433333 20.4166667,12.8466667 L2.435,27.3966667 C0.95,28.7083333 0.0633333333,30.595 0.00333333333,32.5733333 C-0.0583333333,34.5533333 0.71,36.4916667 2.11,37.89 C3.47,39.2516667 5.27833333,40 7.20166667,40 C9.26666667,40 11.2366667,39.1133333 12.6033333,37.565 L27.1533333,19.5833333 C28.0566667,19.8516667 29.01,20 30,20 C35.5233333,20 40,15.5233333 40,10 C40,8.55166667 39.685,7.18 39.1316667,5.93666667 L33.785,11.285 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Admin Setting</span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'admin-setting' ? ' show' : '')); ?>" id="applicationsExamples">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('alias-management') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('alias-management') ? 'active' : '')); ?>" href="<?php echo e(url('alias-management')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Default Alias </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/general') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/general') ? 'active' : '')); ?>" href="<?php echo e(url('setting/general')); ?>">
                                <span class="sidenav-mini-icon"> G </span>
                                <span class="sidenav-normal"> General Setting </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/app') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/app') ? 'active' : '')); ?>" href="<?php echo e(url('setting/app')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> App Setting </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/update-maintenance') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/update-maintenance') ? 'active' : '')); ?>" href="<?php echo e(url('setting/update-maintenance')); ?>">
                                <span class="sidenav-mini-icon"> U </span>
                                <span class="sidenav-normal"> Update & Maintenance </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('setting/ads') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('setting/ads') ? 'active' : '')); ?>" href="<?php echo e(url('setting/ads')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Ads Setting </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e((Request::is('analytics') ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('analytics') ? 'active' : '')); ?>" href="<?php echo e(url('analytics')); ?>">
                                <span class="sidenav-mini-icon"> A </span>
                                <span class="sidenav-normal"> Analytics </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>


            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#authExamples" class="nav-link <?php echo e(($parentFolder == 'authentication' ? ' active' : '')); ?>" aria-controls="authExamples" role="button" aria-expanded="false">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center d-flex align-items-center justify-content-center  me-2">
                        <svg width="12px" height="12px" viewBox="0 0 40 44" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>document</title>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g transform="translate(-1870.000000, -591.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g transform="translate(1716.000000, 291.000000)">
                                        <g transform="translate(154.000000, 300.000000)">
                                            <path class="color-background" d="M40,40 L36.3636364,40 L36.3636364,3.63636364 L5.45454545,3.63636364 L5.45454545,0 L38.1818182,0 C39.1854545,0 40,0.814545455 40,1.81818182 L40,40 Z" opacity="0.603585379"></path>
                                            <path class="color-background" d="M30.9090909,7.27272727 L1.81818182,7.27272727 C0.814545455,7.27272727 0,8.08727273 0,9.09090909 L0,41.8181818 C0,42.8218182 0.814545455,43.6363636 1.81818182,43.6363636 L30.9090909,43.6363636 C31.9127273,43.6363636 32.7272727,42.8218182 32.7272727,41.8181818 L32.7272727,9.09090909 C32.7272727,8.08727273 31.9127273,7.27272727 30.9090909,7.27272727 Z M18.1818182,34.5454545 L7.27272727,34.5454545 L7.27272727,30.9090909 L18.1818182,30.9090909 L18.1818182,34.5454545 Z M25.4545455,27.2727273 L7.27272727,27.2727273 L7.27272727,23.6363636 L25.4545455,23.6363636 L25.4545455,27.2727273 Z M25.4545455,20 L7.27272727,20 L7.27272727,16.3636364 L25.4545455,16.3636364 L25.4545455,20 Z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Authentication</span>
                </a>
                <div class="collapse <?php echo e(($parentFolder == 'authentication' ? ' show' : '')); ?>" id="authExamples">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'signin' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#signinExample">
                                <span class="sidenav-mini-icon"> S </span>
                                <span class="sidenav-normal"> Sign In <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'signin' ? 'show' : '')); ?>" id="signinExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item <?php echo e((Request::is('authentication-signin-basic') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signin-basic') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signin-basic')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> B </span>
                                            <span class="sidenav-normal"> Basic </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-signin-cover') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signin-cover') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signin-cover')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> C </span>
                                            <span class="sidenav-normal"> Cover </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-signin-illustration') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signin-illustration') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signin-illustration')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> I </span>
                                            <span class="sidenav-normal"> Illustration </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'signup' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#signupExample">
                                <span class="sidenav-mini-icon"> S </span>
                                <span class="sidenav-normal"> Sign Up <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'signup' ? 'show' : '')); ?>" id="signupExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item <?php echo e((Request::is('authentication-signup-basic') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signup-basic') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signup-basic')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> B </span>
                                            <span class="sidenav-normal"> Basic </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-signup-cover') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signup-cover') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signup-cover')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> C </span>
                                            <span class="sidenav-normal"> Cover </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-signup-illustration') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-signup-illustration') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-signup-illustration')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> I </span>
                                            <span class="sidenav-normal"> Illustration </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'reset' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#resetExample">
                                <span class="sidenav-mini-icon"> R </span>
                                <span class="sidenav-normal"> Reset Password <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'reset' ? 'show' : '')); ?>" id="resetExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item <?php echo e((Request::is('authentication-reset-basic') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-reset-basic') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-reset-basic')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> B </span>
                                            <span class="sidenav-normal"> Basic </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-reset-cover') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-reset-cover') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-reset-cover')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> C </span>
                                            <span class="sidenav-normal"> Cover </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-reset-illustration') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-reset-illustration') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-reset-illustration')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> I </span>
                                            <span class="sidenav-normal"> Illustration </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'lock' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#lockExample">
                                <span class="sidenav-mini-icon"> L </span>
                                <span class="sidenav-normal"> Lock <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'lock' ? 'show' : '')); ?>" id="lockExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item  <?php echo e((Request::is('authentication-lock-basic') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-lock-basic') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-lock-basic')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> B </span>
                                            <span class="sidenav-normal"> Basic </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-lock-cover') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-lock-cover') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-lock-cover')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> C </span>
                                            <span class="sidenav-normal"> Cover </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-lock-illustration') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-lock-illustration') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-lock-illustration')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> I </span>
                                            <span class="sidenav-normal"> Illustration </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'verification' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#StepExample">
                                <span class="sidenav-mini-icon"> 2 </span>
                                <span class="sidenav-normal"> 2-Step Verification <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'verification' ? 'show' : '')); ?>" id="StepExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item <?php echo e((Request::is('authentication-verification-basic') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-verification-basic') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-verification-basic')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> B </span>
                                            <span class="sidenav-normal"> Basic </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-verification-cover') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-verification-cover') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-verification-cover')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> C </span>
                                            <span class="sidenav-normal"> Cover </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-verification-illustration') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-verification-illustration') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-verification-illustration')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> I </span>
                                            <span class="sidenav-normal"> Illustration </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link <?php echo e(($childFolder == 'error' ? 'active' : '')); ?>" data-bs-toggle="collapse" aria-expanded="false" href="#errorExample">
                                <span class="sidenav-mini-icon"> E </span>
                                <span class="sidenav-normal"> Error <b class="caret"></b></span>
                            </a>
                            <div class="collapse <?php echo e(($childFolder == 'error' ? 'show' : '')); ?>" id="errorExample">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item <?php echo e((Request::is('authentication-error404') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-error404') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-error404')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> E </span>
                                            <span class="sidenav-normal"> Error 404 </span>
                                        </a>
                                    </li>
                                    <li class="nav-item <?php echo e((Request::is('authentication-error500') ? 'active' : '')); ?>">
                                        <a class="nav-link <?php echo e((Request::is('authentication-error500') ? 'active' : '')); ?>" href="<?php echo e(url('authentication-error500')); ?>">
                                            <span class="sidenav-mini-icon text-xs"> E </span>
                                            <span class="sidenav-normal"> Error 500 </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </li>


            <li class="nav-item mt-3">
                <h6 class="ps-4  ms-2 text-uppercase text-xs font-weight-bolder opacity-6">Admin Area</h6>
            </li>
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#laravelExamples" class="nav-link <?php echo e(($parentFolder == 'laravel' ? ' active' : '')); ?>" aria-controls="applicationsExamples" role="button" aria-expanded="true">
                    <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                        <svg width="1rem" height="1rem" viewBox="0 0 512 512" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <title>Admin </title>
                            <g id="Basic-Elements" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="Rounded-Icons" transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF" fill-rule="nonzero">
                                    <g id="Icons-with-opacity" transform="translate(1716.000000, 291.000000)">
                                        <g id="shop-" transform="translate(0.000000, 148.000000)">
                                            <path class="color-background" d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z" id="Path" opacity="0.598981585"></path>
                                            <path class="color-background" d="M505.57 234.62c-3.28-3.53-26.82-32.29-39.51-47.79c-6.75-8.24-12.08-14.75-14.32-17.45l-.18-.22l-.2-.21c-5.22-5.83-12.64-12.51-23.78-12.51a39.78 39.78 0 0 0-5.41.44c-.37.05-.75.11-1.15.15c-2.45.27-10.06 1.5-28.14 4.48c-14 2.29-35.11 5.77-38.31 6.07l-.71.06l-.69.13c-10 1.78-16.62 6.22-19.56 13.19c-1.55 3.68-3.22 11.15 2.94 19.86c1.53 2.22 6.83 9.56 15.94 22.17c6.06 8.4 12.87 17.82 18.75 26L259.9 275L150.66 96.05l-.2-.34l-.23-.33l-.44-.65C145.32 88.17 139.76 80 123.7 80c-1.13 0-2.31 0-3.63.11c-4.6.25-21.42 1.57-40.89 3.11c-21.49 1.69-50.9 4-54.72 4.1h-.73l-.79.08c-9.14.89-15.77 4.6-19.7 11c-6.55 10.69-1.42 22.69.26 26.63C6.87 133 37.56 197.7 64.63 254.81c18 37.94 36.58 77.17 38.1 80.65a34.85 34.85 0 0 0 32.94 21.59a46.62 46.62 0 0 0 9.86-1.1h.21l.2-.05c13.86-3.38 57.83-14.54 89.2-22.59c1.9 3.32 3.9 6.83 6 10.44c21.93 38.5 37.9 66.35 43.16 73.46C287 421 295 432 310.06 432c5.46 0 10.46-1.4 15.74-2.89l1.53-.43h.12c10.53-3 150.69-52.16 157.87-55.35l.22-.1c5.44-2.41 13.66-6.05 16.18-15.4c1.65-6.12.18-12.33-4.38-18.46l-.07-.09l-.07-.09c-.85-1.1-4-5.21-8.27-10.9c-9.13-12.07-23.88-31.57-36.84-48.54c17.37-4.5 38.8-10.11 43.38-11.55c11.47-3.43 14.94-10.69 16-14.73c.79-3.15 1.82-11.2-5.9-18.85zm-320 58.19c-17.81 4.17-30.22 7.08-37.89 8.9c-6.67-13.34-19.74-39.65-32.5-65.33c-29.74-59.92-45.1-90.77-53.18-106.9l8.15-.7c13.34-1.15 31.61-2.72 41.78-3.57c16.76 28.26 74.32 125.3 96.3 162.3zM427.58 172zM310.06 416.4zm53.67-56.95c-24.21 8-37.33 12.37-44.42 14.74c-6.3-10.34-20.16-33.52-32.47-54.19l115.7-29.48c5 6.81 14.57 19.72 33.46 44.93c-18.07 6.04-48.2 16.02-72.27 24zm55.87-121.63l-23.76-31.53c13.67-2.39 21.54-3.77 26.15-4.6l12 14.88l11.94 14.82c-8.2 1.99-17.74 4.32-26.33 6.43z"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <span class="nav-link-text ms-1">Laravel</span>
                </a>
                <div class="collapse show" id="laravelExamples">
                    <ul class="nav ms-4 ps-3">
                        <li class="nav-item <?php echo e((Request::is('laravel-user-profile')  ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e((Request::is('laravel-user-profile')  ? 'active' : '')); ?>" href="<?php echo e(url('laravel-user-profile')); ?>">
                                <span class="sidenav-mini-icon"> U </span>
                                <span class="sidenav-normal"> User Profile </span>
                            </a>
                        </li>
                        <?php if(auth()->user()->role_id == 1): ?>
                        <li class="nav-item <?php echo e(($childFolder == 'users-laravel' ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e(($childFolder == 'users-laravel' ? 'active' : '')); ?>" href="<?php echo e(url('laravel-users-management')); ?>">
                                <span class="sidenav-mini-icon"> M </span>
                                <span class="sidenav-normal"> Users Management </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e(($childFolder == 'roles' ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e(($childFolder == 'roles' ? 'active' : '')); ?>" href="<?php echo e(url('laravel-roles-management')); ?>">
                                <span class="sidenav-mini-icon"> K </span>
                                <span class="sidenav-normal"> Roles Management </span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 2): ?>
                        <li class="nav-item <?php echo e(($childFolder == 'category' ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e(($childFolder == 'category' ? 'active' : '')); ?>" href="<?php echo e(url('laravel-category-management')); ?>">
                                <span class="sidenav-mini-icon"> W </span>
                                <span class="sidenav-normal"> Category Management </span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e(($childFolder == 'tags' ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e(($childFolder == 'tags' ? 'active' : '')); ?>" href="<?php echo e(url('laravel-tags-management')); ?>">
                                <span class="sidenav-mini-icon"> D </span>
                                <span class="sidenav-normal"> Tags Management </span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item <?php echo e(($childFolder == 'items' ? 'active' : '')); ?>">
                            <a class="nav-link <?php echo e(($childFolder == 'items' ? 'active' : '')); ?>" href="<?php echo e(url('laravel-items-management')); ?>">
                                <span class="sidenav-mini-icon"> I </span>
                                <span class="sidenav-normal"> Items Management </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

        </ul>
    </div>
    <div class="sidenav-footer mx-3 mt-3 pt-3">
        <div class="card card-background shadow-none card-background-mask-secondary" id="sidenavCard">
            <div class="full-background" style="background-image: url('assets/img/curved-images/white-curved.jpeg')"></div>
            <div class="card-body text-start p-3 w-100">
                <div class="icon icon-shape icon-sm bg-white shadow text-center mb-3 d-flex align-items-center justify-content-center border-radius-md">
                    <i class="ni ni-diamond text-dark text-gradient text-lg top-0" aria-hidden="true" id="sidenavCardIcon"></i>
                </div>
                <div class="docs-info">
                    <h6 class="text-white up mb-0">Need help?</h6>
                    <p class="text-xs font-weight-bold">Please check our docs</p>
                    <a href="/documentation/getting-started/overview.html" target="_blank" class="btn btn-white btn-sm w-100 mb-0">Documentation</a>
                </div>
            </div>
        </div>
    </div>
</aside><?php /**PATH F:\Learning Admin Panel\admin panel\resources\views/layouts/navbars/auth/sidebar.blade.php ENDPATH**/ ?>