/**
 *
 * You can write your JS code here, DO NOT touch the default style file
 * because it will make it harder for you to update.
 *
 * Register your select2 elements here
 * this will make it easier for you tu find components
 */

"use strict";

$(document).on('submit', '.update-form-submit-event', function (e) {
    e.preventDefault();
    var formData = new FormData(this);
    var form_id = $(this).attr("id");
    var error_box = $('#error_box', this);
    var submit_btn = $(this).find('.submit_btn');
    var btn_html = $(this).find('.submit_btn').html();
    var btn_val = $(this).find('.submit_btn').val();
    var button_text = (btn_html != '' || btn_html != 'undefined') ? btn_html : btn_val;


    // console.log(formData.set);
    formData.append(csrfName, csrfHash);
    // return;
    $.ajax({
        type: 'POST',
        url: $(this).attr('action'),
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        beforeSend: function () {
            submit_btn.html('Please Wait..');
            submit_btn.attr('disabled', true);
        },

        success: function (response) {
            csrfName = response['csrfName'];
            csrfHash = response['csrfHash'];
            if (response.error == false) {
                console.log(response.message);
                iziToast.success({
                    title: "Success",
                    message: response.message,
                    position: "topRight",
                })
                submit_btn.attr("disabled", false);
                submit_btn.html(button_text);
                $('.close').click();
                $('#user_list').bootstrapTable('refresh');
                $('#slider_list').bootstrapTable('refresh');
                window.location.reload();
            } else {
                if (typeof response.message === 'object' &&
                    !Array.isArray(response.message) &&
                    response.message !== null) {
                    for (var k in response.message) {
                        if (response.message.hasOwnProperty(k)) {
                            showToastMessage(response.message[k], "error");
                        }
                    }
                } else {
                    showToastMessage(response.message, "error");
                }
                submit_btn.attr("disabled", false);
                submit_btn.html(button_text);
                // $('.close').click();
                $('#update_modal').bootstrapTable('refresh');
            }
        }
    });
});






// activate and deactivate user
window.user_events = {
    'click .deactivate_user': function (e, value, row, index) {
        console.log(row);
        var user_id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to deactivate " + row.username,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'user_id': user_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/users/deactivate",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        csrfName = response['csrfName'];
                        csrfHash = response['csrfHash'];
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)

                        } else {
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)
                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .activate_user': function (e, value, row, index) {
        console.log(row);
        var user_id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to activate" + row.username,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'user_id': user_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/users/activate",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        csrfName = response['csrfName'];
                        csrfHash = response['csrfHash'];
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)

                        } else {
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)
                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    }
}



// slider events

$('#type_1').change(function () {
    if ($('#type_1').val() == 'services') {
        $('#categories_select_1').hide();
        $('#services_select_1').show();

    } else if ($('#type_1').val() == 'Category') {
        $('#categories_select_1').show();
        $('#services_select_1').hide();
    } else {
        $('#categories_select_1').hide();
        $('#services_select_1').hide();
    }
});

let source = '';
window.slider_events = {
    'click .edite-slider': function (e, value, row, index) {
        $('#id').val(row.id);
        $("#type_1").val(row.type);
        if (row.type == "services") {
            $("#service_item_1").val(row.type_id);
        }
        if (row.type == "Category") {
            $("#Category_item_1").val(row.type_id);
        }

        var regex = /<img.*?src="(.*?)"/;
        var src = regex.exec(row.slider_image)[1];

        source = src;
        console.log(src);
        $('#id').val(row.id)
        $('#offer_image').attr('src', src);
        if (row.og_status == "1") {
            $("#edit_slider_switch").prop('checked', true);
            $("#edit_slider_text").text("Enable");
        } else {
            $("#edit_slider_switch").prop('checked', false);
            $("#edit_slider_text").text("Disable");
        }

        $('#categories_select_1').hide();
        $('#services_select_1').hide();

        $("#type_1").val(row.type).trigger("change");

    },

    'click .delete-slider': function (e, value, row, index) {

        var users_id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(
                    baseUrl + "/admin/sliders/delete_sliders", {
                    [csrfName]: csrfHash,
                    user_id: users_id,

                },
                    function (data) {
                        csrfName = data.csrfName;
                        csrfHash = data.csrfHash;

                        console.log(data);
                        if (data.error == false) {

                            showToastMessage(data.message, "success");
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)
                            return;
                        } else {

                            return showToastMessage(data.message, "error");
                        }
                    }
                )
            }
        });

    },
};


//  featured section

$(document).ready(function () {
    $("#edit_section_type").change(function (e) {
        e.preventDefault();
        if ($(this).val() == 'categories') {
            $('.edit_category_item').removeClass('d-none');
            $('.edit_partners_ids').addClass('d-none');

        } else {
            $('.edit_partners_ids').removeClass('d-none');
            $('.edit_category_item').addClass('d-none');
        }
    });
});

window.featured_section_events = {
    'click .delete-featured_section': function (e, value, row, index) {

        // console.log(row);
        var id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(
                    baseUrl + "/admin/featured_sections/delete_featured_section", {
                    [csrfName]: csrfHash,
                    id: id,

                },
                    function (data) {
                        csrfName = data.csrfName;
                        csrfHash = data.csrfHash;

                        console.log(data);
                        if (data.error == false) {

                            showToastMessage(data.message, "success");
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)
                            return;
                        } else {

                            return showToastMessage(data.message, "error");
                        }
                    }
                )
            }
        });

    },
    'click .update_featured_section': function (e, value, row, index) {
        var category, partner, i;
        console.log(row);
        $('#id').val(row.id);
        $('#edit_title').val(row.title);
        $("#edit_section_type").val(row.section_type).trigger("change");
        if ($('#edit_section_type').val() == 'top_rated_partner') {
            $('.edit_partners_ids').addClass('d-none');
            $('.edit_category_item').addClass('d-none');
        }
        if ($('#edit_section_type').val() == 'top_rated_service') {
            $('.edit_partners_ids').addClass('d-none');
            $('.edit_category_item').addClass('d-none');
        }
        if (row.section_type == "categories") {
            category = row.category_ids.split(",");
            var value_given = row.category_ids.split(",");
            console.log();
            $(document).ready(function () {
                $("#edit_Category_item").val(row.category_ids.split(",")).select2({
                    placeholder: "Select Categories",
                });
            });
        } else {
            if (row.partners_ids != null) {
                partner = row.partners_ids.split(",");
                parseInt(row.partners_ids);
                console.log(typeof (row.partners_ids.split(",")));
            }
            $(document).ready(function () {
                $("#edit_partners_ids").val(partner).select2({
                    placeholder: "Select Partners",
                });
            });
        }
    },
};

$(document).ready(function () {
    $('#edit_section_type').on('change', function () {
        if ($(this).val() == 'categories') {
            $('.edit_category_item').removeClass('d-none');
            $('.edit_partners_ids').addClass('d-none');
        } else if ($(this).val() == 'partner' || $(this).val() == 'partners') {
            $('.edit_category_item').addClass('d-none');
            $('.edit_partners_ids').removeClass('d-none');
        } else if ($(this).val() == 'top_rated_partner' || $(this).val() == 'top_rated_service') {
            $('.edit_partners_ids').addClass('d-none');
            $('.edit_category_item').addClass('d-none');
        } else {
            $('.edit_partners_ids').addClass('d-none');
            $('.edit_category_item').addClass('d-none');
        }
    });
});

// promo code event


window.promo_codes_events = {

    'click .delete-promo_codes': function (e, value, row, index) {
        console.log(row.id);
        var id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                var input_body = {
                    [csrfName]: csrfHash,
                    'id': id
                };
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/promo_codes/delete",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        csrfName = response['csrfName'];
                        csrfHash = response['csrfHash'];
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#promo_code_list').bootstrapTable('refresh')
                            }, 2000)

                        } else {
                            setTimeout(() => {
                                $('#promo_code_list').bootstrapTable('refresh')
                            }, 2000)
                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });

    }
}

window.services_events_admin = {
    'click .delete': function (e, value, row, index) {
        console.log(row);
        var id = row.id;

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                var input_body = {
                    [csrfName]: csrfHash,
                    'id': id
                };
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/services/delete_service",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        csrfName = response['csrfName'];
                        csrfHash = response['csrfHash'];
                        if (response.error == false) {
                            // console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#service_list').bootstrapTable('refresh')
                            }, 2000)

                        } else {
                            showToastMessage(response.message, "error");
                            setTimeout(() => {
                                $('#service_list').bootstrapTable('refresh')
                            }, 2000)
                        }
                    }
                });
            }
        });
    },

    'click .edit': function (e, value, row, index) {
        console.log(row);
        $('#service_id').val(row.id);
        // To select partner
        $('#edit_partner').val(row.user_id);

        // For title of the service
        $('#edit_title').val(row.title);

        // for category and sub-category
        $('#edit_category_item').val(row.category_id).trigger("change");

        // for edit tags
        $('#edit_service_tags').val(row.tags);

        // for edit tax
        // console.log(row.tax_type.trim());
        $('#edit_tax_type').val(row.tax_type.trim());

        // for edit tax id
        // $('#edit_tax_id').val(row.tax_id);
        $('#edit_tax').val(row.tax);

        // for old_image
        console.log(row.image_of_the_service);
        var regex = /<img.*?src="(.*?)"/;
        if (row.image_of_the_service != null && row.image_of_the_service != "nothing found") {
            var src = regex.exec(row.image_of_the_service)[1];
            source = src;
            $('#edit_service_image').attr('src', source);
        }
        // console.log(source);

        // edit price
        $('#edit_price').val(row.price);
        // edit discount
        $('#edit_discounted_price').val(row.discounted_price);

        // switch button events
        if (row.on_site_allowed == "Allowed" || row.on_site_allowed == "allowed") {
            // for on site
            $('#edit_on_site').attr('checked', true);
        }
        if (row.is_pay_later_allowed == "Allowed" || row.is_pay_later_allowed == "allowed" || row.is_pay_later_allowed == "1") {
            // for Pay Later
            $('#edit_pay_later').attr('checked', true);
        }
        console.log(row.is_cancelable);
        if (row.cancelable == "1" || row.cancelable == "1") {
            // for on Allowed
            $('#edit_is_cancelable').attr('checked', true);
        }


        // for members
        $('#edit_members').val(row.number_of_members_required);
        $('#edit_duration').val(row.duration);
        $('#edit_max_qty').val(row.max_quantity_allowed);
        $('#edit_description').text(row.description);

        // 
    }
}

$(document).ready(function () {
    $('.edit_cancelable-till').hide();

    $('input[type=checkbox][name=edit_is_cancelable]').change(function () {
        if ($(this).is(':checked')) {
            // console.log('bhai');
            $(".edit_cancelable-till").show();
        } else {
            $('.edit_cancelable-till').hide();
        }
    });

});
// display newly selected image here for edit service only
function loadFile(event) {
    var image = document.getElementById('edit_service_image');
    image.src = URL.createObjectURL(event.target.files[0]);
};

window.payment_events_admin = {
    'click .delete': function (e, value, row, index) {
        console.log(row.id);
        var id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                var input_body = {
                    [csrfName]: csrfHash,
                    'id': id
                };
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partners/delete_request",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        csrfName = response['csrfName'];
                        csrfHash = response['csrfHash'];
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#payment_request_list').bootstrapTable('refresh')
                            }, 2000)

                        } else {
                            showToastMessage(response.message, "error");
                            setTimeout(() => {
                                $('#payment_request_list').bootstrapTable('refresh')
                            }, 2000)
                        }
                    }
                });
            }
        });

    }
}


window.system_user_events = {
    'click .deactivate-user': function (e, value, row, index) {
        console.log(row);
        var user_id = row.id;
        // return;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to deactivate this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'user_id': user_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/system_users/deactivate_user",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .activate-user': function (e, value, row, index) {
        console.log(row);
        var user_id = row.id;
        // return;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to deactivate this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'user_id': user_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/system_users/activate_user",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .delete-user': function (e, value, row, index) {
        console.log(row);
        var user_id = row.id;
        // return;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to deactivate this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'user_id': user_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/system_users/delete_user",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .edit-user': function (e, value, row, index) {
        console.log(row);
        $("#id").val(row.id);
        $(document).ready(function () {
            $("#edit_role").val(row.role_a).trigger("change");
            if ($("#edit_role").val() == 1) {
                $('#permissions').hide();
                console.log('hello');
            }
        });
        var permissions = JSON.parse(row.permissions);
        console.log(permissions);

        let values;
        var data = (permissions != null) ? true : false;
        if (data) {
            Object.keys(permissions).forEach(key => {

                let single_object = permissions[key];
                if (key == "create") {
                    console.log(single_object);
                    Object.keys(single_object).forEach(val => {
                        // create

                        if (single_object.order == 0) {
                            let order = $('#orders_create_edit')[0];
                            $(order).attr('checked', true);
                        }
                        if (single_object.category == 1) {
                            let category = $('#categories_create_edit')[0];
                            $(category).attr('checked', true);
                        }
                        if (single_object.offers == 1) {
                            let offers = $('#offers_create_edit')[0];
                            $(offers).attr('checked', true);
                        }
                        if (single_object.sliders == 1) {
                            let object = $('#sliders_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.tax == 1) {
                            let object = $('#tax_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.sliders == 1) {
                            let object = $('#sliders_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.services == 1) {
                            let object = $('#services_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.promo_code == 1) {
                            let object = $('#promo_code_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.featured_section == 1) {
                            let object = $('#featured_section_create_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.partner == 1 || single_object.partner != undefined) {
                            let object = $('#partner_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.notification == 1) {
                            let object = $('#send_notification_create_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.city == 1) {
                            let object = $('#city_create_edit ')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.faq == 1) {
                            let object = $('#faq_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.support_ticket == 1) {
                            let object = $('#support_tickets_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.settings == 1) {
                            let object = $('#settings_create_edit')[0];
                            $(object).attr('checked', true);
                        }
                    });
                } else if (key == "read") {
                    Object.keys(single_object).forEach(val => {
                        if (single_object.order == 0) {
                            let object = $('#orders_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.category == 1) {
                            let object = $('#categories_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.offers == 1) {
                            let object = $('#offers_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.sliders == 1) {
                            let object = $('#sliders_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.tax == 1) {
                            let object = $('#tax_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.services == 1) {
                            let object = $('#services_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.promo_code == 1) {
                            let object = $('#promo_code_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.featured_section == 1) {
                            let object = $('#featured_section_read_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.partner == 1 || single_object.partner != undefined) {
                            let object = $('#partner_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.customer != undefined && single_object.customer == 1) {
                            let object = $('#customers_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.notification == 1) {
                            let object = $('#send_notification_read_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.city == 1) {
                            let object = $('#city_read_edit ')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.faq == 1) {
                            let object = $('#faq_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.support_ticket == 1) {
                            let object = $('#support_tickets_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.settings == 1) {
                            let object = $('#settings_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.system == 1) {
                            let object = $('#system_user_read_edit')[0];
                            $(object).attr('checked', true);
                        }
                    });
                } else if (key == "update") {
                    // console.log(single_object);
                    Object.keys(single_object).forEach(val => {
                        if (single_object.order == 0) {
                            let object = $('#orders_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.category == 1) {
                            let object = $('#categories_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.offers == 1) {
                            let object = $('#offers_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.sliders == 1) {
                            let object = $('#sliders_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.tax == 1) {
                            let object = $('#tax_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.services == 1) {
                            let object = $('#services_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.promo_code == 1) {
                            let object = $('#promo_code_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.featured_section == 1) {
                            let object = $('#featured_section_update_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.partner == 1 || single_object.partner != undefined) {
                            let object = $('#partner_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.customer != undefined && single_object.customer == 1) {
                            let object = $('#customers_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.notification == 1) {
                            let object = $('#send_notification_update_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.city == 1) {
                            let object = $('#city_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.faq == 1) {
                            let object = $('#faq_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.system == 1) {
                            let object = $('#system_update_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.support_ticket == 1) {
                            let object = $('#support_tickets_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.settings == 1) {
                            let object = $('#settings_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.system_user == 1) {
                            let object = $('#system_user_update_edit')[0];
                            $(object).attr('checked', true);
                        }
                    });
                } else if (key == "delete") {
                    // console.log(single_object);
                    Object.keys(single_object).forEach(val => {
                        if (single_object.order == 0) {
                            let object = $('#orders_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.category == 1) {
                            let object = $('#categories_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.offers == 1) {
                            let object = $('#offers_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.sliders == 1) {
                            let object = $('#sliders_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.tax == 1) {
                            let object = $('#tax_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.services == 1) {
                            let object = $('#services_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.promo_code == 1) {
                            let object = $('#promo_code_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.featured_section == 1) {
                            let object = $('#featured_section_delete_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.partner == 1 || single_object.partner != undefined) {
                            let object = $('#partner_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.customer != undefined && single_object.customer == 1) {
                            let object = $('#customers_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.notification == 1) {
                            let object = $('#send_notification_delete_edit')[0];
                            $(object).attr('checked', true);
                        } //
                        if (single_object.city == 1) {
                            let object = $('#city_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.faq == 1) {
                            let object = $('#faq_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.system == 1) {
                            let object = $('#system_update_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.support_ticket == 1) {
                            let object = $('#support_tickets_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.settings == 1) {
                            let object = $('#settings_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                        if (single_object.system_user == 1) {
                            let object = $('#system_user_delete_edit')[0];
                            $(object).attr('checked', true);
                        }
                    });
                }
            });
        }
    }
}

function set_attribute_checked(ids) {
    for (let i = 0; i < Object.keys(ids).length; i++) {
        const element = ids[i];
        // console.log(element[0]);
        $(element[0]).attr('checked', true);
    }
}

$('#permissions').show();

$(document).ready(function () {
    $('#role').on('change', function (e) {
        let role = $(this).val();
        if (role == "super_admin") {
            $('#permissions').hide();
        } else {
            $('#permissions').show();
        }
    });

});
$('#edit_role').on('change', function (e) {
    let role = $(this).val();
    if (role == "1") {
        $('#permissions').hide();
    } else {
        $('#permissions').show();
    }
});


window.commission_events = {
    'click .pay-out': function (e, value, row, index) {
        console.log(row);

        $('#partner_id').val(row.partner_id);
    }
}

window.notification_event = {

    'click .delete-notification': function (e, value, row, index) {

        console.log(row);
        var users_id = row.id;
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(
                    baseUrl + "/admin/notification/delete_notification", {
                    [csrfName]: csrfHash,
                    user_id: users_id,

                },
                    function (data) {
                        csrfName = data.csrfName;
                        csrfHash = data.csrfHash;

                        console.log(data);
                        if (data.error == false) {

                            showToastMessage(data.message, "success");
                            setTimeout(() => {
                                $('#user_list').bootstrapTable('refresh')
                            }, 2000)
                            return;
                        } else {

                            return showToastMessage(data.message, "error");
                        }
                    }
                )
            }
        });

    },

};



// partner windows

// partner events

window.partner_events = {
    'click .deactivate_partner': function (e, value, row, index) {
        // console.log(row);
        var id = row.partner_id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to deactivate this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'partner_id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partner/deactivate_partner",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .activate_partner': function (e, value, row, index) {
        console.log(row);
        var id = row.partner_id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to activate this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'partner_id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partner/activate_partner",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .approve_partner': function (e, value, row, index) {
        ``
        console.log(row);
        var id = row.partner_id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to approve this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'partner_id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partner/approve_partner",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();
                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .disapprove_partner': function (e, value, row, index) {
        console.log(row);
        var id = row.partner_id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to disapprove this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'partner_id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partner/disapprove_partner",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();

                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .delete_partner': function (e, value, row, index) {
        console.log(row);
        var id = row.partner_id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this provider",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'partner_id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partner/delete_partner",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#partner_list').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();

                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    },

    'click .view_rating': function (e, value, row, index) {
        console.log(row);
        $('#partner_id').val(row.partner_id)
        var id = row.partner_id;

        $('#rating_table').bootstrapTable('refresh', {
            url: baseUrl + '/admin/partners/view_ratings/' + id
        });


        // console.log($('#rating_table').attr('data-url'));
    }
}

window.rating_event = {
    'click .delete_rating': function (e, value, row, index) {
        console.log(row);
        var id = row.id;
        // console.log(id);
        // return;

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this rating",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'id': id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/partners/delete_rating",
                    data: input_body,
                    dataType: "json",

                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#rating_table').bootstrapTable('refresh')
                            }, 2000)
                            window.location.reload();

                            return;
                        } else {
                            console.log(response);
                            window.location.reload();

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    }
}

window.order_service_events = {
    'click .cancel_order': function (e, value, row, index) {
        console.log(row);
        var id = row.id;
        var service_id = row.service_id;
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to cancel this service",
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Yes, Proceed!'
        }).then((result) => {
            var input_body = {
                [csrfName]: csrfHash,
                'id': id,
                'service_id': service_id
            };
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: baseUrl + "/admin/orders/cancel_order_service",
                    data: input_body,
                    dataType: "json",
                    success: function (response) {
                        if (response.error == false) {
                            console.log(response);
                            showToastMessage(response.message, "success");
                            setTimeout(() => {
                                $('#ordered_services_list').bootstrapTable('refresh')
                            }, 2000)
                            // window.location.reload();

                            // return;
                        } else {
                            console.log(response);
                            setTimeout(() => {
                                $('#ordered_services_list').bootstrapTable('refresh')
                            }, 2000)

                            return showToastMessage(response.message, "error");
                        }
                    }
                });
            }
        });
    }
}

function cancel_service(e) {
    console.log(e);
    // e.preventDefault();
    var id = $(e).data('id');
    var service_id = $(e).data('service_id');

    console.log(id, service_id);

    Swal.fire({
        title: 'Are you sure?',
        text: "Are you sure you want to cancel this service",
        icon: 'error',
        showCancelButton: true,
        confirmButtonText: 'Yes, Proceed!'
    }).then((result) => {
        var input_body = {
            [csrfName]: csrfHash,
            'id': id,
            'service_id': service_id
        };
        if (result.isConfirmed) {
            $.ajax({
                type: "POST",
                url: baseUrl + "/admin/orders/cancel_order_service",
                data: input_body,
                dataType: "json",
                success: function (response) {
                    if (response.error == false) {
                        console.log(response);
                        showToastMessage(response.message, "success");
                        setTimeout(() => {
                            $('#ordered_services_list').bootstrapTable('refresh')
                        }, 2000)
                        window.location.reload();

                        // return;
                    } else {
                        console.log(response);
                        setTimeout(() => {
                            $('#ordered_services_list').bootstrapTable('refresh')
                        }, 2000)
                        window.location.reload();
                        return showToastMessage(response.message, "error");
                    }
                }
            });
        }
    });
}

$(document).ready(function () {
    $('#available-slots').hide();
    $('.rescheduled_date').hide();
    $('#status').change(function (e) {
        e.preventDefault();
        var status = $('#status').val();
        if (status === 'rescheduled') {
            $('#available-slots').show();
            $('.rescheduled_date').show();
        } else {
            $('#available-slots').hide();
            $('.rescheduled_date').hide();
        }
    });

    $('#rescheduled_date').change(function (e) {
        $('#available-slots').empty();
        var weekday = new Array(7);
        e.preventDefault();
        var date = $('#rescheduled_date').val()
        var d = new Date(date)
        var id = $('#order_id').val();
        var input_body = {
            [csrfName]: csrfHash,
            'id': id,
            'date': date
        };
        $.ajax({
            type: "POST",
            url: baseUrl + "/admin/orders/get_slots",
            data: input_body,
            dataType: "JSON",
            success: function (response) {
                if (response.error == false) {
                    var slots = response.available_slots;
                    var slot_selector = "";
                    if (slots == "") {
                            slot_selector +=
                                `   <div class="col-md-12 form-group">
                                    <div class="selectgroup">
                                        <label class="selectgroup-item">
                                        <span class="text-danger">There is no slot available on this date!</span>
                                        </label>                                    
                                    </div>
                                </div>
                                 `;
                    } else {
                        slots.forEach(element => {
                            slot_selector +=
                                `   <div class="col-md-2 form-group">
                                    <div class="selectgroup">
                                        <label class="selectgroup-item">
                                        <input type="radio" name="reschedule" value="` + element + `" class="selectgroup-input">
                                            <span class="selectgroup-button selectgroup-button-icon">
                                                <i class="fas fa-sun"></i> &nbsp; ` + element + `
                                            </span>
                                        </label>                                    
                                    </div>
                                </div>
                                 `;
                        });
                    }
                    console.log(slot_selector);
                    $('#available-slots').append(slot_selector);
                } else {
                    var slot_selector = "";
                    if (response.error == true) {
                        slot_selector +=
                            `   <div class="col-md-12 form-group">
                                    <div class="selectgroup">
                                        <label class="selectgroup-item">
                                            <span class="text-danger">` + response.message + `</span>
                                        </label>                                    
                                    </div>
                                </div>
                                 `;
                    }
                    console.log(slot_selector);
                    $('#available-slots').append(slot_selector);
                    setTimeout(() => {
                        $('#ordered_services_list').bootstrapTable('refresh')
                    }, 2000);
                }
            }
        });

    });


    $('#change_status').on('click', function (e) {
        e.preventDefault();

        // var rc_time = $('.selectgroup-input');
        var status = $('#status').val();
        var order_id = $('#order_id').val();
        var date = $('#rescheduled_date').val()
        var selected_time = '';
        if ($('.selectgroup-input').length > 1) {
            selected_time = $('input[name="reschedule"]:checked').val();
        }
        var input_body = {
            [csrfName]: csrfHash,
            'order_id': order_id,
            'date': date,
            'status': status,
            'selected_time': selected_time,
        };
        // console.log(input_body);
        // return;
        $.ajax({
            type: "POST",
            url: baseUrl + "/admin/orders/change_order_status",
            data: input_body,
            dataType: "json",
            success: function (response) {

                if (response.error == false) {
                    showToastMessage(response.message, "success");

                } else {
                    showToastMessage(response.message, "error");

                }

            }
        });
    });
});
