<?php

namespace App\Controllers\admin;


class Profile extends Admin
{
    public function __construct()
    {
        parent::__construct();
        $this->validation = \Config\Services::validation();

    }
    public function index()
    {
        helper('function');
        if ($this->isLoggedIn) {
            $this->data['title'] = 'Profile | Admin Panel';
            $this->data['main_page'] = 'profile';
            $this->data['data'] = fetch_details('users', ['id' => $this->userId])[0];
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function update()
    {
        if ($this->isLoggedIn) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
          
 $config = new \Config\IonAuth();
 $tables  = $config->tables;
 $this->validation->setRules(
     [
         'username' => [
             "rules" => 'required|trim',
             "errors" => [
                 "required" => "Please enter username"
             ]
         ],
         'phone' => [
             "rules" => 'required|numeric|is_unique[' . $tables['users'] . '.phone]',
             "errors" => [
                 "required" => "Please enter admin's phone number",
                 "numeric" => "Please enter numeric phone number",
                 "is_unique" => "This phone number is already registered"
             ]
         ],
     ],
 );
 if (!$this->validation->withRequest($this->request)->run()) {
     $errors = $this->validation->getErrors();
     $response['error'] = true;
     $response['message'] = $errors;
     $response['csrfName'] = csrf_token();
     $response['csrfHash'] = csrf_hash();
     $response['data'] = [];

     return $this->response->setJSON($response);
 }
            $data = [
                'username' => $_POST['username'],
                'phone' => $_POST['phone'],
            ];
            if ($this->request->getPost('profile')) {
                $img = $this->request->getPost('profile');
                $f = finfo_open();
                $mime_type = finfo_buffer($f, $img, FILEINFO_MIME_TYPE);
                if ($mime_type != 'text/plain') {
                    $response['error'] = true;
                    return $this->response->setJSON([
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'error' => true,
                        'message' => "Please Insert valid image",
                        "data" => []
                    ]);
                }
                $data_photo = $img;
                $img_dir = './public/backend/assets/profiles/';
                list($type, $data_photo) = explode(';', $data_photo);
                list(, $data_photo) = explode(',', $data_photo);
                $data_photo = base64_decode($data_photo);
                $username = microtime(true) . '.jpg';
                if (!is_dir($img_dir)) {
                    mkdir($img_dir, 0777, true);
                }
                if (file_put_contents($img_dir . $username, $data_photo)) {
                    $profile = $username;
                    $data['image'] = $username;
                    $old_image = fetch_details('users', ['id' => $this->userId], ['image']);
                    if ($old_image[0]['image'] == '') {
                        if (is_readable("public/backend/assets/profiles/" . $old_image[0]['image']) && unlink("public/backend/assets/profiles/" . $old_image[0]['image'])) {
                        }
                    }
                } else {
                    $data['image'] = $this->input->post('old_profile');
                    $profile = $this->input->post('old_profile');
                }
            }
            $status = update_details(
                $data,
                ['id' => $this->userId],
                'users'
            );
            if ($status) {
                if (isset($_POST['old']) && isset($_POST['new']) && ($_POST['new'] != "") && ($_POST['old'] != "")) {



                    $identity = $this->session->get('identity');

                    $change = $this->ionAuth->changePassword($identity, $this->request->getPost('old'), $this->request->getPost('new'));

                    if ($change) {



                        $this->ionAuth->logout();
                        return $this->response->setJSON([
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'error' => false,
                            'message' => "User updated successfully",
                            "data" => $_POST
                        ]);
                    } else {
                        return $this->response->setJSON([
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'error' => true,
                            'message' => "Old password did not matched.",
                            "data" => $_POST
                        ]);
                    }
                }
                return $this->response->setJSON([
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'error' => false,
                    'message' => "User updated successfully",
                    "data" => $_POST
                ]);
            } else {
                return $this->response->setJSON([
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'error' => true,
                    'message' => "Something went wrong...",
                    "data" => []
                ]);
            }
        } else {
            return $this->response->setJSON([
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'error' => true,
                'message' => "unauthorized",
                "data" => []
            ]);
        }
    }
}
