<?php

namespace App\Controllers\api;

use App\Controllers\BaseController;
use App\Libraries\Flutterwave;
use App\Libraries\JWT;
use App\Libraries\Paystack;
use App\Libraries\Razorpay;
use App\Libraries\Stripe;

// use App\Models\Bank_transfers;
use App\Models\Addresses_model;
use App\Models\Bookmarks_model;
use App\Models\Category_model;
use App\Models\City_model;
use App\Models\Faqs_model;
use App\Models\Notification_model;
use App\Models\Orders_model;
use App\Models\Partners_model;
use App\Models\Promo_code_model;
use App\Models\Service_model;
use App\Models\Service_ratings_model;
use App\Models\Slider_model;
use App\Models\Transaction_model;
use DateTime;

class V1 extends BaseController
{

    protected $request;
    public $bank_transfer, $paytm;

    /*
    ---------------------------------
    API keys list
    ---------------------------------

    1.  manage_user
    2.  update_user
    3.  update_fcm
    4.  get_settings
    5.  get_sections
    6.  add_transaction
    6.  get_transactions
    7.  add_address
    8.  delete_address
    9.  get_address
    10. validate_promo_code
    11. get_promo_codes
    12. get_categories
    13. get_sub_categories
    14. get_sliders
    15. get_providers
    16. get_services
    17. get_cities
    18. is_city_deliverable
    19. manage_cart
    20. remove_from_cart
    21. get_cart
    22. place_order
    23. get_orders
    24. manage_notification
    25. get_notifications
    26. get_ticket_types
    27. add_ticket
    28. edit_ticket
    29. get_tickets
    30. send_message
    31. get_messages
    32. book_mark
    33. generate_paytm_checksum
    34. generate_paytm_txn_token
    35. validate_paytm_checksum
    36. update_order_status
    37. get_ratings
     */

    /**
     *   @var array $excluded_routes is an array of uri strings which we want to exclude from jwt verification.
     */

    protected $excluded_routes =
    [
        "/api/v1/index",
        "/api/v1",
        "/api/v1/get_services",
        "/api/v1/manage_user",
        "/api/v1/verify_user",
        "/api/v1/get_sections",
        "/api/v1/get_sliders",
        "/api/v1/get_categories",
        "/api/v1/get_sub_categories",
        "/api/v1/flutterwave",
        "/api/v1/get_providers",
        "/api/v1/get_home_screen_data",
        "/api/v1/get_settings",
        "/api/v1/get_faqs",
        "/api/v1/get_ratings",
    ];

    private $user_details = [];
    private $allowed_settings = ["general_settings", "terms_conditions", "privacy_policy", "about_us", 'payment_gateways_settings'];
    private $user_data = ['id', 'username', 'phone', 'email', 'fcm_id', 'image', 'latitude', 'longitude', 'friends_code', 'referral_code', 'city'];

    public function __construct()
    {
        helper('api');
        helper("function");
        $this->request = \Config\Services::request();
        $this->flutterwave = new Flutterwave();
        $this->paystack = new paystack();
        $this->razorpay = new Razorpay();
        $this->JWT = new JWT();

        $current_uri = uri_string();
        if (!in_array($current_uri, $this->excluded_routes)) {
            $token = verify_app_request();
            if ($token['error']) {
                header('Content-Type: application/json');
                http_response_code($token['status']);
                print_r(json_encode($token));
                die();
            }
            $this->user_details = $token['data'];
        } else {
            // check if the token has been sent even if it is excluded. then set the user details if found.
            $token = verify_app_request();
            if (!$token['error'] && isset($token['data']) && !empty($token['data'])) {
                $this->user_details = $token['data'];
            }
        }
    }

    public function index()
    {
        $response = \Config\Services::response();
        helper("filesystem");
        $response->setHeader('content-type', 'Text');
        return $response->setBody(file_get_contents(base_url('apidocs.txt')));
    }

    // 1. manage_user
    public function manage_user()
    {
        $config = new \Config\IonAuth();
        $validation = \Config\Services::validation();
        $request = \Config\Services::request();
        $identity_column = $config->identity;

        if ($identity_column == 'phone') {
            $identity = $request->getPost('mobile');
            $validation->setRule('mobile', 'mobile', 'required|numeric');
        } elseif ($identity_column == 'email') {
            $identity = $request->getPost('email');
            $validation->setRule('email', 'Email', 'required|valid_email');
        } else {
            $validation->setRule('identity', 'Identity', 'required');
        }

        if ($request->getPost('fcm_id')) {
            $validation->setRule('fcm_id', 'FCM ID', 'permit_empty');
        }

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        if (exists(['phone' => $identity], 'users')) {
            // Login Success
            $update_data = $data = $token_data = [];
            $data = fetch_details('users', ["phone" => $identity], $this->user_data)[0];
            if (($request->getPost('fcm_id')) && !empty($request->getPost('fcm_id'))) {
                $update_data = ["fcm_id" => $request->getPost('fcm_id')];
            }
            array_push($this->user_data, "api_key");
            $token = generate_tokens($identity);
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                // $update_data['api_key'] = $token;
                $token_data['user_id'] = $data['id'];
                $token_data['token'] = $token;
                if (isset($token_data) && !empty($token_data)) {
                    insert_details($token_data, 'users_tokens');
                }
            } else {
                // $update_data['api_key'] = $token;
                $token_data['user_id'] = $data['id'];
                $token_data['token'] = $token;

                if ($this->request->getPost('latitude') || !empty($this->request->getPost('latitude'))) {
                    $data['latitude'] = $update_data['latitude'] = $this->request->getPost('latitude');
                }
                if ($this->request->getPost('longitude') || !empty($this->request->getPost('longitude'))) {
                    $data['longitude'] = $update_data['longitude'] = $this->request->getPost('longitude');
                }

                if (isset($token_data) && !empty($token_data)) {
                    insert_details($token_data, 'users_tokens');
                }
                if (isset($update_data) && !empty($update_data)) {
                    update_details($update_data, ['phone' => $identity], "users", false);
                }
            }

            $data['image'] = (isset($data['image']) && !empty($data['image'])) ? base_url('public/backend/assets/profiles/' . $data['image']) : "";
            //remove null values
            $data = remove_null_values($data);

            $response = [
                'error' => false,
                "token" => $token,
                'message' => 'User Logged successfully',
                'data' => $data,
            ];
            return $this->response->setJSON($response);
        } else { //for no registered users
            if ($this->request->getPost('mobile') && empty($this->request->getPost('mobile'))) {
                return response('mobile required');
            }
            if ($this->request->getPost('latitude') && !empty($this->request->getPost('latitude'))) {
                $data['latitude'] = $this->request->getPost('latitude');
            }
            if ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))) {
                $data['longitude'] = $this->request->getPost('longitude');
            }

            if (!exists([$identity_column => $identity], 'users')) {

                if (!empty($_FILES['image']) && isset($_FILES['image'])) {
                    $file = $this->request->getFile('image');
                    $path = 'public/backend/assets/profiles/';
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $data['image'] = $path . $newName;
                }
                $data['phone'] = $identity;
                $data['active'] = 1;
                $data['username'] = $this->request->getPost('username');
                $data['email'] = $this->request->getPost('email');
                $data['fcm_id'] = $this->request->getPost('fcm_id');

                $data['friends_code'] = $this->request->getPost('friends_code');
                $data['referral_code'] = $this->request->getPost('referral_code');
                $data['city'] = $this->request->getPost('city');

                if ($insert_user = insert_details($data, 'users')) {
                    if (!exists(["user_id" => $insert_user['id'], "group_id" => 2], 'users_groups')) {
                        $group_data['user_id'] = $insert_user['id'];
                        $group_data['group_id'] = 2;
                        insert_details($group_data, 'users_groups');
                    }
                    $data = fetch_details('users', ['id' => $insert_user['id']], $this->user_data)[0];
                    $token = generate_token($identity);

                    $token_data['user_id'] = $data['id'];
                    $token_data['token'] = $token;
                    if (isset($token_data) && !empty($token_data)) {
                        insert_details($token_data, 'users_tokens');
                    }
                    $response = [
                        'error' => false,
                        "token" => $token,
                        'message' => 'User Login successfully',
                        'data' => remove_null_values($data),
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'User is already registered',
                    'data' => remove_null_values($data),
                ];
                return $this->response->setJSON($response);
            }
            $response['error'] = true;
            $response['message'] = 'Incorrect password !';
            return $this->response->setJSON($response);
        }
    }

    // 2. update_user
    public function update_user()
    {
        /*
        username:test             {optional}
        email:test@gmail.com      {optional}
        mobile:9874565478         {optional}
        image:FILE                {optional}
        referral_code:MY_CODE     {optional}
        fcm_id:YOUR_FCM_ID        {optional}
        friends_code:45dsrwr      {optional}
        city_id:10                {optional}
        latitude:66.89            {optional}
        longitude:67.8            {optional}
         */

        helper(['form', 'url']);
        if (!isset($_POST)) {
            $response = [
                'error' => true,
                'message' => "Please use Post request",
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $validation = \Config\Services::validation();
        $config = new \Config\IonAuth();
        $tables  = $config->tables;
        $validation->setRules(
            [
                'email' => 'permit_empty|valid_email',
                'phone' => 'permit_empty|numeric|is_unique[' . $tables['users'] . '.phone]',
                'username' => 'permit_empty',
                'referral_code' => 'permit_empty',
                'friends_code' => 'permit_empty',
                'city_id' => 'permit_empty',
                'latitude' => 'permit_empty',
                'longitude' => 'permit_empty',
            ],
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        //Data
        $arr = [];
        if ($this->request->getPost('username') && !empty($this->request->getPost('username'))) {
            $arr['username'] = $this->request->getPost('username');
        }
        if ($this->request->getPost('email') && !empty($this->request->getPost('email'))) {
            $arr['email'] = $this->request->getPost('email');
        }
        if ($this->request->getPost('mobile') && !empty($this->request->getPost('mobile'))) {
            $arr['phone'] = $this->request->getPost('mobile');
        }
        if ($this->request->getPost('referral_code') && !empty($this->request->getPost('referral_code'))) {
            $arr['referral_code'] = $this->request->getPost('referral_code');
        }
        if ($this->request->getPost('friends_code') && !empty($this->request->getPost('friends_code'))) {
            $arr['friends_code'] = $this->request->getPost('friends_code');
        }
        if ($this->request->getPost('city_id') && !empty($this->request->getPost('city_id'))) {
            // if (!exists(['id' => $this->request->getPost('city_id')], 'cities')) {
            //     return response('City not exist');
            // }
            $arr['city'] = $this->request->getPost('city_id');
        }
        if ($this->request->getPost('latitude') && !empty($this->request->getPost('latitude'))) {
            $arr['latitude'] = $this->request->getPost('latitude');
        }
        if ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))) {
            $arr['longitude'] = $this->request->getPost('longitude');
        }

        $user_id = $this->user_details['id'];
        if (!exists(['id' => $user_id], 'users')) {
            $response = [
                'error' => true,
                'message' => 'Invalid User Id',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        if ($this->request->getFile('image')) {
            $file = $this->request->getFile('image');

            if (!$file->isValid()) {
                $response = [
                    'error' => true,
                    'message' => 'Something went wrong please try after some time.',
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }

            $type = $file->getMimeType();
            if ($type == 'image/jpeg' || $type == 'image/png' || $type == 'image/jpg') {
                $path = FCPATH . 'public/backend/assets/profiles/';
                $check_image = fetch_details('users', ['id' => $this->user_details['id']], 'image');
                if (!empty($check_image)) {
                    $image_name = $check_image[0]['image'];
                    $profile_image = (file_exists(FCPATH . $path . $image_name)) ? $path . $image_name : ((file_exists(FCPATH . $image_name)) ? $image_name : ((!file_exists(FCPATH . $path . $image_name)) ? base_url("public/backend/assets/profiles/default.png") : $path . $image_name));
                    if (!empty($check_image[0]['image']) || $check_image[0]['image'] != '') {
                        if (check_exists(base_url('public/backend/assets/profiles/' . $profile_image)) || check_exists(base_url('/public/uploads/users/partners/' . $profile_image)) || check_exists($profile_image)) {
                            unlink($profile_image);
                        }
                    }
                }

                $image = $file->getName();
                $newName = $file->getRandomName();
                $file->move($path, $newName);
                $arr['image'] = $newName;
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Please attach a valid image file.',
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }
        }

        if (!empty($arr)) {
            $status = update_details($arr, ['id' => $user_id], 'users');
            if ($status) {
                $data = fetch_details('users', ['id' => $user_id], $this->user_data)[0];
                $data['image'] = base_url('public/backend/assets/profiles/' . $data['image']);
                $response = [
                    'error' => false,
                    'message' => 'User updated successfully.',
                    'data' => remove_null_values($data),

                ];
                return $this->response->setJSON($response);
            }
        } else {

            $response = [
                'error' => true,
                'message' => 'Please insert any one field to update.',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
    }

    // 3. update_fcm
    public function update_fcm()
    {
        /*
        fcm_id:1564ad654asd5754a5sd
         */

        $validation = \Config\Services::validation();
        $request = \Config\Services::request();

        $validation->setRules(
            ['fcm_id' => 'required'],
            ['fcm_id' => ['required' => 'fcm_id is required']]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $fcm_id = $this->request->getPost('fcm_id');

        if (update_details(['fcm_id' => $fcm_id], ['id' => $this->user_details['id']], 'users')) {
            return response('fcm id updated succesfully', true, ['fcm_id' => $fcm_id]);
        } else {
            return response();
        }
    }

    public function get_settings()
    {
        //     /*
        //         variable:{variable Name}    {privacy_policy, general_settings} (optional)
        //     */

        $validation = \Config\Services::validation();
        $request = \Config\Services::request();

        $variable = (isset($_POST['variable']) && !empty($_POST['variable'])) ? $_POST['variable'] : 'all';

        $setting = array();
        $setting = fetch_details('settings', '', 'variable', '', '', '', 'ASC');

        if (isset($variable) && !empty($variable) && in_array(trim($variable), $this->allowed_settings)) {
            $setting_res[$variable] = get_settings($variable, true);
        } else {
            foreach ($setting as $type) {
                $notallowed_settings = ["languages", "email_settings", "country_codes", "api_key_settings", "test"];
                if (!in_array($type['variable'], $notallowed_settings)) {
                    $setting_res[$type['variable']] = get_settings($type['variable'], true);
                }
            }
        }

        $this->toDateTime = date('Y-m-d H:i');

        $general_settings = $setting_res['general_settings'];
        $this->db = \Config\Database::connect();
        $this->builder = $this->db->table('settings');
        $system_time_zone = $setting_res['general_settings']['system_timezone'];

        date_default_timezone_set($system_time_zone);

        $customer_app_maintenance_mode_schedule_date = isset($setting_res['general_settings']['customer_app_maintenance_schedule_date']) ? (explode("to", $setting_res['general_settings']['customer_app_maintenance_schedule_date'])) : null;
        
        if(!empty($customer_app_maintenance_mode_schedule_date)){
            $customer_app_maintenance_mode_start_date = $customer_app_maintenance_mode_schedule_date[0];
            $customer_app_maintenance_mode_end_date = $customer_app_maintenance_mode_schedule_date[1];    
        }else{
            $customer_app_maintenance_mode_start_date = null;
            $customer_app_maintenance_mode_end_date = null;    
        }
        
        if (isset($setting_res['general_settings']['customer_app_maintenance_mode']) && $setting_res['general_settings']['customer_app_maintenance_mode'] == 1) {
            $today = strtotime(date('Y-m-d H:i'));
            $start_time = strtotime(date('Y-m-d H:i', strtotime($customer_app_maintenance_mode_start_date)));
            $expiry_time = strtotime(date('Y-m-d H:i', strtotime($customer_app_maintenance_mode_end_date)));
            if (($today >=  $start_time) && ($today <= $expiry_time)) {
                $setting_res['general_settings']['customer_app_maintenance_mode'] = "1";
                // $general_settings['customer_app_maintenance_mode'] = "1";
                // $json_string = json_encode($general_settings);
                // $this->builder->where('variable', "general_settings");
                // $this->builder->update(['value' => $json_string]);
                // $this->db->transComplete();
            } else {
                $setting_res['general_settings']['customer_app_maintenance_mode'] = "0";
                // $general_settings['customer_app_maintenance_mode'] = "0";
                // $json_string = json_encode($general_settings);
                // $this->builder->where('variable', "general_settings");
                // $this->builder->update(['value' => $json_string]);
                // $this->db->transComplete();
            }
        }else{
            $setting_res['general_settings']['customer_app_maintenance_mode'] = "0";
        }

        $provider_app_maintenance_mode_schedule_date = isset($setting_res['general_settings']['provider_app_maintenance_schedule_date']) ? (explode("to", $setting_res['general_settings']['provider_app_maintenance_schedule_date'])) : null;
        
        if(!empty($provider_app_maintenance_mode_schedule_date)){
            $provider_app_maintenance_mode_start_date = $provider_app_maintenance_mode_schedule_date[0];
            $provider_app_maintenance_mode_end_date = $provider_app_maintenance_mode_schedule_date[1];    
        }else{
            $provider_app_maintenance_mode_start_date = null;
            $provider_app_maintenance_mode_end_date = null;
        }
        


        if (isset($setting_res['general_settings']['provider_app_maintenance_mode']) && $setting_res['general_settings']['provider_app_maintenance_mode'] == 1) {
            $today = strtotime(date('Y-m-d H:i'));
            $start_time = strtotime(date('Y-m-d H:i', strtotime($provider_app_maintenance_mode_start_date)));
            $expiry_time = strtotime(date('Y-m-d H:i', strtotime($provider_app_maintenance_mode_end_date)));


            if (($today >=  $start_time) && ($today <= $expiry_time)) {
                $setting_res['general_settings']['provider_app_maintenance_mode'] = "1";
                // $general_settings['provider_app_maintenance_mode'] = "1";
                // $json_string = json_encode($general_settings);
                // $this->builder->where('variable', "general_settings");
                // $this->builder->update(['value' => $json_string]);
                // $this->db->transComplete();
            } else {
                $setting_res['general_settings']['provider_app_maintenance_mode'] = "0";
                // $general_settings['provider_app_maintenance_mode'] = "0";
                // $json_string = json_encode($general_settings);
                // $this->builder->where('variable', "general_settings");
                // $this->builder->update(['value' => $json_string]);
                // $this->db->transComplete();
            }
        }else{
            $setting_res['general_settings']['provider_app_maintenance_mode'] = "0";
        }


        $setting_res['server_time'] = $this->toDateTime;
        if (isset($setting_res) && !empty($setting_res)) {
            $response = [
                'error' => false,
                'message' => "setting recieved Successfully",
                'data' => $setting_res,
            ];
        } else {
            $response = [
                'error' => true,
                'message' => "No data found in setting",
                'data' => $setting_res,
            ];
        }

        return $this->response->setJSON($response);
    }

    public function get_home_screen_data()
    {
        /*
        latitude:12.1234578
        longitude:12.1234578
        id:15                   {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'latitude' => 'required',
                'longitude' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        // $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        // $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';

        $where = $additional_data = [];
        $multipleWhere = $partner_ids = '';

        $db = \Config\Database::connect();

        $builder = $db->table('sections');
        $sortable_fields = ['id' => 'id', 'title' => 'title', 'categories' => 'categories', 'style' => 'style', 'service_type' => 'service_type'];

        if (isset($search) and $search != '') {
            $multipleWhere = ['`id`' => $search, '`title`' => $search];
        }

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }

        // count of section
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        $total = $builder->select(' COUNT(id) as `total` ');

        $offer_count = $builder->get()->getResultArray();
        $total = $offer_count[0]['total'];

        // get section data
        $builder->select();
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $offer_recorded = $builder->orderBy($sort, $order)
            ->get()->getResultArray();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($offer_recorded as $row) {
            $partners = $sub_category_ids = $partners_ids = [];

            if ($row['section_type'] == 'categories') {
                if (!is_null($row['category_ids'])) {

                    $partners = $db->table('categories c');
                    $category_ids = explode(',', $row['category_ids']);

                    $ids = (!empty($sub_category_ids)) ? $sub_category_ids : $category_ids;

                    $partners = $partners->Select('c.*')
                        ->whereIn('c.id', $ids)
                        ->get()
                        ->getResultArray();

                    for ($i = 0; $i < count($partners); $i++) {
                        $partners[$i]['image'] = (!empty($partners[$i]['image'])) ? base_url('/public/uploads/categories/' . $partners[$i]['image']) : "";
                        $partners[$i]['discount'] = $partners[$i]['upto'] = "";

                        unset($partners[$i]['created_at']);
                        unset($partners[$i]['updated_at']);
                        unset($partners[$i]['deleted_at']);
                        unset($partners[$i]['slug']);
                        unset($partners[$i]['admin_commission']);
                        unset($partners[$i]['status']);

                        $parent_ids = array_values(array_unique(array_column($partners, "parent_id")));
                        $parent_ids = implode(", ", $parent_ids);
                    }
                }
                $type = 'sub_categories';
            } else {
                if (!is_null($row['partners_ids'])) {
                    $partners_ids = explode(',', $row['partners_ids']);
                }
                $settings = get_settings('general_settings', true);
                $Partners_model = new Partners_model();
                if (($this->request->getPost('latitude') && !empty($this->request->getPost('latitude')) && ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))))) {
                    $additional_data = [
                        'latitude' => $this->request->getPost('latitude'),
                        'longitude' => $this->request->getPost('longitude'),
                        // 'city_id' => $token['data']['city_id'],
                        'max_serviceable_distance' => $settings['max_serviceable_distance'],
                    ];
                }
                // $partners_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);

                // $partners = (!empty($partners_ids)) ? $Partners_model->list(true, $search,NULL, NULL, $sort, $order, $where, 'pd.partner_id', $partners_ids, $additional_data) : [];
                //
                if (is_array($partners_ids) && !empty($partners_ids)) {
                    $partners = $db->table('services s');
                    $partners = $partners->Select('p.id,p.username,p.company,pc.minimum_order_amount,p.image,pc.discount,pc.discount_type,pd.company_name')
                        ->join('users p', 'p.id=s.user_id')
                        ->join('partner_details pd', 'pd.partner_id=s.user_id')
                        ->join('promo_codes pc', 'pc.partner_id=p.id', 'left')
                        ->whereIn('s.user_id', $partners_ids)
                        ->groupBy('p.id')
                        ->get()
                        ->getResultArray();

                    for ($i = 0; $i < count($partners); $i++) {
                        $partners[$i]['upto'] = $partners[$i]['minimum_order_amount'];
                        if (!empty($partners[$i]['image'])) {
                            $image = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $partners[$i]['image'])) ? base_url('public/backend/assets/profiles/' . $partners[$i]['image']) : ((file_exists(FCPATH . $partners[$i]['image'])) ? base_url($partners[$i]['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $partners[$i]['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $partners[$i]['image'])));

                            // $partners[$i]['image'] = base_url('/public/uploads/users/partners/' . $partners[$i]['image']);
                            $partners[$i]['image'] = $image;
                            if ($partners[$i]['discount_type'] == 'percentage') {
                                $discount = $partners[$i]['discount'];
                                $upto = $partners[$i]['minimum_order_amount'];
                                unset($partners[$i]['discount_type']);
                            }
                        }
                        unset($partners[$i]['minimum_order_amount']);
                    }
                }

                $parent_ids = implode(", ", $partners_ids);
                $type = 'partners';
            }
            $tempRow['id'] = $row['id'];
            $tempRow['title'] = $row['title'];
            $tempRow['section_type'] = $type;

            if ($type == 'partners') {
                $tempRow['parent_ids'] = $parent_ids;
                $tempRow['partners'] = $partners;
                $tempRow['sub_categories'] = [];
            } else if ($type == 'sub_categories') {
                $tempRow['sub_categories'] = $partners;
                $tempRow['parent_ids'] = (isset($parent_ids) && !empty($parent_ids)) ? $parent_ids : "";
                $tempRow['partners'] = [];
            }
            $rows[] = $tempRow;
        }

        $section_data = remove_null_values($rows);

        $slider = new Slider_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 50;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'sl.id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('type')) {
            $where['type'] = $this->request->getPost('type');
        }
        if ($this->request->getPost('type_id')) {
            $where['type_id'] = $this->request->getPost('type_id');
        }

        $slider_data = $slider->list(true, $search, $limit, $offset, $sort, $order, $where);
        // returns everything from model

        // for categories
        $categories = new Category_model();

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('slug')) {
            $where['slug'] = $this->request->getPost('slug');
        }
        $where['parent_id'] = 0;

        $category_data = $categories->list(true, $search, null, null, $sort, $order, $where);
        $data['sections'] = $section_data;
        $data['sliders'] = remove_null_values($slider_data['data']);
        $data['categories'] = remove_null_values($category_data['data']);

        if (!empty($rows)) {
            $error = false;
            $message = 'sections fetched successfully';
        } else {
            $error = true;
            $message = 'data not found';
        }
        return response($message, $error, $data, 200);
    }

    // 5. get_sections
    public function get_sections()
    {
        /*
        latitude:12.1234578
        longitude:12.1234578
        id:15                   {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';

        $where = $additional_data = [];
        $multipleWhere = $partner_ids = '';

        $db = \Config\Database::connect();

        $builder = $db->table('sections');
        $sortable_fields = ['id' => 'id', 'title' => 'title', 'categories' => 'categories', 'style' => 'style', 'service_type' => 'service_type'];

        if (isset($search) and $search != '') {
            $multipleWhere = ['`id`' => $search, '`title`' => $search];
        }

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }

        // count of section
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        $total = $builder->select(' COUNT(id) as `total` ');

        $offer_count = $builder->get()->getResultArray();
        $total = $offer_count[0]['total'];

        // get section data
        $builder->select();
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $offer_recorded = $builder->orderBy($sort, $order)->limit($limit, $offset)
            ->get()->getResultArray();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($offer_recorded as $row) {
            $partners = $sub_category_ids = $partners_ids = [];

            if ($row['section_type'] == 'categories') {
                if (!is_null($row['category_ids'])) {

                    $partners = $db->table('categories c');
                    $category_ids = explode(',', $row['category_ids']);

                    $ids = (!empty($sub_category_ids)) ? $sub_category_ids : $category_ids;

                    $partners = $partners->Select('c.*')
                        ->whereIn('c.id', $ids)
                        ->get()
                        ->getResultArray();

                    for ($i = 0; $i < count($partners); $i++) {
                        $partners[$i]['image'] = (!empty($partners[$i]['image'])) ? base_url('/public/uploads/categories/' . $partners[$i]['image']) : "";
                        $partners[$i]['discount'] = $partners[$i]['upto'] = "";

                        unset($partners[$i]['created_at']);
                        unset($partners[$i]['updated_at']);
                        unset($partners[$i]['deleted_at']);
                        unset($partners[$i]['slug']);
                        unset($partners[$i]['admin_commission']);
                        unset($partners[$i]['status']);

                        $parent_ids = array_values(array_unique(array_column($partners, "parent_id")));
                        $parent_ids = implode(", ", $parent_ids);
                    }
                }
                $type = 'sub_categories';
            } else {
                if (!is_null($row['partners_ids'])) {
                    $partners_ids = explode(',', $row['partners_ids']);
                }
                if (is_array($partners_ids) && !empty($partners_ids)) {
                    $partners = $db->table('services s');
                    $partners = $partners->Select('p.id,p.username,pc.minimum_order_amount,p.image,pc.discount,pc.discount_type')
                        ->join('users p', 'p.id=s.user_id')
                        ->join('promo_codes pc', 'pc.partner_id=p.id', 'left')
                        ->whereIn('s.user_id', $partners_ids)
                        ->groupBy('p.id')
                        ->get()
                        ->getResultArray();

                    for ($i = 0; $i < count($partners); $i++) {
                        $partners[$i]['upto'] = $partners[$i]['minimum_order_amount'];
                        if (!empty($partners[$i]['image'])) {
                            $partners[$i]['image'] = base_url('public/uploads/users/partners/' . $partners[$i]['image']);
                            if ($partners[$i]['discount_type'] == 'percentage') {
                                $discount = $partners[$i]['discount'];
                                $upto = $partners[$i]['minimum_order_amount'];
                                unset($partners[$i]['discount_type']);
                            }
                        }
                        unset($partners[$i]['minimum_order_amount']);
                    }
                }
                $parent_ids = implode(", ", $partners_ids);

                $type = 'partners';
            }

            $tempRow['id'] = $row['id'];
            $tempRow['title'] = $row['title'];
            $tempRow['section_type'] = $type;

            if ($type == 'partners') {
                $tempRow['parent_ids'] = $parent_ids;
                $tempRow['partners'] = $partners;
                $tempRow['sub_categories'] = [];
            } else if ($type == 'sub_categories') {
                $tempRow['sub_categories'] = $partners;
                $tempRow['parent_ids'] = (isset($parent_ids) && !empty($parent_ids)) ? $parent_ids : "";
                $tempRow['partners'] = [];
            }
            $rows[] = $tempRow;
        }

        if (!empty($rows)) {
            $error = false;
            $message = 'sections fetched successfully';
        } else {
            $error = true;
            $message = 'data not found';
        }

        return response($message, $error, remove_null_values($rows), 200, ['total' => $total]);
    }

    // 5. add_transaction()
    public function add_transaction()
    {
        /*
        transaction_type : transaction // refund/order { optional - default is transaction }
        order_id:  23
        type :   payment_mthod name
        txn_id : 201567892154
        amount : 450
        status : success / failure
        message : Done
        payment_method:razorpay / paystack / flutterwave
         */

        $this->validation = \Config\Services::validation();

        $this->validation->setRules([
            'transaction_type' => 'required',
            'order_id' => 'required|numeric',
            'type' => 'required',
            'txn_id' => 'required',
            'amount' => 'required',
            'status' => 'required',
            'currency_code' => 'required',
            'message' => 'required',
        ]);

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        } else {
            $transaction_model = new Transaction_model();

            $txn_id = $this->request->getVar('txn_id');
            $payment_method = $this->request->getVar('payment_method');
            $user_id = $this->user_details['id'];

            $user = fetch_details('users', ['id' => $user_id]);
            if (empty($user)) {
                $response = [
                    'error' => true,
                    'message' => "User not found!",
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }

            $payment = verify_payment_transaction($txn_id, $payment_method);

            if ($payment['error'] == 1) {
                $data = array(
                    'transaction_type' => $this->request->getVar('transaction_type'),
                    'user_id' => $user_id,
                    'order_id' => $this->request->getVar('order_id'),
                    'type' => $this->request->getVar('type'),
                    'txn_id' => $txn_id,
                    'amount' => $this->request->getVar('amount'),
                    'status' => $this->request->getVar('status'),
                    'message' => $this->request->getVar('message'),
                );

                if ($transaction_model->save($data)) {
                    $response = [
                        'error' => false,
                        'message' => 'Transaction Added Successfully!',
                        'data' => [],
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => 'Transaction Not Added!',
                        'data' => [],
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Payment not found by the transaction ID!',
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }
        }
    }

    // 6. get_transactions
    public function get_transactions()
    {
        /*
        limit:10            {optional}
        offset:0            {optional}
        sort:id             {optional}
        order:asc           {optional}
         */

        $request = \Config\Services::request();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $user_id = $this->user_details['id'];

        if (!exists(['id' => $user_id], 'users')) {
            $response = [
                'error' => true,
                'message' => 'Invalid User Id.',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $res = fetch_details('transactions', ['user_id' => $user_id], ['id', 'user_id', 'order_id', 'type', 'txn_id', 'amount', 'status', 'message'], $limit, $offset, $sort, $order);
        $total = count($res);

        if (!empty($res)) {
            $response = [
                'error' => false,
                'message' => 'Transactions recieved successfully.',
                'total' => $total,
                'data' => $res,
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'No data found',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
    }

    // 7. add_address
    public function add_address()
    {
        /*
        address_id:40        {optional}
        mobile:1234567890
        address:time square empire
        city_id:1
        lattitude:12.123456
        longitude:123.45645
        area:bhuj
        type:office
        country_code:91     {optional}
        pincode:987654      {optional}
        state:gujrat        {optional}
        country:inda        {optional}
        is_default:1        {optional}
        landmark:#123 ,jaynagar Bhuj    {optional}
        alternate_mobile:7896541230     {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'address_id' => 'permit_empty',
                'mobile' => 'required|numeric',
                'address' => 'required|',
                'city_name' => 'required',
                'lattitude' => 'required|numeric',
                'longitude' => 'required|numeric',
                'area' => 'required',
                'type' => 'required',
                'country_code' => 'permit_empty',
                'alternate_mobile' => 'permit_empty|numeric',
                'landmark' => 'permit_empty',
                'pincode' => 'permit_empty|numeric',
                'state' => 'permit_empty',
                'country' => 'permit_empty',
                'is_default' => 'permit_empty',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        // if city not exist
        // if (!exists(['id' => $this->request->getPost('city_id')], 'cities')) {
        //     return response('Cities not exist');
        // }

        $data = [
            'user_id' => $this->user_details['id'],
            'type' => $this->request->getPost('type'),
            'address' => $this->request->getPost('address'),
            'area' => $this->request->getPost('area'),
            'mobile' => $this->request->getPost('mobile'),
            'city' => $this->request->getPost('city_name'),
            'lattitude' => $this->request->getPost('lattitude'),
            'longitude' => $this->request->getPost('longitude'),
            'alternate_mobile' => ($this->request->getPost('alternate_mobile') && !empty($this->request->getPost('alternate_mobile'))) ? $this->request->getPost('alternate_mobile') : null,
            'pincode' => ($this->request->getPost('pincode') && !empty($this->request->getPost('pincode'))) ? $this->request->getPost('pincode') : null,
            'landmark' => ($this->request->getPost('landmark') && !empty($this->request->getPost('landmark'))) ? $this->request->getPost('landmark') : null,
            'state' => ($this->request->getPost('state') && !empty($this->request->getPost('state'))) ? $this->request->getPost('state') : null,
            'country' => ($this->request->getPost('country') && !empty($this->request->getPost('country'))) ? $this->request->getPost('country') : null,
            'is_default' => ($this->request->getPost('is_default') && !empty($this->request->getPost('is_default'))) ? $this->request->getPost('is_default') : 0,
        ];

        //insert details in table
        if ($this->request->getPost('address_id')) {
            if (!exists(['id' => $this->request->getPost('address_id')], 'addresses')) {
                return response('address not exist');
            }
            $address_id = $this->request->getPost('address_id');
            if (isset($data['is_default']) && $data['is_default'] == 1) {
                $address = fetch_details('addresses', ['id' => $address_id]);
                update_details(['is_default' => '0'], ['user_id' => $address[0]['user_id']], 'addresses');
                update_details(['is_default' => '1'], ['id' => $address_id], 'addresses');
            }

            if (update_details($data, ['id' => $address_id], 'addresses', false)) {
                $action = true;
                $message = "address updated successfully";
            } else {
                $action = false;
                $message = "address not updated";
            }
        } else {
            if ($address = insert_details($data, 'addresses')) {
                $last_added_id = $address['id'];
                if (isset($data['is_default']) && $data['is_default'] == 1) {
                    update_details(['is_default' => '0'], ['user_id' => $data['user_id']], 'addresses');
                    update_details(['is_default' => '1'], ['id' => $last_added_id], 'addresses');
                }

                $action = true;
                $message = "address added successfully";
                $address_id = $address['id'];
            } else {
                $action = false;
                $message = "address not added";
            }
        }

        if ($action) {
            $data = [];
            return response($message, false, $data);
        } else {
            return response($message);
        }
    }

    // 8. delete_address
    public function delete_address()
    {
        /*
        address_id:12
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'address_id' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $address_id = $this->request->getPost('address_id');
        if (!exists(['id' => $this->request->getPost('address_id'), 'user_id' => $this->user_details['id']], 'addresses')) {
            return response('address not exist');
        }

        if (delete_details(['id' => $address_id], 'addresses')) {
            return response('Address Deleted successfully', false);
        } else {
            return response('Address not deleted');
        }
    }

    // 9. get_address
    public function get_address($address_id = 0)
    {
        /*
        address_id:11   {optional}
        limit:10        {optional}
        offset:0        {optional}
        sort:id         {optional}
        order:asc       {optional}
        search:bhuj     {optional}
         */

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 20;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        $where['a.user_id'] = $this->user_details['id'];
        if ($this->request->getPost('address_id')) {
            $where['a.id'] = $this->request->getPost('address_id');
        }
        if (!empty($address_id)) {
            $where['a.id'] = $address_id;
        }

        $address_model = new Addresses_model();
        $address = $address_model->list(true, $search, $limit, $offset, $sort, $order, $where);
        $is_default_counter = array_count_values(array_column($address['data'], 'is_default'));

        if (!isset($is_default_counter['1']) && !empty($address['data'])) {
            update_details(['is_default' => '1'], ['id' => $address['data'][0]['id']], 'addresses');
        }

        if (!empty($address_id)) {
            return remove_null_values($address['data']);
        }
        if (!empty($address['data'])) {
            return response('addresses fetched successfully', false, remove_null_values($address['data']), 200, ['total' => $address['total']]);
        } else {
            return response('address not found', false);
        }
    }

    // 10. validate_promo_code
    public function validate_promo_code()
    {
        /*
        promo_code:FOREVER
        final_total:100
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'promo_code' => 'required',
                'final_total' => 'required|numeric',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $promo_code = $this->request->getPost('promo_code');
        $final_total = $this->request->getPost('final_total');

        if (!exists(['promo_code' => $promo_code], 'promo_codes')) {
            return response('promo code not exist');
        }

        $promo_code = validate_promo_code($this->user_details['id'], $promo_code, $final_total);
        if ($promo_code['error'] == false) {
            return response($promo_code['message'], false, remove_null_values($promo_code['data']));
        } else {
            return response($promo_code['message']);
        }
    }

    // 11. get_promo_codes
    public function get_promo_codes()
    {
        /*
        partner_id:12
        // limit:10            {optional}
        // offset:0            {optional}
        sort:id             {optional}
        order:asc           {optional}
        search:forever      {optional}
         */

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'partner_id' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $partner_id = $this->request->getPost('partner_id');
        $where = ['pc.partner_id' => $partner_id, 'pc.status' => 1, ' start_date <= ' => date('Y-m-d'), '  end_date >= ' => date('Y-m-d')];

        $promo_codes_model = new Promo_code_model();
        $promo_codes = $promo_codes_model->list(true, $search, null, null, $limit, $order, $where);

        if (!empty($promo_codes['data'])) {
            return response('promo codes fetched successfully', false, remove_null_values($promo_codes['data']), 200, ['total' => $promo_codes['total']]);
        } else {
            return response('Data Not Found');
        }
    }

    // 12. get_categories
    public function get_categories()
    {
        /*
        id:10                   {optional}
        slug:repairing works    {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:repairing        {optional}
         */

        $categories = new Category_model();

        // $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        // $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('slug')) {
            $where['slug'] = $this->request->getPost('slug');
        }
        $where['parent_id'] = 0;

        $data = $categories->list(true, $search, null, null, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Categories fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('categories not found', false);
        }
    }

    // 13. get_sub_categories
    public function get_sub_categories()
    {
        /*
        category_id:12
        id:150                  {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:repairing        {optional}
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'category_id' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $categories = new Category_model();

        // $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        // $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('slug')) {
            $where['slug'] = $this->request->getPost('slug');
        }
        if ($this->request->getPost('category_id')) {
            $where['parent_id'] = $this->request->getPost('category_id');
        }
        if (!exists(['parent_id' => $this->request->getPost('category_id')], 'categories')) {
            return response('no sub categories found');
        }
        $data = $categories->list(true, $search, null, null, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Sub Categories fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('Sub categories not found', false);
        }
    }

    // 14. get_sliders
    public function get_sliders()
    {
        /*
        type_id:12              {optional}
        id:150                  {optional}
        type:default            {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:repairing        {optional}
         */

        $slider = new Slider_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('type')) {
            $where['type'] = $this->request->getPost('type');
        }
        if ($this->request->getPost('type_id')) {
            $where['type_id'] = $this->request->getPost('type_id');
        }

        $data = $slider->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('slider fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('slider not found');
        }
    }

    // 15. get_providers
    public function get_providers()
    {
        /*
        latitude:22.839715
        longitude:69.704199
        partner_id:12           {optional}
        category_id:150         {optional}
        service_id:12           {optional}
        sub_category_id:172     {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:repairing        {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'latitude' => 'required',
                'longitude' => 'required',

            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $Partners_model = new Partners_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 20;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('sort'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $filter = ($this->request->getPost('filter') && !empty($this->request->getPost('filter'))) ? $this->request->getPost('filter') : '';
        $where = $additional_data = [];
        $customer_id = '';
        $city_id = '';

        $token = verify_app_request();
        if ($token['error'] == 0) {
            $customer_id = $token['data']['id'];
            $additional_data = [
                'customer_id' => $customer_id,
            ];
            $settings = get_settings('general_settings', true);

            if (($this->request->getPost('latitude') && !empty($this->request->getPost('latitude')) && ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))))) {
                $additional_data = [
                    'latitude' => $this->request->getPost('latitude'),
                    'longitude' => $this->request->getPost('longitude'),
                    // 'city_id' => $token['data']['city_id'],
                    'max_serviceable_distance' => $settings['max_serviceable_distance'],
                ];
            }
        }
        if ($this->request->getPost('partner_id') && !empty($this->request->getPost('partner_id'))) {
            $where['pd.partner_id'] = $this->request->getPost('partner_id');
        }

        if ($this->request->getPost('category_id') && !empty($this->request->getPost('category_id'))) {
            $category_id[] = $this->request->getPost('category_id');

            $subcategory_data = fetch_details('categories', ['id' => $category_id], ['id', 'parent_id']);
            foreach ($subcategory_data as $res) {
                array_push($category_id, $res['parent_id']);
            }
            $c_id = implode(",", $category_id);

            $partner_ids = get_partner_ids('category', 'category_id', [$c_id], true);
            $data = (!empty($partner_ids)) ? $Partners_model->list(true, $search, $limit, $offset, $sort, $order, $where, 'pd.partner_id', $partner_ids, $additional_data) : [];
        } else if ($this->request->getPost('service_id') && !empty($this->request->getPost('service_id'))) {
            $service_id[] = $this->request->getPost('service_id');
            $partner_ids = get_partner_ids('service', 'id', $service_id, true);
            $data = (!empty($partner_ids)) ? $Partners_model->list(true, $search, $limit, $offset, $sort, $order, $where, 'pd.partner_id', $partner_ids, $additional_data) :
                [];
        } else if ($this->request->getPost('sub_category_id') && !empty($this->request->getPost('sub_category_id'))) {
            $sub_category_id[] = $this->request->getPost('sub_category_id');
            $partner_ids = get_partner_ids('category', 'category_id', $sub_category_id, true);
            $data = (!empty($partner_ids)) ? $Partners_model->list(true, $search, $limit, $offset, $sort, $order, $where, 'pd.partner_id', $partner_ids, $additional_data) : [];
        } elseif ($filter != '' && $filter == 'popularity') {
            $data = $Partners_model->list(true, $search, $limit, $offset, 'number_of_orders', 'desc', $where, 'partner_id', [], $additional_data);
        } elseif ($filter != '' && $filter == 'ratings') {
            $data = $Partners_model->list(true, $search, $limit, $offset, ' pd.number_of_ratings, pd.ratings', 'desc', $where, 'pd.partner_id', [], $additional_data);
            // print_r($data);
        } elseif ($filter != '' && $filter == 'discount') {
            $data = $Partners_model->list(true, $search, $limit, $offset, 'maximum_discount_up_to', 'desc', $where, 'pd.partner_id', [], $additional_data);
        } else {
            $data = $Partners_model->list(true, $search, $limit, $offset, $sort, $order, $where, 'pd.id', [], $additional_data);
            // print_r($data);
        }
        if (!empty($data['data'])) {
            for ($i = 0; $i < count($data['data']); $i++) {
                unset($data['data'][$i]['national_id']);
                unset($data['data'][$i]['passport']);
                unset($data['data'][$i]['tax_name']);
                unset($data['data'][$i]['tax_number']);
                unset($data['data'][$i]['bank_name']);
                unset($data['data'][$i]['account_number']);
                unset($data['data'][$i]['account_name']);
                unset($data['data'][$i]['bank_code']);
                unset($data['data'][$i]['swift_code']);
                unset($data['data'][$i]['type']);
                // unset($data['data'][$i]['advance_booking_days']);
                unset($data['data'][$i]['admin_commission']);
            }
            return response('partners fetched successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
        } else {
            return response('partners not found..', false);
        }
    }

    // 16. get_services
    public function get_services()
    {
        /*
        latitude:22.839715
        longitude:69.704199
        partner_id:12           {optional}
        category_id:150         {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:repairing        {optional}
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'latitude' => 'required',
                'longitude' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $Service_model = new Service_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = $additional_data = [];

        if ($this->request->getPost('partner_id') && !empty($this->request->getPost('partner_id'))) {
            $where['user_id'] = $this->request->getPost('partner_id');
        }
        if ($this->request->getPost('category_id') && !empty($this->request->getPost('category_id'))) {
            $where['category_id'] = $this->request->getPost('category_id');
        }
        $settings = get_settings('general_settings', true);
        if (($this->request->getPost('latitude') && !empty($this->request->getPost('latitude')) && ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))))) {
            $additional_data = [
                'latitude' => number_format((float) $this->request->getPost('latitude'), 6, '.', ''),
                'longitude' => number_format((float) $this->request->getPost('longitude'), 6, '.', ''),
                'max_serviceable_distance' => $settings['max_serviceable_distance'],
            ];
        }
        if (isset($this->user_details['id']) && $this->user_details['id']) {
            $additional_data = ['user_id' => $this->user_details['id']];
        }
        $data = $Service_model->list(true, $search, $limit, $offset, $sort, $order, $where, $additional_data);
        if (isset($data['error'])) {
            return response($data['message']);
        }
        if (!empty($data['data'])) {
            return response('services fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('services not found');
        }
    }

    // 17. get_cities
    public function get_cities()
    {
        /*
        id:12                   {optional}
        name:bhuj               {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */

        $City_model = new City_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }

        if ($this->request->getPost('name')) {
            $where['name'] = $this->request->getPost('name');
        }

        $data = $City_model->list(true, $search, $limit, $offset, $sort, $order, $where, $this->user_details);

        if (!empty($data['data'])) {
            return response('cities fetched successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
        } else {
            return response('cities not found');
        }
    }

    // 18. is_city_deliverable
    public function is_city_deliverable()
    {
        /*
        city_id:7
        OR
        name:bhuj
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'id' => 'permit_empty',
                'name' => 'permit_empty',
            ],
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $where = [];
        if (empty($this->request->getPost('id')) && empty($this->request->getPost('name'))) {
            return response('required city id or name');
        }
        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('name')) {
            $where['name'] = $this->request->getPost('name');
        }

        if (exists($where, 'cities')) {
            $city_id = fetch_details('cities', $where, 'id')[0]['id'];
            update_details(['city_id' => $city_id], ['id' => $this->user_details['id']], 'users');
            return response('city is deliverable', false, [], 200, ['city_id' => $city_id]);
        } else {
            return response('city is not deliverable', true, [], 200, ['city_id' => "0"]);
        }
    }

    // 19. manage_cart
    public function manage_cart()
    {
        /*
        service_id:12
        qty:1
        is_saved_for_later:1    {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'service_id' => 'required|numeric',
                'qty' => 'required|numeric|greater_than[0]',
                'is_saved_for_later' => 'permit_empty|numeric',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $service = fetch_details('services', ['id' => $this->request->getPost('service_id')], ['max_quantity_allowed']);
        if (empty($service)) {
            return response('service not found');
        }

        if ($service[0]['max_quantity_allowed'] < $this->request->getPost('qty')) {
            return response('max quanity allowed ' . $service[0]['max_quantity_allowed']);
        }
        $current_service_id = $this->request->getPost('service_id');
        $get_service_id = fetch_details('services', ['id' => $current_service_id]);

        $has_booked_before = fetch_details('cart', ['user_id' => $this->user_details['id']], ['id', 'service_id']);

        $cart_data = fetch_details('cart', ['service_id' => $this->request->getPost('service_id'), 'user_id' => $this->user_details['id']], ['id', 'is_saved_for_later']);
        if (exists(['service_id' => $this->request->getPost('service_id'), 'user_id' => $this->user_details['id']], 'cart')) {

            if (update_details(
                [
                    'qty' => $this->request->getPost('qty'),
                    'is_saved_for_later' => ($this->request->getPost('is_saved_for_later') == '') ? $cart_data[0]['is_saved_for_later']
                        : $this->request->getPost('is_saved_for_later'),
                ],
                ['service_id' => $this->request->getPost('service_id'), 'user_id' => $this->user_details['id']],
                'cart'
            )) {
                $error = false;
                $message = 'cart updated successfully';
                $user_id = $this->user_details['id'];
                // print_r($user_id);
                $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
                $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
                $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                $where = [];

                $cart_data = fetch_details('cart', ['user_id' => $user_id]);
                if (empty($cart_data)) {
                    return response('item not found');
                } else {
                    $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);
                    if (!empty($cart_details['data'])) {
                        return response(
                            $message,
                            $error,
                            remove_null_values($cart_details['data']),
                            200,
                            remove_null_values(
                                [
                                    'provider_id' => $cart_details['provider_id'],
                                    'provider_names' => $cart_details['provider_names'],
                                    'service_ids' => $cart_details['service_ids'],
                                    'qtys' => $cart_details['qtys'],
                                    'visiting_charges' => $cart_details['visiting_charges'],
                                    'advance_booking_days' => $cart_details['advance_booking_days'],
                                    'company_name' => $cart_details['company_name'],
                                    'total_duration' => $cart_details['total_duration'],
                                    'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                    'total_quantity' => $cart_details['total_quantity'],
                                    'sub_total' => $cart_details['sub_total'],
                                    'tax_percentage' => $cart_details['tax_percentage'],
                                    'tax_amount' => $cart_details['taxable_amount'],
                                    'overall_amount' => $cart_details['overall_amount'],
                                    'total' => $cart_details['total'],
                                ]
                            )
                        );
                    } else {
                        return response('item not found');
                    }
                }
            } else {
                $error = true;
                $message = 'cart not updated';
                return response($message, $error);
            }
        } else {
            if (sizeof($has_booked_before) > 0) {
                $current_partner_id = $get_service_id[0]['user_id'];
                $pervious_service_id = $has_booked_before[0]['service_id'];

                $pervious_user_id = fetch_details('services', ['id' => $pervious_service_id], ['user_id'])[0]['user_id'];

                if ($current_partner_id == $pervious_user_id) {
                    if (insert_details(['service_id' => $this->request->getPost('service_id'), 'qty' => $this->request->getPost('qty'), 'is_saved_for_later' => ($this->request->getPost('is_saved_for_later' != '')) ? $this->request->getPost('is_saved_for_later') : 0, 'user_id' => $this->user_details['id']], 'cart')) {
                        $error = false;
                        $message = 'cart added successfully';
                        $user_id = $this->user_details['id'];
                        // print_r($user_id);
                        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
                        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
                        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                        $where = [];

                        $cart_data = fetch_details('cart', ['user_id' => $user_id]);
                        // die();
                        if (empty($cart_data)) {
                            return response('item not found');
                        } else {

                            $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);
                            if (!empty($cart_details['data'])) {
                                return response(
                                    $message,
                                    $error,
                                    remove_null_values($cart_details['data']),
                                    200,
                                    remove_null_values(
                                        [
                                            'provider_id' => $cart_details['provider_id'],
                                            'provider_names' => $cart_details['provider_names'],
                                            'service_ids' => $cart_details['service_ids'],
                                            'qtys' => $cart_details['qtys'],
                                            'visiting_charges' => $cart_details['visiting_charges'],
                                            'advance_booking_days' => $cart_details['advance_booking_days'],
                                            'company_name' => $cart_details['company_name'],
                                            'total_duration' => $cart_details['total_duration'],
                                            'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                            'total_quantity' => $cart_details['total_quantity'],
                                            'sub_total' => $cart_details['sub_total'],
                                            'tax_percentage' => $cart_details['tax_percentage'],
                                            'tax_amount' => $cart_details['taxable_amount'],
                                            'overall_amount' => $cart_details['overall_amount'],
                                            'total' => $cart_details['total'],
                                        ]
                                    )
                                );
                            } else {
                                return response('item not found');
                            }
                        }
                        // return response($message, $error);
                    } else {
                        $error = true;
                        $message = 'cart not added';
                        return response($message, $error);
                    }
                } else {
                    $user_id = $this->user_details['id'];
                    delete_details(['user_id' => $user_id], 'cart');
                    insert_details(['service_id' => $this->request->getPost('service_id'), 'qty' => $this->request->getPost('qty'), 'is_saved_for_later' => ($this->request->getPost('is_saved_for_later' != '')) ? $this->request->getPost('is_saved_for_later') : 0, 'user_id' => $this->user_details['id']], 'cart');
                    $cart_details = fetch_cart(true, $this->user_details['id'], '', 10, 0, '', '', '');
                    $error = false;
                    $message = 'cart added successfully';
                    if (!empty($cart_details['data'])) {
                        return response(
                            $message,
                            $error,
                            remove_null_values($cart_details['data']),
                            200,
                            remove_null_values(
                                [
                                    'provider_id' => $cart_details['provider_id'],
                                    'provider_names' => $cart_details['provider_names'],
                                    'service_ids' => $cart_details['service_ids'],
                                    'qtys' => $cart_details['qtys'],
                                    'visiting_charges' => $cart_details['visiting_charges'],
                                    'advance_booking_days' => $cart_details['advance_booking_days'],
                                    'company_name' => $cart_details['company_name'],
                                    'total_duration' => $cart_details['total_duration'],
                                    'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                    'total_quantity' => $cart_details['total_quantity'],
                                    'sub_total' => $cart_details['sub_total'],
                                    'tax_percentage' => $cart_details['tax_percentage'],
                                    'tax_amount' => $cart_details['taxable_amount'],
                                    'overall_amount' => $cart_details['overall_amount'],
                                    'total' => $cart_details['total'],
                                ]
                            )
                        );
                    } else {
                        return response('item not found');
                    }
                }
            } else {
                if (insert_details(
                    [
                        'service_id' => $this->request->getPost('service_id'),
                        'qty' => $this->request->getPost('qty'),
                        'is_saved_for_later' => ($this->request->getPost('is_saved_for_later') != '') ? $this->request->getPost('is_saved_for_later') : '0', 'user_id' => $this->user_details['id'],
                    ],
                    'cart'
                )) {
                    $error = false;
                    $message = 'cart added successfully';
                    $user_id = $this->user_details['id'];
                    // print_r($user_id);
                    $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
                    $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                    $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
                    $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                    $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                    $where = [];

                    $cart_data = fetch_details('cart', ['user_id' => $user_id]);
                    // die();
                    if (empty($cart_data)) {
                        return response('item not found');
                    } else {

                        $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);
                        if (!empty($cart_details['data'])) {
                            return response(
                                $message,
                                $error,
                                remove_null_values($cart_details['data']),
                                200,
                                remove_null_values(
                                    [
                                        'provider_id' => $cart_details['provider_id'],
                                        'provider_names' => $cart_details['provider_names'],
                                        'service_ids' => $cart_details['service_ids'],
                                        'qtys' => $cart_details['qtys'],
                                        'visiting_charges' => $cart_details['visiting_charges'],
                                        'advance_booking_days' => $cart_details['advance_booking_days'],
                                        'company_name' => $cart_details['company_name'],
                                        'total_duration' => $cart_details['total_duration'],
                                        'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                        'total_quantity' => $cart_details['total_quantity'],
                                        'sub_total' => $cart_details['sub_total'],
                                        'tax_percentage' => $cart_details['tax_percentage'],
                                        'tax_amount' => $cart_details['taxable_amount'],
                                        'overall_amount' => $cart_details['overall_amount'],
                                        'total' => $cart_details['total'],
                                    ]
                                )
                            );
                        } else {
                            return response('item not found');
                        }
                    }
                    // return response($message, $error);
                } else {
                    $error = true;
                    $message = 'cart not added';
                    return response($message, $error);
                }
            }
        }
    }

    // 20. remove_from_cart
    public function remove_from_cart()
    {
        /*
        cart_id:1       {optional}
        service_id:12   {optional}
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'cart_id' => 'permit_empty',
                'service_id' => 'permit_empty|numeric',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $tax = get_settings('system_tax_settings', true)['tax'];
        $db = \Config\Database::connect();

        if (empty($this->request->getPost('cart_id')) && empty($this->request->getPost('service_id'))) {
            return response('required cart id or service id');
        }

        if (!empty($this->request->getPost('cart_id'))) {
            if (!exists(['id' => $this->request->getPost('cart_id'), 'user_id' => $this->user_details['id']], 'cart')) {
                return response('cart id not exist in cart');
            }
            if (delete_details(['id' => $this->request->getPost('cart_id')], 'cart')) {
                $error = false;
                $message = 'service removed from cart';

                $user_id = $this->user_details['id'];
                $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
                $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
                $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                $where = [];

                $cart_data = fetch_details('cart', ['user_id' => $user_id]);
                if (empty($cart_data)) {
                    return response($message, $error);
                } else {

                    $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);
                    if (!empty($cart_details['data'])) {
                        return response(
                            $message,
                            $error,
                            remove_null_values($cart_details['data']),
                            200,
                            remove_null_values(
                                [
                                    'provider_id' => $cart_details['provider_id'],
                                    'provider_names' => $cart_details['provider_names'],
                                    'service_ids' => $cart_details['service_ids'],
                                    'qtys' => $cart_details['qtys'],
                                    'visiting_charges' => $cart_details['visiting_charges'],
                                    'advance_booking_days' => $cart_details['advance_booking_days'],
                                    'company_name' => $cart_details['company_name'],
                                    'total_duration' => $cart_details['total_duration'],
                                    'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                    'total_quantity' => $cart_details['total_quantity'],
                                    'sub_total' => $cart_details['sub_total'],
                                    'tax_percentage' => $cart_details['tax_percentage'],
                                    'tax_amount' => $cart_details['taxable_amount'],
                                    'overall_amount' => $cart_details['overall_amount'],
                                    'total' => $cart_details['total'],
                                ]
                            )
                        );
                    } else {
                        return response('item not found');
                    }
                }
            } else {
                $error = true;
                $message = 'service not removed from cart';
                return response($message, $error);
            }
        } else {
            if (!exists(['service_id' => $this->request->getPost('service_id'), 'user_id' => $this->user_details['id']], 'cart')) {
                return response('service not exist in cart');
            }
            if (delete_details(['service_id' => $this->request->getPost('service_id')], 'cart')) {
                $error = false;
                $message = 'service removed from cart';
                $user_id = $this->user_details['id'];
                $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
                $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
                $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                $where = [];

                $cart_data = fetch_details('cart', ['user_id' => $user_id]);
                if (empty($cart_data)) {
                    return response($message, $error);
                } else {

                    $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);
                    if (!empty($cart_details['data'])) {
                        return response(
                            $message,
                            $error,
                            remove_null_values($cart_details['data']),
                            200,
                            remove_null_values(
                                [
                                    'provider_id' => $cart_details['provider_id'],
                                    'provider_names' => $cart_details['provider_names'],
                                    'service_ids' => $cart_details['service_ids'],
                                    'qtys' => $cart_details['qtys'],
                                    'visiting_charges' => $cart_details['visiting_charges'],
                                    'advance_booking_days' => $cart_details['advance_booking_days'],
                                    'company_name' => $cart_details['company_name'],
                                    'total_duration' => $cart_details['total_duration'],
                                    'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                                    'total_quantity' => $cart_details['total_quantity'],
                                    'sub_total' => $cart_details['sub_total'],
                                    'tax_percentage' => $cart_details['tax_percentage'],
                                    'tax_amount' => $cart_details['taxable_amount'],
                                    'overall_amount' => $cart_details['overall_amount'],
                                    'total' => $cart_details['total'],
                                ]
                            )
                        );
                    } else {
                        return response('item not found');
                    }
                }
            } else {
                $error = true;
                $message = 'service not removed from cart';
                return response($message, $error);
            }
        }
    }

    // 21. get_cart
    public function get_cart()
    {
        /*
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */
        $user_id = $this->user_details['id'];
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        $cart_data = fetch_details('cart', ['user_id' => $user_id]);

        if (empty($cart_data)) {
            return response('item not found');
        } else {

            $cart_details = fetch_cart(true, $this->user_details['id'], $search, $limit, $offset, $sort, $order, $where);

            if (!empty($cart_details)) {
                return response(
                    'cart fetched successfully',
                    false,
                    remove_null_values($cart_details['data']),
                    200,
                    remove_null_values(
                        [
                            'provider_id' => $cart_details['provider_id'],
                            'provider_names' => $cart_details['provider_names'],
                            'service_ids' => $cart_details['service_ids'],
                            'qtys' => $cart_details['qtys'],
                            'visiting_charges' => $cart_details['visiting_charges'],
                            'advance_booking_days' => $cart_details['advance_booking_days'],
                            'company_name' => $cart_details['company_name'],
                            'total_duration' => $cart_details['total_duration'],
                            'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                            'total_quantity' => $cart_details['total_quantity'],
                            'sub_total' => $cart_details['sub_total'],
                            'tax_percentage' => $cart_details['tax_percentage'],
                            'tax_amount' => $cart_details['taxable_amount'],
                            'overall_amount' => $cart_details['overall_amount'],
                            'total' => $cart_details['total'],
                        ]
                    )
                );
            } else {
                return response('item not found');
            }
        }
    }

    // 22. place_order
    public function place_order()
    {
        /*
        payment_method:cod
        address_id:2
        status:awaiting
        date_of_service:2022-05-21
        starting_time:12:35:00
        ending_time:12:35:00
        promo_code:TEST         {optional}
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'promo_code' => 'permit_empty',
                'payment_method' => 'required',
                'address_id' => 'required|numeric',
                'status' => 'required',
                'date_of_service' => 'required|valid_date[Y-m-d]',
                'starting_time' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $cart_data = fetch_cart(true, $this->user_details['id']);
        if (empty($cart_data)) {
            return response("Please add some item in cart", true);
        }

        $service_ids = $cart_data['service_ids'];
        $quantity = $cart_data['qtys'];
        $total = $cart_data['sub_total'];
        $visiting_charges = $cart_data['visiting_charges'];
        $promo_code = $this->request->getPost('promo_code');
        $payment_method = $this->request->getPost('payment_method');
        $address_id = $this->request->getPost('address_id');
        $status = strtolower($this->request->getPost('status'));
        $date_of_service = $this->request->getPost('date_of_service');
        $starting_time = $this->request->getPost('starting_time');
        $minutes = strtotime($starting_time) + ($cart_data['total_duration'] * 60);
        $ending_time = date('H:i:s', $minutes);
        if (!exists(['id' => $address_id], 'addresses')) {
            return response('Address not exist');
        }

        $final_total = intval($total) + intval($visiting_charges);
        $ids = explode(',', $service_ids ?? '');

        $qtys = explode(',', $quantity ?? '');

        $service_data = fetch_details('services', [], '', '', '', '', '', 'id', $ids);
        $partner_id = $service_data[0]['user_id'];
        $availability = check_availability($partner_id, $date_of_service, $starting_time);

        if (isset($availability) && $availability['error'] == "0") {
            $location_data = fetch_details('addresses', ['id' => $address_id], ['city', 'address']);
            $city_id = isset($location_data) && !empty($location_data) ? $location_data[0]['city'] : '';
            $address = isset($location_data) && !empty($location_data) ? $location_data[0]['address'] : '';
            $duration = (strtotime($ending_time) - strtotime($starting_time)) / 60;
            $order = [
                'partner_id' => $partner_id,
                'user_id' => $this->user_details['id'],
                'city' => $city_id,
                'total' => $total,
                'payment_method' => $payment_method,
                'address_id' => $address_id,
                'visiting_charges' => $visiting_charges,
                'address' => $address,
                'date_of_service' => $date_of_service,
                'starting_time' => $starting_time,
                'ending_time' => $ending_time,
                'duration' => $duration,
                'status' => $status,
            ];

            if (!empty($promo_code)) {
                $promo_code = validate_promo_code($this->user_details['id'], $promo_code, $final_total);
                if ($promo_code['error']) {
                    return $response['message'] = ($promo_code['message']);
                }
                //add dicounted final total
                $final_total = $promo_code['data'][0]['final_total'];
                $order['promo_code'] = $promo_code['data'][0]['promo_code'];
                $order['promo_discount'] = $promo_code['data'][0]['final_discount'];
            }
            $order['final_total'] = $final_total;
            $insert_order = insert_details($order, 'orders');
            if ($insert_order) {
                for ($i = 0; $i < count($ids); $i++) {
                    $service_details = get_taxable_amount($ids[$i]);
                    $data = [
                        'order_id' => $insert_order['id'],
                        'service_id' => $ids[$i],
                        'service_title' => $service_details['title'],
                        'tax_percentage' => $service_details['tax_percentage'],
                        'tax_amount' => $service_details['tax_amount'],
                        'price' => $service_details['price'],
                        'quantity' => $qtys[$i],
                        'sub_total' => ($service_details['taxable_amount'] * intval($qtys[$i])),
                        'status' => $status,
                    ];

                    insert_details($data, 'order_services');
                    $orderId['order_id'] = $insert_order['id'];
                }
            } else {
                return response('order not placed');
            }
            $cart_data = fetch_cart(true, $this->user_details['id']);
            // print_r($cart_data);
            foreach ($cart_data['data'] as $row) {
                delete_details(['id' => $row['id']], 'cart');
            }
            return response('Order Placed successfully', false, remove_null_values($orderId));
        } else {
            return response($availability['message'], true);
        }
    }

    // 23. get_orders
    public function get_orders()
    {
        /*
        id:10                   {optional}
        status:awating          {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
        download_invoice:0 // { default - 0 } optional
         */

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $download_invoice = ($this->request->getPost('download_invoice') && !empty($this->request->getPost('download_invoice'))) ? $this->request->getPost('download_invoice') : 1;

        $where = $additional_data = [];

        if ($this->request->getPost('id') && !empty($this->request->getPost('id'))) {
            $where['o.id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('status') && !empty($this->request->getPost('status'))) {
            $where['o.status'] = $this->request->getPost('status');
        }
        if ($this->user_details['id'] != '') {
            $where['o.user_id'] = $this->user_details['id'];
        }
        $orders = new Orders_model();
        $order_detail = $orders->list(true, $search, $limit, $offset, $sort, $order, $where, $download_invoice);

        if (!empty($order_detail['data'])) {
            return response('Order fetched successfully', false, remove_null_values($order_detail['data']), 200, ['total' => $order_detail['total']]);
        } else {
            return response('Order not found');
        }
    }

    // 24. manage_notification
    public function manage_notification()
    {
        /*
        notification_id:15
        is_readed:0             {optional}
        delete_notification:1   {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'notification_id' => 'required',
                'is_readed' => 'permit_empty|numeric',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $nfcs = fetch_details('notifications', ['id' => $this->request->getPost('notification_id')]);
        if (empty($nfcs)) {
            // print_r($nfcs);
            return response('notification not found!');
        }

        // if (!exists(['id' => $this->request->getPost('notification_id')], 'notifications')) {
        // }

        // delete notification
        if ($this->request->getPost('delete_notification') && $this->request->getPost('delete_notification') == 1) {
            $data = ['id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']];
            if (exists(['id' => $this->request->getPost('notification_id'), 'notification_type' => 'general'], 'notifications')) {
                if (exists(['notification_id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']], 'delete_general_notification')) {
                    update_details(['is_deleted' => 1], ['notification_id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']], 'delete_general_notification');
                    return response('Notification deleted successfully', false);
                } else {
                    insert_details(['is_deleted' => 1, 'notification_id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']], 'delete_general_notification');
                    return response('Notification deleted successfully', false);
                }
            }
            if (!exists($data, 'notifications')) {
                return response('notification not found');
            }
            if (delete_details($data, 'notifications')) {
                return response('Notification deleted successfully', false);
            } else {
                return response('Something get wrong');
            }
        }

        $data = ['id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']];
        if (!exists($data, 'notifications')) {
            return response('notification not found..');
        }

        if (exists(['id' => $this->request->getPost('notification_id'), 'notification_type' => 'general'], 'notifications')) {
            if (exists(['notification_id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']], 'delete_general_notification')) {
                update_details(['is_deleted' => !empty($this->request->getPost('is_readed')) ? 1 : 0], ['notification_id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']], 'delete_general_notification');
                return response('Notification updated successfully', false);
            } else {
                $set = [
                    'is_readed' => $this->request->getPost('is_readed') != '' ? 1 : 0,
                    'notification_id' => $this->request->getPost('notification_id'),
                    'user_id' => $this->user_details['id'],
                ];
                insert_details($set, 'delete_general_notification');
                return response('Notification updated successfully', false);
            }
        }

        $update_notifications = update_details(
            ['is_readed' => $this->request->getPost('is_readed') != '' ? 1 : 0],
            ['id' => $this->request->getPost('notification_id'), 'user_id' => $this->user_details['id']],
            'notifications'
        );

        if ($update_notifications == true) {
            $notifcations = $this->get_notifications($this->request->getPost('notification_id'));

            if (!empty($notifcations)) {
                $error = false;
                $message = 'notification updated successfully';
            } else {
                $error = true;
                $message = 'notification not found';
            }
            return response($message, $error, remove_null_values($notifcations));
        } else {
            return response('something get wrong');
        }
    }

    // 25. get_notifications
    public function get_notifications($id = 0)
    {
        /*
        id:10                   {optional}
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = $additional_data = [];

        if ($this->request->getPost('id') && !empty($this->request->getPost('id'))) {
            $where['id'] = $this->request->getPost('id');
        }
        if (!empty($id)) {
            $where['id'] = $id;
        }
        $notifications = new Notification_model();

        $get_notifications = $notifications->list(true, $search, $limit, $offset, $sort, $order, $where);
        foreach ($get_notifications['data'] as $key => $notifcation) {
            $dateTime = new DateTime($notifcation['date_sent']);
            $date = $dateTime->format('Y-m-d');
            $time = $dateTime->format('H:i');
            if ($date == date('Y-m-d')) {
                $start = strtotime($time);
                $end = time();
                $duration = $start - $end;
                $duration = date('H', $duration) . ' hours ago';
            } else {
                $now = time(); // or your date as well
                $date = strtotime($date);
                $datediff = $now - $date;
                $duration = round($datediff / (60 * 60 * 24)) . ' days ago';
            }
            $get_notifications['data'][$key]['duration'] = $duration;
        }
        if (!empty($id)) {
            return $get_notifications['data'];
        }
        if (!empty($get_notifications['data'])) {
            return response('Notifications fetched successfully', false, remove_null_values($get_notifications['data']), 200, ['total' => $get_notifications['total']]);
        } else {
            return response('Notification Not Found');
        }
    }

    // 26. get_ticket_types
    public function get_ticket_types()
    {
        helper("function");
        $type = fetch_details('ticket_types', [], ['id', 'title'], '', '', '', 'ASC');

        if (!empty($type)) {
            return response('Tickets type fetched successfuly', false, $type);
        } else {
            return response('Currently no tickets type available', true);
        }
    }

    // 27. add_ticket
    public function add_ticket()
    {
        /*
        ticket_type_id:1
        subject:test
        email:test@gmail.com
        description:testing
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'ticket_type_id' => 'required|trim|numeric',
                'subject' => 'required|trim',
                'email' => 'required|trim|valid_email',
                'description' => 'required|trim',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $ticket_type_id = $this->request->getPost('ticket_type_id');
        $subject = $this->request->getPost('subject');
        $email = $this->request->getPost('email');
        $description = $this->request->getPost('description');

        if (!exists(['id' => $ticket_type_id], 'ticket_types')) {
            return response('ticket type not exits');
        }
        if (exists(['user_id' => $this->user_details['id'], 'ticket_type_id' => $ticket_type_id, 'subject' => $subject], 'tickets')) {
            return response('ticket already created');
        }
        $data = [
            'ticket_type_id' => $ticket_type_id,
            'user_id' => $this->user_details['id'],
            'subject' => $subject,
            'email' => $email,
            'description' => $description,
            'status' => "0",
        ];
        $ticket = insert_details($data, 'tickets');

        if ($ticket) {
            $data = $this->get_tickets($ticket['id']);
            if (!empty($data[0])) {
                $data = $data[0];
            }
            return response('ticket generated successfuly', false, remove_null_values($data));
        } else {
            return response('Some thing get wrong', true);
        }
    }

    // 28. edit_ticket
    public function edit_ticket()
    {
        /*
        ticket_id:45
        ticket_type_id:1
        subject:test
        email:test@gmail.com
        description:testing
        status:1
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'ticket_id' => 'required|trim|numeric',
                'ticket_type_id' => 'required|trim|numeric',
                'subject' => 'required',
                'email' => 'required|trim|valid_email',
                'description' => 'required',
                'status' => 'permit_empty|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $ticket_id = $this->request->getPost('ticket_id');
        $ticket_type_id = $this->request->getPost('ticket_type_id');
        $subject = $this->request->getPost('subject');
        $email = $this->request->getPost('email');
        $description = $this->request->getPost('description');
        $status = $this->request->getPost('status');

        if (!exists(["id" => $ticket_id], 'tickets')) {
            return response('ticket does not exist', true, []);
        }
        if (!exists(["id" => $ticket_type_id], 'ticket_types')) {
            return response('ticket type does not exist', true, []);
        }

        if ($status == 4 && !exists(['status' => 3, 'id' => $ticket_id], 'tickets')) {
            return response('ticket is not closed', true, []);
        } else if ($status != 2 && $status != 4) {
            return response('user can only resolve or reopen ticket', true, []);
        }

        /* check if the user is updating his own ticket only or not. */
        $ticket_details = fetch_details('tickets', ['id' => $ticket_id], [])[0];
        if ($this->user_details['id'] != $ticket_details['user_id']) {
            $response = [
                'error' => true,
                'message' => "Invalid ticket ID supplied.",
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $data = [
            'ticket_type_id' => $ticket_type_id,
            'user_id' => $this->user_details['id'],
            'subject' => $subject,
            'email' => $email,
            'description' => $description,
            'status' => $status,
        ];
        $ticket = update_details($data, ['id' => $ticket_id], 'tickets');
        if ($ticket) {
            $data = $this->get_tickets($ticket_id);
            return response('ticket updated successfuly', false, $data[0]);
        } else {
            return response('Some thing get wrong', true);
        }
    }

    // 29. get_tickets
    public function get_tickets()
    {
        /*
        ticket_id:1         {optional}
        limit:10            {optional}
        offset:0            {optional}
         */

        $limit = !empty($this->request->getPost("limit")) ? $this->request->getPost("limit") : 10;
        $offset = !empty($this->request->getPost("offset")) ? $this->request->getPost("offset") : 0;
        $db = \Config\Database::connect();

        $where = ['t.user_id' => $this->user_details['id']];
        if ($this->request->getPost('ticket_id') && !empty($this->request->getPost('ticket_id'))) {
            $where['t.id'] = $this->request->getPost('ticket_id');
        }
        $ticket_id = ($this->request->getPost('ticket_id') != '') ? $this->request->getPost('ticket_id') : 0;
        $builder = $db->table('tickets t');
        $total = $builder->select('count(t.id) as total')
            ->join('ticket_types ttype', 't.ticket_type_id=ttype.id')
            ->where($where)
            ->get()
            ->getResultArray();

        $tickets = $builder->select('t.*,ttype.title as ticket_type')
            ->join('ticket_types ttype', 't.ticket_type_id=ttype.id')
            ->where($where)
            ->limit($limit, $offset)
            ->get()->getResultArray();

        $status = [
            0 => "Pending",
            1 => "Opened",
            2 => "Resolved",
            3 => "Closed",
            4 => "Reopened",
        ];
        $rows = [];
        foreach ($tickets as $ticket) {
            $temp = [];
            $temp['id'] = $ticket['id'];
            $temp['ticket_type_id'] = $ticket['ticket_type_id'];
            $temp['ticket_type'] = $ticket['ticket_type'];
            $temp['user_id'] = $ticket['user_id'];
            $temp['description'] = $ticket['description'];
            $temp['subject'] = $ticket['subject'];
            $temp['email'] = $ticket['email'];
            $temp['status_code'] = $ticket['status'];
            $temp['status'] = $status[$ticket['status']];
            $rows[] = $temp;
        }
        if ($ticket_id != 0) {
            return $rows;
        }
        if (!empty($rows)) {
            return response('Tickets  fetched successfuly', false, $rows, 200, ['total' => $total[0]['total']]);
        } else {
            return response('Currently no tickets  available', true);
        }
    }

    // 30. send_message
    public function send_message()
    {
        /*
        ticket_id:10
        message:test
        attachments[] : FILES  // {optional}
         */
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'ticket_id' => 'required|trim|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $ticket_id = $this->request->getPost('ticket_id');
        $message = $this->request->getPost('message');

        /* check if the user is sending message to his own ticket only or not. */
        $ticket_details = fetch_details('tickets', ['id' => $ticket_id]);
        if (!empty($ticket_details)) {
            if ($this->user_details['id'] != $ticket_details[0]['user_id']) {
                $response = [
                    'error' => true,
                    'message' => "Invalid user ID supplied.",
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }
        }

        if (!exists(['id' => $ticket_id], 'tickets')) {
            $response = [
                'error' => true,
                'message' => "Invalid ticket ID supplied.",
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $store_attac = [];
        if (!empty($_FILES['attachments']) && isset($_FILES['attachments'])) {

            $attachments = $this->request->getFileMultiple('attachments');
            /* just validate every file at first. */
            foreach ($attachments as $attachment) {
                if (!$attachment->isValid()) {
                    $response = [
                        'error' => true,
                        'message' => 'Something went wrong please try after some time.',
                        'data' => [],
                    ];
                    return $this->response->setJSON($response);
                }
                $attachment_type = $attachment->getMimeType();
                $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'video/mp4', 'video/mkv', 'video/mov'];
                if (!in_array($attachment_type, $allowed_types)) {
                    $response = [
                        'error' => true,
                        'message' => 'Please attach a valid  file.',
                        'data' => [],
                    ];
                    return $this->response->setJSON($response);
                }
            }
            /* if nothing goes wrong with attachments on top loop, then finally upload the attachments */
            $files = $this->request->getFileMultiple('attachments');
            $path = './public/support-ticket/';
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            foreach ($files as $file) {
                if ($file->isValid()) {
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $store_attac[] = 'public/support-ticket/' . $file->getName();
                }
            }
        } else if ((!isset($_FILES['attachments']) || $this->request->getFileMultiple('attachments') == []) && (!isset($_POST['message']) || empty(trim($_POST['message'])))) {
            return response("Oops! Blank message cannot be sent");
        }

        $data = [
            'user_type' => 'user',
            'user_id' => $this->user_details['id'],
            'ticket_id' => $ticket_id,
            'message' => $message,
            'attachments' => (isset($store_attac) && !empty($store_attac) ? json_encode($store_attac) : ""),
        ];

        $ticket_messages = insert_details($data, 'ticket_messages');
        if ($ticket_messages) {
            // add domain path images
            if (isset($store_attac) && !empty($store_attac)) {
                for ($i = 0; $i < count($store_attac); $i++) {
                    $store_attac[$i] = base_url($store_attac[$i]);
                }
            }
            $data['attachments'] = (!empty($store_attac)) ? $store_attac : [];
            return response('Message sent successfully', false, $data);
        } else {
            return response('Some thing get wrong', true);
        }
    }

    // 31. get_messages
    public function get_messages()
    {
        /*
        ticket_id:10
        limit:10           {optional}
        offset:0           {optional}
        sort:id             {optional}
        order:asc           {optional}
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'ticket_id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $db = \Config\Database::connect();
        $limit = !empty($this->request->getPost("limit")) ? $this->request->getPost("limit") : 10;
        $offset = !empty($this->request->getPost("offset")) ? $this->request->getPost("offset") : 0;
        $sort = !empty($this->request->getPost("sort")) ? $this->request->getPost("sort") : 'tm.id';
        $order = !empty($this->request->getPost("order")) ? $this->request->getPost("order") : 'DESC';
        $ticket_id = $this->request->getPost('ticket_id');

        $ticket_details = fetch_details('tickets', ['id' => $ticket_id], [])[0];
        if ($this->user_details['id'] != $ticket_details['user_id']) {
            $response = [
                'error' => true,
                'message' => "Invalid ticket ID supplied.",
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $builder = $db->table('ticket_messages tm');
        $total = $builder->select('count(tm.id) as total')
            ->where('tm.ticket_id', $ticket_id)
            ->get()
            ->getResultArray();

        $ticket_messages = $builder->select('tm.*')
            ->where('tm.ticket_id', $ticket_id)
            ->limit($limit, $offset)
            ->orderBy($sort, $order)
            ->get()
            ->getResultArray();

        $rows = [];
        $status = [
            0 => "Pending",
            1 => "Opened",
            2 => "Resolved",
            3 => "Closed",
            4 => "Reopened",
        ];

        $rows['ticket_details'] = [
            'status' => $status[$ticket_details['status']],
            'status_code' => $ticket_details['status'],
        ];

        foreach ($ticket_messages as $message) {
            $message['attachments'] = json_decode(str_replace("'", '', $message['attachments']));
            if (!empty($message['attachments'])) {
                // add domain path in images
                for ($i = 0; $i < count($message['attachments']); $i++) {
                    $message['attachments'][$i] = base_url($message['attachments'][$i]);
                }
            }

            $temp = [];
            $temp['id'] = $message['id'];
            $temp['user_type'] = $message['user_type'];
            $temp['message'] = $message['message'];
            $temp['attachments'] = (!empty($message['attachments'])) ? $message['attachments'] : [];

            $rows['messages'][] = $temp;
        }

        if (!empty($rows['messages'])) {
            return response('Messages Retrived successfully', false, $rows, 200, ['total' => $total[0]['total']]);
        } else {
            return response('Currently no messages are available', true, $rows);
        }
    }

    // 32. book_mark
    public function book_mark()
    {
        /*
        type:add/remove/list
        partner_id:12
        limit:10            {optional}
        offset:0            {optional}
        sort:id             {optional}
        order:asc           {optional}
        search:test         {optional}
         */

        $book_marks = new Bookmarks_model();
        $validation = \Config\Services::validation();

        $user_id = $this->user_details['id'];

        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = ['b.user_id' => $user_id];

        $validation->setRules(
            [
                'type' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $type = $this->request->getPost('type');
        if ($type == 'add' || $type == "remove") {
            $validation->setRules(
                [
                    'partner_id' => 'required',
                ]
            );
            if (!$validation->withRequest($this->request)->run()) {
                $errors = $validation->getErrors();
                $response = [
                    'error' => true,
                    'message' => $errors,
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }
        }

        $partner_id = $this->request->getPost('partner_id');

        $is_booked = is_bookmarked($user_id, $partner_id)[0]['total'];

        $partner_details = fetch_details('partner_details', ['partner_id' => $partner_id]);
        $data = [
            'user_id' => $user_id,
            'partner_id' => $partner_id,
        ];

        if ($type == 'add' && !empty($partner_details)) {
            if ($is_booked == 0) {
                if ($book_marks->save($data)) {
                    return response('Added to book marks', false, [], 200);
                } else {
                    return response('Could not add to the book marks', true, [], 200);
                }
            } else {
                return response('This partner is already bookmarked', true, [], 200);
            }
        } else if ($type == 'remove' && !empty($partner_details)) {
            $remove = delete_bookmark($user_id, $partner_id);
            if ($is_booked > 0) {
                if ($remove) {
                    return response('Removed from book marks', false, [], 200);
                } else {
                    return response('Could not remove form', true, [], 200);
                }
            } else {
                return response('No partner selected', true, [], 200);
            }
        } elseif ($type == "list") {

            $Partners_model = new Partners_model();
            $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
            $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
            $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('sort'))) ? $this->request->getPost('sort') : 'id';
            $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
            $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
            $where = $additional_data = [];
            $filter = ($this->request->getPost('filter') && !empty($this->request->getPost('filter'))) ? $this->request->getPost('filter') : '';
            $customer_id = $this->user_details['id'];

            if ($customer_id != '') {
                $additional_data = [
                    'customer_id' => $customer_id,
                ];
            }

            $partner_ids = favorite_list($user_id);

            $data = $Partners_model->list(true, $search, $limit, $offset, $sort, $order, $where, 'pd.partner_id', $partner_ids, $additional_data);
            $user = ['user_id' => $user_id];
            // print_r($data);
            if (!empty($data['data'])) {
                for ($i = 0; $i < count($data['data']); $i++) {
                    unset($data['data'][$i]['national_id']);
                    unset($data['data'][$i]['passport']);
                    unset($data['data'][$i]['tax_name']);
                    unset($data['data'][$i]['tax_number']);
                    unset($data['data'][$i]['bank_name']);
                    unset($data['data'][$i]['account_number']);
                    unset($data['data'][$i]['account_name']);
                    unset($data['data'][$i]['bank_code']);
                    unset($data['data'][$i]['swift_code']);
                    unset($data['data'][$i]['type']);
                    unset($data['data'][$i]['advance_booking_days']);
                    unset($data['data'][$i]['admin_commission']);
                    array_merge($data['data'][$i], $user);
                }
                return response('Bookmarks Retrieved successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
            } else {
                return response("No Bookmarks found", false);
            }

            $data = $book_marks->list(true, $search, $limit, $offset, $sort, $order, $where);
            return response('Data Retrived successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
        }
    }

    // 33. generate_paytm_checksum
    public function generate_paytm_checksum()
    {
        $validation = \Config\Services::validation();

        /*
        order_id:1001
        amount:1099
        user_id:73              //{ optional }
        industry_type:Industry  //{ optional }
        channel_id:WAP          //{ optional }
        website:website link    //{ optional }
         */

        $validation->setRules(
            [
                'order_id' => 'required',
                'amount' => 'required|numeric',
            ],
            [
                'subscription_id' => [
                    'required' => 'User id is required',
                ],
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        } else {
            $settings = get_settings('payment_gateways_settings', true);
            $credentials = $this->paytm->get_credentials();
            $paytm_params["MID"] = $settings['paytm_merchant_id'];

            $paytm_params["ORDER_ID"] = $this->request->getPost('order_id');
            $paytm_params["TXN_AMOUNT"] = $this->request->getPost('amount');
            $paytm_params["CUST_ID"] = $this->user_details['id'];

            $paytm_params["WEBSITE"] = (($this->request->getPost('website', true) != null) && !empty($this->request->getPost('website'))) ? $this->request->getPost('website', true) : '';

            $paytm_params["CALLBACK_URL"] = $credentials['url'] . "theia/paytmCallback?ORDER_ID=" . $paytm_params["ORDER_ID"];

            $paytm_checksum = $this->paytm->generateSignature($paytm_params, $settings['paytm_merchant_key']);

            if (!empty($paytm_checksum)) {
                $response['error'] = false;
                $response['message'] = "Checksum created successfully";
                $response['order id'] = $paytm_params["ORDER_ID"];
                $response['data'] = $paytm_params;
                $response['signature'] = $paytm_checksum;
                return $this->response->setJSON($response);
            } else {
                $response['error'] = true;
                $response['message'] = "Data not found!";
                return $this->response->setJSON($response);
            }

            $data['error'] = true;
            $data['message'] = "checking if we're here";
            $data['data'] = $paytm_params;
            return $this->response->setJSON($data);
        }
    }

    // 34. generate_paytm_txn_token
    public function generate_paytm_txn_token()
    {
        $validation = \Config\Services::validation();

        /*
        amount:100.00
        order_id:102
        user_id:73
        industry_type:      //{optional}
        channel_id:      //{optional}
        website:      //{optional}
         */
        if (!$user_token = verify_tokens()) {
            $status = $this->response->getStatusCode();
            return $this->response->setStatusCode($status);
        }

        $validation->setRules(
            [
                'order_id' => 'required',
                'amount' => 'required|numeric',
                'user_id' => 'required|numeric',
            ],
            [
                'user_id' => [
                    'required' => 'User id is required',
                ],
                'order_id' => [
                    'required' => 'order id is required',
                ],
                'amount' => [
                    'required' => 'amount id is required',
                ],
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        } else {
            $credentials = $this->paytm->get_credentials();
            $order_id = $_POST['order_id'];
            $amount = $_POST['amount'];
            $user_id = $_POST['user_id'];
            $paytmParams = array();

            $paytmParams["body"] = array(
                "requestType" => "Payment",
                "mid" => $credentials['paytm_merchant_id'],
                "websiteName" => "WEBSTAGING",
                "orderId" => $order_id,
                "callbackUrl" => $credentials['url'] . "theia/paytmCallback?ORDER_ID=" . $order_id,
                "txnAmount" => array(
                    "value" => $amount,
                    "currency" => "INR",
                ),
                "userInfo" => array(
                    "custId" => $user_id,
                ),
            );

            $checksum = $this->paytm->generateSignature(json_encode($paytmParams["body"], JSON_UNESCAPED_SLASHES), $credentials['paytm_merchant_key']);

            $paytmParams["head"] = array(
                "signature" => $checksum,
            );

            $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);
            $url = $credentials['url'] . "/theia/api/v1/initiateTransaction?mid=" . $credentials['paytm_merchant_id'] . "&orderId=" . $order_id;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json"));
            $paytm_response = curl_exec($ch);

            if (!empty($paytm_response)) {
                $paytm_response = json_decode($paytm_response, true);
                if (isset($paytm_response['body']['resultInfo']['resultMsg']) && ($paytm_response['body']['resultInfo']['resultMsg'] == "Success" || $paytm_response['body']['resultInfo']['resultMsg'] == "Success Idempotent")) {
                    $response['error'] = false;
                    $response['message'] = "Transaction token generated successfully";
                    $response['txn_token'] = $paytm_response['body']['txnToken'];
                    $response['paytm_response'] = $paytm_response;
                    return $this->response->setJSON($response);
                } else {
                    $response['error'] = true;
                    $response['message'] = $paytm_response['body']['resultInfo']['resultMsg'];
                    $response['txn_token'] = "";
                    $response['paytm_response'] = $paytm_response;
                    return $this->response->setJSON($response);
                }
            }
        }
    }

    // 35. validate_paytm_checksum
    public function validate_paytm_checksum()
    {
        /**
         *  paytm_checksum:PAYTM_CHECKSUM
         *  order_id:1001
         *  amount:1099
         *  user_id:73              //{ optional }
         *  industry_type:Industry  //{ optional }
         *  channel_id:WAP          //{ optional }
         *  website:website link    //{ optional }
         */
        $validation = \Config\Services::validation();

        if (!$user_token = verify_tokens()) {
            $status = $this->response->getStatusCode();
            return $this->response->setStatusCode($status);
        }

        $validation->setRules(
            [
                'order_id' => 'required',

            ],
            [
                'order_id' => [
                    'required' => 'User id is required',
                ],
            ]
        );
        $order_id = $this->request->getPost('order_id');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        } else {
            $data = verify_payment_transaction($order_id, 'paytm');
            $response = [
                'error' => false,
                'message' => 'success full paymnet',
                'data' => $data,
            ];
            return $this->response->setJSON($response);
        }
    }

    public function update_order_status()
    {
        /*
        order_id:42
        status:rescheduled
        date:2022-11-28 {optional} only enter when update status to rescheduled
        time:11:00:00 {optional} only enter when update status to rescheduled
         */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'order_id' => 'required|numeric',
                'status' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $order_id = $this->request->getPost('order_id');
        $customer_id = $this->user_details['id'];
        $status = $this->request->getPost('status');
        $date = $this->request->getPost('date');
        $selected_time = $this->request->getPost('time');
        if ($status == "rescheduled") {
            $validate = validate_status($order_id, $status, $date, $selected_time);
        } else {
            $validate = validate_status($order_id, $status);
        }
        if ($validate['error']) {
            $response['error'] = true;
            $response['message'] = $validate['message'];
            $response['data'] = [];
            return $this->response->setJSON($response);
        } else {
            if ($validate['error']) {
                $response['error'] = true;
                $response['message'] = $validate['message'];
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['data'] = array();
                return $this->response->setJSON($response);
            }
            // if ($status == "cancelled") {
            //     $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status']);
            //     if (isset($transaction) && !empty($transaction)) {
            //         $type = $transaction[0]['type'];
            //         $currency = $transaction[0]['currency_code'];
            //         $txn_id = $transaction[0]['txn_id'];
            //         $amount = $transaction[0]['amount'];
            //         if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
            //             $flutterwave = new Flutterwave();
            //             $payment = $flutterwave->refund_payment($txn_id, $amount);
            //             if (isset($payment['status']) && $payment['status'] == 'success') {
            //                 $data = [
            //                     'transaction_type' => 'refund',
            //                     'order_id' => $order_id,
            //                     'user_id' => $customer_id,
            //                     'type' => 'flutterwave',
            //                     'txn_id' => $payment['id']
            //                 ];
            //                 $success =  insert_details($data, 'transactions');
            //                 $response['error'] = false;
            //                 $response['csrfName'] = csrf_token();
            //                 $response['csrfHash'] = csrf_hash();
            //                 $response['message'] = "Payment Refund Successfully";
            //                 if ($success) {
            //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
            //                     $response = [
            //                         'error' => false,
            //                         'message' => "Order cancelled Successfully!",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 }
            //             } else {
            //                 $message = json_decode($payment, true);
            //                 $response['error'] = true;
            //                 $response['csrfName'] = csrf_token();
            //                 $response['csrfHash'] = csrf_hash();
            //                 $response['message'] = $message['message'];
            //             }
            //         }
            //         if ($type == "stripe" && $transaction[0]['status'] == 'succeeded') {
            //             $stripe = new Stripe();
            //             $payment = $stripe->refund($txn_id, $amount);
            //             if (isset($payment['status']) && $payment['status'] == "succeeded") {
            //                 $amount = intval($payment['amount']) / 100;
            //                 $data = [
            //                     'transaction_type' => $payment['object'],
            //                     'order_id' => $order_id,
            //                     'user_id' => $customer_id,
            //                     'type' => 'stripe',
            //                     'txn_id' => $payment['payment_intent'],
            //                     'amount' => $amount,
            //                     'currency_code' => $currency,
            //                     'status' => $payment['status']

            //                 ];
            //                 $success = insert_details($data, 'transactions');
            //                 $response = [
            //                     'error' => false,
            //                     'csrfName' => csrf_token(),
            //                     'csrfHash' => csrf_hash(),
            //                     'message' => "Payment Refund Successfully",
            //                 ];
            //                 if ($success) {
            //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
            //                     $response = [
            //                         'error' => false,
            //                         'message' => "Order cancelled Successfully!",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 }

            //                 return $this->response->setJSON($response);
            //             } else {
            //                 $res = json_decode($payment['body']);
            //                 $msg = $res->error->message;
            //                 $response = [
            //                     'error' => true,
            //                     'csrfName' => csrf_token(),
            //                     'csrfHash' => csrf_hash(),
            //                     'message' => $msg,
            //                 ];
            //                 return $this->response->setJSON($response);
            //             }
            //         }
            //         if ($type == "razorpay" && $transaction[0]['status'] == "captured") {
            //             $razorpay = new Razorpay();
            //             $payment = $razorpay->refund_payment($txn_id, $amount);
            //             if (isset($payment['status']) && $payment['status'] == "processed") {
            //                 $amount = intval($payment['amount']) / 100;
            //                 $data = [
            //                     'transaction_type' => $payment['entity'],
            //                     'order_id' => $order_id,
            //                     'user_id' => $customer_id,
            //                     'type' => 'razorpay',
            //                     'txn_id' => $payment['payment_id'],
            //                     'amount' => $amount,
            //                     'currency_code' => $currency,
            //                     'status' => $payment['status']

            //                 ];
            //                 $success = insert_details($data, 'transactions');
            //                 if ($success) {
            //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
            //                     $response = [
            //                         'error' => false,
            //                         'message' => "Order cancelle    d Successfully!",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 } else {
            //                     $response = [
            //                         'error' => false,
            //                         'csrfName' => csrf_token(),
            //                         'csrfHash' => csrf_hash(),
            //                         'message' => "order can not be cancelled",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 }
            //             } else {
            //                 $res = json_decode($payment['body'], true);
            //                 $msg = $res['error']['description'];
            //                 $response = [
            //                     'error' => true,
            //                     'csrfName' => csrf_token(),
            //                     'csrfHash' => csrf_hash(),
            //                     'message' => $msg,
            //                 ];
            //                 return $this->response->setJSON($response);
            //             }
            //         }
            //         if ($type == "paystack" && $transaction[0]['status'] == "success") {
            //             $paystack = new Paystack();
            //             $payment = $paystack->refund($txn_id, $amount);
            //             $message = json_decode($payment, true);
            //             if (isset($payment['status']) && $payment['status'] == "true") {
            //                 update_details(['status' => $status], ['id' => $order_id], 'orders');
            //                 $amount = intval($payment['amount']) / 100;
            //                 $data = [
            //                     'transaction_type' => $payment['entity'],
            //                     'order_id' => $order_id,
            //                     'user_id' => $customer_id,
            //                     'type' => 'paystack',
            //                     'txn_id' => $payment['payment_id'],
            //                     'amount' => $amount,
            //                     'currency_code' => $currency,
            //                     'status' => $payment['status']

            //                 ];
            //                 $success = insert_details($data, 'transactions');
            //                 if ($success) {
            //                     $response = [
            //                         'error' => false,
            //                         'message' => "Order cancelled Successfully!",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 } else {
            //                     $response = [
            //                         'error' => false,
            //                         'csrfName' => csrf_token(),
            //                         'csrfHash' => csrf_hash(),
            //                         'message' => "order can not be cancelled",
            //                     ];
            //                     return $this->response->setJSON($response);
            //                 }
            //             } else {
            //                 $res = json_decode($payment, true);
            //                 $response = [
            //                     'error' => true,
            //                     'csrfName' => csrf_token(),
            //                     'csrfHash' => csrf_hash(),
            //                     'message' => $res['message'],
            //                 ];
            //                 return $this->response->setJSON($response);
            //             }
            //         }
            //     }
            // }
            if ($status == "rescheduled") {
                $user_no = fetch_details('users', ['id' => $customer_id], 'phone')[0]['phone'];
                $response = [
                    'error' => false,
                    'message' => "Order rescheduled successfully!",
                    'contact' => "You can call on '$user_no.' number to reschedule",
                ];
                return $this->response->setJSON($response);
            }
            if ($status == "awaiting") {
                $response = [
                    'error' => false,
                    'message' => "Order is in Awaiting!",
                ];
                return $this->response->setJSON($response);
            }
            if ($status == "confirmed") {
                $response = [
                    'error' => false,
                    'message' => "Order is Confirmed!",
                ];
                return $this->response->setJSON($response);
            }
            if ($status == "cancelled") {
                $response = [
                    'error' => false,
                    'message' => "Order is cancelled!",
                ];
                return $this->response->setJSON($response);
            }
            if ($status == "completed") {
                $commision = unsettled_commision($this->userId);
                update_details(['balance' => $commision], ['id' => $this->userId], 'users');
                $response = [
                    'error' => false,
                    'message' => "Order Completed successfully!",
                ];
                return $this->response->setJSON($response);
            }

            //custom notification message
            if ($status == 'awaiting') {
                $type = ['type' => "customer_order_awaiting"];
            } elseif ($status == 'confirmed') {
                $type = ['type' => "customer_order_confirmed"];
            } elseif ($status == 'rescheduled') {
                $type = ['type' => "customer_order_rescheduled"];
            } elseif ($status == 'cancelled') {
                $type = ['type' => "customer_order_cancelled"];
            } elseif ($status == 'completed') {
                $type = ['type' => "customer_order_completed"];
            }
            $custom_notification = fetch_details('notifications', $type);
            $app_name = isset($settings['company_title']) && !empty($settings['company_title']) ? $settings['company_title'] : '';
            $user_res = fetch_details('users', ['id' => $customer_id], 'username,fcm_id');
            $customer_msg = (!empty($custom_notification)) ? $custom_notification[0]['message'] : 'Hello Dear ' . $user_res[0]['username'] . ' order status updated to ' . $status . ' for your order ID #' . $order_id . ' please take note of it! Thank you for shopping with us. Regards ' . $app_name . '';
            $fcm_ids = array();

            if (!empty($user_res[0]['fcm_id'])) {
                $fcmMsg = array(
                    'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "Order status updated",
                    'body' => $customer_msg,
                    'type' => "order",
                );
                $fcm_ids[0][] = $user_res[0]['fcm_id'];
                send_notification($fcmMsg, $fcm_ids);
            }
        }
    }

    public function get_booked_slot()
    {
        // partner_id : 50 [required]
        // date : '2022-08-04' [Y-m-d] [required]
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'partner_id' => 'required|numeric',
                'date' => 'required|valid_date[Y-m-d]',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $partner_id = $this->request->getPost('partner_id');
        $date = $this->request->getPost('date');
        $booked_slots = booked_timings($partner_id, $date);
        if (!empty($booked_slots)) {
            $response = [
                'error' => false,
                'message' => 'Booked slots',
                'data' => $booked_slots,
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'Booked slots not available!',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
    }

    public function flutterwave()
    {
        $system_settings = get_settings('system_settings', true);

        $credentials = $this->flutterwave->get_credentials();
        $local_secret_hash = $credentials['secret_hash'];
        $request_body = file_get_contents('php://input');
        $event = json_decode($request_body, false);
        log_message('error', 'Flutterwave Webhook --> ' . var_export($event, true));
        log_message('error', 'Flutterwave Webhook SERVER Variable --> ' . var_export($_SERVER, true));

        if (!empty($event->data->id)) {
            $txn_id = (isset($event->data->id)) ? $event->data->id : "";
            log_message('error', 'Flutterwave Webhook txn_id Variable --> ' . var_export($txn_id, true));

            if (!empty($txn_id)) {
                $transaction = fetch_details('transactions', ['txn_id' => $txn_id], '*');
                if (!empty($transaction)) {
                    $order_id = $transaction[0]['order_id'];
                    $user_id = $transaction[0]['user_id'];
                } else {
                    $order_id = 0;
                }
            }
            $amount = $event->data->amount;
            $currency = $event->data->currency;
            log_message('error', 'Flutterwave Webhook order_id --> ' . var_export($order_id, true));
        } else {
            $order_id = 0;
            $amount = 0;
            $currency = (isset($event->data->currency)) ? $event->data->currency : "";
            $balance_transaction = 0;
        }

        // /* Wallet refill has unique format for order ID - wallet-refill-user-{user_id}-{system_time}-{3 random_number}  */
        if (empty($order_id)) {
            $order_id = (!empty($event->data->orderRef) && isset($event->data->orderRef)) ? $event->data->orderRef : 0;
        }

        if (!is_numeric($order_id) && strpos($order_id, "wallet-refill-user") !== false) {
            $temp = explode("-", $order_id);
            if (isset($temp[3]) && is_numeric($temp[3]) && !empty($temp[3] && $temp[3] != '')) {
                $user_id = $temp[3];
            } else {
                $user_id = 0;
            }
        }

        $signature = (isset($_SERVER['HTTP_VERIF_HASH'])) ? $_SERVER['HTTP_VERIF_HASH'] : '';

        /* comparing our local signature with received signature */
        if (empty($signature) || $signature != $local_secret_hash) {
            log_message('error', 'FlutterWave Webhook - Invalid Signature - JSON DATA --> ' . var_export($event, true));
            log_message('error', 'FlutterWave Server Variable invalid --> ' . var_export($_SERVER, true));
        }

        if ($event->event == 'charge.completed' && $event->data->status == 'successful') {
            if (!empty($order_id)) {
                /* To do the wallet recharge if the order id is set in the patter */
                if (strpos($order_id, "wallet-refill-user") !== false) {
                    $data['transaction_type'] = "wallet";
                    $data['user_id'] = $user_id;
                    $data['order_id'] = $order_id;
                    $data['type'] = "credit";
                    $data['txn_id'] = $txn_id;
                    $data['amount'] = $amount;
                    $data['status'] = "success";
                    $data['message'] = "Wallet refill successful";
                    $this->transaction_model->add_transaction($data);

                    $this->load->model('customer_model');
                    if ($this->customer_model->update_balance($amount, $user_id, 'add')) {
                        $response['error'] = false;
                        $response['transaction_status'] = $event->data->status;
                        $response['message'] = "Wallet recharged successfully!";
                    } else {
                        $response['error'] = true;
                        $response['transaction_status'] = $event->data->status;
                        $response['message'] = "Wallet could not be recharged!";
                        log_message('error', 'Flutterwave Webhook | wallet recharge failure --> ' . var_export($event, true));
                    }
                    echo json_encode($response);
                    return false;
                } else {

                    /* process the order and mark it as received */
                    $order = fetch_details('orders', ['id' => $order_id], false, false, false, false, false, false);
                    log_message('error', 'Flutterwave Webhook user id --> ' . var_export($order['order_data'][0]['user_id'], true));

                    if (isset($order['order_data'][0]['user_id'])) {
                        $user = fetch_details('users', ['id' => $order['order_data'][0]['user_id']]);
                        $overall_total = array(
                            'total_amount' => $order['order_data'][0]['total'],
                            'delivery_charge' => $order['order_data'][0]['delivery_charge'],
                            'tax_amount' => $order['order_data'][0]['total_tax_amount'],
                            'tax_percentage' => $order['order_data'][0]['total_tax_percent'],
                            'discount' => $order['order_data'][0]['promo_discount'],
                            'wallet' => $order['order_data'][0]['wallet_balance'],
                            'final_total' => $order['order_data'][0]['final_total'],
                            'otp' => $order['order_data'][0]['otp'],
                            'address' => $order['order_data'][0]['address'],
                            'payment_method' => $order['order_data'][0]['payment_method'],
                        );

                        $overall_order_data = array(
                            'cart_data' => $order['order_data'][0]['order_items'],
                            'order_data' => $overall_total,
                            'subject' => 'Order received successfully',
                            'user_data' => $user[0],
                            'system_settings' => $system_settings,
                            'user_msg' => 'Hello, Dear ' . ucfirst($user[0]['username']) . ', We have received your order successfully. Your order summaries are as followed',
                            'otp_msg' => 'Here is your OTP. Please, give it to delivery boy only while getting your order.',
                        );

                        if (isset($user[0]['email']) && !empty($user[0]['email'])) {
                            email_sender($user[0]['email'], 'Order received successfully', $this->load->view('admin/pages/view/email-template.php', $overall_order_data, true));
                        }
                        /* No need to add because the transaction is already added just update the transaction status */
                        if (!empty($transaction)) {
                            $transaction_id = $transaction[0]['id'];
                            update_details(['status' => 'success'], ['txn_id' => $txn_id], 'transactions');
                        }

                        /* add transaction of the payment */

                        update_details(['active_status' => 'received'], ['id' => $order_id], 'orders');
                        update_details(['active_status' => 'received'], ['order_id' => $order_id], 'order_items');

                        $status = json_encode(array(array('received', date("d-m-Y h:i:sa"))));
                        update_details(['status' => $status], ['id' => $order_id], 'orders', false);
                        update_details(['status' => $status], ['order_id' => $order_id], 'order_items', false);

                        // place order custome notification on payment success

                        $custom_notification = fetch_details('custom_notifications', ['type' => "place_order"], '');
                        $hashtag_order_id = '< order_id >';
                        $string = json_encode($custom_notification[0]['title'], JSON_UNESCAPED_UNICODE);
                        $hashtag = html_entity_decode($string);
                        $data1 = str_replace($hashtag_order_id, $order_id, $hashtag);
                        $title = output_escaping(trim($data1, '"'));
                        $hashtag_application_name = '< application_name >';
                        $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                        $hashtag = html_entity_decode($string);
                        $data2 = str_replace($hashtag_application_name, $system_settings['app_name'], $hashtag);
                        $message = output_escaping(trim($data2, '"'));

                        $fcm_admin_subject = (!empty($custom_notification)) ? $title : 'New order placed ID #' . $order_id;
                        $fcm_admin_msg = (!empty($custom_notification)) ? $message : 'New order received for  ' . $system_settings['app_name'] . ' please process it.';
                        $user_fcm = fetch_details('users', ['id' => $user_id], 'fcm_id');
                        $user_fcm_id[0][] = $user_fcm[0]['fcm_id'];
                        if (!empty($user_fcm_id)) {
                            $fcmMsg = array(
                                'title' => $fcm_admin_subject,
                                'body' => $fcm_admin_msg,
                                'type' => "place_order",
                                'content_available' => true,
                            );
                            send_notification($fcmMsg, $user_fcm_id);
                        }

                        log_message('error', 'Flutterwave Webhook inner Success --> ' . var_export($event, true));
                    }
                    log_message('error', 'Flutterwave Webhook outer Success --> ' . var_export($event, true));
                }
            } else {
                /* No order ID found */
                log_message('error', 'Flutterwave Webhook | No Order ID found --> ' . var_export($event, true));
                return $this->output
                    ->set_content_type('application/json')
                    ->set_status_header(304)
                    ->set_output(json_encode(array(
                        'message' => '304 Not Modified - order/transaction id not found',
                        'error' => true,
                    )));
            }

            $response['error'] = false;
            $response['transaction_status'] = $event->data->status;
            $response['message'] = "Transaction successfully done";
            log_message('error', 'Flutterwave Transaction Successfully --> ' . var_export($event, true));
            echo json_encode($response);
            return false;
        } else {
            if (!empty($order_id) && is_numeric($order_id)) {
                update_details(['active_status' => 'cancelled'], ['id' => $order_id], 'orders');
                update_details(['active_status' => 'cancelled'], ['order_id' => $order_id], 'order_items');

                $status = json_encode(array(array('cancelled', date("d-m-Y h:i:sa"))));
                update_details(['status' => $status], ['id' => $order_id], 'orders', false);
                update_details(['status' => $status], ['order_id' => $order_id], 'order_items', false);
            }

            /* No need to add because the transaction is already added just update the transaction status */
            if (!empty($transaction)) {
                $transaction_id = $transaction[0]['id'];
                update_details(['status' => 'failed'], ['id' => $transaction_id], 'transactions');
            }
            $response['error'] = true;
            $response['transaction_status'] = $event->data->status;
            $response['message'] = "Transaction could not be detected.";
            log_message('error', 'Flutterwave Webhook | Transaction could not be detected --> ' . var_export($event, true));
            echo json_encode($response);
            return false;
        }
    }

    // available slots api
    public function get_available_slots()
    {
        //     /*
        //         partner_id : 15
        //         date : 2022-11-01
        //     */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'partner_id' => 'required|numeric',
                'date' => 'required|valid_date[Y-m-d]',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $days = [
            'Mon' => 'monday',
            'Tue' => 'tuesday',
            'Wed' => 'wednesday',
            'Thu' => 'thursday',
            'Fri' => 'friday',
            'Sat' => 'saturday',
            'Sun' => 'sunday',
        ];
        $partner_id = $this->request->getPost('partner_id');
        $date = $this->request->getPost('date');
        $time = $this->request->getPost('date');
        $date = new DateTime($date);
        $date = $date->format('Y-m-d');
        $day = date('D', strtotime($date));
        $whole_day = $days[$day];

        $partner_data = fetch_details('partner_details', ['partner_id' => $partner_id], ['advance_booking_days']);
        $time_slots = get_available_slots($partner_id, $date);

        $available_slots = $busy_slots = $time_slots['all_slots'] = [];

        if (isset($time_slots['available_slots']) && !empty($time_slots['available_slots'])) {
            $available_slots = array_map(function ($time_slot) {
                return ["time" => $time_slot, "is_available" => 1];
            }, $time_slots['available_slots']);
        }

        if (isset($time_slots['busy_slots']) && !empty($time_slots['busy_slots'])) {
            $busy_slots = array_map(function ($time_slot) {
                return ["time" => $time_slot, "is_available" => 0];
            }, $time_slots['busy_slots']);
        }
        $time_slots['all_slots'] = array_merge($available_slots, $busy_slots);
        array_sort_by_multiple_keys($time_slots['all_slots'], ["time" => SORT_ASC]);
        $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, "day" => $whole_day]);

        if (!empty($partner_data) && $partner_data[0]['advance_booking_days'] > 0) {
            $allowed_advanced_booking_days = $partner_data[0]['advance_booking_days'];
            $current_date = new DateTime();
            $max_available_date = $current_date->modify("+ $allowed_advanced_booking_days day")->format('Y-m-d');

            if ($date > $max_available_date) {
                $response = [
                    'error' => true,
                    'message' => "You'can not choose date beyond available booking days which is + $allowed_advanced_booking_days days",
                    'data' => [],
                ];
                return $this->response->setJSON(remove_null_values($response));
            }
        } else if (!empty($partner_data) && $partner_data[0]['advance_booking_days'] == 0) {
            $current_date = new DateTime();
            if ($date > $current_date->format('Y-m-d')) {
                $response = [
                    'error' => true,
                    'message' => "Advanced Booking for this partner is not available",
                    'data' => [],
                ];
                return $this->response->setJSON(remove_null_values($response));
            }
        } else {
            $response = [
                'error' => true,
                'message' => "No Partner Found",
                'data' => [],
            ];
            return $this->response->setJSON(remove_null_values($response));
        }

        // if (empty($partner_timing)) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner Is closed on this day",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }

        // if ($partner_timing[0]['is_open'] == 0) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner Is closed on this day",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }
        // if ($time < $partner_timing[0]['opening_time']) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner is not available at this time",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }
        // if ($time >= $partner_timing[0]['closing_time']) {
        //     $response = [
        //         'error' => true,
        //         'message' => "please Choose different time , Partner will be closed at this time",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }

        if (!empty($time_slots)) {
            $response = [
                'error' => $time_slots['error'],
                'message' => ($time_slots['error'] == false) ? 'Found Time slots' : $time_slots['message'],
                'data' => [
                    'all_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['all_slots'] : [],
                    // 'available_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['available_slots'] : [],
                    // 'busy_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['busy_slots'] : []
                ],
            ];
            return $this->response->setJSON(remove_null_values($response));
        } else {
            $response = [
                'error' => true,
                'message' => 'No slot is available on this date!',
                'data' => [],
            ];
            return $this->response->setJSON(remove_null_values($response));
        }
    }

    public function get_ratings()
    {
        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'partner_id' => 'permit_empty',
            ],
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $limit = (isset($_POST['limit']) && !empty($_POST['limit'])) ? $_POST['limit'] : 10;
        $offset = (isset($_POST['offset']) && !empty($_POST['offset'])) ? $_POST['offset'] : 0;
        $sort = (isset($_POST['sort']) && !empty($_POST['sort'])) ? $_POST['sort'] : 'id';
        $order = (isset($_POST['order']) && !empty($_POST['order'])) ? $_POST['order'] : 'ASC';
        $search = (isset($_POST['search']) && !empty($_POST['search'])) ? $_POST['search'] : '';
        $partner_id = ($this->request->getPost('partner_id') != '') ? $this->request->getPost('partner_id') : '';
        $ratings = new Service_ratings_model();

        if ($partner_id != '') {
            $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order, ['s.user_id' => $partner_id]);
        } else {
            $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order);
        }

        return response('Data Retrieved successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
    }

    public function add_rating()
    {
        $validation = \Config\Services::validation();
        $ratings_model = new Service_ratings_model();

        $validation->setRules(
            [
                'service_id' => 'required|numeric',
                'rating' => 'required|numeric|greater_than[0]|less_than_equal_to[5]',
                'comment' => 'permit_empty',
            ],
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $user_id = $this->user_details['id'];
        $service_id = $this->request->getPost('service_id');
        $orders = has_ordered($user_id, $service_id);

        if ($orders['error'] == true) {
            return response($orders['message'], true, [], 200);
        }
        $rd = fetch_details('services_ratings', ['user_id' => $user_id, 'service_id' => $service_id]);
        if (empty($rd)) {
            $rating = $this->request->getPost('rating');

            $comment = (isset($_POST['comment']) && $_POST['comment'] != "") ? $this->request->getPost('comment') : "";
            $uploaded_images = $this->request->getFiles('images');
            $data = [
                'user_id' => $user_id,
                'service_id' => $service_id,
                'rating' => $rating,
                'comment' => $comment,
            ];
            $names = "";
            $image_names['name'] = [];
            $data['images'] = [];
            $path = "public/uploads/ratings/";
            if (isset($uploaded_images['images'])) {
                foreach ($uploaded_images['images'] as $images) {
                    $validate_image = valid_image($images);
                    if ($validate_image == true) {
                        return response("Invalid Image", true, []);
                    }
                    $newName = $images->getRandomName();
                    if ($newName != null) {
                        move_file($images, $path, $newName);
                        $name = "public/uploads/ratings/$newName";
                        array_push($image_names['name'], $name);
                    }
                }
                $names = json_encode($image_names['name']);
            }
            $data['images'] = $names;
            $saved_data = $ratings_model->save($data);
            if ($saved_data) {
                update_ratings($service_id, $rating);
                return response("Rating Saved", false, remove_null_values($data), 200);
            } else {
                return response("Could not save ratings", true, [], 200);
            }
        } else {
            $rating_id = $rd[0]['id'];

            $rating = (isset($_POST['rating'])) ? $this->request->getPost('rating') : "";
            $comment = (isset($_POST['comment'])) ? $this->request->getPost('comment') : "";

            $data = [
                'rating' => ($rating != "") ? $rating : $rd[0]['rating'],
                'comment' => ($comment != "") ? $comment : $rd[0]['comment'],
            ];
            $data['images'] = [];
            $uploaded_images = $this->request->getFiles('images');
            $path = "public/uploads/ratings/";

            if (isset($uploaded_images['images'])) {
                foreach ($uploaded_images['images'] as $images) {
                    $validate_image = valid_image($images);
                    if ($validate_image == true) {
                        return response("Invalid Image", true, []);
                    }
                    $newName = $images->getRandomName();
                    if ($newName == null) {
                        $image = null;
                    } else {

                        move_file($images, $path, $newName);
                        $name = "public/uploads/ratings/$newName";
                        array_push($data['images'], $name);
                    }
                }
                $data['images'] = json_encode($data['images']);
            } else {
                $data['images'] = $rd[0]['images'];
            }
            $updated_data = $ratings_model->update($rating_id, $data);
            if ($updated_data) {
                update_ratings($service_id, $rating);
                return response("Rating Updated Successfully", false, [], 200);
            } else {
                return response("Rating couldn't be Updated", true, [], 200);
            }
        }
    }

    public function update_rating()
    {
        $validation = \Config\Services::validation();
        $ratings_model = new Service_ratings_model();
        $validation->setRules(
            [
                'rating_id' => 'required',
                'rating' => 'permit_empty',
                'comment' => 'permit_empty',
                'image' => 'permit_empty',
            ],
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $user_id = $this->user_details['id'];
        $rating_id = $this->request->getPost('rating_id');

        $ratings = has_rated($user_id, $rating_id);

        // print_r($ratings);
        if ($ratings['error']) {
            return response($ratings['message'], true, [], 200);
        }
        // echo "<pre>";
        // print_r($ratings['data'][0]);
        // return;
        $rating = (isset($_POST['rating'])) ? $this->request->getPost('rating') : "";
        $comment = (isset($_POST['comment'])) ? $this->request->getPost('comment') : "";
        if ($rating > 5) {
            return response("Can not rate More than 5", true, [], 200);
        }
        $data = [
            'rating' => ($rating != "") ? $rating : $ratings['data'][0]['rating'],
            'comment' => ($comment != "") ? $comment : $ratings['data'][0]['comment'],
        ];
        $data['images'] = [];
        $uploaded_images = $this->request->getFiles('images');
        $path = "public/uploads/ratings/";

        if (isset($uploaded_images['images'])) {
            // $og_images = json_decode($ratings['data'][0]['images']);
            // foreach ($og_images as $og_image) {
            //     unlink($og_image);
            // }
            foreach ($uploaded_images['images'] as $images) {
                $validate_image = valid_image($images);
                if ($validate_image == true) {
                    return response("Invalid Image", true, []);
                }
                $newName = $images->getRandomName();
                if ($newName == null) {
                    $image = null;
                } else {

                    move_file($images, $path, $newName);
                    $name = "public/uploads/ratings/$newName";
                    array_push($data['images'], $name);
                }
            }
            $data['images'] = json_encode($data['images']);
        } else {
            $data['images'] = $ratings['data'][0]['images'];
        }
        $updated_data = $ratings_model->update($rating_id, $data);
        if ($updated_data) {
            return response("Ranking Updated Successfully", false, [], 200);
        } else {
            return response("Ranking Updated UnSuccessful", true, [], 200);
        }
    }

    public function is_area_deliverable()
    {
        $validation = \Config\Services::validation();

        $validation->setRules(
            [
                'partner_id' => 'required',
                'latitude' => 'permit_empty',
                'longitude' => 'permit_empty',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $partner_id = $this->request->getPost('partner_id');

        $manual_latitude = $this->request->getPost('latitude');
        $manual_longitude = $this->request->getPost('longitude');

        $user_id = $this->user_details['id'];
        $lat1 = (!isset($manual_latitude) && $manual_latitude == "") ? $this->user_details['latitude'] : $manual_latitude;
        $lon1 = (!isset($manual_longitude) && $manual_longitude == "") ? $this->user_details['longitude'] : $manual_longitude;

        $partner_cred = fetch_details('users', ['id' => $partner_id])[0];
        $partner_details = fetch_details('partner_details', ['partner_id' => $partner_id])[0];
        $lat2 = $partner_cred['latitude'];
        $lon2 = $partner_cred['longitude'];
        $range = $partner_details['service_range'];
        $units = get_settings('range_units');

        $unit = 'k';
        $data = distance_finder($lat1, $lon1, $lat2, $lon2, $unit);

        $distance['distance'] = $data;
        if ($data == 0) {
            return response('Yes!, service is available', false, remove_null_values($distance), 200);
        } else if ($data <= $range) {
            return response('Yes!, service is available', false, remove_null_values($distance), 200);
        } else {
            return response('No!, service is not available', true, remove_null_values($distance), 200);
        }
    }

    public function check_available_slot()
    {

        //     /*
        //         partner_id : 15
        //         date : 2022-11-01
        //         time:12:35:00
        //     */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'partner_id' => 'required|numeric',
                'date' => 'required|valid_date[Y-m-d]',
                'time' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $partner_id = $this->request->getPost('partner_id');
        $date = $this->request->getPost('date');
        $time = $this->request->getPost('time');
        $data = check_availability($partner_id, $date, $time);

        return $this->response->setJSON($data);
    }

    public function razorpay_create_order()
    {

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'order_id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }

        $order_id = $this->request->getPost('order_id');
        if ($this->request->getPost('order_id') && !empty($this->request->getPost('order_id'))) {
            $where['o.id'] = $this->request->getPost('order_id');
        }
        $orders = new Orders_model();
        $order_detail = $orders->list(true, "", null, null, "", "", $where);
        $settings = get_settings('payment_gateways_settings', true);

        if (!empty($order_detail) && !empty($settings)) {
            $currency = $settings['razorpay_currency'];
            $price = $order_detail['data'][0]['final_total'];
            $amount = intval($price * 100);
            $create_order = $this->razorpay->create_order($amount, $order_id, $currency);
            if (!empty($create_order)) {
                $response = [
                    'error' => false,
                    'message' => 'razorpay order created',
                    'data' => $create_order,
                ];
            } else {
                $response = [
                    'error' => true,
                    'message' => 'razorpay order not created',
                    'data' => [],
                ];
            }
        } else {
            $response = [
                'error' => true,
                'message' => 'details not found"',
                'data' => [],
            ];
        }
        return $this->response->setJSON($response);
    }

    public function update_service_status()
    {

        //     /*
        //         order_id : 149
        //         service_id : 17
        //         status : pending/awaiting/confirmed/rescheduled/cancelled/completed
        //     */

        $validation = \Config\Services::validation();
        $validation->setRules(
            [
                'service_id' => 'required|numeric',
                'status' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
        $order_id = $this->request->getPost('order_id');
        $service_id = $this->request->getPost('service_id');
        $status = strtolower($this->request->getPost('status'));
        $all_status = ['pending', 'awaiting', 'confirmed', 'rescheduled', 'cancelled', 'completed'];
        if (in_array(strtolower($status), $all_status)) {
            $res = update_details(['status' => $status], ['service_id' => $service_id, 'order_id' => $order_id], 'order_services');
            $data = fetch_details('order_services', ['service_id' => $service_id, 'order_id' => $order_id]);
            if ($res) {
                $response = [
                    'error' => false,
                    'message' => 'Service status updated successfully!',
                    'data' => $data,
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Service status cant be changed!',
                    'data' => [],
                ];
                return $this->response->setJSON($response);
            }
        } else {
            $response = [
                'error' => true,
                'message' => 'Please enter valid status!',
                'data' => [],
            ];
            return $this->response->setJSON($response);
        }
    }

    public function get_faqs()
    {
        /*
        limit:10                {optional}
        offset:0                {optional}
        sort:id                 {optional}
        order:asc               {optional}
        search:test             {optional}
         */

        $Faqs_model = new Faqs_model();
        $limit = !empty($this->request->getPost('limit')) ? $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';

        $data = $Faqs_model->list(true, $search, $limit, $offset, $sort, $order);

        if (!empty($data['data'])) {
            return response('faqs fetched successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
        } else {
            return response('faqs not found');
        }
    }

    public function verify_user()
    {
        $config = new \Config\IonAuth();
        $validation = \Config\Services::validation();
        $request = \Config\Services::request();
        $identity_column = $config->identity;

        if ($identity_column == 'phone') {
            $identity = $request->getPost('mobile');
            $validation->setRule('mobile', 'mobile', 'required|numeric|is_unique[users.' . $identity_column . ']', [
                'is_unique' => 'This mobile number is already registered',
            ]);
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => false,
                'message' => "This mobile number is not registered",
            ];
            return $this->response->setJSON($response);
        }
    }

    public function delete_user_account()
    {

        $user_id = $this->user_details['id'];
        if (!exists(['id' => $user_id], 'users')) {
            return response('user does not exist please enter valid user ID!', true);
        }
        $user_data = fetch_details('users_groups', ['user_id' => $user_id]);
        if (!empty($user_data) && isset($user_data[0]['group_id']) && !empty($user_data[0]['group_id']) && $user_data[0]['group_id'] == 2) {
            if (delete_details(['id' => $user_id], 'users') && delete_details(['user_id' => $user_id], 'users_groups')) {
                delete_details(['user_id' => $user_id], 'users_tokens');
                return response('User account deleted successfully', false);
            } else {
                return response('User account does not delete', true);
            }
        } else {
            return response("This user's account can't delete ", true);
        }
    }

    public function logout()
    {
        /*
        all_device:true/false                {default = false}
         */
        $request = \Config\Services::request();
        $jwt = new JWT();
        $all_device = $request->getPost('all_device');
        $user_id = $this->user_details['id'];
        $token = $jwt->getBearerToken();
        if (isset($all_device) && $all_device == true) {
            if (isset($user_id) && !empty($user_id) && delete_details(['user_id' => $user_id], 'users_tokens')) {
                return response('User logout successfully', false);
            } else {
                return response('User does not logout ', true);
            }
        } else {
            if (isset($token) && !empty($token) && delete_details(['token' => $token], 'users_tokens')) {
                return response('User logout successfully', false);
            } else {
                return response('User does not logout ', true);
            }
        }
    }
}
