<?php

namespace App\Controllers\partner;

use App\Models\Orders_model;
use App\Libraries\Flutterwave;
use App\Libraries\Paystack;
use App\Libraries\Razorpay;
use App\Libraries\Stripe;

class Orders extends Partner
{
    public $orders;
    public function __construct()
    {
        parent::__construct();
        $this->orders = new Orders_model();
    }
    public function index()
    {
        if ($this->isLoggedIn && !$this->userIsAdmin) {
            $this->data['title'] = 'Orders | Partner Panel';
            $this->data['main_page'] = 'orders';

            return view('backend/partner/template', $this->data);
        } else {
            return redirect('partner/login');
        }
    }
    public function list()
    {
        $orders_model = new Orders_model();
        return $orders_model->list(false, '', 10, 0, '', '', ['o.partner_id' => $this->userId]);
    }
    public function view_orders()
    {
        $uri = service('uri');
        if (!$this->isLoggedIn && !$this->userIsPartner) {
            return redirect('partner/login');
        } else {
            $this->orders = new Orders_model();
            $this->data['title'] = 'Orders | Partner Panel';
            $this->data['main_page'] = 'order_details';
            $order_id = $uri->getSegments()[3];
            $order_data =  fetch_details('orders', ['id' => $order_id]);

            if (empty($order_data)) {
                return redirect('partner/orders');
            }

            $where['o.id'] = $order_id;
            $order_details = $this->orders->list(true, '', 10, 0, '', '', $where);
            $this->data['order_details'] = $order_details['data'][0];

            $subtotal = 0.00;
            $tax_amount = 0.00;
            foreach ($order_details['data'][0]['services'] as $service) {
                $subtotal += floatval($service['sub_total']);
                $tax_amount += floatval($service['tax_amount']);
            }

            $promocode_discount = 0.00;
            if (isset($order_details) && !empty($order_details['data']) && !empty($order_details['data'][0]['promo_discount'])) {
                $promocode_discount = intval($order_details['data'][0]['total'] + $order_details['data'][0]['visiting_charges']) * intval($order_details['data'][0]['promo_discount']) / 100;
            }
            $data = get_settings('general_settings', true);
            $tax = get_settings('system_tax_settings', true);
        
            $this->data['currency'] = $data['currency'];
            $this->data['tax'] = $tax['tax'];
            $this->data['promocode_discount'] = $order_details['data'][0]['promo_discount'];
            $this->data['subtotal'] = $subtotal;
            $this->data['tax_amount'] = $tax_amount;
            return view('backend/partner/template', $this->data);
        }
    }
    public function order_summary_table($order_id = "")
    {
        $uri = service('uri');
        $order_id = $uri->getSegments()[3];
        $orders_model = new Orders_model();
        $data = get_settings('general_settings', true);
        $currency = $data['currency'];
        $orders = $orders_model->invoice($order_id);
        $services = $orders['order']['services'];
        $total =  count($services);
        $subtotal = 0.00;
        $tax_amount = 0;
        if (!empty($orders)) {

            $i = 0;
            $rows = [];
            foreach ($services as $service) {
                $subtotal += floatval($service['sub_total'] - $service['tax_amount']);
                $tax_amount += floatval($service['tax_amount']);

                $operations = '<button class="btn btn-danger btn-sm cancel_service" data-id="' . $service['id'] . '"> <i class="fas fa-trash"></i> </button>';
                $rows[$i] = [
                    'service_title' => ucwords($service['service_title']),
                    'price' => $currency . number_format($service['price']),
                    'quantity' => 'x' . ucwords($service['quantity']),
                    'subtotal' => $currency . number_format($service['sub_total'] - $service['tax_amount']),
                    'operations' => $operations,
                ];
                $i++;
            }

            $row = [
                'service_title' => "",
                'quantity' => "<strong>Total</strong>",
                'price' => "",
                'subtotal' => "<strong>" . $currency . $subtotal . "</strong>",
            ];
           
            if (!empty($rows)) {
                array_push($rows, $row);
            }
            $array['total'] = $total;
            $array['rows'] = $rows;
            echo json_encode($array);
        }
    }
    public function invoice_table($order_id = "")
    {
        $uri = service('uri');
        $order_id = $uri->getSegments()[3];
        $orders_model = new Orders_model();
        $data = get_settings('general_settings', true);
        $currency = $data['currency'];
        $orders = $orders_model->invoice($order_id);
        $services = $orders['order']['services'];
        $total =  count($services);
        $tax = get_settings('system_tax_settings', true);
        $subtotal = 0.00;
        $tax_amount = 0;
        if (!empty($orders)) {

            $i = 0;
            $rows = [];
            foreach ($services as $service) {
                $subtotal += floatval($service['sub_total'] - $service['tax_amount']);
                $tax_amount += floatval($service['tax_amount']);

                $operations = '<button class="btn btn-danger btn-sm cancel_service" data-id="' . $service['id'] . '"> <i class="fas fa-trash"></i> </button>';
                $rows[$i] = [
                    'service_title' => ucwords($service['service_title']),
                    'price' => $currency . number_format($service['price']),
                    'quantity' => 'x' . ucwords($service['quantity']),
                    'subtotal' => $currency . number_format($service['sub_total'] - $service['tax_amount']),
                    'operations' => $operations,
                ];
                $i++;
            }

            $row = [
                'service_title' => "",
                'quantity' => "<strong>Total</strong>",
                'price' => "",
                'subtotal' => "<strong>" . $currency . $subtotal . "</strong>",
            ];
            $total_tax_amount =  ($subtotal* $tax['tax'])/100;
            $tax = [
                'service_title' => "",
                'quantity' => "<strong>Tax Amount</strong>",
                'price' => "",
                'subtotal' => "<strong>" . $currency . $total_tax_amount . "</strong>",
            ];
            $visiting_charges = [
                'service_title' => "",
                'quantity' => "<strong>Visiting Charges</strong>",
                'price' => "",
                'subtotal' => "<strong>" . $currency . $orders['order']['visiting_charges'] . "</strong>",
            ];
            $promo_code_discount_amount = (($orders['order']['total'] + $orders['order']['visiting_charges']) * $orders['order']['promo_discount']) / 100;
            $promo_code_discount = [
                'service_title' => "",
                'quantity' => "<strong>Promo Code Discount</strong>",
                'price' => "",
                'subtotal' => "<strong>" . $currency . $orders['order']['promo_discount'] . "</strong>",
            ];
            $payble_amount = ($subtotal + $total_tax_amount + $orders['order']['visiting_charges']) - $orders['order']['promo_discount'];
                $final_total = [
                    'service_title' => "",
                    'quantity' => "<strong>Final Total</strong>",
                    'price' => "",
                    'subtotal' => "<strong>" . $currency . $payble_amount . "</strong>",
                ];
            if (!empty($rows)) {
                array_push($rows, $row);
                array_push($rows, $tax);
                array_push($rows, $visiting_charges);
                array_push($rows, $promo_code_discount);
                array_push($rows, $final_total);
            }
            $array['total'] = $total;
            $array['rows'] = $rows;
            echo json_encode($array);
        }
    }
    public function invoice()
    {
        if (!$this->isLoggedIn && !$this->userIsPartner) {
            return redirect('partner/login');
        } else {
            $uri = service('uri');
            $order_id = $uri->getSegments()[3];
            $order_data =  fetch_details('orders', ['id' => $order_id]);

            if (empty($order_data)) {
                return redirect('partner/orders');
            }
            $this->orders = new Orders_model();
            $this->data['title'] = 'Orders | Partner Panel';
            $this->data['main_page'] = 'invoice';
            $order_details = $this->orders->invoice($order_id);
            $subtotal = 0.00;
            foreach ($order_details['order']['services'] as $service) {
                $subtotal += floatval($service['sub_total']);
            }

            $promocode_discount = 0.00;
            if (isset($order_details) && !empty($order_details['order']['promo_discount'])) {
                $promocode_discount = intval($order_details['order']['total'] + $order_details['order']['visiting_charges']) * intval($order_details['order']['promo_discount']) / 100;
            }
            $this->data['promocode_discount'] = $promocode_discount;
            $this->data['subtotal'] = $subtotal;
            $data = get_settings('general_settings', true);
            $this->data['currency'] = $data['currency'];
            $this->data['logo'] = $data['partner_logo'];
            $this->data['order'] = $order_details['order'];
            return view('backend/partner/template', $this->data);
        }
    }


    public function update_order_status()
    {
        if ($this->isLoggedIn && $this->userIsPartner) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            $order_id = $this->request->getPost('order_id');
            $status = $this->request->getPost('status');
            $date = $this->request->getPost('date');
            $selected_time = $this->request->getPost('selected_time');

            $partner_id = fetch_details('orders', ['id' => $order_id], ['partner_id'])[0]['partner_id'];


            if ($status == "rescheduled" && $selected_time == "") {
                $response = [
                    'error' => true,
                    'message' => ' Please select reschedule timing!',
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            $is_provider_available = check_availability($partner_id, $date, $selected_time);
            if ($status == "rescheduled" && $is_provider_available) {
                $response = validate_status($order_id, $status, $date, $selected_time);
                return json_encode($response);
            } else {
                $response = validate_status($order_id, $status);
                return json_encode($response);
            }
        } else {
            return redirect('admin/login');
        }
    }


    public function get_slots()
    {
        if ($this->isLoggedIn) {

            $order_id = $this->request->getPost('id');
            $date = $this->request->getPost('date');

            $partner_id =  fetch_details('orders', ['id' => $order_id], ['partner_id'])[0];

            $slots =  get_available_slots($partner_id, $date);
            // print_r($slots);

            return $this->response->setJSON($slots);
        } else {
            return redirect('partner/login');
        }
    }
}
