<?php

namespace App\Controllers\partner;

use App\Controllers\BaseController;

class Partner extends BaseController
{

    public function __construct()
    {

        helper('function', 'form', 'url', 'filesystem');
        $this->validation = \Config\Services::validation();
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
        $user = $this->ionAuth->user()->row();
        $this->data['admin'] = $this->userIsAdmin;
        $this->data['partner'] = $this->userIsPartner;
        $this->data['partnerId'] = $user->id;
        $this->data['Identity'] = $this->userIdentity;
        $this->data['settings'] = $this->settings;
       
       
        $session = session();

        $lang = $session->get('lang');
        if (empty($lang)) {
            $lang = 'en';
        }
        $this->data['current_lang'] = $lang;
        $this->data['username'] =  $user->username;
        $this->data['languages_locale'] = fetch_details('languages', [], [], null, '0', 'id', 'ASC');
       

        $profile = '';
        if (!empty($data)) {
            $data = $data[0];
            if ($data['image'] != '') {
                if (check_exists(base_url($data['image']))) {
                    $profile = '<img alt="image" src="' .  base_url($data['image']) . '" class="rounded-circle mr-1">';
                } else {

                    $profile = '<figure class="avatar mb-2 avatar-sm mt-1" data-initial="' . strtoupper($data['username'][0]).'"></figure>';
                }
            } else {
                $profile = '<figure class="avatar mb-2 avatar-sm mt-1" data-initial="' . strtoupper($data['username'][0]). '"></figure>';
            }
            $this->data['profile_picture'] = $profile;
        }
        $this->data['profile_picture'] = $profile;

    }
}
