<?php

namespace App\Controllers\partner;

use App\Models\Service_model;

class Services extends Partner
{
    public $service, $validations, $db;
    public function __construct()
    {
        parent::__construct();
        $this->service = new Service_model();
        $this->validation = \Config\Services::validation();
        $this->db      = \Config\Database::connect();
    }

    public function index()
    {
        if ($this->isLoggedIn) {
            if (!exists(['partner_id' => $this->userId, 'is_approved' => 1], 'partner_details')) {
                return redirect('partner/profile');
            }
            $tax_details = fetch_details('taxes', ['status' => 1]);
            $this->data['title'] = 'Services | Partner Panel';
            $this->data['main_page'] = 'services';
            $this->data['tax_details'] = $tax_details;
            $this->data['tax'] = get_settings('system_tax_settings', true);
            $this->data['categories'] = fetch_details('categories', []);

            return view('backend/partner/template', $this->data);
        } else {
            return redirect('partner/login');
        }
    }
    public function add()
    {
        if ($this->isLoggedIn) {
            if (!exists(['partner_id' => $this->userId, 'is_approved' => 1], 'partner_details')) {
                return redirect('partner/profile');
            }
            $this->data['title'] = 'Add Services | Partner Panel';
            $this->data['main_page'] = FORMS . 'add_services';
            $this->data['categories'] = fetch_details('categories', []);
            $this->data['tax'] = get_settings('system_tax_settings', true);
            $tax_details = fetch_details('taxes', ['status' => 1]);
            $this->data['tax_details'] = $tax_details;
            return view('backend/partner/template', $this->data);
        } else {
            return redirect('partner/login');
        }
    }

    public function add_service()
    {
        if ($this->isLoggedIn) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            if (isset($_POST) && !empty($_POST)) {
                $price = $this->request->getPost('price');
                $this->validation->setRules(
                    [
                        'title' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter service title"
                            ]
                        ],
                        'categories' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please select category"
                            ]
                        ],
                        'tags' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter service tag"
                            ]
                        ],
                        'price' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter price",
                                "numeric" => "Please enter numeric value for price"
                            ]
                        ],
                        'discounted_price' => [
                            "rules" => 'required|numeric|less_than['.$price.']',
                            "errors" => [
                                "required" => "Please enter discounted price",
                                "numeric" => "Please enter numeric value for discounted price",
                                "less_than" => "Discounted price should be less than price"
                            ]
                        ],
                        'members' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter required member for service",
                                "numeric" => "Please enter numeric value for required member"
                            ]
                        ],
                        'duration' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter duration to perform task",
                                "numeric" => "Please enter numeric value for duration of task"
                            ]
                        ],
                        'max_qty' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter max quantity allowed for services",
                                "numeric" => "Please enter numeric value for max quantity allowed for services"
                            ]
                        ],
                        // 'image' => [
                        //     "rules" => 'uploaded[image]|ext_in[image,png,jpg,gif,jpeg,webp]|max_size[image,8496]|is_image[image]'
                        // ],
                    ],
                );
                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                
                } else {
                    if (isset($_POST['tags'][0]) && !empty($_POST['tags'][0])) {
                        $base_tags = $this->request->getPost('tags');
                        $s_t = $base_tags;
                        $val = explode(',', str_replace(']', '', str_replace('[', '', $s_t[0])));
                        $tags = [];
                        foreach ($val as $s) {
                            $tags[] = json_decode($s, true)['value'];
                        }
                    } 
                    $title = $this->removeScript($this->request->getPost('title'));
                    $description = $this->removeScript($this->request->getPost('description'));
                    $path = "./public/uploads/services/";
                    if (isset($_POST['service_id']) && !empty($_POST['service_id'])) {
                        $service_id = $_POST['service_id'];
                        $old_icon = fetch_details('services', ['id' => $service_id], ['image'])[0]['image'];
                    } else {
                        $service_id = "";
                        $old_icon = "";
                    }
                    if (!empty($_FILES['image']) && isset($_FILES['image'])) {
                        $file =  $this->request->getFile('image');
                        if ($file->isValid()) {
                            if ($file->move($path)) {
                                if (!empty($old_icon)) {
                                    unlink($old_icon);
                                }
                                $image_name = 'public/uploads/services/' . $file->getName();
                            }
                        } else {
                            $image_name = $old_icon;
                        }
                    }

                    if (isset($_POST['sub_category']) && !empty($_POST['sub_category'])) {
                        $category_id = $_POST['sub_category'];
                    } else {
                        $category_id = $_POST['categories'];
                    }
                    $discounted_price = $this->request->getPost('discounted_price');
                    $price = $this->request->getPost('price');
                    if ($discounted_price >= $price && $discounted_price == $price) {
                        $response = [
                            'error' => true,
                            'message' => "discounted price can not be higher than or equal to the price",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    }
                    $user_id = $this->ionAuth->getUserId();

                    if (isset($_POST['is_cancelable']) && $_POST['is_cancelable'] == 'on') {
                        $is_cancelable = "1";
                    } else {
                        $is_cancelable = "0";
                    }
                    if ($is_cancelable == "1" && $this->request->getVar('cancelable_till') == "") {
                        $response = [
                            'error' => true,
                            'message' => "Please Add Minutes",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    }
                    $service = array(
                        'id' => $service_id,
                        'user_id' => $user_id,
                        'category_id' => $category_id,
                        'tax_type' => $this->request->getVar('tax_type'),
                        // 'tax_id' => $this->request->getVar('tax_id'),
                        'tax' => $this->request->getPost('tax'),
                        'title' => $title,
                        'description' => $description,
                        'slug' => '',
                        'tags' =>  implode(',', $tags),
                        'price' => $price,
                        'discounted_price' => $discounted_price,
                        'image' => $image_name,
                        'number_of_members_required' => $this->request->getVar('members'),
                        'duration' => $this->request->getVar('duration'),
                        'rating' => 1,
                        'number_of_ratings' => 10,
                        'on_site_allowed' => 10,
                        'number_of_ratings' => 10,
                        'on_site_allowed' => ($this->request->getPost('on_site') == "on") ? 1 : 0,
                        'is_pay_later_allowed' => ($this->request->getPost('pay_later') == "on") ? 1 : 0,
                        'is_cancelable' => $is_cancelable,
                        'cancelable_till' => ($is_cancelable == "1") ? $this->request->getVar('cancelable_till') : '',
                        'max_quantity_allowed' => $this->request->getPost('max_qty')
                    );


                    $service_model = new Service_model();
                    if ($service_model->save($service)) {
                        $response = [
                            'error' => false,
                            'message' => "Service saved successfully!",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    } else {
                        $response = [
                            'error' => true,
                            'message' => "Service can not be Save!",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    }
                }
            } else {
                return redirect()->to('partner/services');
            }
        } else {
            return redirect('partner/login');
        }
    }

    public function list()
    {

        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
        $service_model = new Service_model();
        $where['user_id'] = $_SESSION['user_id'];
        $services =  $service_model->list(false, $search, $limit, $offset, $sort, $order, $where);
        return $services;
    }

    public function update_service()
    {
        if ($this->isLoggedIn) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            $price = $this->request->getPost('price');
            $this->validation->setRules(
                [
                    'title' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please enter service title"
                        ]
                    ],
                    'categories' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please select category"
                        ]
                    ],
                    'tags' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please enter service tag"
                        ]
                    ],
                    'price' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter price",
                            "numeric" => "Please enter numeric value for price"
                        ]
                    ],
                    'discounted_price' => [
                        "rules" => 'required|numeric|less_than['.$price.']',
                        "errors" => [
                            "required" => "Please enter discounted price",
                            "numeric" => "Please enter numeric value for discounted price",
                            "less_than" => "Discounted price should be less than price"
                        ]
                    ],
                    'members' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter required member for service",
                            "numeric" => "Please enter numeric value for required member"
                        ]
                    ],
                    'duration' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter duration to perform task",
                            "numeric" => "Please enter numeric value for duration of task"
                        ]
                    ],
                    'max_qty' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter max quantity allowed for services",
                            "numeric" => "Please enter numeric value for max quantity allowed for services"
                        ]
                    ],
                ],
            );
            if (!$this->validation->withRequest($this->request)->run()) {
                $errors  = $this->validation->getErrors();
                $response['error'] = true;
                $response['message'] = $errors;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['data'] = [];
                return $this->response->setJSON($response);
            }else{
            $base_tags = $this->request->getPost('tags');
            $s_t = $base_tags;
            $val = explode(',', str_replace(']', '', str_replace('[', '', $s_t[0])));

            $tags = [];
            foreach ($val as $s) {
                $tags[] = json_decode($s, true)['value'];
            }
           
            $service_image = $this->request->getFile('image');
            $id = $this->request->getPost('row_id');
            $old_data = fetch_details('services', ['id' => $id]);
            $old_image = $old_data[0]['image'];
            $t = time();
            $ext = $service_image->getExtension();
            $image_name = 'SERVICE' . $t . '.' . $ext;
            $path = "/public/uploads/services/";
            $old_path = "public/uploads/services/" . $old_image;
            if ($service_image->getName() != '') {
                unlink($old_path);
            }


            $category = $this->request->getPost('category_item');
            if ($category == "select_category" || $category == "Select Category") {
                $response = [
                    'error' => true,
                    'message' => "Please select anything other than Select Category",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            $discounted_price = $this->request->getPost('discounted_price');
            $price = $this->request->getPost('price');
            if ($discounted_price >= $price && $discounted_price == $price) {
                $response = [
                    'error' => true,
                    'message' => "discounted price can not be higher than or equal to the price",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            $user_id = $this->ionAuth->user()->row()->id;



            $tax_id = 00;
            // $data['user_id'] = $user_id;
            $data['category_id'] = $category;
            $data['tax_id'] = $tax_id;
            $data['tax'] = $this->request->getPost('tax');
            $data['title'] = $this->request->getPost('title');
            $data['slug'] = '';
            $data['description'] = $this->request->getPost('description');
            $data['tags'] = json_encode($tags);
            $data['price'] = $this->request->getPost('price');
            $data['discounted_price'] = $this->request->getPost('discounted_price');


            $data['image'] = $image_name;
            $data['number_of_members_required'] = $this->request->getPost('members');
            $data['duration'] = $this->request->getPost('duration');
            $data['rating'] = 1;
            $data['number_of_ratings'] = 10;
            $data['on_site_allowed'] = ($this->request->getPost('update_on_site') == "on") ? 1 : 0;
            $data['max_quantity_allowed'] = $this->request->getPost('max_qty');
            $data['is_pay_later_allowed'] = ($this->request->getPost('update_pay_later') == "on") ? 1 : 0;
            $data['status'] = ($this->request->getPost('status') == "on") ? 1 : 0;


            if ($this->db->table('services')->update($data, ['id' => $id])) {
                if (move_file($service_image, $path, $image_name)) {
                    $response = [
                        'error' => false,
                        'message' => "Service has been added",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "can not insert Service some issue occurred",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                }
            }
        }
        } else {
            return redirect('partner/login');
        }
    
    }

    public function delete()
    {
        if ($this->isLoggedIn) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            $id = $this->request->getPost('id');
            $db      = \Config\Database::connect();
            $builder = $db->table('services')->delete(['id' => $id]);
            if ($builder) {
                $response = [
                    'error' => false,
                    'message' => 'service deleted successfully',
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
            } else {
                $response = [
                    'error' => true,
                    'message' => 'service can not be deleted!',
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
            }
            return $this->response->setJSON($response);
        } else {
            return redirect('partner/login');
        }
    }
}
