<?php
/* 
    ------------------------------------------------------------------------------------
        edemand helpers
    ------------------------------------------------------------------------------------

    1.  function curl($url, $method = 'GET', $header = ['Content-Type: application/x-www-form-urlencoded'], $data = [], $authorization = NULL)
    2.  function generate_token()
    3.  function verify_token()
    4.  function xss_clean($data)
    5.  function get_settings($type = 'system_settings', $is_json = false)
    6.  function output_escaping($array)
    7.  function escape_array($array)
    8.  function update_details($set, $where, $table, $escape = true)
    9.  function fetch_details($table, $where = [], $fields = [])
    10. function exists($where, $table)
    11. function active_plan($user_id)
    12. function update_characters($length, $user_id, $provider = "")
    13. function user_characters($user_id)
    14. function active_plan_type($user_id)
    15. function verify_voice($language  ,$voice  , $provider )
    16. function get_plans($plan_id = null)
    17. function get_subscription($user_id, $active = false)
    18. function get_subscription($user_id, $active = false)
    19. function add_subscription($user_id, $plan_id, $tenure, $transaction_id, $price, $starts_from = '', $start_now = false)
    20. function slugify($text, $divider = '-')
    21. function verify_payment_transaction($txn_id, $payment_method, $additional_data = [])
    22. function add_transaction($transaction_id, $amount, $payment_method, $user_id, $status = 'pending', $subscription_id = '', $message = '')
    23. function upcoming_plans($user_id)
    24. function subscription_status($subscription_id)
    25. function valid_image($image)
    26. function move_file($file, $path = 'public/uploads/images/', $name = '', $replace = false, $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'])
    27. function formatOffset($offset)
    28. function get_timezone()
    29. function get_timezone_array()
    30. function check_exists($file)
    31. function has_upcoming($user_id)
    32. function convert_active($user_id)
    33. function upcoming_plan($user_id)
    34. function numbers_initials($num)
    35. function mail_error($subject, $message, $trace = "")
    36. function mask_email($email)
    37. function get_system_update_info()
    38. function labels($label, $alt = '')
    39. function create_label($variable , $title = '')
    40. function get_currency()
    41. function console_log($data)
    42. function delete_directory($dir) 
    43. function formate_number($number, $decimals = 0, $decimal_separator = '.', $thousand_separator = ',', $currency_symbol = '', $type = 'prefix')
    44. function email_sender($user_email, $subject, $message)
    45. create_unique_slug() ->not sure what i'll do
    46. insert_details
    47. remove_null_value
    48. response
    49. verify_app_request
    50. function fetch_cart($from_app = false, int $user_id = 0, string $search = '', int $limit = 10, int $offset = 0, string $sort = 'c.id', string $order = 'Desc', $where = [], $additional_data = [])


*/

use App\Libraries\Paystack;
use App\Libraries\Paytm;
use App\Libraries\Razorpay;
use App\Libraries\Flutterwave;
use App\Libraries\Stripe;
use App\Models\Orders_model;

use function PHPUnit\Framework\returnSelf;

function get_city_name($city_id)
{
    if (!empty($city_id)) {
        $where['id'] = $city_id;
        $city = fetch_details('cities', $where, ['name']);
        if (isset($city) && !empty($city)) {
            $name  = $city[0]['name'];
            return $name;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function update_balance($amount, $partner_id, $action)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('users');
    if ($action == "add") {
        $builder->set('balance', 'balance+' . $amount, FALSE);
    } elseif ($action == "deduct") {
        $builder->set('balance', 'balance-' . $amount, FALSE);
    }
    return $builder->where('id', $partner_id)->update();
}


function get_catgory_name($category_id = '')
{
    if (!empty($category_id)) {
        $where['id'] = $category_id;
        $where['status'] = '1';
        $categories = fetch_details('categories', $where, ['name']);
        if (isset($categories) && !empty($categories)) {
            $name  = $categories[0]['name'];
            return $name;
        } else {
            return 'general';
        }
    } else {
        return false;
    }
}


function get_subcatgory_name($category_id)
{
    $where['parent_id'] = $category_id;
    $where['status'] = '1';
    $subcategory = fetch_details('categories', $where, ['name']);
    if (isset($subcategory) && !empty($subcategory)) {
        return  $subcategory[0]['name'];
    } else {
        return '';
    }
}
function get_city($city_id = '')
{
    if (!empty($city_id)) {
        if ($city = fetch_details('cities', ['id' => $city_id], ['name'])) {
            $name  = $city[0]['name'];
            return $name;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function order_details($order_id)
{
    $model = new Orders_model();
    $where_in_key = 'o.status';
    $where_in_value = ['awaiting', 'confirmed', 'rescheduled'];
    $data = [];
    $order_details = $model->list(false, '', 10, 0, '', '', ['o.id' => $order_id], $where_in_key, $where_in_value);
    if (isset($order_details) && !empty($order_details)) {
        $details = json_decode($order_details);
        $data['order'] = isset($details->rows[0]) ? $details->rows[0] : '';
        $services = isset($details->rows[0]->services) ? $details->rows[0]->services : '';
        $id = (!empty($services)) ? array_column($services, 'service_id') : "";
        $data['cancellable'] = fetch_details('services', [], ['duration', 'is_cancelable', 'cancelable_till'], null, '0', '', '', 'id', $id);
        unset($data['order']->services);
        return $data;
    } else {
        return new stdClass();
    }
}
function check_cancelable($date_of_service, $starting_time, $cancellable_befor_min)
{
    $today = strtotime(date('y-m-d H:i'));
    $format_date = date('y-m-d H:i', strtotime("$date_of_service $starting_time"));
    $service_date = strtotime($format_date);
    if ($service_date >= $today) {
        $i = ($service_date - $today) / 60;
        if (intval($cancellable_befor_min) > $i) {
            return false;
        } else {
            return true;
        }
    }
}

function test($order_id, $status, $table = '', $user_id = null)
{
    $db      = \Config\Database::connect();
    $ionAuth = new \IonAuth\Libraries\IonAuth();
    $builder = $db->table('orders o');
    $error = 0;
    $cancelable_till = '';
    $is_already_cancelled = 0;
    $is_cancelable = 0;
    $cancelable_count = 0;
    $group = array('partner');
    $check_status = ['awaiting', 'confirmed', 'rescheduled', 'cancelled', 'completed'];

    if (in_array(($status), $check_status)) {
        $builder->select('o.status')->where('id', $order_id);
        $active_status = $builder->get()->getResultArray()[0]['status'];

        if ($active_status == 'cancelled' || $active_status == 'completed') {
            $response['error'] = true;
            $response['message'] = "You can't update status once item cancelled OR completed";
            $response['data'] = array();
            return $response;
        }
        $builder->select('o.status,os.service_id,s.is_cancelable,s.cancelable_till,s.duration')
            ->join('order_services os', 'os.order_id=o.id')
            ->join('services s', 's.id=os.service_id')
            ->where('o.id', $order_id);

        $service_data = $builder->get()->getResultArray();
        $priority_status = [
            'awaiting' => 0,
            'confirmed' => 1,
            'cancelled' => 2,
            'rescheduled' => 3,
            'completed' => 4,
        ];
        $is_posted_status_set = $canceling_completed_order = false;
        $is_posted_status_set_count = 0;

        for ($i = 0; $i < count($service_data); $i++) {
            /* check if there are any products returnable or cancellable products available in the list or not */
            if ($service_data[$i]['is_cancelable'] == 1) {
                $cancelable_count += 1;
            }
            if ($is_posted_status_set_count == count($service_data)) {
                $is_posted_status_set = true;
            }
            if (($status == "cancelled") && (in_array("completed", $check_status))) {
                $canceling_completed_order = true;
            }
        }

        $is_cancelable = ($cancelable_count >= 1) ? 1 : 0;

        for ($i = 0; $i < count($service_data); $i++) {
            if ($service_data[$i]['status'] == 'cancelled') {
                $error = 1;
                $is_already_cancelled = 1;
                break;
            }

            if ($status == 'rescheduled' && $service_data[$i]['is_rescheduled'] == 0) {
                $error = 1;
                break;
            }

            if ($status == 'returned' && $service_data[$i]['is_returnable'] == 1 && $priority_status[$service_data[$i]['active_status']] < 3) {
                $error = 1;
                $returnable_till = 'delivery';
                break;
            }

            if ($status == 'cancelled' && $service_data[$i]['is_cancelable'] == 1) {
              

                $max = $priority_status[$service_data[$i]['cancelable_till']];
                $min = $priority_status[$service_data[$i]['active_status']];

                if ($min > $max) {
                    $error = 1;
                    $cancelable_till = $service_data[$i]['cancelable_till'];
                    break;
                }
            }

            if ($status == 'cancelled' && $service_data[$i]['is_cancelable'] == 0) {
                $error = 1;
                break;
            }
        }
        if ($is_posted_status_set == true) {
            /* status posted is already present in any of the order item */
            $response['error'] = true;
            $response['message'] = "Order is already marked as $status. You cannot set it again!";
            $response['data'] = array();
            return $response;
        }
        if ($canceling_completed_order == true) {
            /* when user is trying cancel delivered order / item */
            $response['error'] = true;
            $response['message'] = "You cannot cancel completed service";
            $response['data'] = array();
            return $response;
        }
        for ($i = 0; $i < count($service_data); $i++) {
            if ($status == 'cancelled' && $service_data[$i]['is_cancelable'] == 1) {
                $max = $priority_status[$service_data[$i]['cancelable_till']];
                $min = $priority_status[$service_data[$i]['active_status']];
                if ($min > $max) {
                    $error = 1;
                    $cancelable_till = $service_data[$i]['cancelable_till'];
                    break;
                }
            }
            if ($status == 'cancelled' && $service_data[$i]['is_cancelable'] == 0) {
                $error = 1;
                break;
            }
        }
        if ($status == 'cancelled' && $error == 1 && !empty($cancelable_till) && !$ionAuth->loggedIn() && !$ionAuth->in_groupF($group, $user_id)) {
            $response['error'] = true;
            $response['message'] = (count($service_data) > 1) ? " One of the order item can be cancelled till " . $cancelable_till . " only " : "The order item can be cancelled till " . $cancelable_till . " only";
            $response['data'] = array();
            return $response;
        }

        if ($status == 'cancelled' && $error == 1 && !$ionAuth->loggedIn() && !$ionAuth->in_group($group, $user_id)) {
            $response['error'] = true;
            $response['message'] = (count($service_data) > 1) ? "One of the order item can't be cancelled !" : "The order item can't be cancelled !";
            $response['data'] = array();
            return $response;
        }
        if ($status == "cancellable" && $is_cancelable == 1) {
            echo "service is cancellable";
        }
        $response['error'] = false;
        $response['message'] = " ";
        $response['data'] = array();
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "Invalid Status Passed";
        $response['data'] = array();
        return $response;
    }
}

function get_service_details($order_id)
{
    $db      = \Config\Database::connect();
    // $where = 'status != "cancelled"';
    $data = $db
        ->table(' order_services')
        ->select('*')
        ->where('order_id', $order_id)
        ->where('status != ', 'cancelled')
        ->get()->getResultArray();


    $results = [];
    // $service_data = [];
    for ($i = 0; $i < sizeof($data); $i++) {
        $id =  $data[$i]['service_id'];
        // print_r($id);
        $service_data =  $db
            ->table('services')
            ->select('*')
            ->where('id', $id)
            ->get()->getResultArray();
        if (isset($service_data[0]) && !empty($service_data)) {
            array_push($results, $service_data[0]);
        }
    }
    // print_r($service_data);

    if (!empty($results))
        return $results;
    else {
        $response['error'] = true;
        $response['message'] = "No such service found!";
        return $response;
    }
}


function validate_status($order_id, $status, $date = '', $selected_time = "")
{
    $check_status = ['awaiting', 'confirmed', 'rescheduled', 'cancelled', 'completed'];
    if (in_array(($status), $check_status)) {
        $db      = \Config\Database::connect();
        $builder = $db->table('orders');
        $builder->select('status')->where('id', $order_id);
        $active_status = $builder->get()->getResultArray();
        $active_status = (isset($active_status[0]['status'])) ? $active_status[0]['status'] : "";

        if ($active_status == $status) {
            $response['error'] = true;
            $response['message'] = "You can't update the same status again";
            $response['data'] = array();
            return $response;
        }

        if ($active_status == 'cancelled' || $active_status == 'completed') {
            $response['error'] = true;
            $response['message'] = "You can't update status once item cancelled OR completed";
            $response['data'] = array();
            return $response;
        }
        if ($active_status == '') {
            $response['error'] = true;
            $response['message'] = "Invalid order or status data";
            $response['data'] = array();
            return $response;
        }


        if (in_array($active_status, ["confirmed", "rescheduled"]) && $status == "awaiting") {
            $response['error'] = true;
            $response['message'] = "You can't change status back to Awaiting! from confirmed";
            $response['data'] = array();
            return $response;
        }

        if (in_array($status, ["awaiting", "confirmed", "completed"])) {
            update_details(['status' => $status], ['id' => $order_id], 'orders');
            update_details(["status" => $status], ["order_id" => $order_id, "status!=" => "cancelled"], "order_services");
        }

        if ($status == 'rescheduled') {
            $data =  get_service_details($order_id);
            $time_calc = 0;
            for ($i = 0; $i < count($data); $i++) {
                $time_calc    += (int)$data[$i]['duration'];
            }
            $time_to_add = "+$time_calc minutes";
            $end_time = strtotime($time_to_add, strtotime($selected_time));
            $new_end_time =  date('h:i:s', $end_time);
            update_details(
                [
                    'status' => 'rescheduled',
                    'date_of_service' => $date,
                    'starting_time' => $selected_time,
                    'ending_time' => $new_end_time,
                    'duration' => $time_calc
                ],
                ['id' => $order_id],
                'orders'
            );
            update_details(["status" => $status], ["order_id" => $order_id, "status!=" => "cancelled"], "order_services");
        }
        if ($status == 'cancelled') {
            $order_details = order_details($order_id);
            // print_R($order_details);
            //     return;
            if (!empty($order_details)) {
                $order = $order_details['order'];
                
                $customer_id = $order->user_id;
                $date_of_service = $order->date_of_service;
                $starting_time = $order->starting_time;
                $cancellable = $order_details['cancellable'];

                $response = [];
                $response['status'] = $status;
                foreach ($cancellable as $key) {
                    if ($key['is_cancelable'] == "1" && $key['cancelable_till']) {
                        $is_cancelable = check_cancelable(date('y-m-d', strtotime($date_of_service)), $starting_time, $key['cancelable_till']);
                        if ($is_cancelable == true) {

                            update_details(['status' => $status], ['id' => $order_id], 'orders');
                            update_details(["status" => $status], ["order_id" => $order_id], "order_services");
                            $refund = process_refund($order_id, $status, $customer_id);
                            $response['is_cancelable'] = true;
                            $response['error'] = false;
                            $response['message'] = "Order updated successfully";
                            $response['data'] = $refund;
                            return $response;
                        } else {
                            $response['error'] = true;
                            $response['message'] = "Order is not cancelable!";
                            $response['data'] = [];
                            return $response;
                        }
                    } else {
                        $response['error'] = true;
                        $response['message'] = "Order is not cancelable!";
                        $response['data'] = [];
                        return $response;
                    }
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Order data not found!";
                $response['data'] = [];
                return $response;
            }
        }
        $response['error'] = false;
        $response['message'] = "Order updated successfully ";
        $response['data'] = [];
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "Invalid Status Passed";
        $response['data'] = array();
        return $response;
    }
}

function unsettled_commision($partner_id = '')
{
    $amount =  fetch_details('orders', ['partner_id' => $partner_id, 'is_commission_settled' => '0'], ['sum(final_total) as total']);
    if (isset($amount) && !empty($amount)) {
        //  commission will be in % here
        $admin_commission_percentage = get_admin_commision($partner_id);
        $admin_commission_amount = intval($admin_commission_percentage) / 100;
        $total = $amount[0]['total'];
        $commision = intval($total) * $admin_commission_amount;
        $unsettled_amount = $total - $commision;
    }

    return $unsettled_amount;
}
function get_admin_commision($partner_id = '')
{
    $commision =  fetch_details('partner_details', ['partner_id' => $partner_id], ['admin_commission'])[0]['admin_commission'];
    return $commision;
}
function process_refund($order_id, $status, $customer_id)
{
    $possible_status = array("cancelled");
    if (!in_array($status, $possible_status)) {
        $response['error'] = true;
        $response['message'] = 'Refund cannot be processed. Invalid status';
        $response['data'] = array();
        return $response;
    }
    /* if complete order is getting cancelled */
    $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status']);
    if (isset($transaction) && !empty($transaction)) {
        $type = $transaction[0]['type'];
        $currency = $transaction[0]['currency_code'];
        $txn_id = $transaction[0]['txn_id'];
        $amount = $transaction[0]['amount'];
        if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
            $flutterwave = new Flutterwave();
            $payment = $flutterwave->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == 'success') {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'flutterwave',
                    'txn_id' => $payment['id']
                ];
                $success =  insert_details($data, 'transactions');
                $response['error'] = false;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = "Payment Refund Successfully";
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                }
            } else {
                $message = json_decode($payment, true);
                $response['error'] = true;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = $message['message'];
            }
        }
        if ($type == "stripe" && $transaction[0]['status'] == 'succeeded') {
            $stripe = new Stripe();
            $payment = $stripe->refund($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "succeeded") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['object'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'stripe',
                    'txn_id' => $payment['payment_intent'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                }

                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "razorpay" && $transaction[0]['status'] == "captured") {
            $razorpay = new Razorpay();
            $payment = $razorpay->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "processed") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['entity'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'razorpay',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelle    d Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "order can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment['body'], true);
                $msg = $res['error']['description'];
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "paystack" && $transaction[0]['status'] == "success") {
            $paystack = new Paystack();
            $payment = $paystack->refund($txn_id, $amount);
            $message = json_decode($payment, true);
            if (isset($payment['status']) && $payment['status'] == "true") {
                update_details(['status' => $status], ['id' => $order_id], 'orders');
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['entity'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paystack',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "order can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment, true);
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $res['message'],
                ];
                return $response;
            }
        }
    } else {
        $response = [
            'error' => true,
            'csrfName' => csrf_token(),
            'csrfHash' => csrf_hash(),
            'message' => 'No transactio found of this order!',
        ];
        return $response;
    }
}

function process_service_refund($order_id, $ordered_service_id, $status, $customer_id, $amount)
{
    $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status']);

    if (isset($transaction) && !empty($transaction)) {
        $service_id = $ordered_service_id;
        $type = $transaction[0]['type'];
        $currency = $transaction[0]['currency_code'];
        $txn_id = $transaction[0]['txn_id'];
        $amount = $amount;
        if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
            $flutterwave = new Flutterwave();
            $payment = $flutterwave->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == 'success') {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'flutterwave',
                    'txn_id' => $payment['id']
                ];
                $success =  insert_details($data, 'transactions');
                $response['error'] = false;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = "Payment Refund Successfully";
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                }
            } else {
                $message = json_decode($payment, true);
                $response['error'] = true;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = $message['message'];
            }
        }
        if ($type == "stripe" && $transaction[0]['status'] == 'succeeded') {
            $stripe = new Stripe();
            $payment = $stripe->refund($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "succeeded") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['object'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'stripe',
                    'txn_id' => $payment['payment_intent'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                }

                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "razorpay" && $transaction[0]['status'] == "captured") {
            $razorpay = new Razorpay();
            $payment = $razorpay->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "processed") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['entity'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'razorpay',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Order cancelle    d Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "order can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment['body'], true);
                $msg = $res['error']['description'];
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "paystack" && $transaction[0]['status'] == "success") {
            $paystack = new Paystack();
            $payment = $paystack->refund($txn_id, $amount);
            $message = json_decode($payment, true);
            if (isset($payment['status']) && $payment['status'] == "true") {
                update_details(['status' => $status], ['id' => $order_id], 'orders');
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['entity'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paystack',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status']

                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    $response = [
                        'error' => false,
                        'message' => "Order cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "order can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment, true);
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $res['message'],
                ];
                return $response;
            }
        }
    } else {
        $response = [
            'error' => true,
            'csrfName' => csrf_token(),
            'csrfHash' => csrf_hash(),
            'message' => 'No transactio found of this order!',
        ];
        return $response;
    }
}

function curl($url, $method = 'GET', $header = ['Content-Type: application/x-www-form-urlencoded'], $data = [], $authorization = NULL)
{
    $ch = curl_init();
    $curl_options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_HEADER => 0,
        CURLOPT_HTTPHEADER => $header
    );

    if (strtolower($method) == 'post') {
        $curl_options[CURLOPT_POST] = 1;
        $curl_options[CURLOPT_POSTFIELDS] = http_build_query($data);
    } else {
        $curl_options[CURLOPT_CUSTOMREQUEST] = 'GET';
    }
    curl_setopt_array($ch, $curl_options);

    $result = array(
        'body' => curl_exec($ch),
        'http_code' => curl_getinfo($ch, CURLINFO_HTTP_CODE),
    );
    return $result;
}
function generate_token()
{
    $jwt = new App\Libraries\JWT();
    $payload = [
        'iat' => time(), /* issued at time */
        'iss' => 'edemand',
        'exp' => time() + (30 * 60), /* expires after 1 minute */
        'sub' => 'edemand_authentication'
    ];
    $token = $jwt->encode($payload, "my_secret");
    return $token;
}
function verify_token()
{
    // to verify the token from admin pannel    
    $responses = \Config\Services::response();
    $jwt = new App\Libraries\JWT;
    // verify_ip();
    try {
        $token = $jwt->getBearerToken();
    } catch (\Exception $e) {
        $response['error'] = true;
        $response['message'] = $e->getMessage();
        print_r(json_encode($response));
        return false;
    }

    if (!empty($token)) {
        $api_keys = API_SECRET;

        if (empty($api_keys)) {
            $response['error'] = true;
            $response['message'] = 'No Client(s) Data Found !';
            print_r(json_encode($response));
            return $response;
        }

        $flag = true; //For payload indication that it return some data or throws an expection.
        $error = true; //It will indicate that the payload had verified the signature and hash is valid or not.

        $message = '';
        $user_token = " ";
        try {
            $user_id = $jwt->decode_unsafe($token)->user_id;
            $user_token = fetch_details('users', ['id' => $user_id])[0]['api_key'];
        } catch (\Exception $e) {
            $message = $e->getMessage();
        }
        try {
            $payload = $jwt->decode($token, $api_keys, ['HS256']);

            if (isset($payload->iss)) {
                $error = false;
                $flag = false;
            } else {
                $error = true;
                $flag = false;
                $message = 'Invalid Hash';
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
        }
        if ($flag) {
            $response['error'] = true;
            $response['message'] = $message;
            print_r(json_encode($response));
            return false;
        } else {
            if ($error == true) {
                $response['error'] = true;
                $response['message'] = $message;
                $responses->setStatusCode(401);
                print_r(json_encode($response));
                return false;
            } else {
                return $payload->user_id;
            }
        }
    } else {
        $response['error'] = true;
        $response['message'] = "Unauthorized access not allowed";
        print_r(json_encode($response));
        return false;
    }
}
function xss_clean($data)
{
    $data = trim($data);
    // Fix &entity\n;
    $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
    $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
    $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
    $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
    // Remove any attribute starting with "on" or xmlns
    $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
    // Remove javascript: and vbscript: protocols
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
    // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);
    // Remove namespaced elements (we do not need them)
    $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
    do {
        // Remove really unwanted tags
        $old_data = $data;
        $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
    } while ($old_data !== $data);
    // we are done...
    return $data;
}
function get_settings($type = 'system_settings', $is_json = false, $bool = false)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('settings');
    if ($type == 'all') {
        $res = $builder->select(' * ')->get()->getResultArray();
    } else {
        $res = $builder->select(' * ')->where('variable', $type)->get()->getResultArray();
    }
    if (!empty($res)) {
        if ($is_json) {
            return json_decode($res[0]['value'], true);
        } else {
            return $res[0]['value'];
        }
    } else {
        if ($bool) {

            return false;
        } else {
            return [];
        }
    }
}
function output_escaping($array)
{
    if (!empty($array)) {
        if (is_array($array)) {
            $data = array();
            foreach ($array as $key => $value) {
                if ($value != null) {
                    $data[$key] = stripcslashes($value);
                }
            }
            return $data;
        } else if (is_object($array)) {
            $data = new stdClass();
            foreach ($array as $key => $value) {
                $data->$key = stripcslashes($value);
            }
            return $data;
        } else {
            return stripcslashes($array);
        }
    }
}
function escape_array($array)
{
    $db      = \Config\Database::connect();
    $posts = array();
    if (!empty($array)) {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $posts[$key] = $db->escapeString($value);
            }
        } else {
            return $db->escapeString($array);
        }
    }
    return $posts;
}
function update_details($set, $where, $table, $escape = true)
{
    $db      = \Config\Database::connect();
    $db->transStart();
    if ($escape) {
        $set = escape_array($set);
    }
    $db->table($table)->update($set, $where);
    $db->transComplete();
    $response = FALSE;
    if ($db->transStatus() === TRUE) {
        $response = TRUE;
    }
    return $response;
}
function fetch_details($table, $where = [], $fields = [], $limit = "", $offset = '0', $sort = 'id', $order = 'DESC', $where_in_key = '', $where_in_value = [], $or_like = [])
{
    $db      = \Config\Database::connect();
    $builder = $db->table($table);
    if (!empty($fields)) {
        $builder = $builder->select($fields);
    }
    if (!empty($where)) {
        $builder = $builder->where($where)->select($fields);
    }
    if (!empty($where_in_key) && !empty($where_in_value)) {
        $builder = $builder->whereIn($where_in_key, $where_in_value);
    }
    if (isset($or_like) && !empty($or_like)) {
        $builder->groupStart();
        $builder->orLike($or_like);
        $builder->groupEnd();
    }
    if ($limit != null && $limit != "") {
        $builder = $builder->limit($limit, $offset);
    }
    $builder = $builder->orderBy($sort, $order);
    $res = $builder->get()->getResultArray();
    return $res;
}
function exists($where, $table)
{
    $db      = \Config\Database::connect();
    $builder = $db->table($table);
    $builder = $builder->where($where);
    $res = count($builder->get()->getResultArray());
    if ($res > 0) {
        return true;
    } else {
        return false;
    }
}
function get_group($name = "")
{
    $db      = \Config\Database::connect();
    $builder = $db->table("groups as g");
    $builder->select('ug.*,g.name');
    $builder->where('g.name', $name);
    $builder->join('users_groups as ug', 'g.id = ug.group_id ', "left");
    $group = $builder->get()->getResultArray();
    return $group;
}
function slugify($text, $divider = '-')
{
    $text = preg_replace('~[^\pL\d]+~u', $divider, $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, $divider);
    $text = preg_replace('~-+~', $divider, $text);
    $text = strtolower($text);
    if (empty($text)) {
        return 'n-a';
    }
    return $text;
}
function verify_payment_transaction($txn_id, $payment_method, $additional_data = [])
{
    $db      = \Config\Database::connect();

    if (empty(trim($txn_id))) {
        $response['error'] = true;
        $response['message'] = "Transaction ID is required";
        return $response;
    }
    $razorpay = new Razorpay;
    switch ($payment_method) {
        case 'razorpay':

            $payment = $razorpay->fetch_payments($txn_id);
            if (!empty($payment) && isset($payment['status'])) {
                if ($payment['status'] == 'authorized') {
                    $capture_response = $razorpay->capture_payment($payment['amount'], $txn_id, $payment['currency']);
                    if ($capture_response['status'] == 'captured') {
                        $response['error'] = false;
                        $response['message'] = "Payment captured successfully";
                        $response['amount'] = $capture_response['amount'] / 100;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    } else if ($capture_response['status'] == 'refunded') {
                        $response['error'] = true;
                        $response['message'] = "Payment is refunded.";
                        $response['amount'] = $capture_response['amount'] / 100;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    } else {
                        $response['error'] = true;
                        $response['message'] = "Payment could not be captured.";
                        $response['amount'] = (isset($capture_response['amount'])) ? $capture_response['amount'] / 100 : 0;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    }
                } else if ($payment['status'] == 'captured') {
                    $status = 'captured';
                    $response['error'] = false;
                    $response['message'] = "Payment captured successfully";
                    $response['amount'] = $payment['amount'] / 100;
                    $response['status'] = $payment['status'];
                    $response['data'] = $payment;
                    return $response;
                } else if ($payment['status'] == 'created') {
                    $status = 'created';
                    $response['error'] = true;
                    $response['message'] = "Payment is just created and yet not authorized / captured!";
                    $response['amount'] = $payment['amount'] / 100;
                    $response['data'] = $payment;
                    $response['status'] = $payment['status'];
                    return $response;
                } else {
                    $status = 'failed';
                    $response['error'] = true;
                    $response['message'] = "Payment is " . ucwords($payment['status']) . "! ";
                    $response['amount'] = (isset($payment['amount'])) ? $payment['amount'] / 100 : 0;
                    $response['status'] = $payment['status'];
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the transaction ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                $response['status'] = 'failed';
                return $response;
            }
            break;
        case "paystack":
            $paystack = new Paystack;
            $payment = $paystack->verify_transation($txn_id);
            if (!empty($payment)) {
                $payment = json_decode($payment, true);
                if (isset($payment['data']['status']) && $payment['data']['status'] == 'success') {
                    $response['error'] = false;
                    $response['message'] = "Payment is successful";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    $response['status'] = $payment['data']['status'];
                    return $response;
                } elseif (isset($payment['data']['status']) && $payment['data']['status'] != 'success') {
                    $response['error'] = true;
                    $response['message'] = "Payment is " . ucwords($payment['data']['status']) . "! ";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    $response['status'] = $payment['data']['status'];

                    return $response;
                } else {
                    $response['error'] = true;
                    $response['message'] = "Payment is unsuccessful! ";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the transaction ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                $response['status'] = 'failed';
                return $response;
            }
            break;
        case 'paytm':
            $paytm = new Paytm;
            $payment = $paytm->transaction_status($txn_id);
            if (!empty($payment)) {
                $payment = json_decode($payment, true);
                if (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultCode'] == '01' && $payment['body']['resultInfo']['resultStatus'] == 'TXN_SUCCESS')
                ) {
                    $response['error'] = false;
                    $response['message'] = "Payment is successful";
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } elseif (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultStatus'] == 'TXN_FAILURE')
                ) {
                    $response['error'] = true;
                    $response['message'] = $payment['body']['resultInfo']['resultMsg'];
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } else if (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultStatus'] == 'PENDING')
                ) {
                    $response['error'] = true;
                    $response['message'] = $payment['body']['resultInfo']['resultMsg'];
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } else {
                    $response['error'] = true;
                    $response['message'] = "Payment is unsuccessful!";
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the Order ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                return $response;
            }
            break;
    }
}
function add_transaction($transaction_details)
{
    $db      = \Config\Database::connect();

    $insert = $db->table('transactions')->insert($transaction_details);
    if ($insert) {
        return $db->insertID();
    } else {
        return false;
    }
}

function valid_image($image)
{
    helper(['form', 'url']);
    $request = \Config\Services::request();
    if ($request->getFile($image)) {
        $file = $request->getFile($image);
        if (!$file->isValid()) {
            return false;
        }
        $type = $file->getMimeType();
        if ($type == 'image/jpeg' || $type == 'image/png' || $type == 'image/jpg' || $type == 'image/svg+xml' || $type = 'image/gif') {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}
function move_file($file, $path = 'public/uploads/images/', $name = '', $replace = false, $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'image/svg+xml', 'image/gif'])
{
    $type = $file->getMimeType();
    $p = FCPATH . $path;
    if (in_array($type, $allowed_types)) {
        if ($name == '') {
            $name = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->getName());
        }


        $ext =  $file->guessExtension();
        if ($file->move($p, $name, $replace)) {
            $name = $file->getName();
            $response['error'] = false;
            $response['message'] = "File moved successfully";
            $response['file_name'] = $name;
            $response['extension'] = $ext;
            $response['file_size'] = $file->getSizeByUnit("kb");
            $response['path'] = $path;
            $response['full_path'] = $path . $name;
        } else {
            $response['error'] = true;
            $response['message'] = "File could not be moved!" . $file->getError();
            $response['file_name'] = $name;
            $response['extension'] = "";
            $response['file_size'] = "";
            $response['path'] = $path;
            $response['full_path'] = "";
        }

        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "File could not be moved! Invalid file type uploaded";
        return $response;
    }
}
function formatOffset($offset)
{
    $hours = $offset / 3600;
    $remainder = $offset % 3600;
    $sign = $hours > 0 ? '+' : '-';
    $hour = (int) abs($hours);
    $minutes = (int) abs($remainder / 60);
    if ($hour == 0 and $minutes == 0) {
        $sign = ' ';
    }
    return $sign . str_pad($hour, 2, '0', STR_PAD_LEFT) . ':' . str_pad($minutes, 2, '0');
}
function get_timezone()
{
    $list = DateTimeZone::listAbbreviations();
    $idents = DateTimeZone::listIdentifiers();
    $data = $offset = $added = array();
    foreach ($list as $abbr => $info) {
        foreach ($info as $zone) {
            if (
                !empty($zone['timezone_id'])
                and
                !in_array($zone['timezone_id'], $added)
                and
                in_array($zone['timezone_id'], $idents)
            ) {
                $z = new DateTimeZone($zone['timezone_id']);
                $c = new DateTime("", $z);
                $zone['time'] = $c->format('H:i a');
                $offset[] = $zone['offset'] = $z->getOffset($c);
                $data[] = $zone;
                $added[] = $zone['timezone_id'];
            }
        }
    }
    array_multisort($offset, SORT_ASC, $data);
    $options = array();
    foreach ($data as $key => $row) {
        $options[$row['timezone_id']] = $row['time'] . ' - '
            . formatOffset($row['offset'])
            . ' ' . $row['timezone_id'];
    }
    return $options;
}
function get_timezone_array()
{
    $list = DateTimeZone::listAbbreviations();
    $idents = DateTimeZone::listIdentifiers();

    $data = $offset = $added = array();
    foreach ($list as $abbr => $info) {
        foreach ($info as $zone) {
            if (
                !empty($zone['timezone_id'])
                and
                !in_array($zone['timezone_id'], $added)
                and
                in_array($zone['timezone_id'], $idents)
            ) {
                $z = new DateTimeZone($zone['timezone_id']);
                $c = new DateTime("", $z);
                $zone['time'] = $c->format('h:i A');
                $offset[] = $zone['offset'] = $z->getOffset($c);
                $data[] = $zone;
                $added[] = $zone['timezone_id'];
            }
        }
    }

    array_multisort($offset, SORT_ASC, $data);
    $i = 0;
    $temp = array();
    foreach ($data as $key => $row) {
        $temp[0] = $row['time'];
        $temp[1] = formatOffset($row['offset']);
        $temp[2] = $row['timezone_id'];
        $options[$i++] = $temp;
    }

    return $options;
}
function check_exists($file)
{
    $file_headers = @get_headers($file);

    $target_path = FCPATH . $file;
    if (!file_exists($target_path)) {

        return true;
    } else {
        return false;
    }
}

function numbers_initials($num)
{
    if ($num > 1000) {

        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('K', 'M', 'B', 'T');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];

        return $x_display;
    }

    return $num;
}
function mail_error($subject, $message, $trace = "")
{
}
function mask_email($email)
{

    $em   = explode("@", $email);

    $name = implode('@', array_slice($em, 0, count($em) - 1));
    $len  = floor(strlen($name) / 2);


    return substr($name, 0, $len) . str_repeat('*', $len) . "@" . end($em);
}
function get_system_update_info()
{
    $check_query = false;
    $query_path = "";
    $data['previous_error'] = false;
    $sub_directory = (file_exists(UPDATE_PATH . "update/updater.json")) ? "update/" : "";
    if (file_exists(UPDATE_PATH . "updater.json") || file_exists(UPDATE_PATH . "update/updater.json")) {
        $lines_array = file_get_contents(UPDATE_PATH . $sub_directory . "updater.json");
        $lines_array = json_decode($lines_array, true);
        $file_version = $lines_array['version'];
        $file_previous = $lines_array['previous'];
        $check_query = $lines_array['manual_queries'];
        $query_path = $lines_array['query_path'];
    } else {
        print_r("no json exists");
        die();
    }
    $db_version_data =   fetch_details("updates");
    if (!empty($db_version_data) && isset($db_version_data[0]['version'])) {
        $db_current_version = $db_version_data[0]['version'];
    }
    if (!empty($db_current_version)) {
        $data['db_current_version'] = $db_current_version;
    } else {
        $data['db_current_version'] = $db_current_version = 1.0;
    }
    if ($db_current_version == $file_previous) {
        $data['file_current_version'] = $file_current_version = $file_version;
    } else {
        $data['previous_error'] = true;
        $data['file_current_version'] = $file_current_version = false;
    }

    if ($file_current_version != false && $file_current_version > $db_current_version) {

        $data['is_updatable'] =  true;
    } else {
        $data['is_updatable'] =  false;
    }
    $data['query'] =  $check_query;
    $data['query_path'] =  $query_path;
    return $data;
}

function labels($label, $alt = '')
{

    $label = trim($label);
    if (lang('Text.' . $label) != 'Text.' . $label) {
        if (lang('Text.' . $label) == '') {
            return $alt;
        }
        return trim(lang('Text.' . $label));
    } else {
        return trim($alt);
    }
}

function create_label($variable, $title = '')
{
    if ($title == '') {
        $title = $variable;
    }
    return '<div class="form-group col-md-6">
        <label>' . $title . '</label>
        <input type="text" name="' . $variable . '" value="' . labels($variable) . '" class="form-control">
    </div>';
}
function get_currency()
{
    try {
        $currency = get_settings('general_settings', true)['currency'];
        if ($currency == '') {
            $currency = '₹';
        }
    } catch (Exception $e) {
        $currency = '₹';
        console_log($e);
    }
    return $currency;
}


function console_log($data)
{
    if (is_array($data)) {
        $data = json_encode($data);
    } elseif (is_object($data)) {
        $data = json_encode($data);
    }
    echo "<script>console.log('$data')</script>";
}

function delete_directory($dir)
{

    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {

            if ($object != "." && $object != "..") {

                if (filetype($dir . "/" . $object) == "dir") {

                    // return 'this is folder';
                    $dir_sec = $dir . "/" . $object;
                    if (is_dir($dir_sec)) {
                        $objects_sec = scandir($dir_sec);
                        foreach ($objects_sec as $object_sec) {
                            if ($object_sec != "." && $object_sec != "..") {
                                if (filetype($dir_sec . "/" . $object_sec) == "dir")
                                    rmdir($dir_sec . "/" . $object_sec);
                                else
                                    unlink($dir_sec . "/" . $object_sec);
                            }
                        }
                        rmdir($dir_sec);
                    }
                } else {
                    unlink($dir . "/" . $object);
                }
            }
        }
        return rmdir($dir);
    }
}

function format_number($number, $decimals = 0, $decimal_separator = '.', $thousand_separator = ',', $currency_symbol = '', $type = 'prefix')
{
    $number = number_format($number, $decimals, $decimal_separator, $thousand_separator);
    $number = (!empty(trim($currency_symbol))) ? (($type == 'prefix') ? $currency_symbol . $number : $number . $currency_symbol) : $number;
    return $number;
}
function email_sender($user_email, $subject, $message)
{
    $email = \Config\Services::email();

    $email_settings = \get_settings('email_settings', true);

    $smtpUsername = $email_settings['smtpUsername'];
    $email_type = $email_settings['mailType'];

    $email->setFrom($smtpUsername, $email_type);
    $email->setTo($user_email);
    $email->setSubject($subject);
    $email->setMessage($message);
    // print_R($email->send());
    if ($email->send()) {
        echo "in if";
        return true;
    } else {
        $data = $email->printDebugger(['headers']);
        return $data;
    }
}

// new functions

function insert_details(array $data, string $table): array
{
    $db      = \Config\Database::connect();
    $status = $db->table($table)->insert($data);
    $id = $db->insertID();
    if (!$status) {
        return [
            "error" => true,
            "message" => UNKNOWN_ERROR_MESSAGE,
            "data" => []
        ];
    }
    return [
        "error" => false,
        "message" => "Data inserted",
        "id" => $id,
        "data" => []
    ];
}

//remove null value from array 
function remove_null_values(array $data)
{
    // interger column names
    $integer = [
        'alternate_mobile' => 0,
        'range_wise_charges' => 0,
        'per_km_charge' => 0,
        'max_deliverable_distance' => 0,
        'fixed_charge' => 0,
        'discount' => 0,
    ];

    //enter emtpy array columnt 
    $array = [];


    foreach ($data as $key => $value) {
        if (is_array($value) || is_object($value)) {
            $data[$key] = remove_null_values($value);
        } else {
            if (is_null($value)) {
                if (isset($integer[$key])) {
                    //add 0
                    $data[$key] = 0;
                } else if (isset($array[$key])) {
                    //add empty array
                    $data[$key] = [];
                } else {
                    //add empty string
                    $data[$key] = '';
                }
            }
        }
    }

    return $data;
}


function response(string $message = UNKNOWN_ERROR_MESSAGE, bool $error = true, $data = [], int $status_code = 200, $additional_data = [])
{
    $response = \Config\Services::response();
    $send = [
        "error" => $error,
        "message" => $message,
        "data" => $data
    ];
    $send = array_merge($send, $additional_data);
    return $response->setJSON($send)->setStatusCode($status_code);
}


function delete_details(array $data, string $table)
{
    $db      = \Config\Database::connect();
    $builder = $db->table($table);
    if ($builder->delete($data)) {
        return true;
    }
    return false;
}


function validate_promo_code($user_id, $promo_code, $final_total)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('promo_codes pc');
    $promo_code = $builder->select('pc.*,count(o.id) as promo_used_counter ,( SELECT count(user_id) from orders where user_id =' . $user_id . ' and promo_code ="' . $promo_code . '") as user_promo_usage_counter ')
        ->join('orders o', 'o.promo_code=pc.promo_code', 'left')
        ->where(['pc.promo_code' => $promo_code, 'pc.status' => '1', ' start_date <= ' => date('Y-m-d'), '  end_date >= ' => date('Y-m-d')])
        ->get()->getResultArray();
    if (!empty($promo_code[0]['id'])) {
        if (intval($promo_code[0]['promo_used_counter']) < intval($promo_code[0]['no_of_users'])) {

            if ($final_total >= intval($promo_code[0]['minimum_order_amount'])) {

                if ($promo_code[0]['repeat_usage'] == 1 && ($promo_code[0]['user_promo_usage_counter'] <= $promo_code[0]['no_of_repeat_usage'])) {
                    if (intval($promo_code[0]['user_promo_usage_counter']) <= intval($promo_code[0]['no_of_repeat_usage'])) {
                        $response['error'] = false;
                        $response['message'] = 'The promo code is valid';
                        if ($promo_code[0]['discount_type'] == 'percentage') {
                            $promo_code_discount =  floatval($final_total  * $promo_code[0]['discount'] / 100);
                        } else {
                            $promo_code_discount = $promo_code[0]['discount'];
                        }
                        if ($promo_code_discount <= $promo_code[0]['max_discount_amount']) {
                            $total = floatval($final_total) - $promo_code_discount;
                        } else {
                            $total = floatval($final_total) - $promo_code[0]['max_discount_amount'];
                            $promo_code_discount = $promo_code[0]['max_discount_amount'];
                        }
                        $promo_code[0]['final_total'] = strval(floatval($total));
                        $promo_code[0]['final_discount'] = strval(floatval($promo_code_discount));
                        $response['data'] = $promo_code;
                        return $response;
                    } else {

                        $response['error'] = true;
                        $response['message'] = 'This promo code cannot be redeemed as it exceeds the usage limit';
                        $response['data']['final_total'] = strval(floatval($final_total));
                        return $response;
                    }
                } else if ($promo_code[0]['repeat_usage'] == 0 && ($promo_code[0]['user_promo_usage_counter'] <= 0)) {
                    if (intval($promo_code[0]['user_promo_usage_counter']) <= intval($promo_code[0]['no_of_repeat_usage'])) {
                        $response['error'] = false;
                        $response['message'] = 'The promo code is valid';

                        if ($promo_code[0]['discount_type'] == 'percentage') {
                            $promo_code_discount =  floatval($final_total  * $promo_code[0]['discount'] / 100);
                        } else {
                            $promo_code_discount = floatval($final_total - $promo_code[0]['discount']);
                        }
                        if ($promo_code_discount <= $promo_code[0]['max_discount_amount']) {
                            $total = floatval($final_total) - $promo_code_discount;
                        } else {
                            $total = floatval($final_total) - $promo_code[0]['max_discount_amount'];
                            $promo_code_discount = $promo_code[0]['max_discount_amount'];
                        }
                        $promo_code[0]['final_total'] = strval(floatval($total));
                        $promo_code[0]['final_discount'] = strval(floatval($promo_code_discount));
                        $response['data'] = $promo_code;
                        return $response;
                    } else {

                        $response['error'] = true;
                        $response['message'] = 'This promo code cannot be redeemed as it exceeds the usage limit';
                        $response['data']['final_total'] = strval(floatval($final_total));
                        return $response;
                    }
                } else {
                    $response['error'] = true;
                    $response['message'] = 'The promo has already been redeemed. cannot be reused';
                    $response['data']['final_total'] = strval(floatval($final_total));
                    return $response;
                }
            } else {

                $response['error'] = true;
                $response['message'] = 'This promo code is applicable only for amount greater than or equal to ' . $promo_code[0]['minimum_order_amount'];
                $response['data']['final_total'] = strval(floatval($final_total));
                return $response;
            }
        } else {

            $response['error'] = true;
            $response['message'] = "This promo code is applicable only for first " . $promo_code[0]['no_of_users'] . " users";
            $response['data']['final_total'] = strval(floatval($final_total));
            return $response;
        }
    } else {
        $response['error'] = true;
        $response['message'] = 'The promo code is not available or expired';
        $response['data']['final_total'] = strval(floatval($final_total));
        return $response;
    }
}

function get_near_partners($latitude, $longitude, $distance, $is_array = false)
{

    // $max_deliverable_distance = fetch_details('cities', ['id' => $city_id], ['max_deliverable_distance'])[0]['max_deliverable_distance'];
    $max_deliverable_distance = $distance;
    $db      = \Config\Database::connect();
    $point = ($latitude > -90 && $latitude < 90) ? "POINT($latitude" : "POINT($latitude > 90";
    $point .= ($longitude > -180 && $longitude < 180) ? " $longitude)" : " $longitude > 180)";

    $builder = $db->table('users u');
    // $partners = $builder->select("u.latitude,u.longitude,u.id,ST_Distance_Sphere(POINT(u.latitude,u.longitude), ST_GeomFromText('$point') ) as distance")
    //     ->join('users_groups ug', 'ug.user_id=u.id')
    //     ->where('ug.group_id', '3')
    //     ->where("ST_Distance_Sphere(POINT(u.latitude,u.longitude), ST_GeomFromText('$point') ) / 1000 <=", $max_deliverable_distance)
    //     ->get()->getResultArray();

    $partners = $builder->Select("u.latitude,u.longitude,u.id,st_distance_sphere(POINT($longitude, $latitude), POINT(`longitude`, `latitude` ))/1000  as distance")
        ->join('users_groups ug', 'ug.user_id=u.id')
        ->where('ug.group_id', '3')
        ->having('distance < ' . $max_deliverable_distance)
        ->orderBy('distance')
        ->get()->getResultArray();

    $ids = [];

    foreach ($partners as $key => $parnter) {
        $ids[] = $parnter['id'];
    }
    if ($is_array == false) {
        $ids = implode(',', $ids);
    }
    return $ids;
}

function fetch_cart($from_app = false, int $user_id = 0, string $search = '', int $limit = 10, int $offset = 0, string $sort = 'c.id', string $order = 'Desc', $where = [], $additional_data = [])
{

    $db      = \Config\Database::connect();
    $builder = $db->table('cart c');

    $sortable_fields = [
        'c.id' => 'c.id'
    ];


    if ($search and $search != '') {
        $multipleWhere = [
            '`s.id`' => $search, '`s.title`' => $search, '`s.description`' => $search, '`s.status`' => $search, '`s.tags`' => $search,
            '`s.price`' => $search, '`s.discounted_price`' => $search, '`s.rating`' => $search, '`s.number_of_ratings`' => $search,
            '`s.max_quantity_allowed`' => $search
        ];
    }
    $total  = $builder->select(' COUNT(c.id) as `total` ')->where('c.user_id', $user_id);
    if (isset($multipleWhere) && !empty($multipleWhere)) {
        $builder->orWhere($multipleWhere);
    }
    if (isset($where) && !empty($where)) {
        $builder->where($where);
    }
    $service_count = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
    $total = $service_count[0]['total'];

    if (isset($multipleWhere) && !empty($multipleWhere)) {
        $builder->orLike($multipleWhere);
    }
    if (isset($where) && !empty($where)) {
        $builder->where($where);
    }
    $service_record = $builder
        ->select('c.id as cart_id,c.service_id,c.qty,c.is_saved_for_later,s.*,s.title as service_name,p.username as partner_name,pd.visiting_charges as visiting_charges,cat.name as category_name')
        ->join('services s', 'c.service_id=s.id', 'left')
        ->join('users p', 'p.id=s.user_id', 'left')
        ->join('categories cat', 'cat.id=s.category_id', 'left')
        ->join('partner_details pd', 'pd.partner_id=s.user_id', 'left')
        ->where('c.user_id', $user_id)->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
    $bulkData = $rows = $tempRow = array();
    $bulkData['total'] = $total;
    $tax =  get_settings('system_tax_settings', true)['tax'];

    foreach ($service_record as $row) {
        // OPD area
        if ($from_app) {
            if (check_exists(base_url('/public/uploads/services/' . $row['image']))) {
                $images = base_url('/public/uploads/services/' . $row['image']);
            } else {
                $images = 'nothing found';
            }
        } else {
            if (check_exists(base_url('/public/uploads/services/' . $row['image']))) {
                $images = '<a  href="' . base_url('/public/uploads/services/' . $row['image'])  . '" data-lightbox="image-1"><img height="80px" class="rounded-circle" src="' . base_url("/public/uploads/services/" . $row['image']) . '" alt="image of the services multiple will be here"></a>';
            } else {
                $images = 'nothing found';
            }
        }

        $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';
        $site_allowed = ($row['on_site_allowed'] == 1) ? 'Allowed' : 'Not Allowed';
        $pay_later = ($row['is_pay_later_allowed'] == 1) ? 'Allowed' : 'Not Allowed';

        $rating = $row['rating'] . "/5";
        // OPD area ends
        $tempRow['id'] = $row['cart_id'];
        $tempRow['service_id'] = $row['service_id'];
        $tempRow['service_id'] = $row['service_id'];
        $tempRow['is_saved_for_later'] = $row['is_saved_for_later'];
        $tempRow['qty'] = $row['qty'];
        $tempRow['visiting_charges'] =  $row['visiting_charges'];

        $tempRow['servic_details']['id'] = $row['id'];
        $tempRow['servic_details']['partner_id '] = $row['user_id'];
        $tempRow['servic_details']['category_id '] = $row['category_id'];
        $tempRow['servic_details']['category_name'] = $row['category_name'];
        $tempRow['servic_details']['partner_name'] = $row['partner_name'];
        //$tempRow['servic_details']['visiting_charges'] = $row['visiting_charges'];
        $tempRow['servic_details']['tax_id '] = $row['tax_id'];
        $tempRow['servic_details']['tax'] = $row['tax'];
        $tempRow['servic_details']['title'] = $row['title'];
        $tempRow['servic_details']['slug'] = $row['slug'];
        $tempRow['servic_details']['description'] = $row['description'];
        $tempRow['servic_details']['tags'] = $row['tags'];
        $tempRow['servic_details']['image_of_the_service'] = $images;
        $tempRow['servic_details']['price'] = $row['price'];
        $tempRow['servic_details']['discounted_price'] = $row['discounted_price'];
        $tempRow['servic_details']['number_of_members_required'] = $row['number_of_members_required'];
        $tempRow['servic_details']['duration'] = $row['duration'];
        $tempRow['servic_details']['tags'] = json_decode((string)$row['tags'], true);
        $tempRow['servic_details']['rating'] = $rating;
        $tempRow['servic_details']['number_of_ratings'] = $row['number_of_ratings'];
        $tempRow['servic_details']['on_site_allowed'] = $site_allowed;
        $tempRow['servic_details']['max_quantity_allowed'] = $row['max_quantity_allowed'];
        $tempRow['servic_details']['is_pay_later_allowed'] = $pay_later;
        // $tempRow['servic_details']['advance_booking_days'] = $row['advance_booking_days'];
        $tempRow['servic_details']['status'] = $status;
        $tempRow['servic_details']['created_at'] = $row['created_at'];

        $rows[] = $tempRow;
    }

    if ($from_app) {
        if (!empty($service_record)) {
            $array_ids =  fetch_details('cart c', ['user_id' => $user_id], 'service_id,qty');
            $s = [];
            $q = [];
            foreach ($array_ids as $ids) {
                array_push($s, $ids['service_id']);
                array_push($q, $ids['qty']);
            }
            $id = implode(',', $s);
            $qty = implode(',', $q);
            $builder =  $db->table('services s');



            $extra_data = $builder
                ->select('SUM(IF(s.discounted_price  > 0 , (s.discounted_price * c.qty) , (s.price * c.qty))) as subtotal, 
            SUM(c.qty) as total_quantity,pd.visiting_charges as visiting_charges,SUM(s.duration) as total_duration,pd.advance_booking_days as advance_booking_days,pd.company_name as company_name')
                ->join('cart c', 'c.service_id = s.id')
                ->join('partner_details pd', 'pd.partner_id=s.user_id')
                ->where('c.user_id', $user_id)
                ->whereIn('s.id', $s)->get()->getResultArray();



            $sub_total = $extra_data[0]['subtotal'];
            $calc = (($sub_total * intval($tax)) / 100);

            $data['total'] = (empty($total)) ? (string) count($rows) : $total;
            $data['advance_booking_days'] = isset($extra_data[0]['advance_booking_days']) ? $extra_data[0]['advance_booking_days'] : "";
            $data['visiting_charges'] = $extra_data[0]['visiting_charges'];
            $data['company_name'] = isset($extra_data[0]['company_name']) ? $extra_data[0]['company_name'] : "";
            $data['service_ids'] = $id;
            $data['qtys'] = isset($qty) ? $qty : 0;
            $data['total_quantity'] = $extra_data[0]['total_quantity'];
            $data['total_duration'] = $extra_data[0]['total_duration'];
            $data['sub_total'] = $sub_total;
            $data['tax_percentage'] = $tax;
            $data['taxable_amount'] = $calc;
            $data['overall_amount'] = $sub_total + $calc + $data['visiting_charges'];
            $data['data'] = $rows;

            $provider_data =  $db->table('services s');
            $providers = $provider_data
                ->select('u.username as provider_names, u.id as provider_id')
                ->join('users u', 'u.id = s.user_id')
                ->whereIn('s.id', $s)->get()->getResultArray();

            $pds = [];
            $pid = [];
            foreach ($providers as $provider) {
                array_push($pds, $provider['provider_names']);
                array_push($pid, $provider['provider_id']);
            }

            $unique_name = array_unique($pds);
            $unique_id = array_unique($pid);
            $names = implode(',', $unique_name);
            $ids = implode(',', $unique_id);

            $data['provider_names'] = $names;
            $data['provider_id'] = $ids;
            $pay_later_array = [];
            foreach ($service_record as $service_row) {
                array_push($pay_later_array, $service_row['is_pay_later_allowed']);
            }
            if (in_array(0, $pay_later_array)) {
                $data['is_pay_later_allowed'] = 0;
            } else {
                $data['is_pay_later_allowed'] = 1;
            }
            return $data;
        } else {
            $data = [];
            return $data;
        }
    } else {
        // else return json
        $bulkData['rows'] = $rows;
        return json_encode($bulkData);
    }
}


function send_bulk_notifications($fcmMsg, $registrationIDs_chunks, $user_ids)
{
    $fcmFields = [];
    foreach ($registrationIDs_chunks as $registrationIDs) {
        $fcmFields = array(
            'registration_ids' => $registrationIDs,  // expects an array of ids
            'priority' => 'high',
            'notification' => $fcmMsg,
            'data' => $fcmMsg,
        );
        $data = $fcmFields;
        unset($data['registration_ids']);
        $data = json_encode($data);

        // set json encoded data in Database 
        $headers = array(
            'Authorization: key=' . get_settings('fcm_server_key'),
            'Content-Type: application/json'
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmFields));
        $result = curl_exec($ch);
        curl_close($ch);
    }
    // print_r($fcmFields);
    return $fcmFields;
}

function get_taxable_amount($service_id)
{
    $service_details = fetch_details('services', ['id' => $service_id])[0];
    if ($service_details['tax'] != 0) {
        $tax_percentage = $service_details['tax'];
    } else {
        $tax_percentage = 0;
    }
    $price = (!empty($service_details['discounted_price'] && $service_details['discounted_price'] < $service_details['price'])) ? $service_details['discounted_price'] : $service_details['price'];
    $tax_amount = (!empty($tax_percentage)) ? ($price * $tax_percentage) / 100 : 0;
    $taxable_amount = $price + $tax_amount;

    $result = [
        'title' => $service_details['title'],
        'tax_percentage' => $tax_percentage,
        'tax_amount' => $tax_amount,
        'price' => $price,
        'taxable_amount' => $taxable_amount,
    ];
    return $result;
}

function get_partner_ids(string $type = '', string $column_name = 'id', array $ids = [], $is_array = false, array $fields_name = ['*'])
{
    $db      = \Config\Database::connect();
    if ($type == 'service') {
        $builder = $db->table('services s');
        $partners = $builder->select('s.user_id as id')
            ->whereIn('s.' . $column_name, $ids)
            ->get()->getResultArray();
    } else if ($type == 'category') {
        $builder = $db->table('services s');
        $partners = $builder->select('s.user_id as id')
            ->whereIN('s.' . $column_name, $ids)
            ->get()->getResultArray();
        // echo $db->getLastQuery();
    } else {
        $builder = $db->table('users u');
        $partners = $builder->select($fields_name)
            ->join('users_groups ug', 'ug.user_id=u.id')
            ->where('ug.group_id', '3')
            ->whereIn($column_name, $ids)
            ->get()->getResultArray();
    }
    $ids = [];
    foreach ($partners as $key => $parnter) {
        $ids[] = $parnter['id'];
    }
    $ids = array_unique($ids);
    if ($is_array == false) {
        $ids = implode(',', $ids);
    }
    return $ids;
}

function check_partner_availibility(int $partner_id)
{
    $days = [
        'Mon' => 'monday',
        'Tue' => 'tuesday',
        'Wed' => 'wednsday',
        'Thu' => 'thursday',
        'Fri' => 'friday',
        'Sat' => 'staturday',
        'Sun' => 'sunday'
    ];

    $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $days[date('D')]]);
    if (empty($partner_timing)) {
        return false;
    }
    $partner_timing = $partner_timing[0];
    $time = new DateTime($partner_timing['opening_time']);
    $opening_time = $time->format('H:i');
    $time = new DateTime($partner_timing['closing_time']);
    $closing_time = $time->format('H:i');
    $current_time = date('H:i');
    if (($opening_time <= $current_time) or ($current_time >= $closing_time)) {
        return   $partner_timing;
    } else {
        return false;
    }

    // print_r($partner_timing);
}

function get_booked_slot($service_id, $date)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('services s');
    $builder->select('s.user_id,o.starting_time,o.ending_time,o.date_of_service,o.duration');
    $builder->join('orders o', 'o.partner_id=s.user_id');
    $builder->where('o.date_of_service', $date);
    $builder->where('o.status', 1);
    $order_details = $builder->get()->getResultArray();
    $booked_slots = [];
    $i = 1;
    foreach ($order_details as $key => $order) {
        $slot_name = 'time_slot_' . $i;
        $booked_slots[$slot_name] = [
            'start_time' => $order['starting_time'],
            'end_time' => $order['ending_time'],
            'duration' => $order['duration']
        ];
    }
    return $booked_slots;
}

function get_time_slot()
{
    $days = [
        'Mon' => 'monday',
        'Tue' => 'tuesday',
        'Wed' => 'wednsday',
        'Thu' => 'thursday',
        'Fri' => 'friday',
        'Sat' => 'staturday',
        'Sun' => 'sunday'
    ];


    $service_id = 16;
    $partner_id = 50;
    $start_times = "5:00";
    $end_time = "6:00";
    $qty = 2;
    $date = date('Y-m-d');
    $day = $days[date('D', strtotime($date))];
    $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $day]);
    $service_details = fetch_details('services', ['id' => $service_id]);
    $service_duration = $service_details[0]['duration'];
    $parnter_opening_time = $partner_timing[0]['opening_time'];
    $parnter_closing_time = $partner_timing[0]['closing_time'];

    $time1 = strtotime($parnter_opening_time);
    $time2 = strtotime($parnter_closing_time);
    $total_hours = round(abs($time2 - $time1) / 3600, 2);

    $time_slotes = [];
    $increament_time = $service_duration;
    $slote_start_time = $parnter_opening_time;
    $i = 0;
    do {
        $slot_name = "time_slot_" . $i;
        $slote_end_time = date('H:i:s', strtotime('+' . $increament_time . ' minutes', strtotime($parnter_opening_time)));
        $time_slotes[$slot_name] = [
            'start_time' => date('H:i:s', strtotime($slote_start_time)),
            'end_time' => $slote_end_time
        ];
        $increament_time += $service_duration;
        $slote_start_time = $slote_end_time;
        $i++;
    } while ($slote_end_time != $parnter_closing_time);

    return $time_slotes;
}

function check_partner_type($partner_id)
{
    $data = fetch_details('partner_details', ['partner_id' => $partner_id]);
    if (isset($data[0]['type']) && $data[0]['type'] == '1') {
        return 'organization';
    } else {
        return 'single';
    }
}

function check_available_employee($partner_id)
{
    $db      = \Config\Database::connect();
    $data = $db->table('orders o')
        ->select('COUNT(o.id) AS order_count,
                SUM(os.quantity) AS quantity,
                (COUNT(o.id) * SUM(os.quantity)) AS order_members,
                pd.number_of_members,
                (pd.number_of_members -(COUNT(o.id) * SUM(os.quantity))) AS available_members')
        ->join('partner_details pd', 'pd.partner_id = o.partner_id', 'left')
        ->join('order_services os', 'o.id = os.order_id', 'left')
        ->where("o.partner_id = $partner_id AND o.status IN('confirmed', 'rescheduled')")
        ->get()->getResultArray();
    $type = check_partner_type($partner_id);
    if (!empty($type) && $type == 'organization' && !empty($data[0]['order_count']) && $data[0]['available_members'] != 0) {
        $response['error'] = false;
        $response['message'] = "Partner is available";
        $response['data'] = $data;
    } else {
        $response['error'] = true;
        $response['message'] = "Partner is not available";
        $response['data'] = $data;
    }
    return $response;
}
function check_availability_old($service_ids, $date_of_service, $starting_time)
{
    // get day
    $date = strtotime($date_of_service);
    $day = date('l', $date);
    $db      = \Config\Database::connect();
    $builder = $db->table('services s');
    $service_id = explode(",", $service_ids);
    // count total duration
    $total_duration = $builder
        ->select('sum(s.duration) as total')
        ->join('partner_details p', 'p.partner_id  = s.user_id')
        ->join('partner_timings pt', 'pt.partner_id  = p.partner_id')
        ->where('pt.day', $day)
        ->where('pt.is_open', 1)
        ->whereIn('s.id', $service_id)
        ->get()->getResultArray();
    // echo $db->lastQuery;

    $duration = $total_duration[0]['total'];

    // get end time
    $start_time  = strtotime(date('H:i', strtotime("$starting_time")));
    $end_time = date('H:i', strtotime(date('H:i', $start_time) . ' +' . $duration . ' minute'));

    // get data 
    $details = $builder
        ->select('s.id,s.title,s.user_id as partner_id,s.duration,p.company_name,p.type,p.number_of_members,pt.is_open,
        pt.day,pt.opening_time,pt.closing_time,o.starting_time as order_start_time,o.ending_time as order_end_time')
        ->join('partner_details p', 'p.partner_id  = s.user_id')
        ->join('partner_timings pt', 'pt.partner_id  = p.partner_id')
        ->join('orders o', 'o.partner_id  = s.user_id')
        ->whereIn('s.id', $service_id)
        ->where('pt.day', $day)
        ->where('pt.is_open', 1)
        ->where('pt.opening_time <= ', $starting_time)
        ->where('pt.closing_time >= ', $end_time)
        ->groupBy('s.id')
        ->get()->getResultArray();

    $response = '';
    if (isset($details) && !empty($details)) {
        foreach ($details as $detail) {
            // print_r($detail);
            $opening_time = new DateTime($detail['opening_time']);
            $opening_time = $opening_time->format('H:i');

            $closing_time = new DateTime($detail['closing_time']);
            $closing_time = $closing_time->format('H:i');


            if ($detail['type'] == 0) {
                // type of individual
                if (strtotime($date_of_service) > strtotime($opening_time)) {
                    if (strtotime($date_of_service) < strtotime($closing_time)) {
                        $response['error'] = false;
                        $response['message'] = "time slot is available";
                    } else {
                        $response['error'] = true;
                        $response['message'] = "time slot is not available";
                    }
                } else {
                    $response['error'] = true;
                    $response['message'] = "Service is not opening for that time";
                }
            } else {
                // type of organization

                $partner_id = $detail['partner_id'];
                $partner_data = check_available_employee($partner_id);

                if (isset($partner_data) && !empty($partner_data)) {

                    if (strtotime($date_of_service) > strtotime($opening_time)) {
                        if (strtotime($date_of_service) < strtotime($closing_time)) {
                            $response['error'] = true;
                            $response['message'] = "Partner is not available";
                        } else {
                            $response['error'] = false;
                            $response['message'] = "Partner is available";
                        }
                    } else {
                        return true;
                        // $response['error'] = true;
                        // $response['message'] = "Partner is not available for that time";
                    }
                } else {
                    $response['error'] = true;
                    $response['message'] = "Partner is not available";
                }
            }
        }
    } else {
        $response['error'] = true;
        $response['message'] = "Service not available";
    }
    return $response;
}

function get_recommended_time_slot($duration)
{
    $db = \Config\Database::connect();
    $builder = $db->table('partner_timings pt');
}

function is_bookmarked($user_id, $partner_id)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('bookmarks');
    $data =  $builder
        ->select('COUNT(id) as total')
        ->where('user_id', $user_id)
        ->where('partner_id', $partner_id)->get()->getResultArray();
    return $data;
}

function delete_bookmark($user_id, $partner_id)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('bookmarks');
    $data = $builder->where(['user_id' => $user_id, 'partner_id' => $partner_id])
        ->delete();
    if ($data) {
        return true;
    } else {
        return false;
    }
}

function send_notification($fcmMsg, $registrationIDs_chunks)
{
    $fcmFields = [];
    foreach ($registrationIDs_chunks as $registrationIDs) {
        $fcmFields = array(
            'registration_ids' => $registrationIDs,  // expects an array of ids
            'priority' => 'high',
            'data' => $fcmMsg,
        );
        // 'notification' => $fcmMsg,

        $headers = array(
            'Authorization: key=' . get_settings('api_key_settings', true)['firebase_server_key'],
            'Content-Type: application/json'
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmFields));
        $result = curl_exec($ch);
        return $result;
        curl_close($ch);
    }
    // print_r($fcmFields);
}

function is_permitted($user_id, $type_of_permission, $permit)
{
    $db      = \Config\Database::connect();
    $builder = $db->table('user_permissions');
    $builder->select('role,permissions');
    $builder->where('user_id', $user_id);
    $permissions = $builder->get()->getResultArray();

    if ($permissions[0]['role'] == "1") {
        return true;
    } else {
        $permissions = json_decode($permissions[0]['permissions'], true);

        foreach ($permissions as $key => $val) {
            if ($key == $type_of_permission) {      //to check if the given type of permission is valid

                if ($val[$permit] == "yes") {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }
}

function get_category($category_id = '')
{
    if (!empty($category_id)) {
        $where['parent_id'] = $category_id;
    }
    $where['status'] = '1';
    $categories = fetch_details('categories', $where, ['name', 'id']);
    return $categories;
}
// returns booked slot on provider on given date between partner's openning hours
function booked_timings($partner_id, $date_of_service)
{
    $db = \config\Database::connect();
    $table = $db->table('orders o');
    $day = date('l', strtotime($date_of_service));
    $response = $table->select('o.starting_time,o.ending_time')
        ->join('order_services os', 'o.id = os.order_id')
        ->join('services s', 'os.service_id = s.id')
        ->join('partner_timings pt', 'pt.partner_id = o.partner_id')
        ->where(['o.partner_id' => $partner_id, 'o.date_of_service' => $date_of_service, 'pt.day' => $day, 'pt.is_open' => '1'])
        ->whereIn('o.status', ['confirmed', 'rescheduled', 'awaiting'])
        ->groupBy('o.id')
        ->orderBy('o.starting_time')
        ->get()->getResultArray();
    return $response;
}

function check_availability($partner_id, $booking_date, $time)
{
    $today = date('Y-m-d');
    if ($booking_date < $today) {
        $response['error'] = true;
        $response['message'] = "please select upcoming date!";
        return $response;
    }
    $db = \config\Database::connect();
    $table = $db->table('orders a');
    $day = date('l', strtotime($booking_date));
    $timings = getTimingOfDay($partner_id, $day);
    if (isset($timings) && !empty($timings)) {
        $opening_time = $timings['opening_time'];
        $closing_time = $timings['closing_time'];
        $booked_slots = $table->select('a.starting_time AS free_before, (a.starting_time + INTERVAL a.duration HOUR_MINUTE) AS free_after')
            ->where("NOT EXISTS ( SELECT 1 FROM orders b WHERE b.starting_time
    BETWEEN (a.starting_time + INTERVAL a.duration HOUR_MINUTE) AND
    (a.starting_time + INTERVAL a.duration HOUR_MINUTE) + INTERVAL 15 SECOND - INTERVAL 1 MICROSECOND) AND
    (a.starting_time + INTERVAL a.duration HOUR_MINUTE) BETWEEN '$booking_date $opening_time' AND '$booking_date $closing_time' AND date_of_service = '$booking_date' AND status IN('awaiting','pending','confirmed','rescheduled') AND partner_id = '50'")
            ->groupBy('id')->orderBy('starting_time', 'ASC')->get()->getResultArray();
        // echo $db->lastQuery;
        if (isset($booked_slots) && !empty($booked_slots)) {
            if ($time >= $opening_time && $time < $closing_time) {

                foreach ($booked_slots as $key => $val) {
                    $from = strtotime($val['free_before']);
                    $till = strtotime($val['free_after']);
                    $t = isBetween($from, $till, strtotime($time)); // if doesnt work remove strtotime

                    if (isset($t) && $t == true) {
                        $response['error'] = true;
                        $response['message'] = "provider is busy at this time select another slot";
                    } else {
                        $response['error'] = false;
                        $response['message'] = "slot is available at this time";
                    }
                }
                return $response;
            } else {
                $response['error'] = true;
                $response['message'] = "Provider is closed at this time";
                return $response;
            }
        } else {
            $response['error'] = false;
            $response['message'] = "slot is availavble at this time";
            return $response;
        }
    } else {
        $response['error'] = true;
        $response['message'] = "provider is closed on this day";
        return $response;
    }
}


function isBetween($from, $till, $input)
{
    if ($input >= $from && $input <= $till) {
        return true;
    } else {
        return false;
    }
}

function getTimingOfDay($partner_id, $day)
{
    $timings = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $day], ['opening_time', 'closing_time', 'is_open']);
    if (!empty($timings) && isset($timings[0]) && $timings[0]['is_open'] == '1') {
        return $timings[0];
    } else {
        return false;
    }
}
function get_available_slots($partner_id, $booking_date)
{
    $today = date('Y-m-d');
    if ($booking_date < $today) {
        $response['error'] = true;
        $response['message'] = "please select upcoming date!";
        return $response;
    }
    $db = \config\Database::connect();
    $day = date('l', strtotime($booking_date));
    $timings = getTimingOfDay($partner_id, $day);
    if (isset($timings) && !empty($timings)) {
        $opening_time = $timings['opening_time'];
        $closing_time =  $timings['closing_time'];
        $booked_slots = booked_timings($partner_id, $booking_date);
        $interval  = 30 * 60;
        $start_time = strtotime($opening_time);
        $current_time = time();
        $end_time = strtotime($closing_time);
        $count = count($booked_slots);
        $current_date = date('Y-m-d');
        $available_slots = [];
        $busy_slots = [];
        
        if (isset($booked_slots) && !empty($booked_slots)) {
            while ($start_time <= $end_time) {
                $array_of_time[] = date("H:i:s", $start_time);
                $start_time += $interval;
            }
            $count_suggestion_slots = count($array_of_time);
            for ($i = 0; $i < $count; $i++) {
                for ($j = 0; $j < $count_suggestion_slots; $j++) {
                    if (strtotime($array_of_time[$j]) < strtotime($booked_slots[$i]['starting_time']) || strtotime($array_of_time[$j]) > strtotime($booked_slots[$i]['ending_time'])) {
                        if (!in_array($array_of_time[$j], $available_slots)) {
                            if (strtotime($array_of_time[$j]) > $current_time || strtotime($booking_date) != strtotime($current_date)) {
                                $available_slots[] = $array_of_time[$j];
                            }
                            else
                            {
                                $busy_slots[] = $array_of_time[$j];
                            }
                        } 
                        else {
                            // if (!in_array($array_of_time[$j], $busy_slots))
                            $busy_slots[] = $array_of_time[$j];
                        }
                    } else {
                        if (!in_array($array_of_time[$j], $busy_slots))
                            $busy_slots[] = $array_of_time[$j];
                    }
                }

                $count_busy_slots = count($busy_slots);
                for ($k = 0; $k < $count_busy_slots; $k++) {
                    if (($key = array_search($busy_slots[$k], $available_slots)) !== false) {
                        unset($available_slots[$key]);
                    }
                }
            }
            $response['error'] = false;
            $response['available_slots'] = $available_slots;
            $response['busy_slots'] = $busy_slots;
            return $response;
        } else {
            while ($start_time <= $end_time) {
                $array_of_time[] = date("H:i:s", $start_time);
                $start_time += $interval;
            }
            $response['error'] = false;
            $response['available_slots'] = $array_of_time;
            $response['busy_slots'] = $busy_slots;
            return $response;
        }
    } else {
        $response['error'] = true;
        $response['message'] = "provider is closed on this day";
        return $response;
    }
}



function get_service($service_id)
{
    if ($service_id != null) {
        return false;
    }

    $service = fetch_details('services', ['id' => $service_id]);

    if ($service != null && !empty($service)) {
        return response('Found data', false, $service);
    } else {
        return response('No Data Found', false, []);
    }
}


function has_ordered($user_id, $service_id)
{
    $db = \config\Database::connect();

    $services =  fetch_details('services', ['id' => $service_id]);

    if (empty($services)) {
        $response['error'] = true;
        $response['message'] = "No Service Found";
        return $response;
    }

    $builder = $db
        ->table('orders o')
        ->select(' o.id,o.user_id,os.service_id')
        ->join('order_services os', 'os.order_id = o.id')
        ->where('user_id', $user_id)
        ->where('o.status', 'completed')
        ->where('os.service_id', $service_id)->get()->getResultArray();

    if (!empty($builder)) {
        $response['error'] = false;
        $response['message'] = "Has ordered";
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "Can not rate service  without Placing orders";
        return $response;
    }
}

function has_rated($user_id, $rate_id)
{
    $db = \config\Database::connect();

    $builder = $db
        ->table('services_ratings sr')
        ->select('sr.*')
        ->where('sr.id', $rate_id)
        ->where('user_id', $user_id);
    $old_data = $builder->get()->getResultArray();
    if (!empty($old_data)) {
        $response['error'] = false;
        $response['message'] = "Found Rating";
        $response['data'] = $old_data;
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "No Rating Found";
        return $response;
    }
}


function get_ratings($user_id)
{
    $db = \config\Database::connect();

    //    echo "<pre>";
    $builder = $db
        ->table('services s')
        ->select("
            COUNT(sr.rating) as total_ratings,
            SUM( CASE WHEN sr.rating = ceil(5) THEN 1 ELSE 0 END) as rating_5,
            SUM( CASE WHEN sr.rating = ceil(4) THEN 1 ELSE 0 END) as rating_4,
            SUM( CASE WHEN sr.rating = ceil(3) THEN 1 ELSE 0 END) as rating_3,
            SUM( CASE WHEN sr.rating = ceil(2) THEN 1 ELSE 0 END) as rating_2,
            SUM( CASE WHEN sr.rating = ceil(1) THEN 1 ELSE 0 END) as rating_1
        ")
        ->join('services_ratings sr', 'sr.service_id = s.id')
        ->where('s.user_id', $user_id)
        ->get()->getResultArray();


    // print_r($builder);
    return $builder;
}


function update_ratings($service_id, $rate)
{
    $db = \config\Database::connect();
    $service_data = fetch_details('services', ['id' => $service_id]);
    if (!empty($service_data)) {
        $user_id = $service_data[0]['user_id'];
    }
    $partner_data = fetch_details('partner_details', ['partner_id' => $user_id]);

    if (!empty($partner_data)) {
        $partner_id = $partner_data[0]['partner_id'];
    }

    $service_ids = fetch_details('services', ['user_id' => $user_id], ['id']);

    $ids = [];

    foreach ($service_ids as $si) {
        array_push($ids, $si['id']);
    }

    $data = $db
        ->table('services_ratings sr')
        ->select(
            'count(sr.rating) as number_of_ratings,
            sum(sr.rating) as total_rating,
            (sum(sr.rating) /count(sr.rating)) as avg_rating'
        )
        ->whereIn('service_id', $ids)
        ->get()->getResultArray();

    if (!empty($data)) {
        $data[0]['number_of_ratings'] = $data[0]['number_of_ratings'];
        $data[0]['total_rating'] = $data[0]['total_rating'];
        $data[0]['avg_rating'] = $data[0]['total_rating'] / $data[0]['number_of_ratings'];

        $updated_data =  update_details(['ratings' => $data[0]['avg_rating'], 'number_of_ratings' => $data[0]['number_of_ratings']], ['partner_id' => $partner_id], 'partner_details');
        $updated_data =  update_details(['rating' => $data[0]['avg_rating'], 'number_of_ratings' => $data[0]['number_of_ratings']], ['id' => $service_id], 'services');
    } else {
        $updated_data =  update_details(
            ['ratings' => $rate, 'number_of_ratings' => 1],
            ['partner_id' => $partner_id],
            'partner_details'
        );
        $updated_data =  update_details(['rating' => $rate, 'number_of_ratings' => 1], ['id' => $service_id], 'services');
    }

    if ($updated_data != "") {
        return  $response['error'] = false;
    } else {
        return  $response['error'] = true;
    }
}

function rating_images($rating_id, $from_app = false)
{

    $rating_data = fetch_details('services_ratings', ['id' => $rating_id]);
    $d = ($from_app == false) ? 'for web' : 'for app';
    // print_r($d);
    // die();
    if (!empty($rating_data)) {
        $rating_images = json_decode($rating_data[0]['images'], true);
        // print_r($rating_images);
        $images_restored = [];
        foreach ($rating_images as $ri) {
            if ($from_app == false) {
                $image = '<a  href="' . base_url($ri) . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . base_url($ri) . '" alt=""></a>';
                array_push($images_restored, $image);
            } else {
                array_push($images_restored, base_url($ri));
            }
        }
    }
    return $images_restored;
}

function fetch_promo_codes($partner_id)
{
    $db = \config\Database::connect();

    $builder = $db
        ->table('promo_codes pc')
        ->select('pc.*')
        ->where('pc.partner_id', $partner_id);
    $data = $builder->get()->getResultArray();
    return $data;
}

function fetch_number_of_orders($partner_id)
{

    $db = \config\Database::connect();

    $builder = $db
        ->table('orders o')
        ->select('COUNT(o.id) as total_number_of_orders')
        ->where('o.partner_id', $partner_id);
    $data = $builder->get()->getResultArray();
    // return $data;
    if (!empty($data))
        return $data[0];
    else
        return $data;
}


function is_favorite($user_id, $partner_id)
{
    $db = \config\Database::connect();

    $builder = $db
        ->table('bookmarks b')
        ->select('b.*')
        ->where('b.user_id', $user_id)
        ->where('b.partner_id', $partner_id);
    $data = $builder->get()->getResultArray();
    if (!empty($data)) {
        return true;
    } else {
        return false;
    }
}


function favorite_list($user_id)
{
    $db = \config\Database::connect();

    $builder = $db
        ->table('bookmarks b')
        ->select('b.partner_id')
        ->where('b.user_id', $user_id);
    $data = $builder->get()->getResultArray();
    $partner_ids = [];
    if (!empty($data)) {
        foreach ($data as $dt) {
            array_push($partner_ids, $dt['partner_id']);
        }
        return $partner_ids;
    } else {
        return false;
    }
}

function distance_finder($lat1, $lon1, $lat2, $lon2, $unit)
{
    if (($lat1 == $lat2) && ($lon1 == $lon2)) {
        return 0;
    } else {
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);

        if ($unit == "K" || $unit == "KILOMETERS") {
            return ($miles * 1.609344);
        } else if ($unit == "N") {
            return ($miles * 0.8684);
        } else {
            return $miles;
        }
    }
}

function in_cart_qty($service_id, $user_id)
{
    $data = fetch_details('cart', ['user_id' => $user_id, 'service_id' => $service_id], ['qty']);
    $quantity = (!empty($data)) ? $data[0]['qty'] : '0';
    return $quantity;
}

function resize_image($image, $new_image, $width = 300, $height = 300)
{
    if (file_exists(FCPATH . $image)) {
        \Config\Services::image('gd')
            ->withFile(FCPATH . $image)
            ->resize($width, $height, true, 'auto')
            ->save(FCPATH . $new_image);
        $response['error'] = false;
        $response['message'] = "File resizes successfully";
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "File does not exist";
        return $response;
    }
}
