<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('provider', "Add Provider") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/partners') ?>">Provider</a></div>
                <div class="breadcrumb-item">Add Provider</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <h2 class='section-title'><?= labels('provider_details', "Provider Details") ?></h2>
            <div class="form-wrapper">
                <?= form_open('/admin/partner/insert_partner', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_partner', 'enctype' => "multipart/form-data"]); ?>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="company">Company Name</label>
                            <input id="company_name" class="form-control" type="text" name="company_name" placeholder="Enter the company name here" >
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="name">Image</label><br>
                            <input type="file" name="image" id="image" accept="image/*">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="banner_image">Banner Image</label><br>
                            <input type="file" name="banner_image" id="banner_image" accept="image/*">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- <div class="col-md-6">
                        <div class="form-group">
                            <div class="cities" id="cities_select">
                                <label for="city">City</label>
                                <select id="city" class="form-control" name="city">
                                    <option value="default">Select city</option>
                                    <?php
                                    foreach ($city_name as $city) : ?>
                                        <option value="<?= $city['id'] ?>"><?= $city['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div> -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <div class="cities" id="cities_select">
                                <label for="city">City</label>
                                <input type="text" name="city" class="form-control" placeholder="Enter your provider's city name">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address">Address</label>
                            <textarea id="address" class="form-control" name="address" placeholder="Enter the address here" rows="5"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="partner_location">Current Location</label>
                            <input id="partner_location" class="form-control" type="text" name="partner_location">
                        </div>
                    </div>
                    <div class="col-md">
                        <div id="map_wrapper_div_partner">
                            <div id="partner_map">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="partner_latitude">Latitude</label>
                            <input id="partner_latitude" class="form-control" type="text" name="partner_latitude" placeholder="Latitude">
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="partner_longitude">Longitude</label>
                            <input id="partner_longitude" class="form-control" type="text" name="partner_longitude" placeholder="Longitude">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="type">Type</label>
                            <select class="form-control" name="type" id="type">
                                <option value="">Select Type</option>
                                <option value="0">Individual</option>
                                <option value="1">Organization</option>
                            </select>
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="number_of_members">Number of Members</label>
                            <input id="number_of_members" class="form-control" type="text" name="number_of_members" placeholder="Enter the number of member here">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="visiting_charges">Visiting Charges</label>
                            <input id="visiting_charges" class="form-control" type="text" name="visiting_charges" placeholder="Enter the site visiting charges">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="advance_booking_days">Advance Booking Days</label>
                            <input id="advance_booking_days" class="form-control" type="text" name="advance_booking_days" placeholder="Enter the advanced booking days here">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-3 col-form-label">Status<span class="text-danger text-sm">*</span></label>
                            <div id="is_approved" class="btn-group col-sm-8">

                                <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="1"> Approved
                                </label>
                                <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="0" checked> Not approved
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="about">About Provider</label>
                            <textarea id="about" class="form-control" type="text" name="about" rowspan="10" placeholder="Enter the extra information about provider"></textarea>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Working Days</label>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="0">Monday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="0" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['opening_time']) ? $partner_timings[0]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="0" class="form-control end_time" name="end_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['closing_time']) ? $partner_timings[0]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (isset($partner_timings) &&  !empty($partner_timings) && $partner_timings[0]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="1">Tuesday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="1" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[1]['opening_time']) ? $partner_timings[1]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="01" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[1]['closing_time']) ? $partner_timings[1]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="2">Wednesday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="2" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[2]['opening_time']) ? $partner_timings[2]['opening_time'] : '0') ?> ">
                                </div>
                                <div class="col-md-1  text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="02" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[2]['closing_time']) ? $partner_timings[2]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[2]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="3">Thursday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="3" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[3]['opening_time']) ? $partner_timings[3]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[3]['closing_time']) ? $partner_timings[3]['closing_time'] : '0') ?>">

                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="4">Friday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="4" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[4]['opening_time']) ? $partner_timings[4]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[4]['closing_time']) ? $partner_timings[4]['closing_time'] : '0') ?>">

                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="5">Saturday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="5" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[5]['opening_time']) ? $partner_timings[5]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[5]['closing_time']) ? $partner_timings[5]['closing_time'] : '0') ?>">

                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="6">Sunday</label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="6" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[6]['opening_time']) ? $partner_timings[6]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    To
                                </div>
                                <div class="col-md-3">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[6]['closing_time']) ? $partner_timings[6]['closing_time'] : '0') ?>">

                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Open
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-12 col-md-6 col-lg-6">
                <div class="card">
                    <div class="card-header bg-navy border-0 h5">
                        <h4>Personal Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input id="username" class="form-control" type="text" name="username" placeholder="Enter the name here">
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input id="email" class="form-control" type="text" name="email" placeholder="Enter the email here">
                        </div>
                        <div class="form-group">
                            <label for="phone">Phone Number</label>
                            <input id="phone" class="form-control" type="text" name="phone" placeholder="Enter the phone here">
                        </div>
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input id="password" class="form-control" type="password" name="password" placeholder="Enter the password here">
                        </div>
                        <div class="form-group">
                            <label for="passport">Passport</label><br>
                            <input type="file" name="passport" id="passport" accept="image/*">
                        </div>
                        <div class="form-group">
                            <label for="national_id">National Identity</label><br>
                            <input type="file" name="national_id" id="national_id" accept="image/*">
                        </div>
                        <div class="form-group">
                            <label for="admin_commission">Commision(%)<small>( Commission(%) to be given to the Super Admin on Service.)</small></label>
                            <input id="admin_commission" class="form-control" type="number" name="admin_commission" placeholder="Enter the commission here" min="0">
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-lg-6">
                <div class="card">
                    <div class="card-header bg-navy border-0 h5">
                        <h4>Bank Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="tax_name">Tax Name</label>
                            <input id="tax_name" class="form-control" type="text" name="tax_name" placeholder="Enter the tax name here">
                        </div>
                        <div class="form-group">
                            <label for="tax_number">Tax Number</label>
                            <input id="tax_number" class="form-control" type="text" name="tax_number" placeholder="Enter the tax number here">
                        </div>
                        <div class="form-group">
                            <label for="account_number">Account Number</label>
                            <input id="account_number" class="form-control" type="text" name="account_number" placeholder="Enter the account number here">
                        </div>
                        <div class="form-group">
                            <label for="account_name">Account Name</label>
                            <input id="account_name" class="form-control" type="text" name="account_name" placeholder="Enter the account name here">
                        </div>
                        <div class="form-group">
                            <label for="bank_code">Bank Code</label>
                            <input id="bank_code" class="form-control" type="text" name="bank_code" placeholder="Enter the bank code here">
                        </div>
                        <div class="form-group">
                            <label for="bank_name">Bank Name</label>
                            <input id="bank_name" class="form-control" type="text" name="bank_name" placeholder="Enter the bank name here">
                        </div>
                        <div class="form-group">
                            <label for="swift_code">Swift Code</label>
                            <input id="swift_code" class="form-control" type="text" name="swift_code" placeholder="Enter the swift code here">
                        </div>
                    </div>
                    <div class="button-wrapper">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <button type="submit" class="btn btn-success">Add Provider</button>
                    </div>
                    <?= form_close(); ?>

                </div>
            </div>
        </div>
    </section>
</div>

<style>
</style>