<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('categories', "Categories") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Categories</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="card-body">
                <h2 class='section-title'><?= labels('create_category', "Create Category") ?></h2>
                <div class="row mt-3">
                    <div class="col-md">
                        <?= form_open('/admin/category/add_category', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_Category', 'enctype' => "multipart/form-data"]); ?>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input id="name" class="form-control" type="text" name="name" placeholder="Enter the name of the Category here">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm">
                        <div class="form-group">
                            <label for="make_parent">Type</label><br>
                            <select name="make_parent" id="make_parent" class="form-control">
                                <option value="0">Category</option>
                                <option value="1">Sub Category</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row" id="parent">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="category_ids">Select Parent Category</label><br>
                            <select name="parent_id" id="category_ids" class="form-control">
                                <option value="">Select Parent Category</option>
                                <?php foreach ($categories as $category) : ?>
                                    <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="custom-file form-group">
                            <label for="image" class="custom-file-label">Image</label>
                            <input  type="file" id="image" class="custom-file-input" name="image" accept="image/*" onchange="readURL(this)" />
                        </div>
                    </div>
                </div>
                <div class="col-md-6" id="service_image_section">
                    <div class="form-group image">
                        <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" alt="Service Image" width="30%" id="service_image">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="commision">Commision(%)<small>( Commission(%) to be given to the Super Admin on service.)</small></label>
                            <input id="commision" class="form-control" type="text" name="commision" placeholder="Enter the commission for the Category here" min="0">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="custom-control custom-switch mt-4">
                            <input class="custom-control-input" type="checkbox" name="changer" id="changer" checked>
                            <label class="custom-control-label" for="changer">
                                <p id="category_para" class="ml-10">
                                    Enable
                                </p>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div>
                            <button type="reset" class="btn btn-warning">Reset</button>
                            <button type="submit" class="btn btn-success">Add Category</button>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'>Category List</h2>
            <div class="row pb-3">
                <div class="col-12">
                    <table class="table table-striped" id="category_list" data-detail-formatter="category_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/categories/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="parent_id" class="text-center" data-sortable="true"><?= labels('parent_id', 'Parent Id') ?></th>
                                <th data-field="parent_category_name" class="text-center"><?= labels('parent_category_name', 'Parent Category Name') ?></th>
                                <th data-field="name" class="text-center" data-sortable="true"><?= labels('name', 'Name') ?></th>
                                <th data-field="category_image" class="text-center"><?= labels('image', 'Image') ?></th>
                                <th data-field="admin_commission" class="text-center" data-sortable="true"><?= labels('admin_commission', 'Admin Commission') ?></th>
                                <th data-field="status" class="text-center" data-sortable="true"><?= labels('status', 'Status') ?></th>
                                <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                <th data-field="operations" class="text-center" data-events="Category_events"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?= form_open('admin/category/update_category', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_Category', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="form-group">
                        <label for="name">Parent Category</label> <br>

                        <select name="parent_id_edit" id="parent_id_edit" class="form-control">
                            <option value="">Select Parent Category</option>
                            <?php foreach ($categories as $category) : ?>
                                <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input id="edit_name" class="form-control" type="text" name="name" placeholder="Enter the name of the Category here">
                    </div>



                    <div class="row">
                        <div class="col-md">
                            <img src="" alt="old_image" id="category_image" class="w-50" id="update_service_image">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="mb-3">
                                        <?= labels('service_image', "Service Image") ?>
                                        <label for="formFile" class="form-label">Choose Image for Category</label>
                                        <input class="form-control" type="file" id="formFile" name="image" accept="image/*" onchange="loadFile(event)">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="commision">Commision</label>
                        <input id="commision_1" class="form-control" type="number" name="commision_1" placeholder="Enter the commission for the Category here" min="0">
                    </div>
                    <div class="custom-control custom-switch mt-4">
                        <input type="checkbox" class="custom-control-input change
                        r_ed" id="changer_1" name="changer_1" checked>
                        <label class="custom-control-label" for="changer_1">
                            <p id="category_para_edit" class="ml-10">
                                Enable
                            </p>
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>