<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <div class="row mb-4">
            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="card card-statistic-2">
                    <div class="card-stats">
                        <div class="card-stats-title">Users Statistics

                        </div>
                        <div class="card-stats-items">
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_admin ?></div>
                                <div class="card-stats-item-label">System users</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_partners ?></div>
                                <div class="card-stats-item-label">Providers</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_customers ?></div>
                                <div class="card-stats-item-label">Customers</div>
                            </div>
                        </div>
                    </div>
                    <div class="card-icon bg-success">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Total Users</h4>
                        </div>
                        <div class="card-body">
                            <?= $total_users ?>
                        </div>
                    </div>
                </div>
                <div class="card card-statistic-1 ">
                    <div class="card-icon bg-danger">
                        <i class="far fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Total Earning</h4>
                        </div>

                        <div class="card-body">
                            <span>
                                <?= $currency ?>
                            </span>
                            <span class=""><?= $total_earning ?></span>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="card card-statistic-2">
                    <div class="card-stats">
                        <div class="card-stats-title">Services Statistics

                        </div>
                        <div class="card-stats-items">
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $available_services ?></div>
                                <div class="card-stats-item-label">Available Services</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_top_rated ?></div>
                                <div class="card-stats-item-label">Top Rated</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $new_services ?></div>
                                <div class="card-stats-item-label">Newely Added</div>
                            </div>
                        </div>
                    </div>
                    <div class="card-icon bg-warning">
                        <i class="fas fa-tools"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Total Services</h4>
                        </div>
                        <div class="card-body">
                            <?= $total_on_sale_service ?>
                        </div>
                    </div>
                </div>
                <div class="card card-statistic-1 ">
                    <div class="card-icon bg-info">
                        <i class="far fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Admin Earning</h4>
                        </div>

                        <div class="card-body">
                            <span>
                                <?= $currency ?>
                            </span>
                            <span class=""><?= $admin_earning ?></span>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="card card-statistic-2">
                    <div class="card-stats">
                        <div class="card-stats-title">Order Statistics
                        </div>
                        <div class="card-stats-items">
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_awaiting ?></div>
                                <div class="card-stats-item-label">Awaiting</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_confirmed ?></div>
                                <div class="card-stats-item-label">Confirmed</div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?= $total_completed ?></div>
                                <div class="card-stats-item-label">Completed</div>
                            </div>
                        </div>
                    </div>
                    <div class="card-icon bg-info">
                        <i class="fas fa-dolly-flatbed"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Total Orders</h4>
                        </div>
                        <div class="card-body">
                            <?= $total_orders ?>
                        </div>
                    </div>
                </div>
                <div class="card card-statistic-1 ">
                    <div class="card-icon bg-warning">
                        <i class="far fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4>Provider Earning</h4>
                        </div>

                        <div class="card-body">
                            <span>
                                <?= $currency ?>
                            </span>
                            <span class=""> <?= $partner_earnings ?></span>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-header">
                        <h4>Orders</h4>
                    </div>
                    <div class="card-body" style="height: 411px;">
                        <canvas id="myChart" width="200" height="400" style="display: block; box-sizing: border-box; height: 400px; width: 400px;"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-9 col-md-9 col-sm-9 col-9">
                <div class="chart">
                    <div class="card">
                        <div class="card-header">
                            <h4>Earning</h4>
                        </div>
                        <div class="card-body">
                            <canvas id="myChart11" width="200" height="65"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid card">
                <h2 class="section-title">Order Details</h2>
                <div class="row">
                    <div class="col-lg">
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="col-md">
                                    <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/orders/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, Al
                            
                            l]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                        <thead>
                                            <tr>
                                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                                <th data-field="user_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('user_id', 'User id') ?></th>
                                                <th data-field="customer" class="text-center"><?= labels('customer', 'Customer') ?></th>
                                                <th data-field="partner" class="text-center"><?= labels('provider', 'Provider') ?></th>
                                                <!-- <th data-field="city_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('city_id', 'city_id') ?></th> -->
                                                <th data-field="total" class="text-center"><?= labels('total', 'Total') ?></th>
                                                <th data-field="promo_code" class="text-center" data-visible="false"><?= labels('promo_code', 'Promo code') ?></th>
                                                <th data-field="promo_discount" class="text-center" data-visible="false"><?= labels('promo_discount', 'Promo discount') ?></th>
                                                <th data-field="final_total" class="text-center" data-sortable="true" data-visible="false"><?= labels('final_total', 'Final total') ?></th>
                                                <th data-field="admin_earnings" class="text-center" data-visible="false"><?= labels('Admin earnings', 'Admin earnings') ?></th>
                                                <th data-field="partner_earnings" class="text-center" data-visible="false"><?= labels('Partner earnings', 'Partner earnings') ?></th>
                                                <th data-field="address_id" class="text-center" data-visible="false"><?= labels('address_id', 'Address id') ?></th>
                                                <th data-field="address" class="text-center" data-visible="false"><?= labels('address', 'Address') ?></th>
                                                <th data-field="date_of_service" class="text-center"><?= labels('date_of_service', 'Date of Service') ?></th>
                                                <th data-field="starting_time" class="text-center"><?= labels('starting_time', 'Starting time') ?></th>
                                                <th data-field="ending_time" class="text-center"><?= labels('ending_time', 'Ending time') ?></th>
                                                <th data-field="duration" class="text-center" data-visible="false"><?= labels('duration', 'Duration') ?></th>
                                                <th data-field="status" class="text-center"><?= labels('status', 'Status') ?></th>
                                                <th data-field="remarks" class="text-center" data-visible="false"><?= labels('remarks', 'Remarks') ?></th>
                                                <th data-field="operations" class="text-center" data-events="orders_events"><?= labels('operations', 'Operations') ?></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>

<script>
    $(document).ready(function() {
        // var ctx = $('#income').getContext('2d');
        var ctx = document.getElementById('myChart').getContext('2d');

        // var ltx = document.getElementById('orders').getContext('2d');

        var my_chart = new Chart(ctx, {
            type: 'doughnut',

            data: {
                labels: ['Awaiting', 'Confirmed', 'Completed', 'Rescheduled', 'Cancelled'],
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'Chart.js Doughnut Chart'
                        }
                    }
                },
                datasets: [{
                    data: [<?= $total_awaiting ?>, <?= $total_confirmed ?>, <?= $total_completed ?>, <?= $total_rescheduled ?>, <?= $total_cancelled ?>],
                    backgroundColor: [
                        '#00aa9f', '#fcd100', '#006800', '#081269', '#FF3333'
                    ],

                }],

            },
        });
        var ctx = document.getElementById('myChart11').getContext('2d');
        var my_chart = new Chart(ctx, {
            type: 'bar',

            data: {
                labels: ["Total Earning", "Admin Earning", "Provider Earnings"],
                datasets: [{
                    label: "Earnings",
                    data: [<?= $total_earning ?>, <?= $admin_earning ?>, <?= $partner_earnings ?>],
                    backgroundColor: [
                        '#00aa9f', '#fcd100', '#006800'
                    ],

                }, ],


            },

            options: {
                responsive: true,
                beginAtZero: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    // title: {
                    //     display: true,
                    //     text: 'Bar Chart Of earning'
                    // }
                }
            },
        });
    });
</script>