<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('featured_section', "Featured Section") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Featured Sections</a></div>
            </div>
        </div>

        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="card-body">
                <div class="row">
                    <div class="col-md">
                        <h2 class='section-title'><?= labels('manage_featured_section', "Create Featured Section") ?></h2>
                        <?= form_open('/admin/featured_sections/add_featured_section', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_featured_section', 'enctype' => "multipart/form-data"]); ?>
                        <div class="form-group">
                            <label for="name">Title</label>
                            <input id="title" class="form-control" type="text" name="title" placeholder="Enter the name of the title here">
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="service">Section Types</label>
                            <select id="section_type" class="form-control" name="section_type">
                                <option value=" ">Select Types</option>
                                <option value="categories">Categories</option>
                                <option value="partners">Custom Provider</option>
                                <option value="top_rated_partner">Top Rated Provider</option>
                                <option value="top_rated_service">Top Rated Service</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group Category_item d-none">
                            <label for="feature_category_item">Categories</label> <br>
                            <select id="feature_category_item" class="" name="category_item[]" multiple>
                                <?php foreach ($categories_name as $Category) : ?>
                                    <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group partners_ids d-none">
                            <label for="partners_ids">Custom Provider</label> <br>
                            <select id="partners_ids" class="form-control" name="partners_ids[]" multiple>
                                <?php foreach ($partners as $partner) : ?>
                                    <option value="<?= $partner['partner_id'] ?>"><?= $partner['partner_name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <button type="submit" class="btn btn-success">Add Section</button>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('featured_section', "Featured Section") ?></h2>
            <div class="row">
                <div class="col-lg">
                    <div class="card-body">
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="col-md">
                                    <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/featured_sections/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                        <thead>
                                            <tr>
                                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                                <th data-field="title" class="text-center" data-sortable="true"><?= labels('title', 'Title') ?></th>
                                                <th data-field="category_ids" class="text-center" data-visible="false" data-sortable="true"><?= labels('category_id', 'Category id') ?></th>
                                                <th data-field="section_type" class="text-center" data-sortable="true"><?= labels('section', 'Section Type') ?></th>
                                                <th data-field="partners_ids" class="text-center" data-visible="false" data-sortable="true"><?= labels('provider_id', 'Provider Id') ?></th>
                                                <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                                <th data-field="operations" class="text-center" data-events="featured_section_events"><?= labels('operations', 'Operations') ?></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Featured Section</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- <form action="" method="post"> -->
                    <?= form_open('admin/featured_sections/update_featured_section', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'edit_feature', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="form-group">
                        <label for="title">Title</label>
                        <input id="edit_title" class="form-control" type="text" name="title" placeholder="Enter the title here">
                    </div>

                    <div class="form-group">
                        <label for="service">Section Types</label>
                        <select id="edit_section_type" class="form-control" name="section_type">
                            <option value=" ">Select Types</option>
                            <option value="categories">Categories</option>
                            <option value="partners">Provider</option>
                            <option value="top_rated_partner">Top Rated Provider</option>
                            <option value="top_rated_service">Top Rated Service</option>
                        </select>
                    </div>
                    <div class="form-group edit_category_item d-none">
                        <label for="name">Categories</label> <br>
                        <select id="edit_Category_item" class="form-control" name="edit_Category_item[]" multiple>
                            <?php foreach ($categories_name as $Category) : ?>
                                <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group edit_partners_ids d-none">
                        <label for="name">Provider</label>
                        <select id="edit_partners_ids" class="form-control" name="edit_partners_ids[]" multiple>
                            <?php foreach ($partners as $partner) : ?>
                                <option value="<?= $partner['partner_id'] ?>"><?= $partner['partner_name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" name="submit">Update Section</button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>