<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('invoice', 'Invoice') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('admin/orders') ?>">Orders</a></div>
                <div class="breadcrumb-item">Invoice</div>
            </div>
        </div>

        <div class="section-body">
            <div class="container-fluid card" id="print_invoice">
                <div class="card-body p-5">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md partner_details">
                                    <h4 class="h4 font-weight-bolder text-body">
                                        <?= $partner_details['company_name'] ?>
                                    </h4>
                                    <p class="mb-0 h6"> <?= $partner_details['address'] ?> </p>
                                    <p class="mb-0 h6"> <?= $partner_details['email'] ?> </p>
                                    <p class="mb-0 h6"><?= $partner_details['phone'] ?> </p>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-md partner_details">
                                    <span class="font-weight-bold text-dark"> BILL TO: </span>
                                    <hr class="w-100 border-secondary">
                                    <p class="mb-0 h6"><?= $user_details['username'] ?></p>
                                    <p class="mb-0 h6"> <?= $order['address'] ?> </p>
                                    <p class="mb-0 h6"> <?= ($user_details['email'] != '') ? $user_details['email'] : '' ?> </p>
                                    <p class="mb-0 h6"> <?= ($user_details['phone'] != '') ? $user_details['phone'] : '' ?> </p>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-1"></div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md text-sm-right left-row">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h4 class="h4 font-weight-bolder text-sm-right text-dark invoice-text">INVOICE</h4>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="col-md ">
                                                <?php $partner_details['image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $partner_details['image'])) ? base_url('public/backend/assets/profiles/' . $partner_details['image']) : ((file_exists(FCPATH . $partner_details['image'])) ? base_url($partner_details['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $partner_details['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $partner_details['image'])));
                                                ?>
                                                <img src="<?= $partner_details['image'] ?>" alt="Partner LOGO" class="mt-4 media-80">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row text-sm-right mt-4">
                                        <div class="col-md-9">
                                            <h6 class="h6 text-sm-right font-weight-bold invoice-text">
                                                Invoice no:
                                            </h6>
                                        </div>
                                        <div class="col-md">
                                            <h6 class="h6 text-sm-right invoice-text">
                                                #INVO-<?= $order['id'] ?>
                                            </h6>
                                        </div>
                                    </div>
                                    <div class="row text-sm-right mt-4">
                                        <div class="col-md-9">
                                            <p class="h6 text-sm-right font-weight-bold invoice-text">
                                                Invoice Date:
                                            </p>
                                        </div>
                                        <?php
                                        $date1 =  $order['created_at'];
                                        $dt = new DateTime($date1);
                                        $date = $dt->format('d-m-Y');
                                        ?>
                                        <div class="col-md">
                                            <h6 class="h6 text-sm-right invoice-text">
                                                <?= $date ?>
                                            </h6>
                                        </div>
                                    </div>
                                    <div class="row text-sm-right mt-4 invoice-text">
                                        <div class="col-md-9">
                                            <h6 class="h6 text-sm-right font-weight-bold">
                                                Order status:
                                            </h6>
                                        </div>
                                        <div class="col-md">
                                            <h6 class="h6 text-sm-right font-weight-bold invoice-text">
                                                <?= $order['status'] ?>
                                            </h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="w-100 border-secondary">
                    <div class="row">
                        <div class="col-md-12 mt-3">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered table-sm" id="invoice_table" data-show-export="true" data-export-types="['txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-toggle="table" data-search-highlight="true" data-url="<?= base_url('admin/orders/invoice_table/' . $order['id']); ?>" data-side-pagination="server">
                                    <thead>
                                        <tr>
                                            <th data-field="service_title" data-visible="true">Service</th>
                                            <th data-field="price" data-visible="true">Price</th>
                                            <th data-field="quantity" data-visible="true">Quantity</th>
                                            
                                            <th data-field="subtotal" data-visible="true">Subtotal</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <div class="col-md"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md">
                            <p class="h5 mt-5 text-center text-danger">
                                Thank you for your Business
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div id="section-not-to-print float-right">
                            <button type="button" value="Print this page" onclick="printDiv('print_invoice')" class="btn btn-default"><i class="fa fa-print"></i> Print</button>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>