<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('commission_settlement', "Commission Settlement") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/partners') ?>">Provider</a></div>
                <div class="breadcrumb-item">Commission Settlement</div>
            </div>
        </div>

        <div class="section-body">
            <div class="card">
                <div class="card-body">
                    <h2 class='section-title mt-2'><?= labels('commission_list', "Commission List") ?></h2>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-borderd" id="commission_list" data-show-export="true" data-export-types="['txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-show-columns="true" data-search="true" data-show-refresh="true" data-toggle="table" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url('admin/partners/commission_list'); ?>" data-sort-name="id" data-sort-order="desc">
                                    <thead>
                                        <tr>
                                            <th data-field="partner_id" data-visible="true" data-sortable="true">
                                                <?= labels('provider_id', 'Provider ID')  ?>
                                            </th>
                                            <th data-field="company_name" data-visible="true">
                                                <?= labels('company_name', 'Company Name')  ?>
                                            </th>
                                            <th data-field="partner_name" data-visible="true">
                                                <?= labels('provider_name', 'Provider Name')  ?>
                                            </th>
                                            <th data-field="balance" data-visible="true" data-sortable="true"><?= labels('balance', 'Balance') ?></th>
                                            <th data-field="operations" data-visible="true" data-events="commission_events"><?= labels('operations', 'Operations') ?></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- model for commission settlement -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Settle Commission</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?= base_url('admin/partners/commission_pay_out') ?>" method="post" class="form-submit-event" id="pay-out-form">
                        <input type="hidden" name="partner_id" id="partner_id">
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <label for="amount">Amount</label>
                                    <input id="amount" class="form-control" type="text" name="amount" min="0">
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            Update Balance
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>