<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('services', "Services") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Services</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <h5 class="section-title">Add Service</h5>
            <?= form_open('/admin/services/add_service', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_service', 'enctype' => "multipart/form-data"]); ?>
            <div class="card-body">
                <div class="row">
                    <div class="col-md">
                        <div class="jquery-script-clear"></div>
                        
                        <div class="categories" id="categories">
                            <label for="partner">Select Provider</label> <br>
                            <select id="partner" class="form-control w-100" name="partner">
                                <option value="">Select Provider</option>
                                <?php foreach ($partner_name as $pn) : ?>
                                    <option value="<?= $pn['id'] ?>"><?= $pn['company_name'] .' - '.$pn['username'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="title">Title of the service</label>
                            <input class="form-control" type="text" name="title">
                        </div>
                    </div>
                    <div class="col-md">
                        <!-- <div class="jquery-script-clear"></div> -->
                        <div class="categories" id="categories">
                            <label for="category_item">Choose a Category for your service</label>
                            <select id="category_item" class="form-control" name="categories">
                                <option value=""> Select Category</option>
                                <?php foreach ($categories_name as $category) : ?>
                                    <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="tags">Tags</label><br>
                            <input id="tags" class="w-100" type="text" name="tags[]">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-file">
                            <div class="form-group">
                                <?= labels('service_image', "Service Image") ?>
                                <input type="file" class="custom-file-input" id="service_image_selector" name="service_image_selector" accept='image/*' onchange="readURL(this)">
                                <input type="hidden" class="form-control" name="old_icon" id="old_icon">
                                <label class="custom-file-label mt-4" for="service_image_selector">Choose file</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6" id="service_image_section">
                        <div class="form-group image">
                            <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" alt="Service Image" width="30%" id="service_image">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="tax_type">Price Type</label>
                            <select name="tax_type" id="tax_type" class="form-control">
                                <option value="excluded">Tax Excluded In Price</option>
                                <option value="included">Tax Included In Price</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group mb-1">
                            <label for="tax">Tax <small>in percentage(%)</small></label>
                            <input id="tax" class="form-control" type="text" name="tax" value="<?= $tax['tax'] ?>" data-value="1"  readonly>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input id="price" class="form-control" type="text" name="price" placeholder="price">
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="discounted_price">Discounted Price</label>
                            <input id="discounted_price" class="form-control" type="text" name="discounted_price" placeholder="Discounted Price" >
                        </div>
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="on_site" name="on_site">
                            <label class="custom-control-label" for="on_site">On Site Allowed</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="pay_later" name="pay_later">
                            <label class="custom-control-label" for="pay_later">Pay Later Allowed</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="is_cancelable" name="is_cancelable">
                            <label class="custom-control-label" for="is_cancelable">Is Cancelable ?</label>
                        </div>
                    </div>
                </div>
                <div class="row" id="cancel_order">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="cancelable_till">Cancelable before</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span>Minutes</span>
                                    </div>
                                </div>
                                <input type="number" class="form-control" name="cancelable_till" id="cancelable_till" placeholder="Ex. 30" min="0" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="members">Members Required to Perform Task</label>
                            <input id="members" class="form-control" type="text" name="members" placeholder="Members Required" min="0">
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="duration"><?= labels('duration_to_perform_task', 'Duration to Perform Task') ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span>Minutes</span>
                                    </div>
                                </div>
                                <input type="text" class="form-control" name="duration" id="duration" placeholder="Duration of the Service" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="max_qty">Max Quantity allowed for services</label>
                            <input id="max_qty" class="form-control" type="text" name="max_qty" placeholder="Max Quantity allowed for services">
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="Description">Description</label>
                            <textarea rows=10 class='form-control' name="description"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="submit" value="Add Service" id="service_submit" class="btn btn-success btn-block">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="reset" value="Reset" class="btn btn-danger btn-block">
                        </div>
                    </div>
                </div>
            </div>
            <?= form_close() ?>
        </div>

        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('all_services', "All Services") ?></h2>
            <div class="row ">
                <div class="col-md-12">
                    <table class="table table-striped" id="service_list" data-detail-view="true" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/services/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <!-- EVRY VISIBLE DATA HERE -->
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="title" class="text-center" data-sortable="true"><?= labels('title', 'Title') ?></th>
                                <th data-field="tags" class="text-center" data-sortable="true" data-visible="false"><?= labels('tags ', 'Tags') ?></th>
                                <th data-field="image_of_the_service" class="text-center"><?= labels('image ', 'Image') ?></th>
                                <th data-field="price" class="text-center" data-sortable="true"><?= labels('price ', 'Price') ?></th>
                                <th data-field="discounted_price" class="text-center" data-sortable="true"><?= labels('discounted_price ', 'Discounted price') ?></th>
                                <th data-field="rating" class="text-center" data-sortable="true"><?= labels('rating ', 'Rating') ?></th>
                                <th data-field="status" class="text-center" data-sortable="true" data-visible="false"><?= labels('status ', 'Status') ?></th>
                                <th data-field="category_id" class="text-center" data-sortable="true" data-visible="false"><?= labels('category_id', 'Category ID') ?></th>

                                <!-- EVERY NONVISIBLE DATA HERE -->
                                <!-- <th data-field="tax_id" class="text-center" data-sortable="true" data-visible="false"><?= labels('tax_id ', 'Tax ID') ?></th> -->
                                <th data-field="tax" class="text-center" data-sortable="true" data-visible="false"><?= labels('tax', 'Tax(%)') ?></th>
                                <th data-field="number_of_members_required" class="text-center" data-sortable="true" data-visible="false"><?= labels('number_of_members_required ', 'Members required') ?></th>
                                <th data-field="duration " class="text-center" data-sortable="true" data-visible="false"><?= labels('duration ', 'Duration') ?></th>
                                <th data-field="number_of_ratings" class="text-center" data-sortable="true" data-visible="false"><?= labels('number_of_ratings ', 'Numbers of Rating') ?></th>

                                <th data-field="on_site_allowed" class="text-center" data-sortable="true" data-visible="false"><?= labels('on_site_allowed ', 'On Site Allowed') ?></th>

                                <th data-field="max_quantity_allowed" class="text-center" data-sortable="true" data-visible="false"><?= labels('max_quantity_allowed ', 'Max Quantity Allowed') ?></th>

                                <th data-field="is_pay_later_allowed" class="text-center" data-sortable="true" data-visible="false"><?= labels('is_pay_later_allowed ', 'Pay Later Allowed') ?></th>



                                <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                <th data-field="operations" class="text-center" data-events="services_events_admin"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>

                </div>
            </div>
        </div>
    </section>
</div>

<!-- update Service -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Service</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= form_open(
                    '/admin/services/update_service',
                    ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_service', 'enctype' => "multipart/form-data"]
                ); ?>
                <input type="hidden" name="service_id" id="service_id">
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="edit_partner">Select Partner</label> <br>
                        <select id="edit_partner" class="form-control w-100" name="partner">
                          
                            <?php foreach ($partner_name as $pn) : ?>
                                <option value="<?= $pn['id'] ?>"><?= $pn['username'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_title">Title of the service</label>
                            <input class="form-control" type="text" name="title" id="edit_title">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="jquery-script-clear"></div>
                        <div class="categories" id="categories">
                            <label for="edit_category_item">Choose a Category for your service</label>
                            <select id="edit_category_item" class="form-control" name="categories">
                               
                                <?php foreach ($categories_name as $category) : ?>
                                    <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group mt-4">
                            <label for="edit_tags">Tags</label>
                            <input id="edit_service_tags" class="w-100" type="text" name="tags[]">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-file">
                            <div class="form-group">
                                <?= labels('service_image', "Service Image") ?>
                                <input type="file" class="custom-file-input" id="edit_service_image_selector" name="service_image_selector" accept='image/*' onchange="loadFile(event)">
                                <input type="hidden" class="form-control" name="old_icon" id="old_icon">
                                <label class="custom-file-label mt-4" for="edit_service_image_selector">Choose file</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mt-3" id="service_image_section">
                        <div class="form-group image">
                            <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" alt="Service Image" width="30%" id="edit_service_image">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_tax_type">Tax Type</label>
                            <select name="tax_type" id="edit_tax_type" class="form-control">
                                <option value="excluded">Excluded</option>
                                <option value="included">Included</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group mb-1">
                            <label for="tax">Tax</label>
                            <input id="edit_tax" class="form-control" type="text" name="tax" readonly>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_price">Price</label>
                            <input id="edit_price" class="form-control" type="text" name="price" placeholder="price" >
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_discounted_price">Discounted Price</label>
                            <input id="edit_discounted_price" class="form-control" type="text" name="discounted_price" placeholder="Discounted Price">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-3">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="edit_on_site" name="on_site">
                            <label class="custom-control-label" for="edit_on_site">On Site Allowed</label>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="edit_pay_later" name="pay_later">
                            <label class="custom-control-label" for="edit_pay_later">Pay Later Allowed</label>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="edit_is_cancelable" name="edit_is_cancelable">
                            <label class="custom-control-label" for="edit_is_cancelable">Is Cancelable ?</label>
                        </div>
                    </div>
                    <div class="col-lg-3 edit_cancelable-till">
                        <div class="form-group">
                            <label for="edit_cancelable_till">Cancelable before</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span>Minutes</span>
                                    </div>
                                </div>
                                <input type="number" class="form-control" name="cancelable_till" id="edit_cancelable_till" placeholder="Ex. 30" min="0" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_members">Number of Members Required to Perform Task</label>
                            <input id="edit_members" class="form-control" type="text" name="members" placeholder="Members Required">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="edit_duration"><?= labels('duration_to_perform_task', 'Duration to Perform Task') ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span>Minutes</span>
                                    </div>
                                </div>
                                <input type="number" class="form-control" name="duration" id="edit_duration" placeholder="Duration of the Service" min="0" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg">
                        <div class="form-group">
                            <label for="edit_max_qty">Max Quantity allowed for services</label>
                            <input id="edit_max_qty" class="form-control" type="text" name="max_qty" placeholder="Max Quantity allowed for services">
                        </div>
                    </div>
                    <div class="col-lg">
                        <div class="form-group">
                            <label for="edit_description">Description</label>
                            <textarea rows='10' cols='30' class='form-control h-50' name="description" id="edit_description"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="submit" value="Update Service" id="service_submit" class="btn btn-success btn-block">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="reset" value="Reset" class="btn btn-danger btn-block">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <button type="button" class="btn btn-secondary btn-block" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
                <?= form_close() ?>

            </div>
        </div>
    </div>
</div>