<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('Tax Settings', "System Tax settings") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Tax settings</div>
            </div>
        </div>

        <div class="section-body">
            <div class="container-fluid card">
                <h2 class='section-title'><?= labels('system_taxes', "System Taxes settings") ?></h2>
                <form action="<?= base_url('admin/settings/system_tax_settings') ?>" method="post">
                    <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
                    <div class="container-fluid card p-3">
                        <div class="col-md">
                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input id="status" class="custom-control-input" type="checkbox" name="tax_status" checked>
                                    <label for="status" class="custom-control-label">
                                        <span id="tax_status">
                                            Enable
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg">
                                <div class="form-group">
                                    <label for="system_tax_settings"> Enter Tax Name</label>
                                    <input type="text" name="tax_name" id="system_tax_settings" value="<?= isset($tax_name) ? $tax_name : '' ?>" placeholder="Enter Tax name." class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg">
                                <div class="form-group">
                                    <label for="system_tax_settings"> Enter Taxable Amount <small>In Percentage</small> </label>
                                    <input type="text" name="tax" id="system_tax_settings" value="<?= isset($tax) ? $tax : '' ?>" placeholder="Enter Taxable amount." class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-md">
                                <div class="form-group">
                                    <input type='submit' name='update' id='update' value='<?= labels('save', "Update") ?>' class='btn btn-success' />
                                    <input type='reset' name='clear' id='clear' value='<?= labels('reset', "clear") ?>' class='btn btn-danger' />
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
</div>