<?php

namespace App\Controllers\admin;

use App\Models\Service_model;

class Services extends Admin
{
    public $validation, $db, $ionAuth, $creator_id, $service;
    public function __construct()
    {
        parent::__construct();
        $this->service = new Service_model();
        $this->validation = \Config\Services::validation();
        $this->db = \Config\Database::connect();
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
        $this->creator_id = $this->userId;
    }
    public function index()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Services | Admin Panel';
            $this->data['main_page'] = 'services';
            $this->data['categories_name'] = fetch_details('categories', [], ['id', 'name']);

            $partner_data = $this->db->table('users u')
                ->select('u.id,u.username,pd.company_name')
                ->join('partner_details pd', 'pd.partner_id = u.id')
                ->where('is_approved', '1')
                ->get()->getResultArray();

            $this->data['partner_name'] = $partner_data;
            // $this->data['tax'] = fetch_details('taxes', [], ['id', 'title', 'percentage']);
            // $this->data['tax'] = get_settings('system_tax_settings', true);
                $tax=get_settings('system_tax_settings', true);
            if($tax['tax_status']==0){
                $this->data['tax'] = 0;
            }else{
                  $this->data['tax']= $tax['tax'];
            }
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $additional_data = [], $column_name = '', $whereIn = [])
    {
        $Service_model = new Service_model();
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
        $data = $Service_model->list(false, $search, $limit, $offset, $sort, $order);
        return $data;
    }

    public function add_service()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            if (isset($_POST) && !empty($_POST)) {
                $price = $this->request->getPost('price');
                $this->validation->setRules(
                    [
                        'partner' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please select provider"
                            ]
                        ],
                        'title' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter service title"
                            ]
                        ],
                        'categories' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please select category"
                            ]
                        ],
                        'tags' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter service tag"
                            ]
                        ],
                        'description' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter description"
                            ]
                        ],
                        'price' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter price",
                                "numeric" => "Please enter numeric value for price"
                            ]
                        ],
                        'discounted_price' => [
                            "rules" => 'required|numeric|less_than['.$price.']',
                            "errors" => [
                                "required" => "Please enter discounted price",
                                "numeric" => "Please enter numeric value for discounted price",
                                "less_than" => "Discounted price should be less than price"
                            ]
                        ],
                        'members' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter required member for service",
                                "numeric" => "Please enter numeric value for required member"
                            ]
                        ],
                        'duration' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter duration to perform task",
                                "numeric" => "Please enter numeric value for duration of task"
                            ]
                        ],
                        'max_qty' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter max quantity allowed for services",
                                "numeric" => "Please enter numeric value for max quantity allowed for services"
                            ]
                        ],
                        'service_image_selector' => [
                            "rules" => 'uploaded[service_image_selector]|ext_in[service_image_selector,png,jpg,gif,jpeg,webp]|max_size[service_image_selector,8496]|is_image[service_image_selector]'
                        ],
                    ],
                );
                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;

                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                }

                if (isset($_POST['tags'][0]) && !empty($_POST['tags'][0])) {
                    $base_tags = $this->request->getPost('tags');
                    $s_t = $base_tags;
                    $val = explode(',', str_replace(']', '', str_replace('[', '', $s_t[0])));
                    $tags = [];
                    foreach ($val as $s) {
                        $tags[] = json_decode($s, true)['value'];
                    }
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Tags required!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
                $title = $this->removeScript($this->request->getPost('title'));
                $description = $this->removeScript($this->request->getPost('description'));
                $path = "public/uploads/services/";

                $image_name = "";

                if (!empty($_FILES['service_image_selector']) && isset($_FILES['service_image_selector'])) {
                    $file =  $this->request->getFile('service_image_selector');

                    if ($file->isValid()) {
                        $name = $file->getRandomName();
                        if ($file->move($path, $name)) {
                            $image_name = 'public/uploads/services/' . $name;
                        }
                    }
                }

                $category_id = $this->request->getPost('categories');
                $discounted_price = $this->request->getPost('discounted_price');
                if ($discounted_price >= $price && $discounted_price == $price) {
                    $response = [
                        'error' => true,
                        'message' => "discounted price can not be higher than or equal to the price",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
                $user_id = $this->request->getPost('partner');
                $is_cancelable = (isset($_POST['is_cancelable'])) ? 1 : 0;

                $service = [
                    'user_id' => $user_id,
                    'category_id' => $category_id,
                    'tax_type' => $this->request->getVar('tax_type'),
                    // 'tax_id' => 0,
                    'tax' => $this->request->getPost('tax'),
                    'title' => $title,
                    'description' => $description,
                    'slug' => '',
                    'tags' =>  implode(',', $tags),
                    'price' => $price,
                    'discounted_price' => $discounted_price,
                    'image' => $image_name,
                    'number_of_members_required' => $this->request->getVar('members'),
                    'duration' => $this->request->getVar('duration'),
                    'rating' => 0,
                    'number_of_ratings' => 0,
                    'on_site_allowed' => ($this->request->getPost('on_site') == "on") ? 1 : 0,
                    'is_pay_later_allowed' => ($this->request->getPost('pay_later') == "on") ? 1 : 0,
                    'is_cancelable' => $is_cancelable,
                    'cancelable_till' => $this->request->getVar('cancelable_till'),
                    'max_quantity_allowed' => $this->request->getPost('max_qty')
                ];
                if ($this->service->save($service)) {
                    $response = [
                        'error' => false,
                        'message' => "Service saved successfully!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Service can not be saved!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect()->to('partner/services');
            }
        } else {
            return redirect('partner/login');
        }
    }

    public function delete_service()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            $id = $this->request->getPost('id');
            $old_data = fetch_details('services', ['id' => $id], ['image']);

            if ($old_data[0]['image'] != NULL &&  file_exists($old_data[0]['image'])) {
                unlink($old_data[0]['image']);
            }
            $builder = $this->db->table('services')->delete(['id' => $id]);
            if ($builder) {
                $response = [
                    'error' => false,
                    'message' => "success in deleting the service",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "Unsuccessful in deleting services",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('partner/login');
        }
    }

    public function update_service()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if (isset($_POST) && !empty($_POST)) {

                $price = $this->request->getPost('price');
                $rules = [
                    'partner' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please select provider"
                        ]
                    ],
                    'title' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please enter service title"
                        ]
                    ],
                    'categories' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please select category"
                        ]
                    ],
                    'tags' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please enter service tag"
                        ]
                    ],
                    'description' => [
                        "rules" => 'required',
                        "errors" => [
                            "required" => "Please enter description"
                        ]
                    ],
                    'price' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter price",
                            "numeric" => "Please enter numeric value for price"
                        ]
                    ],
                    'discounted_price' => [
                        "rules" => 'required|numeric|less_than['.$price.']',
                        "errors" => [
                            "required" => "Please enter discounted price",
                            "numeric" => "Please enter numeric value for discounted price",
                            "less_than" => "Discounted price should be less than price"
                        ]
                    ],
                    'members' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter required member for service",
                            "numeric" => "Please enter numeric value for required member"
                        ]
                    ],
                    'duration' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter duration to perform task",
                            "numeric" => "Please enter numeric value for duration of task"
                        ]
                    ],
                    'max_qty' => [
                        "rules" => 'required|numeric',
                        "errors" => [
                            "required" => "Please enter max quantity allowed for services",
                            "numeric" => "Please enter numeric value for max quantity allowed for services"
                        ]
                    ],
                ];
                if (isset($_FILES['service_image_selector']) && $_FILES['service_image_selector']['size'] > 0) {
                    $rules['service_image_selector'] =[
                        "rules" => 'uploaded[service_image_selector]|ext_in[service_image_selector,png,jpg,gif,jpeg,webp]|max_size[service_image_selector,8496]|is_image[service_image_selector]'
                    ];
                }

                $this->validation->setRules($rules);
                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;

                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                }

                $Service_id = $this->request->getPost('service_id');

                if (isset($_POST['tags'][0]) && !empty($_POST['tags'][0])) {
                    $base_tags = $this->request->getPost('tags');
                    $s_t = $base_tags;
                    $val = explode(',', str_replace(']', '', str_replace('[', '', $s_t[0])));
                    $tags = [];
                    foreach ($val as $s) {
                        $tags[] = json_decode($s, true)['value'];
                    }
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Tags required!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
                $title = $this->removeScript($this->request->getPost('title'));
                $description = $this->removeScript($this->request->getPost('description'));
                $path = "public/uploads/services/";

                $image_name = "";

                $file =  $this->request->getFile('service_image_selector');
                if (!empty($file) && $file->getName() != "") {
                    // print_r($file);

                    if ($file->isValid()) {
                        $name = $file->getRandomName();
                        if ($file->move($path, $name)) {
                            $image_name = 'public/uploads/services/' . $name;
                        }
                    }
                } else {
                    $og_image = fetch_details('services', ['id' => $Service_id], ['image']);
                    if (isset($og_image) && !empty($og_image)) {
                        $image_name = $og_image['0']['image'];
                    } else {
                        $image_name = NULL;
                    }
                }


                $category_id = $_POST['categories'];
                $discounted_price = $this->request->getPost('discounted_price');
                $price = $this->request->getPost('price');
                if ($discounted_price >= $price && $discounted_price == $price) {
                    $response = [
                        'error' => true,
                        'message' => "discounted price can not be higher than or equal to the price",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
                $user_id = $this->request->getPost('partner');

                if (isset($_POST['is_cancelable'])) {
                    $is_cancelable = "1";
                } else {
                    $is_cancelable = "0";
                }
                $service = [
                    'user_id' => $user_id,
                    'category_id' => $category_id,
                    'tax_type' => $this->request->getVar('tax_type'),
                    // 'tax_id' => $this->request->getVar('tax_id'),
                    'tax' => $this->request->getPost('tax'),
                    'title' => $title,
                    'description' => $description,
                    'slug' => '',
                    'tags' =>  implode(',', $tags),
                    'price' => $price,
                    'discounted_price' => $discounted_price,
                    'image' => $image_name,
                    'number_of_members_required' => $this->request->getVar('members'),
                    'duration' => $this->request->getVar('duration'),
                    'rating' => 1,
                    'number_of_ratings' => 10,
                    'number_of_ratings' => 10,
                    'on_site_allowed' => ($this->request->getPost('on_site') == "on") ? 1 : 0,
                    'is_pay_later_allowed' => ($this->request->getPost('pay_later') == "on") ? 1 : 0,
                    'is_cancelable' => $is_cancelable,
                    'cancelable_till' => $this->request->getVar('cancelable_till'),
                    'max_quantity_allowed' => $this->request->getPost('max_qty')
                ];
                if ($this->service->update($Service_id, $service)) {
                    $response = [
                        'error' => false,
                        'message' => "Service saved successfully!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Service can not be Save!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect()->to('partner/services');
            }
        } else {
            return redirect('partner/login');
        }
    }
}
