<?php

namespace App\Controllers\api;

use App\Controllers\BaseController;
use App\Libraries\Flutterwave;
use App\Libraries\Paystack;
use App\Libraries\Razorpay;
use App\Libraries\Stripe;


class Webhooks extends BaseController
{
    private $stripe;
    public function __construct()
    {
        $this->stripe = new Stripe;
    }

    public function stripe()
    {
        $credentials = $this->stripe->get_credentials();
        $request_body = file_get_contents('php://input');
        $event = json_decode($request_body, FALSE);

        log_message('error', 'Stripe Webhook --> ' . var_export($event, true));

        if (!empty($event->data->object->payment_intent)) {
            $txn_id = (isset($event->data->object->payment_intent)) ? $event->data->object->payment_intent : "";
            if (!empty($txn_id)) {
                $amount = ($event->data->object->amount / 100);
                $currency = $event->data->object->currency;
                $order_id = $event->data->object->metadata->order_id;
                $order_data = fetch_details('orders', ["id" => $order_id]);
                $user_id = $order_data[0]['user_id'];
                $partner_id = $order_data[0]['partner_id'];
            }
        } else {
            $order_id = 0;
            $amount = 0;
            $currency = (isset($event->data->object->currency)) ? $event->data->object->currency : "";
        }

        $http_stripe_signature = isset($_SERVER['HTTP_STRIPE_SIGNATURE']) ? $_SERVER['HTTP_STRIPE_SIGNATURE'] : "";
        $result = $this->stripe->construct_event($request_body, $http_stripe_signature, $credentials['webhook_key']);
        if ($result == "Matched") {
            if ($event->type == 'charge.succeeded') {
                $data = [
                    'transaction_type' => 'transaction',
                    'user_id' => $user_id,
                    'partner_id' => $partner_id,
                    'order_id' => $order_id,
                    'type' => 'stripe',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'status' => 'success',
                    'currency_code' => $currency,
                    'message' => 'order placed successfully',
                ];
                $insert_id = add_transaction($data);
                if ($insert_id) {
                    $response['error'] = false;
                    $response['transaction_status'] = $event->type;
                    $response['message'] = "Transaction successfully done";
                    return $this->response->setJSON($response);
                } else {
                    $response['error'] = true;
                    $response['message'] = "something went wrong";
                    return $this->response->setJSON($response);
                }
            } elseif ($event->type == 'charge.failed') {
                $data = [
                    'transaction_type' => 'transaction',
                    'user_id' => $user_id,
                    'partner_id' => $partner_id,
                    'order_id' => $order_id,
                    'type' => 'stripe',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'status' => 'failed',
                    'currency_code' => $currency,
                    'message' => 'order placed successfully',
                ];
                $insert_id = add_transaction($data);
            } elseif ($event->type == 'charge.pending') {
                $data = [
                    'transaction_type' => 'transaction',
                    'user_id' => $user_id,
                    'partner_id' => $partner_id,
                    'order_id' => $order_id,
                    'type' => 'stripe',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'status' => 'pending',
                    'currency_code' => $currency,
                    'message' => 'order placed successfully',
                ];
                $insert_id = add_transaction($data);

                return false;
            } elseif ($event->type == 'charge.expired') {
                $data = [
                    'transaction_type' => 'transaction',
                    'user_id' => $user_id,
                    'partner_id' => $partner_id,
                    'order_id' => $order_id,
                    'type' => 'stripe',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'status' => 'failed',
                    'currency_code' => $currency,
                    'message' => 'order placed successfully',
                ];
                $insert_id = add_transaction($data);
                return false;
            } elseif ($event->type == 'charge.refunded') {
                $charge = $event->data->object;
                $data = [
                    'transaction_type' => 'transaction',
                    'user_id' => $user_id,
                    'partner_id' => $partner_id,
                    'order_id' => $order_id,
                    'type' => 'stripe',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'status' => 'refund',
                    'currency_code' => $currency,
                    'message' => 'order placed successfully',
                ];
                $insert_id = add_transaction($data);
                return false;
            } else {
                $response['error'] = true;
                $response['transaction_status'] = $event->type;
                $response['message'] = "Transaction could not be detected.";
                echo json_encode($response);
                return false;
            }
        } else {
            log_message('error', 'Stripe Webhook | Invalid Server Signature  --> ');
            return false;
        }
    }
    public function paystack()
    {
        $system_settings = get_settings('system_settings', true);
        $paystack = new Paystack;
        $credentials = $paystack->get_credentials();

        $secret_key = $credentials['secret'];
        $request_body = file_get_contents('php://input');
        $event = json_decode($request_body, true);
        log_message('error', 'paystack Webhook --> ' . var_export($event, true));;


        if (!empty($event['data'])) {

            $txn_id = (isset($event['data']['reference'])) ? $event['data']['reference'] : "";
            log_message('error', 'paystack Webhook SERVER Variable --> ' . var_export($txn_id, true));


            if (isset($txn_id) && !empty($txn_id)) {
                $transaction = fetch_details('transactions', ['txn_id' => $txn_id]);
                if (!empty($transaction)) {
                    $order_id = $transaction[0]['order_id'];
                    $user_id = $transaction[0]['user_id'];
                } else {
                    $order_id = 0;
                    $order_id = $event['data']['metadata']['order_id'];
                    $order_data = fetch_details('orders', ["id" => $order_id]);
                    $user_id = $order_data[0]['user_id'];
                    $partner_id = $order_data[0]['partner_id'];
                }
            }
            $amount = $event['data']['amount'];
            $currency = $event['data']['currency'];
        } else {
            $order_id = 0;
            $amount = 0;
            $currency = (isset($event['data']['currency'])) ? $event['data']['currency'] : "";
        }

        // validate event do all at once to avoid timing attack
        if ($_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] !== hash_hmac('sha512', $request_body, $secret_key)) {
            log_message('error', 'Paystack Webhook - Invalid Signature - JSON DATA --> ' . var_export($event, true));
            log_message('error', 'Paystack Server Variable invalid --> ' . var_export($_SERVER, true));
            //exit();
        }

        if ($event['event'] == 'charge.success') {
            if (!empty($order_id)) {     /* To do the wallet recharge if the order id is set in the pattern */

                /* process the order and mark it as received */
                $order = fetch_details('orders', ['id' => $order_id]);

                log_message('error', 'Paystack Webhook | order --> ' . var_export($order, true));

                /* No need to add because the transaction is already added just update the transaction status */
                if (!empty($transaction)) {
                    $transaction_id = $transaction[0]['id'];
                    update_details(['status' => 'success'], ['id' => $transaction_id], 'transactions');
                } else {
                    /* add transaction of the payment */
                    $amount = ($event['data']['amount'] / 100);
                    $data = [
                        'transaction_type' => 'transaction',
                        'user_id' => $user_id,
                        'partner_id' => $partner_id,
                        'order_id' => $order_id,
                        'type' => 'paystack',
                        'txn_id' => $txn_id,
                        'amount' => $amount,
                        'status' => 'success',
                        'currency_code' => $currency,
                        'message' => 'order placed successfully',
                    ];
                    $insert_id = add_transaction($data);
                }
                if ($insert_id) {
                    $response['error'] = false;
                    $response['transaction_status'] = $event->type;
                    $response['message'] = "Transaction successfully done";
                    return $this->response->setJSON($response);
                } else {
                    $response['error'] = true;
                    $response['message'] = "something went wrong";
                    return $this->response->setJSON($response);
                }

                log_message('error', 'Paystack Webhook inner Success --> ' . var_export($event, true));

                log_message('error', 'Paystack Webhook order Success --> ' . var_export($event, true));
            } else {
                /* No order ID found / sending 304 error to payment gateway so it retries wenhook after sometime*/
                log_message('error', 'Paystack Webhook | Order id not found --> ' . var_export($event, true));
                return $this->output
                    ->set_content_type('application/json')
                    ->set_status_header(304)
                    ->set_output(json_encode(array(
                        'message' => '304 Not Modified - order/transaction id not found',
                        'error' => true
                    )));
            }
        } else if ($event['event'] == 'charge.dispute.create') {
            if (!empty($order_id) && is_numeric($order_id)) {
                $order = fetch_details('orders', ['id' => $order_id]);

                if ($order['order_data']['0']['active_status'] == 'received' || $order['order_data']['0']['active_status'] == 'processed') {
                    update_details(['status' => 'awaiting'], ['id' => $order_id], 'orders');
                }

                if (!empty($transaction)) {
                    $transaction_id = $transaction[0]['id'];
                    update_details(['status' => 'pending'], ['id' => $transaction_id], 'transactions');
                }

                log_message('error', 'Paystack Transaction is Pending --> ' . var_export($event, true));
            }
        } else {

            if (!empty($order_id) && is_numeric($order_id)) {
                update_details(['status' => 'cancelled'], ['id' => $order_id], 'orders');
            }
            /* No need to add because the transaction is already added just update the transaction status */
            if (!empty($transaction)) {
                $transaction_id = $transaction[0]['id'];
                update_details(['status' => 'failed'], ['id' => $transaction_id], 'transactions');
            }

            $response['error'] = true;
            $response['transaction_status'] = $event['event'];
            $response['message'] = "Transaction could not be detected.";
            log_message('error', 'Paystack Webhook | Transaction could not be detected --> ' . var_export($event, true));
            echo json_encode($response);
            return false;
        }
    }

    public function razorpay()
    {
        //Debug in server first
        if ((strtoupper($_SERVER['REQUEST_METHOD']) != 'POST') || !array_key_exists('HTTP_X_RAZORPAY_SIGNATURE', $_SERVER))
            exit();
        $razorpay = new Razorpay;
        $system_settings = get_settings('system_settings', true);
        $credentials = $razorpay->get_credentials();

        $request = file_get_contents('php://input');

        $request = json_decode($request, true);

        define('RAZORPAY_SECRET_KEY', $credentials['secret']);
        log_message('error', 'Razorpay IPN POST --> ' . var_export($request, true));
        $http_razorpay_signature = isset($_SERVER['HTTP_X_RAZORPAY_SIGNATURE']) ? $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'] : "";
        log_message('error', 'Razorpay IPN SERVER --> ' . var_export($_SERVER, true));


        $txn_id = (isset($request['payload']['payment']['entity']['id'])) ? $request['payload']['payment']['entity']['id'] : "";

        if (!empty($request['payload']['payment']['entity']['id'])) {
            if (!empty($txn_id)) {
                $transaction = fetch_details('transactions', ['txn_id' => $txn_id]);
            }
            $amount = $request['payload']['payment']['entity']['amount'];
            $amount = ($amount / 100);
            $currency = (isset($request['payload']['payment']['entity']['currency'])) ? $request['payload']['payment']['entity']['currency'] : "";
        } else {
            $amount = 0;
            $currency = (isset($request['payload']['payment']['entity']['currency'])) ? $request['payload']['payment']['entity']['currency'] : "";
        }


        if (!empty($transaction)) {
            $order_id = $transaction[0]['order_id'];
            $user_id = $transaction[0]['user_id'];
            $order_data = fetch_details('orders', ["id" => $order_id]);
            $user_id = $order_data[0]['user_id'];
            $partner_id = $order_data[0]['partner_id'];
        } else {
            $order_id = 0;
            $order_id = (isset($request['payload']['order']['entity']['notes']['order_id'])) ? $request['payload']['order']['entity']['notes']['order_id'] : $request['payload']['payment']['entity']['notes']['order_id'];
            $order_data = fetch_details('orders', ["id" => $order_id]);
            $user_id = $order_data[0]['user_id'];
            $partner_id = $order_data[0]['partner_id'];
        }
        if ($http_razorpay_signature) {
            if ($request['event'] == 'payment.authorized') {
                $currency = (isset($request['payload']['payment']['entity']['currency'])) ? $request['payload']['payment']['entity']['currency'] : "INR";
                $response = $razorpay->capture_payment($amount * 100, $txn_id, $currency);
                return;
            }
            if ($request['event'] == 'payment.captured' || $request['event'] == 'order.paid') {
                if ($request['event'] == 'order.paid') {
                    $order_id = $request['payload']['order']['entity']['receipt'];
                    $order_data = fetch_details('orders', ["id" => $order_id]);
                    $user_id = $order_data[0]['user_id'];
                    $partner_id = $order_data[0]['partner_id'];
                }
                if (!empty($order_id)) {


                    /* process the order and mark it as received */

                    /* No need to add because the transaction is already added just update the transaction status */
                    if (!empty($transaction)) {
                        $transaction_id = $transaction[0]['id'];
                        update_details(['status' => 'success'], ['id' => $transaction_id], 'transactions');
                    } else {
                        /* add transaction of the payment */
                        $currency = (isset($request['payload']['payment']['entity']['currency'])) ? $request['payload']['payment']['entity']['currency'] : "";
                        $data = [
                            'transaction_type' => 'transaction',
                            'user_id' => $user_id,
                            'partner_id' => $partner_id,
                            'order_id' => $order_id,
                            'type' => 'razorpay',
                            'txn_id' => $txn_id,
                            'amount' => $amount,
                            'status' => 'success',
                            'currency_code' => $currency,
                            'message' => 'order placed successfully',
                        ];
                        $insert_id = add_transaction($data);
                    }
                    if ($insert_id) {
                        $response['error'] = false;
                        $response['transaction_status'] = $request['event'];
                        $response['message'] = "Transaction successfully done";
                        return $this->response->setJSON($response);
                    } else {
                        $response['error'] = true;
                        $response['message'] = "something went wrong";
                        return $this->response->setJSON($response);
                    }

                    update_details(['active' => 'confirmed'], ['id' => $order_id], 'orders');
                }
            } else {
                log_message('error', 'Razorpay Order id not found --> ' . var_export($request, true));
                /* No order ID found */
            }

            $response['error'] = false;
            $response['transaction_status'] = $request['event'];
            $response['message'] = "Transaction successfully done";
            echo json_encode($response);
            return false;
        } elseif ($request['event'] == 'payment.failed') {
            //$order = fetch_orders($order_id, false, false, false, false, false, false, false);

            if (!empty($order_id)) {
                // update_stock($order['order_data'][0]['product_variant_ids'], $order['order_data'][0]['quantity'], 'plus');
                update_details(['status' => 'cancelled'], ['id' => $order_id], 'orders');
            }
            /* No need to add because the transaction is already added just update the transaction status */
            if (!empty($transaction)) {
                $transaction_id = $transaction[0]['id'];
                update_details(['status' => 'failed'], ['id' => $transaction_id], 'transactions');
            }
            $response['error'] = true;
            $response['transaction_status'] = $request['event'];
            $response['message'] = "Transaction is failed. ";
            log_message('error', 'Razorpay Webhook | Transaction is failed --> ' . var_export($request['event'], true));
            echo json_encode($response);
            return false;
        } elseif ($request['event'] == 'payment.authorized') {
            if (!empty($order_id)) {
                update_details(['active_status' => 'awaiting'], ['id' => $order_id], 'orders');
                update_details(['active_status' => 'awaiting'], ['order_id' => $order_id], 'order_items');
            }
        } elseif ($request['event'] == "refund.processed") {
            //Refund Successfully
            $transaction = fetch_details('transactions', ['txn_id' => $request['payload']['refund']['entity']['payment_id']]);
            if (empty($transaction)) {
                return false;
            }
            process_refund($order_id, 'cancelled', $user_id);
            $response['error'] = false;
            $response['transaction_status'] = $request['event'];
            $response['message'] = "Refund successfully done. ";
            log_message('error', 'Razorpay Webhook | Payment refund done --> ' . var_export($request['event'], true));
            echo json_encode($response);
            return false;
        } elseif ($request['event'] == "refund.failed") {
            $response['error'] = true;
            $response['transaction_status'] = $request['event'];
            $response['message'] = "Refund is failed. ";
            log_message('error', 'Razorpay Webhook | Payment refund failed --> ' . var_export($request['event'], true));
            echo json_encode($response);
            return false;
        } else {
            $response['error'] = true;
            $response['transaction_status'] = $request['event'];
            $response['message'] = "Transaction could not be detected.";
            log_message('error', 'Razorpay Webhook | Transaction could not be detected --> ' . var_export($request['event'], true));
            echo json_encode($response);
            return false;
        }
    }

    public function edie($error_msg)
    {
        global $debug_email;
        $report =  "ERROR : " . $error_msg . "\n\n";
        $report .= "POST DATA\n\n";
        foreach ($_POST as $key => $value) {
            $report .= "|$key| = |$value| \n";
        }
        log_message('error', $report);
        die($error_msg);
    }
}
