<?php

namespace App\Models;

use CodeIgniter\Model;

class Category_model extends Model
{
    public $admin_id;
    public function __construct()
    {
        // $this->base = new BaseController;

        $ionAuth = new \IonAuth\Libraries\IonAuth();
        $this->admin_id = ($ionAuth->isAdmin()) ? $ionAuth->user()->row()->id : 0;
    }
    protected $table = 'categories';
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'image', 'parent_id', 'slug', 'admin_commission', 'status', 'dark_color', 'light_color'];

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [])
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('categories');
        $multipleWhere = [];
        $condition = $bulkData = $rows = $tempRow = [];

        if (isset($_GET['offset']))
            $offset = $_GET['offset'];

        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                '`id`' => $search,
                '`name`' => $search,
                '`admin_commission`' => $search
            ];
        }
        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'id') {
                $sort = "id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }

        if ($from_app) {
            $where['status'] = 1;
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $builder->select('COUNT(id) as `total` ');
        $order_count = $builder->get()->getResultArray();
        $total = $order_count[0]['total'];

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $builder->select('*');
        $category_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($category_record as $row) {
            if ($from_app == false) {
                if (check_exists(base_url('/public/uploads/categories/' . $row['image']))) {
                    $category_image = '<a  href="' . base_url('/public/uploads/categories/' . $row['image'])  . '" data-lightbox="image-1"><img height="80px" width="80px" class="rounded" src="' . base_url("/public/uploads/categories/" . $row['image']) . '" alt=""></a>';
                } else {
                    $category_image = 'nothing found';
                }
                $operations = '';
                if ($this->admin_id != 0) {
                    $operations = '
                        <button class="btn btn-success edite-Category" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal" onclick="category_id(this)"> <i class="fa fa-pen" aria-hidden="true"></i> </button> 
                        <button class="btn btn-danger delete-Category" data-id="' . $row['id'] . '"  onclick="category_id(this)"> <i class="fa fa-trash" aria-hidden="true"></i> </button> 
                    ';
                }
            } else {
                if (check_exists(base_url('/public/uploads/categories/' . $row['image']))) {
                    $category_image = base_url('/public/uploads/categories/' . $row['image']);
                } else {
                    $category_image = '';
                }
            }

            $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';
            $parent_category_name = '';
            if (!empty($row['parent_id'])) {
                $parent_category_name = (!empty(fetch_details('categories', ['id' => $row['parent_id']]))) ? fetch_details('categories', ['id' => $row['parent_id']])[0]['name'] : '';
            }
            $tempRow['id'] = $row['id'];

            $tempRow['name'] = $row['name'];
            $tempRow['slug'] = $row['slug'];
            $tempRow['parent_id'] = $row['parent_id'];
            $tempRow['parent_category_name'] = ($parent_category_name != '') ? $parent_category_name : 'No Parent found';
            $tempRow['category_image'] = $category_image;
            $tempRow['admin_commission'] = $row['admin_commission'];
            $tempRow['status'] = $row['status'];
            $tempRow['dark_color']=$row['dark_color'];
            $tempRow['light_color'] = $row['light_color'];

            if ($from_app == false) {
                $tempRow['admin_commission'] = $row['admin_commission'];
                $tempRow['created_at'] = $row['created_at'];

                $tempRow['dark_color'] = $row['dark_color'];
                $tempRow['light_color'] = $row['light_color'];
                $tempRow['dark_color_format'] = ($row['dark_color']=="") ?  'No color': ' <div style="border-radius: 30px;width: 80px; height: 20px;background-color: '.$row['dark_color'].'"> </div>' ;
                $tempRow['light_color_format'] = ($row['light_color'] == "") ?  'No color' : ' <div style="border-radius: 30px;width: 80px; height: 20px;background-color: ' . $row['light_color'] . '"> </div>';
               
                $tempRow['status'] = ($row['status'] == 1) ? "<label class='badge badge-success'>Active</label>" : "<label class='badge badge-danger'>Deactive</label>";
                $tempRow['og_status'] = $row['status'] == 1;
                $tempRow['operations'] = $operations;
            }


            $rows[] = $tempRow;
        }
        if ($from_app) {
            // if request from app return array 
            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            // else return json
            $bulkData['rows'] = $rows;
            return json_encode($bulkData);
        }
    }
}
