<?php

namespace App\Models;

use CodeIgniter\Model;

class Orders_model extends Model
{

    protected $table = 'orders';
    protected $primaryKey = 'id';
    protected $allowedFields = ['partner_id', 'user_id', 'city_id', 'city', 'total', 'promo_code', 'promo_discount', 'final_total', 'payment_method', 'admin_earnings', 'visiting_charges', 'partner_earnings', 'address_id', 'address', 'date_of_service', 'starting_time', 'ending_time', 'duration', 'status', 'remarks'];

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'o.id', $order = 'DESC', $where = [], $where_in_key = '', $where_in_value = [], $addition_data = '', $download_invoice = false)
    {

        $db      = \Config\Database::connect();
        $builder = $db->table('orders o');


        $multipleWhere = [];
        $bulkData = $rows = $tempRow = [];

        if (isset($_GET['offset']))
            $offset = $_GET['offset'];

        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                '`o.id`' => $search,
                '`o.user_id`' => $search,
                '`o.partner_id`' => $search,
                '`o.total`' => $search,
                '`o.address`' => $search,
                '`o.date_of_service`' => $search,
                '`o.starting_time`' => $search,
                '`o.ending_time`' => $search,
                '`o.duration`' => $search,
                '`o.status`' => $search,
                '`o.remarks`' => $search,
                '`up.username`' => $search,
                '`u.username`' => $search,
                '`os.service_title`' => $search,
                '`os.status`' => $search,
            ];
        }

        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'o.id') {
                $sort = "o.id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }

        $order_count = $builder->select('count(DISTINCT(o.id)) as total')
            ->join('order_services os', 'os.order_id=o.id')
            ->join('users u', 'u.id=o.user_id')
            ->join('users up', 'up.id=o.partner_id')
            ->join('partner_details pd', 'o.partner_id = pd.partner_id');


        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($where_in_key) && !empty($wherwhere_in_key) && isset($where_in_value) && !empty($where_in_value)) {
            $builder->whereIn($where_in_key, $where_in_value);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        $order_count = $builder->get()->getResultArray();
        $total = $order_count[0]['total'];
        //  selecting actual data

        $builder->select('o.*,pd.advance_booking_days,u.id as customer_id,u.username as user_name,u.phone as customer_no,u.latitude as 	latitude,u.longitude as longitude ,up.image as profile_image,u.email as customer_email,up.username as partner_name,up.phone as partner_no,u.balance as user_wallet, pd.company_name,o.visiting_charges')
            ->join('order_services os', 'os.order_id=o.id')
            ->join('users u', 'u.id=o.user_id')
            ->join('users up', 'up.id=o.partner_id')
            ->join('partner_details pd', 'o.partner_id = pd.partner_id');

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($where_in_key) && !empty($wherwhere_in_key) && isset($where_in_value) && !empty($where_in_value)) {
            $builder->whereIn($where_in_key, $where_in_value);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        if (isset($_GET['order_status_filter']) && $_GET['order_status_filter'] != '') {
            // echo '1';
            $builder->where('o.status', $_GET['order_status_filter']);
        }
        if (isset($_POST['status']) && $_POST['status'] != '') {
            $builder->where('o.status', $_POST['status']);
        }
        $order_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->groupBy('o.id')->get()->getResultArray();
        // print_r($order_record);

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();
        if (empty($order_record)) {
            $bulkData = array();
        } else {
            foreach ($order_record as $row) {
                $builder = $db->table('order_services os');
                $services = $builder->select('
                os.id,
                os.order_id,
                os.service_id,
                os.service_title,
                os.tax_percentage,
                os.tax_amount,
                os.price,
                os.quantity,
                os.sub_total,
                os.status,                
                ,s.tags,s.duration,s.category_id,s.is_cancelable,s.cancelable_till,sr.rating,sr.comment,sr.images')
                    ->where('os.order_id', $row['id'])
                    ->join('services as s', 's.id=os.service_id', 'left')
                    ->join('services_ratings as sr', 'sr.service_id=os.service_id AND sr.user_id=' . $row["user_id"] . '', 'left')->get()->getResultArray();

                // print_R($services);
                $order_record['order_services'] = $services;
                if ($from_app == false) {
                    $operations = '<a href="orders/veiw_orders/' . $row['id'] . '" class="btn btn-warning btn-sm"  title = "view the order"> <i class="fa fa-eye" aria-hidden="true"></i> </a> ';
                    if ($row['status'] != 'cancelled') {
                        $operations .= '<a href="orders/invoice/' . $row['id'] . '" class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="bottom" title="Invoice"><i class="fa fa-receipt"></i></a> ';
                    }
                    $operations .= '<button class="btn btn-danger delete_orders btn-sm" data-id="' . $row['id'] . '" onclick="order_id(this)" data-toggle="modal" data-target="#delete_modal" title = "Delete order"> <i class="fa fa-trash" aria-hidden="true"></i> </button> ';

                    if (($row['status'] == 'awaiting')) {
                        $status = "<label class='badge badge-secondary'>Awaiting</label>";
                    } elseif (($row['status'] == 'confirmed')) {
                        $status = "<label class='badge badge-primary'>Confirmed</label>";
                    } elseif (($row['status'] == 'rescheduled')) {
                        $status = "<label class='badge badge-info'>Rescheduled</label>";
                    } elseif (($row['status'] == 'cancelled')) {
                        $status = "<label class='badge badge-danger'>Cancelled </label>";
                    } elseif (($row['status'] == 'completed')) {
                        $status = "<label class='badge badge-success'>Completed</label>";
                    } elseif (($row['status'] == 'pending')) {
                        $status = "<label class='badge badge-secondary'>Pending</label>";
                    } else {
                        $status = "status not defined";
                    }
                } else {
                    $status = $row['status'];
                }
                $tax_amount = 0.00;
                $settings = get_settings('general_settings', true);
                $tax = get_settings('system_tax_settings', true);
                $tax_amount =  ($row['total']* $tax['tax'])/100;
                $currency = $settings['currency'];
                // foreach ($order_record['order_services'] as $order_data) {
                //     $tax_amount +=  $order_data['tax_amount'];
                // }

                // print_r($is_cancelable);
                $s = [];
                foreach ($order_record['order_services'] as $service_data) {
                    $array_ids =  fetch_details('services s', ['id' => $service_data['service_id']], 'is_cancelable');
                    foreach ($array_ids as $ids) {
                        array_push($s, $ids['is_cancelable']);
                    }
                }
                $address_data = fetch_details('addresses', ['id' => $row["address_id"]], 'address,area,pincode,city,state,country');
                // $city_name = fetch_details('cities', ['id' => $row['city_id']], 'name');
   
                if(isset($address_data[0])){
                     $res =  array_slice($address_data[0], 0, 2, true) +
                    array("city" => $address_data[0]['city']) +
                    array_slice($address_data[0], 2, count($address_data[0]) - 1, true);
                      $address = implode(",", $res);
                }else{
                    $address="";
                }
               

                $row['profile_image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $row['profile_image'])) ? base_url('public/backend/assets/profiles/' . $row['profile_image']) : ((file_exists(FCPATH . $row['profile_image'])) ? base_url($row['profile_image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $row['profile_image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $row['profile_image'])));

                $tempRow['id'] = $row['id'];
                $tempRow['customer'] = $row['user_name'];
                $tempRow['customer_id'] = $row['customer_id'];
                $tempRow['latitude'] = $row['latitude'];
                $tempRow['longitude'] = $row['longitude'];
                $tempRow['advance_booking_days'] = $row['advance_booking_days'];
                $tempRow['customer_no'] = $row['customer_no'];
                $tempRow['customer_email'] = $row['customer_email'];
                $tempRow['user_wallet'] = $row['user_wallet'];
                $tempRow['payment_method'] = $row['payment_method'];
                $tempRow['partner'] = $row['partner_name'];
                $tempRow['profile_image'] = $row['profile_image'];
                $tempRow['user_id'] = $row['user_id'];
                $tempRow['partner_id'] = $row['partner_id'];
                $tempRow['city_id'] = $row['city'];
                $tempRow['total'] = $row['total'];
                $tempRow['tax_percentage'] = $tax['tax'];
                $tempRow['tax_amount'] = strval($tax_amount);
                $tempRow['promo_code'] = $row['promo_code'];
                $tempRow['promo_discount'] = $row['promo_discount'];
                $tempRow['final_total'] = strval($row['final_total'] + $tax_amount);
                $tempRow['admin_earnings'] = $row['admin_earnings'];
                $tempRow['partner_earnings'] = $row['partner_earnings'];
                $tempRow['address_id'] = $row['address_id'];
                $tempRow['address'] = $address;
                $tempRow['date_of_service'] = date("d-M-Y", strtotime($row['date_of_service']));
                $tempRow['starting_time'] = date("h:i A", strtotime($row['starting_time']));
                $tempRow['ending_time'] = date("h:i A", strtotime($row['ending_time']));
                $tempRow['duration'] = $row['duration'];
                if (in_array(0, $s)) {
                    $tempRow['is_cancelable'] = 0;
                } else {
                    $start_time = $row['starting_time'];
                    // $cancel_time = date('H:i:s', strtotime("-" . $order_record['order_services'][0]['cancelable_till'] . " min"));
                    $time = strtotime($start_time);
                    $time = $time - ($order_record['order_services'][0]['cancelable_till'] * 60);
                    $cancel_time = date("H:i:s", $time);
                    $current_time = time();
                    if ($current_time > $cancel_time) {
                        $tempRow['is_cancelable'] = 0;
                    } else {
                        $tempRow['is_cancelable'] = 1;
                    }
                }
                
                $tempRow['status'] = $status;
                $tempRow['remarks'] = $row['remarks'];
                $tempRow['created_at'] =  date("d-M-Y h:i A", strtotime($row['created_at']));
                $tempRow['company_name'] = $row['company_name'];
                $tempRow['visiting_charges'] = $row['visiting_charges'];
                $tempRow['services'] = $order_record['order_services'];
                $tempRow['invoice_no'] = 'INV-' . $row['id'];

                // print_r($tempRow['services']);
                // foreach($tempRow['services'] as $service_data)
                // {
                //     // print_r($service_data);
                //     $is_cancelable = [];
                //     array_push($is_cancelable,$service_data['is_cancelable']);
                // }

                // print_R(implode(',',$is_cancelable));
                if (!$from_app) {
                    $tempRow['operations'] = $operations;
                    unset($tempRow['updated_at']);
                }
                $rows[] = $tempRow;
            }
        }
        $bulkData['rows'] = $rows;
        if ($from_app) {

            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            return json_encode($bulkData);
        }
    }

    public function invoice($order_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('orders o');
        $tempRow = array();
        $builder->select('o.*,u.username as customer,u.phone as customer_no,u.email as customer_email,up.username as partner_name,up.phone as partner_no,u.balance as user_wallet,pd.visiting_charges,pd.address,pd.company_name,pd.tax_name,pd.tax_number')
            ->join('order_services os', 'os.order_id=o.id', 'left')
            ->join('users u', 'u.id=o.user_id', 'left')
            ->join('users up', 'up.id=o.partner_id', 'left')
            ->join('partner_details pd', 'o.partner_id = pd.partner_id', 'left');
        $builder->where('o.id', $order_id)->where("os.status != 'cancelled'");

        $order_record = $builder->get()->getResultArray();
        foreach ($order_record as $row) {
            $builder = $db->table('order_services os');
            $services = $builder->select('os.*,s.tags,s.duration,s.category_id')
                ->where('os.order_id', $row['id'])
                // ->where('os.status', 'cancelled')
                ->join('services as s', 's.id=os.service_id', 'left')->get()->getResultArray();
            $tempRow['order'] = $order_record[0];
            $tempRow['order']['services'] = $services;
        }
        return $tempRow;
    }

    public function ordered_services_list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'o.id', $order = 'DESC', $where = [], $where_in_key = '', $where_in_value = [])
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('order_services os');

        $multipleWhere = [];
        $condition = $bulkData = $rows = $tempRow = [];

        if (isset($_GET['offset']))
            $offset = $_GET['offset'];

        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                '`os.id`' => $search,
                '`os.order_id`' => $search,
                '`os.service_id`' => $search,
                '`os.service_title`' => $search,
                '`os.quantity`' => $search,
                '`os.status`' => $search
            ];
        }
        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        $sort = "id";
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'id') {
                $sort = "id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        $order = "ASC";
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }

        if ($from_app) {
            $where['status'] = 1;
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $builder->select('COUNT(os.id) as `total` ')
            ->join('services s', 's.id = os.service_id', 'left');
        $order_count = $builder->get()->getResultArray();
        $total = $order_count[0]['total'];

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }



        $builder->select('os.*,s.is_cancelable, s.cancelable_till')
            ->join('services s', 's.id = os.service_id', 'left');
        $taxes = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();


        foreach ($taxes as $row) {

            $tempRow['id'] = $row['id'];
            $tempRow['order_id'] = $row['order_id'];
            $tempRow['service_id'] = $row['service_id'];
            $tempRow['service_title'] = $row['service_title'];
            $tempRow['tax_percentage'] = $row['tax_percentage'];
            $tempRow['tax_amount'] = $row['tax_amount'];
            $tempRow['price'] = $row['price'];
            $tempRow['quantity'] = $row['quantity'];
            $tempRow['sub_total'] = $row['sub_total'];

            // service table section
            $tempRow['is_cancelable'] = ($row['is_cancelable'] == 1) ?
                "<span class='badge badge-success'>Yes</span>" : "<span class='badge badge-danger'>No</span>";

            $tempRow['cancelable_till'] = ($row['cancelable_till'] != '') ? $row['cancelable_till'] : 'Not cancelable';
            // 
            $tempRow['status'] = $row['status'];
            if ($row['is_cancelable'] == 1) {
                if ($row['status'] == 'completed') {
                    $tempRow['operations'] = '';
                } else if ($row['status'] == 'cancelled') {
                    $tempRow['operations'] = '';
                } else {
                    $tempRow['operations'] = '
                    <button type="button" class="btn btn-danger btn-sm cancel_order" title="Cancel Order">
                        <i class="fas fa-times"></i>
                    </button>
                    ';

                    // $tempRow['operations'] .= '
                    //     <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#change_order_status" 
                    //     title="Reschedule Order">
                    //       <i class="fas fa-clock"></i>
                    //     </button>
                    // ';
                }
            } else {
                $tempRow['operations'] = '-';
            }


            $rows[] = $tempRow;
        }
        if ($from_app) {
            // if request from app return array 
            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            // else return json
            $bulkData['rows'] = $rows;
            return json_encode($bulkData);
        }
    }
}
