<?php

namespace App\Models;

use CodeIgniter\Model;



class System_user_model extends Model
{

    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $allowedFields = ['username', 'active', 'first_name', 'last_name', 'ip_address', 'password', 'email', 'balance', 'activation_selector', 'activation_code', 'forgotten_password_selector', 'forgotten_password_code', 'forgotten_password_time', 'remember_selector', 'remember_code', 'created_on', 'last_login', 'company', 'phone', 'fcm_id', 'image', 'api_key', 'friends_code', 'referral_code', 'city_id','city' ,'latitude', 'longitude'];


    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [])
    {

        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('users u');
        $values = ['7'];
        if ($search and $search != '') {
            $multipleWhere = [
                '`u.id`' => $search,
                '`u.company`' => $search,
                '`u.username`' => $search,
                '`u.email`' => $search,
                '`u.phone`' => $search,
                '`u.city`' => $search,
            ];
        }

        $builder->select(' COUNT(u.id) as `total` ')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->join('user_permissions up', 'up.user_id = u.id')
            ->where('ug.group_id', 1)
            ->whereNotIn('u.active', $values);

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        $partner_count = $builder->get()->getResultArray();

        $total = $partner_count[0]['total'];


        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }

        $builder->select(' 
            u.*,            
            ug.group_id,
            up.user_id,up.role,up.permissions
        ')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->join('user_permissions up', 'up.user_id = u.id')
            ->where('ug.group_id', 1)
            ->whereNotIn('u.active', $values);

        $system_user_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        // print_r($system_user_record);
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($system_user_record as $row) {

            if ($row['role'] == "1") {
                $role = "<span class='badge badge-danger'>Super Admin</span>";
                $operations = '
                <button class="btn btn-success edit-user" title=" Edit Admin " data-toggle="modal" data-target="#edit_permission"> <i class="fa fa-pen" aria-hidden="true"></i> </button>  
                <button class="btn btn-danger delete-user" title=" Delete Admin "> <i class="fa fa-trash" aria-hidden="true"></i> </button>';
            } else if ($row['role'] == "2") {
                $role = "<span class='badge badge-warning'>Admin</span>";
                $operations = ($row['active'] == 1) ?
                    '<button class="btn btn-danger deactivate-user" title=" Deactivate Admin "> <i class="fa fa-ban" aria-hidden="true"></i> </button>' :
                    '<button class="btn btn-success activate-user" title=" Activate Admin "> <i class="fa fa-check" aria-hidden="true"></i> </button>';
                $operations .= '
                <button class="btn btn-success edit-user" title=" Edit Admin " data-toggle="modal" data-target="#edit_permission"> <i class="fa fa-pen" aria-hidden="true"></i> </button>  
                <button class="btn btn-danger delete-user" title=" Delete Admin "> <i class="fa fa-trash" aria-hidden="true"></i> </button>';
            } else {
                $role = "<span class='badge badge-info'>Editor</span>";
                $operations = ($row['active'] == 1) ?
                    '<button class="btn btn-danger deactivate-user" title=" Deactivate Editor "> <i class="fa fa-ban" aria-hidden="true"></i> </button>' :
                    '<button class="btn btn-success activate-user" title=" Activate Editor "> <i class="fa fa-check" aria-hidden="true"></i> </button>';
                $operations .= '
                <button class="btn btn-success edit-user" title=" Edit Editor"data-toggle="modal" data-target="#edit_permission"> <i class="fa fa-pen" aria-hidden="true"></i> </button>  
                <button class="btn btn-danger delete-user" title="Delete Editor"> <i class="fa fa-trash" aria-hidden="true"></i> </button>';
            }

            $tempRow['id'] = $row['id'];
            $tempRow['username'] = $row['username'];
            $tempRow['email'] = $row['email'];
            $tempRow['role_a'] = $row['role'];
            $tempRow['role'] = $role;
            $tempRow['permissions'] = $row['permissions'];
            $tempRow['operations'] = $operations;

            if ($from_app == false) {
                $tempRow['created_at'] = $row['created_at'];
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return json_encode($bulkData);
    }
}
