<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('system_users', "System Users") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"> <a href="<?= base_url('admin/system_users') ?>"> System Users</a></div>
                <div class="breadcrumb-item">Add System Users</a></div>
            </div>
        </div>

        <div class="section-body">
            <div class="container-fluid card">
                <h2 class='section-title'><?= labels('add_system_user', "Add System User") ?></h2>
                <form action="<?= base_url('admin/system_users/permit') ?>" method="post" class="form-submit-event" id="system_user_form">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="row">
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="user_type">User Type</label>
                                        <select id="user_type" class="form-control" name="user_type">
                                            <option value="select_user_type">Select Users Type</option>
                                            <option value="existing_user">Old Users</option>
                                            <option value="new_user">New User</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="old_user">
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="user_name">User Name</label>
                                        <select id="user_name" class="form-control" name="user">
                                            <option value="default" selected>Select User</option>
                                            <?php foreach ($users as $user) :  ?>
                                                <option value="<?= $user['id'] ?>"> <?= $user['username'] ?> </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="new_user">
                                <div class="col-md">
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="user_name">User Name</label>
                                                <input id="name" class="form-control" type="text" name="new_user_name">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="mobile">Mobile</label>
                                                <input id="mobile" class="form-control" type="number" name="phone" min="0">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="email">E-mail</label>
                                                <input id="email" class="form-control" type="mail" name="mail">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="password">Password</label>
                                                <input id="password" class="form-control" type="password" name="password">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="confirm_password">Confirm Password</label>
                                                <input id="confirm_password" class="form-control" type="password" name="confirm_password">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="role">Role</label>
                                        <select id="role" class="form-control" name="role">
                                            <option value="default">Select Role</option>
                                            <option value="super_admin">Super Admin</option>
                                            <option value="admin">Admin</option>
                                            <option value="editor">Editor</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md">
                                    <div class="form-group">
                                        <input type="submit" value="Submit" class="btn btn-success">
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-9" id="permissions">
                            <div class="table-responsive">
                                <table class="table permission-table">
                                    <tbody>
                                        <tr>
                                            <th>Module/Permissions</th>
                                            <th>Create</th>
                                            <th>Read</th>
                                            <th>Update</th>
                                            <th>Delete</th>
                                        </tr>
                                    </tbody>
                                    <tbody>
                                        <?php foreach ($permissions as $perms => $value) : ?>
                                            <tr>
                                                <td>
                                                    <?= $perms ?>

                                                    <!-- <?php print_r($value) ?> -->
                                                    <!-- <?php print_r((!empty($value[1]) ? $value[1] : "no data")) ?> -->
                                                </td>

                                                <td class="align-baseline">
                                                    <?php
                                                    $i;
                                                    $cust_id =  $perms . "_create"
                                                    ?>
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "create") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id ?>" value="true" checked>
                                                                <label for="<?= $cust_id ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                </td>
                                                <td class="align-baseline">
                                                    <?php
                                                    $cust_id_read =  $perms . "_read";
                                                    ?>

                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "read") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_read ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_read ?>" value="true" checked>
                                                                <label for="<?= $cust_id_read ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                </td>
                                                <td class="align-baseline">

                                                    <?php $cust_id_update =  $perms . "_update" ?>
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "update") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_update ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_update ?>" value="true" checked>
                                                                <label for="<?= $cust_id_update ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php else : ?>
                                                        <?php endif ?>
                                                        <?php ?>
                                                    <?php endfor ?>

                                                </td>

                                                <td class="align-baseline">
                                                    <?php $cust_id_delete =  $perms . "_delete"  ?>
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "delete") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_delete ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_delete ?>" value="true" checked>
                                                                <label for="<?= $cust_id_delete ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php else : ?>
                                                        <?php endif ?>
                                                        <?php ?>
                                                    <?php endfor ?>
                                                    <!--  -->
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </section>
</div>