<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('notification', "Notification") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('notification', 'Notification') ?></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('send_notifications', "Send Notification") ?></h2>
                    <div class="card-body">
                        <?= form_open('/admin/notification/add_notification', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_notification', 'enctype' => "multipart/form-data"]); ?>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="type"><?= labels('type', "Type") ?> <small> <?= labels('notification', "Notification") ?></small> </label>
                                    <select id="type1" class="form-control" name="type">
                                        <option value=""><?= labels('select_type', "Select Type") ?> </option>
                                        <option value="personal"><?= labels('personal', "Personal") ?> </option>
                                        <option value="general"><?= labels('general', "General") ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="title"><?= labels('title', "Title") ?></label>
                                    <input id="title" class="form-control" type="title" name="title" placeholder="Enter the title here">
                                </div>
                            </div>
                        </div>
                        <div class="row" id="user_select">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="personal">
                                        <label for="Category_item"><?= labels('personal', "Personal") ?></label>
                                        <select id="users" class="form-control" name="user_ids[]" multiple>
                                            <?php foreach ($users as $user) : ?>
                                                <option value="<?= $user['id'] ?>"><?= $user['username'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                          
                            <div class="col-md-4">
                            <div class="form-group">
                            <label for="message"><?= labels('message', "Message") ?></label>
                            <textarea id="messgae" class="form-control col-md-12" name="message" placeholder="Enter The message Here"></textarea>
                        </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="Image" name="image" aria-describedby="notification_image">
                                            <label class="custom-file-label" for="image"><?= labels('choose_file', "Choose file") ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <button type="reset" class="btn btn-warning"><?= labels('Reset', "Reset") ?></button>
                                    <button type="submit" class="btn btn-success"><?= labels('send_notifications', "Send Notification") ?></button>
                                </div>
                            </div>
                        </div>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('notification_details', "Notification details") ?></h2>
            <div class="row">
                <div class="col-lg">
                    <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/notification/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-visible="true" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="title" class="text-center" data-visible="true" ><?= labels('title', 'Title') ?></th>
                                <th data-field="message" class="text-center" data-visible="true" ><?= labels('message', 'Message') ?></th>
                                <th data-field="image" class="text-center" ><?= labels('image', 'Image') ?></th>
                                <th data-field="type" class="text-center" data-visible="true" data-sortable="true"><?= labels('type', 'Type') ?></th>
                                <th data-field="notification_type" class="text-center" data-visible="true" data-sortable="true"><?= labels('notification_type', 'Notification Type') ?></th>
                                <th data-field="operations" class="text-center" data-events="notification_event"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>