<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('view_orders', 'View Orders') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('view_orders', 'View Orders') ?></a></div>
            </div>
        </div>

        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="align-items-center bg-navy card-header d-flex justify-content-between">
                            <div class="bg-navy">
                                <h4><?= labels('order_details', 'Order Details') ?></h4>
                            </div>
                            <div>
                                <a href="<?= base_url("admin/orders/invoice/" . $order_details['id']); ?>" class="btn btn-primary"><i class="fa fa-receipt"></i><?= labels('invoice', 'Invoice') ?> </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <h4><?= labels('provider_details', 'Provider Details') ?></h4>
                                    <div class="table-responsive">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <th><?= labels('order_ID', 'Order ID') ?> :</th>
                                                    <td><?= $order_details['id'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('provider', 'Provider') ?> :</th>
                                                    <td><?= $order_details['partner'] . " ( ID : " . $order_details['partner_id'] . " ) " ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('company_name', 'Company Name') ?> :</th>
                                                    <td><?= $order_details['company_name'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('address', 'Address') ?> :</th>
                                                    <td><?= $order_details['address'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('date_of_service', 'Date Of Service') ?> :</th>
                                                    <td><?= $order_details['date_of_service'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('service_start_time', 'Service Start Time') ?> :</th>
                                                    <td><?= date("h:i A", strtotime($order_details['starting_time'])) ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('service_end_time', 'Service End Time') ?> :</th>
                                                    <td><?= date("h:i A", strtotime($order_details['ending_time'])) ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('service_duration', 'Service Duration') ?> :</th>
                                                    <td><?= $order_details['duration'] . " Minutes" ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('visiting_charges', 'Visiting Charges') ?> :</th>
                                                    <td><?= $currency . '' . $order_details['visiting_charges'] ?></td>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    <hr class="d-md-none"/>
                                </div>
                                <div class="col-md-4">
                                    <h4><?= labels('customer_details', 'Customer Details') ?></h4>
                                    <div class="table-responsive">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <th><?= labels('name', 'Name') ?> :</th>
                                                    <td><?= $customer['username'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('email', 'Email-ID') ?> :</th>
                                                    <td><?= $customer['email'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('contact_no', 'Contact No') ?> :</th>
                                                    <td><?= $customer['phone'] ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?= labels('address', 'Address') ?> :</th>
                                                    <td><?= $currency . '' . $order_details['address'] ?></td>
                                                </tr>
                                                
                                            </thead>
                                        </table>
                                    </div>
                                    <hr class="d-md-none"/>
                                </div>
                                <div class="col-md-4">
                                    <h4><?= labels('customer_location', 'Customer Location') ?></h4>
                                    <div id="map_tuts" style="height: 250px;"></div>
                                    <input type="hidden" name="latitude" id="lat" value="<?= ($customer['latitude'] != '') ? $customer['latitude'] : ''  ?> " readonly>
                                    <input type="hidden" name="longitude" id="lon" value="<?= ($customer['longitude'] != '') ? $customer['longitude'] : '' ?> " readonly>
                                </div>
                                <div class="col-md-12">
                                    <table class="table table-bordered table-hover table-md">
                                        <thead>
                                            <tr>
                                                <th><?= labels('service_name', 'Service name') ?></th>
                                                <th><?= labels('provider', 'Category') ?></th>
                                                <th><?= labels('status', 'Status') ?></th>
                                                <th><?= labels('price', 'Price') ?></th>
                                                <th><?= labels('quantity', 'Quantity') ?></th>
                                                <th><?= labels('sub_total', 'Sub Total') ?></th>
                                                <th><?= labels('operations', 'Operations') ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <?php $total_tax_amount = 0;
                                            foreach ($order_details['services'] as $services) {

                                            ?>
                                                <tr class="table-light">
                                                    <td class="table-light d-none"> <?= $services['id'] ?></td>
                                                    <td class="table-light"> <?= $services['service_title'] ?></td>
                                                    <td class="table-light"><?= get_catgory_name($services['category_id']) ?></td>
                                                    <td class="table-light"> <?= $services['status'] ?></td>
                                                    <td class="table-light"> <?= $currency . '' . $services['price'] ?></td>
                                                    <td class="table-light"> <?= $services['quantity'] ?></td><br>
                                                    <td class="table-light"> <?= $currency . '' . $services['sub_total'] - $services['tax_amount'] ?></td><br>

                                                    <!-- <td class="table-light"> <?=  $currency . (strval($services['sub_total']) - strval($services['tax_amount'])) ?></td><br> -->
                                                    <?php if ($services['status'] != 'cancelled') : ?>
                                                        <td class="table-light" onclick="cancel_service(this)" data-id="<?= $services['id'] ?>" data-service_id="<?= $services['service_id'] ?>">
                                                            <button class="btn btn-danger btn-sm cancel_order">
                                                                <i class="fas fa-times"></i>
                                                            </button>
                                                        </td><br>
                                                    <?php else : ?>
                                                        <td class="table-light"> - </td><br>
                                                    <?php endif ?>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                        <thead>
                                            <?php $total_tax_amount =  ($order_details['total'] * $tax)/100; ?>
                                            <tr>
                                                <td colspan="4"></td>
                                                <th><?= labels('total', 'Total') ?></th>
                                                <td colspan="2"><?= $currency . '' . $order_details['total'] ?></td>
                                            </tr>
                                            <tr>
                                                <td colspan="4"></td>
                                                <th><?= labels('tax_amount', 'Tax Amount') ?>  (<?= $tax ?>%)</th>
                                                <td colspan="2"><?= $currency . '' . $total_tax_amount ?></td>
                                            </tr>
                                            <tr>
                                                <td colspan="4"></td>
                                                <th><?= labels('visiting_charges', 'Visiting Charges') ?> </th>
                                                <td colspan="2"><?= $currency . '' . $order_details['visiting_charges'] ?></td>
                                            </tr>
                                            <tr>
                                                <td colspan="4"></td>
                                                <th><?= labels('promocode_discount', 'Promocode Discount') ?> </th>
                                                <td colspan="2"><?= $currency . '' . $order_details['promo_discount'] ?> <?= (!empty($order_details['promo_code']) ? "<b>(" . $order_details['promo_code'] . ")</b>" : ""); ?></td>
                                            </tr>
                                            <tr>
                                                <td colspan="4"></td>
                                                <th><?= labels('final_total', 'Final Total') ?> </th>
                                                <?php  $final_total = ($order_details['total'] + $total_tax_amount + $order_details['visiting_charges']) - $order_details['promo_discount'];  ?>
                                                <td colspan="2"><?= $currency . '' . $final_total ?></td>
                                            </tr>
                                        </thead>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 col-md-6 col-lg-6">
                    <div class="row">
                        <div class="col-md">
                            <div class="card">
                                <div class="card-header bg-navy border-0 h5">
                                    <h4><?= labels('order_status', "Order Status") ?></h4>
                                </div>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group p-2 col-md">
                                                <div class="row">
                                                    <div class="col-md">
                                                        <select name="status" id="status" class="form-control update_order_status">
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="pending" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "pending") ? "selected" : "" ?>><?= labels('pending', 'Pending') ?></option>
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="awaiting" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "awaiting") ? "selected" : "" ?>><?= labels('awaiting', 'Awaiting') ?></option>
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="confirmed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "confirmed") ? "selected" : "" ?>><?= labels('confirmed', 'Confirmed') ?></option>
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="rescheduled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "rescheduled") ? "selected" : "" ?>><?= labels('rescheduled', 'Rescheduled') ?></option>
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="cancelled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "cancelled") ? "selected" : "" ?>><?= labels('cancelled', 'Cancelled') ?></option>
                                                            <option data-customer_id="<?= $order_details["customer_id"] ?>" value="completed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "completed") ? "selected" : "" ?>><?= labels('completed', 'Completed') ?></option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md">

                                                        <div class="form-group rescheduled_date">
                                                            <label for="rescheduled_date"> <?= labels('rescheduled_date', "Rescheduled Date") ?></label>
                                                            <input id="rescheduled_date" class="form-control" type="date" name="rescheduled_date">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm mt-2">
                                                        <div class="row " id="available-slots">

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mt-1">
                                                    <div class="col-md mt-3">
                                                        <input type="hidden" name="order_id" id="order_id" value="<?= $order_details['id'] ?>">
                                                        <button class="btn btn-block btn-primary w-25" id="change_status">
                                                        <?= labels('update_status', " Update Status") ?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <p class="order-detail-p reschedulable"></p>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-6">
                    <div class="card">
                        <div class="card-header bg-navy border-0 h5">
                            <h4><?= labels('payment_details', 'Payment Details') ?> </h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md">
                                    <div class="table-responsive mb-3 table-sm">
                                        <table class="table table-hover table-bordered " id="payment_table" data-show-export="true" data-export-types="[' txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-show-columns="true" data-show-toggle="true" data-show-refresh="true" data-toggle="table" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url('/admin/orders/view_payment_details/' . $order_details['id']); ?>">
                                            <thead>
                                                <tr>
                                                    <th data-field="name" data-visible="false"><?= labels('user_name', 'User Name') ?> </th>
                                                    <th data-field="type" data-visible="true"><?= labels('payment_type', 'Payment Type') ?> </th>
                                                    <th data-field="transaction_type" data-visible="true"><?= labels('transaction_type', 'Transaction Type') ?> </th>
                                                    <th data-field="amount" data-visible="true"><?= labels('amount', 'Amount') ?></th>
                                                    <th data-field="status" data-visible="true"><?= labels('status', 'Status') ?></th>
                                                </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>