<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('system_tax_settings', 'Tax settings') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('system_tax_settings', 'Tax settings') ?></div>
            </div>
        </div>

        <div class="section-body">
            <div class="container-fluid card">
                <h2 class='section-title'><?= labels('system_tax_settings', 'Tax settings') ?></h2>
                <form action="<?= base_url('admin/settings/system_tax_settings') ?>" method="post">
                    <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
                    <div class="container-fluid card p-3">
                        <div class="col-md">
                            <div class="form-group">
                                <div class="custom-control custom-switch">



                                    

                                    <input type="hidden" name="tax_status" value='0' id="tax_status_value">
                                    <input type="checkbox" name="tax_status" id="status" <?php echo isset($tax_status) && $tax_status == "1" ? "checked" : "" ?>  class="custom-control-input" value=<?= isset($tax_status) ? $tax_status : "0"; ?>>



                                    <label for="status" class="custom-control-label">
                                        <span id="tax_status">
                                            <?php echo isset($tax_status) && $tax_status == 1 ? labels('enable', 'Enable') : labels('disable', 'Disable') ?>

                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="system_tax_settings"> <?= labels('enter_tax_name', 'Enter Tax Name') ?></label>
                                    <input type="text" name="tax_name" id="system_tax_settings" value="<?= isset($tax_name) ? $tax_name : '' ?>" placeholder="<?= labels('enter_tax_name', 'Enter Tax Name') ?>" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="system_tax_settings"> <?= labels('enter_taxable_amount', 'Enter Taxable Amount ') ?> <small> <?= labels('in_percentage', 'In Percentage') ?></small> </label>
                                    <input type="text" name="tax" id="system_tax_settings" value="<?= isset($tax) ? $tax : '' ?>" placeholder=" <?= labels('enter_taxable_amount', 'Enter Taxable Amount ') ?>" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md">
                                <div class="form-group">
                                    <input type='submit' name='update' id='update' value='<?= labels('save_changes', "Update") ?>' class='btn btn-success' />
                                    <input type='reset' name='clear' id='clear' value='<?= labels('Reset', "clear") ?>' class='btn btn-danger' />
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
<script>
    $('#status').on('change', function() {
        this.value = this.checked ? 1 : 0;
    }).change();
</script>