<div class="main-content profile-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('my_profile', "My Profile") ?></h1>
        </div>
        <?php if (empty($partner_details)) { ?>
            <div class="alert alert-info" role="alert">
                Please Complete Your KYC Then you can Access Panel
            </div>
        <?php } else if ($partner_details['is_approved'] == "0") { ?>
            <div class="alert alert-primary" role="alert">
                Your KYC request is pending please wait for admin action.
            </div>
        <?php } else if ($partner_details['is_approved'] == "2") { ?>
            <div class="alert alert-danger" role="alert">
                Your KYC request is Rejected by Admin Please try again.
            </div>
        <?php }  ?>

        <div class="section-body">
            <div class="row mt-sm-4">
                <div class="col-md-12">
                    <div class="card">
                        <?= form_open('/partner/update_profile', ['method' => "post", 'class' => 'form-submit-event', 'enctype' => "multipart/form-data"]); ?>
                        <div class="card-header">
                            <h4><?= labels('edit_profile', "Edit Profile") ?></h4>
                        </div>
                        <div class="card-body">
                            <h4>Provider Details</h4>
                            <hr>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="">Admin Commission(%)</label>
                                        <input type="text" name="admin_commission" value="<?= $admin_commission ?>" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label for="">Username</label>
                                    <input type="text" name="username" value="<?= $data['username'] ?>" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <label for="">Email</label>
                                    <input type="email" name="email" value="<?= $data['email'] ?>" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <label for="">Phone</label>
                                    <input type="number" name="phone" value="<?= $data['phone'] ?>" class="form-control" min="0">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="">Address</label>
                                    <input type="text" name="address" value="<?= $partner_details['address'] ?>" class="form-control" min="0">
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image"><?= labels('change_profile_picture', 'Change Profile Picture') ?></label>
                                        <div class="image-preview align-items-center d-flex justify-content-between">
                                            <a href="<?= !empty($data) && !empty($data['image']) ? base_url($data['image']) : "" ?>" data-lightbox="image-1">
                                                <img class="img-fluid" src="<?= !empty($data) && !empty($data['image']) ? base_url($data['image']) : "" ?>" alt=""></a>
                                        </div>
                                        <input type="file" class="form-control mt-2" name="image" id="image" value="<?= $data['image']; ?>" placeholder="" min="1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="banner"><?= labels('change_banner', 'Change Banner') ?></label>
                                        <div class="image-preview align-items-center d-flex justify-content-between">
                                            <a href="<?= !empty($partner_details) && !empty($partner_details['banner']) ? base_url($partner_details['banner']) : "" ?>" data-lightbox="image-1">
                                                <img class="img-fluid" src="<?= !empty($partner_details) && !empty($partner_details['banner']) ? base_url($partner_details['banner']) : "" ?>" alt=""></a>
                                        </div>
                                        <input type="file" class="form-control mt-2" name="banner" id="banner" value="<?= $partner_details['banner']; ?>" placeholder="" min="1">

                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Search your city</label>
                                    </div>
                                    <input id="city_search" class="form-control" type="text" name="places">
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Map</label>
                                    </div>
                                    <div id="map_wrapper_div">
                                        <div id="map"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Latitude</label>
                                        <input type="text" class="form-control" name="latitude" id="latitude" value="<?= $data['latitude'] ?>" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Longitude</label>
                                        <input type="text" class="form-control" name="longitude" id="longitude" value="<?= $data['longitude'] ?>" readonly>
                                    </div>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Working Days</label>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Monday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[0]['opening_time']) ? $partner_timings[0]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[0]['closing_time']) ? $partner_timings[0]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[0]['is_open']) && $partner_timings[0]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="monday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Tuesday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[1]['opening_time']) ? $partner_timings[1]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[1]['closing_time']) ? $partner_timings[1]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[1]['is_open']) && $partner_timings[1]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="tuesday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Wednesday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[2]['opening_time']) ? $partner_timings[2]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[2]['closing_time']) ? $partner_timings[2]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[2]['is_open']) && $partner_timings[2]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="wednesday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Thursday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[3]['opening_time']) ? $partner_timings[3]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[3]['closing_time']) ? $partner_timings[3]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[3]['is_open']) && $partner_timings[3]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="thursday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Friday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[4]['opening_time']) ? $partner_timings[4]['opening_time'] : '') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[4]['closing_time']) ? $partner_timings[4]['closing_time'] : '') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[4]['is_open']) && $partner_timings[4]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="friday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Saturday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[5]['opening_time']) ? $partner_timings[5]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[5]['closing_time']) ? $partner_timings[5]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[5]['is_open']) && $partner_timings[5]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="saturday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0">Sunday</label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[6]['opening_time']) ? $partner_timings[6]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                To
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[6]['closing_time']) ? $partner_timings[6]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[6]['is_open']) && $partner_timings[6]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="sunday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Open
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <?php $days = [
                                            0 => 'monday',
                                            1 => 'tuesday',
                                            2 => 'wednesday',
                                            3 => 'thursday',
                                            4 => 'friday',
                                            5 => 'saturday',
                                            6 => 'sunday'
                                        ]; ?>
                                <div class="col-md-6">
                                    <label for="">Working Days</label>
                                    <?php foreach ($days as $day) {
                                        foreach ($partner_timings as $time) { ?>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for=""><?= $day ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= $time['opening_time'] ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= $time['closing_time'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <input class="check_box check_box" type="checkbox" name="<?= $time['day'] ?>" <?= ($time['is_open'] == 1) ? 'checked' : '' ?> id="flexCheckDefault">
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }
                                    } ?>
                                </div> -->
                            </div>
                            <hr>
                            <h4>ID Proofs:</h4>
                            <div class="row">
                                <div class="col-md-4 ">
                                    <label for="national_id">National ID</label>
                                    <input type="file" name="national_id" class="form-control" id="national_id">
                                    <div class="row p-3">
                                        <div class="col">
                                            <div class="profile-img">
                                                <?php
                                                if (isset($partner_details['national_id']) && !empty($partner_details['national_id'])) {
                                                ?>
                                                    <img src="<?= base_url($partner_details['national_id']) ?>" class="img-fluid" alt="">
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-md-4">
                                    <label for="address_id">Address ID</label>
                                    <input type="file" name="address_id" class="form-control" id="address_id">
                                    <div class="row p-3">
                                        <div class="col">
                                            <div class="profile-img">
                                                <?php
                                                if (isset($partner_details['address_id']) && !empty($partner_details['address_id'])) {
                                                ?>
                                                    <img src="<?= base_url($partner_details['address_id']) ?>" alt="">
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="passport">Passport</label>
                                    <input type="file" name="passport" class="form-control" id="passport">
                                    <div class="row p-3">
                                        <div class="col">
                                            <div class="profile-img">
                                                <?php
                                                if (isset($partner_details['passport']) && !empty($partner_details['passport'])) {
                                                ?>
                                                    <img src="<?= base_url($partner_details['passport']) ?>" alt="">
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <h4>Bank Details:</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="">Bank Name</label>
                                    <input type="text" name="bank_name" value="<?= $partner_details['bank_name'] ?>" class="form-control" id="">
                                </div>
                                <div class="col-md-4">
                                    <label for="">Account Number</label>
                                    <input type="text" name="account_number" value="<?= $partner_details['account_number'] ?>" class="form-control" id="">
                                </div>
                                <div class="col-md-4">
                                    <label for="">Account Name</label>
                                    <input type="text" name="account_name" value="<?= $partner_details['account_name'] ?>" class="form-control" id="">
                                </div>
                                <div class="col-md-4">
                                    <label for="">Bank code</label>
                                    <input type="text" name="bank_code" value="<?= $partner_details['bank_code'] ?>" class="form-control" id="">
                                </div>
                            </div>
                            <hr>
                            <h4>Other Details:</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="">Advance Booking Days</label>
                                    <input type="text" class="form-control" value="<?= $partner_details['advance_booking_days'] ?>" name="advance_booking_days">
                                </div>
                                <div class="col-md-4">
                                    <label for="">Type</label>
                                    <select name="type" id="" class="form-control">
                                        <option value="0" <?= ($partner_details['type'] == 0) ? 'selected' : '' ?>>Individual </option>
                                        <option value="1" <?= ($partner_details['type'] == 1) ? 'selected' : '' ?>>Organization</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="">Visiting Charges</label>
                                    <input type="number" class="form-control" value="<?= $partner_details['visiting_charges'] ?>" name="visiting_charges" min="0">
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-6">
                                    <label for="">About</label>
                                    <textarea type="text" class="form-control" value="" name="about" rows="12"><?= $partner_details['about'] ?></textarea>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <button class="btn btn-primary" type="submit">Update</button>
                                    <button class="btn btn-secondary mx-1" type="reset">Reset</button>
                                </div>
                            </div>
                            <?= form_close() ?>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>
